/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module mpif
(
  /*****************************************************************************
  * CRM
  *****************************************************************************/
  input  wire         rst_n,
  input  wire         clk,
  output reg          watchdog_reset_req,
 
  /*****************************************************************************
  * MFSM IF 
  *****************************************************************************/
  output reg          mfsm_keeprfon,
  input  wire         mfsm_phyerr,
  
  output reg          mfsm_txreq,
  output reg          mfsm_txabort,
  input  wire         mfsm_txend,
  
  output reg          mfsm_rxreq,
  input  wire         mfsm_sendrxv1,
  input  wire         mfsm_sendrxv2,
  input  wire         mfsm_rxendfortiming,
  output reg          mfsm_rxend,
  input  wire         mfsm_rxerr,
  output reg          mfsm_rxvector1_done,
  
  /*****************************************************************************
  * MAC IF 
  *****************************************************************************/
  input  wire         mac_txreq,                                 
  input  wire         mac_rxreq, 
  input  wire         mac_keeprfon,                              
  output reg          mac_phyrdy,                             
  input  wire         mac_mimocmdvalid,    
  input  wire [7:0]   mac_txdata,                        
  input  wire         mac_macdatavalid,                          
  output reg          mac_txend, 
  output reg          mac_phyerr,
  output reg  [7:0]   mac_rxdata,                             
  output reg          mac_rxerr,                              
  output reg          mac_rxend,                                
  output reg          mac_rxendfortiming,                       
  output reg          mac_rxrifsdetected,                        
  output reg          mac_cca_primary20,                          
  output reg          mac_cca_secondary20,                        
  output reg          mac_cca_secondary40,

  /*****************************************************************************
  * PHY TX IF
  *****************************************************************************/
  /* TXVECTOR */
  output reg          txv1_update,                      
  output reg  [ 3:0]  txv1_format,                      
  output reg  [ 2:0]  txv1_ch_bandwidth,                
  output reg          txv1_preamble_type,               
  output reg  [ 7:0]  txv1_antenna_set,                 
  output reg  [ 7:0]  txv1_txpwr_level_index,           
  output reg  [ 2:0]  txv1_n_tx,                        
  output reg          txv1_time_of_departure_requested, 
  output reg  [11:0]  txv1_l_length,                    
  output reg  [ 3:0]  txv1_l_rate,                      
  output reg  [15:0]  txv1_service, 
  output wire [ 6:0]  txv1_scrambler_initial_state,
  output reg          txv1_trigger_responding,
  output reg          txv2_update,
  output reg          txv2_sounding,
  output reg          txv2_smoothing,
  output reg  [ 1:0]  txv2_gi_type,
  output reg          txv2_aggregation,
  output reg          txv2_stbc,
  output reg  [ 1:0]  txv2_num_ext_ss,
  output reg  [ 7:0]  txv2_smmindex,
  output reg  [ 6:0]  txv2_mcs,
  output reg          txv2_fec_coding,
  output reg          txv2_beamformed,
  output reg          txv2_doze_not_allowed,
  output reg  [ 8:0]  txv2_partial_aid,
  output reg  [ 5:0]  txv2_group_id,
  output reg  [ 7:0]  txv2_n_user,
  output reg  [ 2:0]  txv2_nss,
  output reg  [ 4:0]  txv2_user_position,
  output reg          txv2_uplink_flag,
  output reg          txv2_beam_change,
  output reg          txv2_dcm,
  output reg  [ 1:0]  txv2_he_ltf_type,
  output reg          txv2_doppler,
  output reg          txv2_midamble,
  output reg  [ 5:0]  txv2_bss_color,
  output reg  [ 6:0]  txv2_txop_duration,
  output reg  [ 3:0]  txv2_spatial_reuse1,
  output reg  [ 3:0]  txv2_spatial_reuse2,
  output reg  [ 3:0]  txv2_spatial_reuse3,
  output reg  [ 3:0]  txv2_spatial_reuse4,
  output reg          txv2_sig_b_compression_mode,
  output reg          txv2_dcm_sig_b,
  output reg  [ 2:0]  txv2_mcs_sig_b,
  output reg  [ 7:0]  txv2_ru_allocation1,
  output reg  [ 7:0]  txv2_ru_allocation2,
  output reg  [ 7:0]  txv2_ru_allocation3,
  output reg  [ 7:0]  txv2_ru_allocation4,
  output reg  [10:0]  txv2_staid,
  output reg  [ 8:0]  txv2_he_siga_reserved,
  output reg  [ 2:0]  txv2_num_he_ltf,
  output reg          txv2_he_ltf_mode,
  output reg          txv2_ldpc_extra_symbol,
  output reg  [ 2:0]  txv2_starting_sts_num,
  output reg          txv3_update,
  output reg  [19:0]  txv3_length,
  output reg  [ 2:0]  txv3_packet_extension,
  output reg          txv3_trigger_method,
  output reg  [ 6:0]  txv3_ru_tone_set_index,
  output reg          txv3_feedback_status,
  /* TX DATA */
  input  wire         tx_ready,
  output reg  [ 7:0]  tx_data,
  output reg          tx_last,
  output reg          tx_valid,
 
  /*****************************************************************************
  * PHY RX IF
  *****************************************************************************/
  input  wire         rxv1_update,
  input  wire [ 3:0]  rxv1_format,
  input  wire [ 2:0]  rxv1_ch_bandwidth,
  input  wire         rxv1_preamble_type,
  input  wire         rxv2_update,
  input  wire [11:0]  rxv2_l_length,
  input  wire [ 3:0]  rxv2_l_rate,
  input  wire [ 7:0]  rxv2_rssi,
  input  wire         rxv2_dyn_bandwidth_in_non_ht,
  input  wire [ 1:0]  rxv2_ch_bandwidth_in_non_ht,
  input  wire         rxv2_sounding,
  input  wire         rxv2_smoothing,
  input  wire [ 1:0]  rxv2_gi_type,
  input  wire         rxv2_aggregation,
  input  wire         rxv2_stbc,
  input  wire [ 1:0]  rxv2_num_ext_ss,
  input  wire         rxv2_l_sig_valid,
  input  wire         rxv2_beamformed,
  input  wire         rxv2_doze_not_allowed,
  input  wire         rxv2_first_user,
  input  wire [ 8:0]  rxv2_partial_aid,
  input  wire [ 5:0]  rxv2_group_id,
  input  wire [ 6:0]  rxv2_mcs,
  input  wire [ 2:0]  rxv2_nss,
  input  wire         rxv2_fec_coding,
  input  wire [19:0]  rxv2_length,
  input  wire         rxv2_uplink_flag,
  input  wire         rxv2_beam_change,
  input  wire         rxv2_dcm,
  input  wire [ 2:0]  rxv2_rulen,
  input  wire [ 1:0]  rxv2_he_ltf_type,
  input  wire         rxv2_doppler,
  input  wire [ 5:0]  rxv2_bss_color,
  input  wire [ 6:0]  rxv2_txop_duration,
  input  wire [ 3:0]  rxv2_pe_duration,
  input  wire [ 3:0]  rxv2_spatial_reuse,
  input  wire         rxv2_sig_b_compression_mode,
  input  wire         rxv2_dcm_sig_b,
  input  wire [ 2:0]  rxv2_mcs_sig_b,
  input  wire [ 7:0]  rxv2_n_user,
  input  wire [10:0]  rxv2_staid,
  input  wire [143:0] rxv2_ndp_report,
  /* RX DATA */
  output wire         rx_ready,
  input wire [ 7:0]   rx_data,
  input wire          rx_last,
  input wire          rx_valid,
  
  /*****************************************************************************
  * AGC 
  *****************************************************************************/
  /* For building RXVECTOR1, captured on rising edge of mfsm_sendrxv1 */
  input  wire [ 7:0]  agc_rx_antennaset,
  input  wire [ 7:0]  agc_rssi1, 
  input  wire [ 7:0]  agc_rssi2, 
  input  wire [ 7:0]  agc_rssi3, 
  input  wire [ 7:0]  agc_rssi4, 
  /* For building RXVECTOR2, captured on rising edge of mfsm_sendrxv2 */
  input  wire [ 7:0]  agc_rcpi,
  input  wire [ 7:0]  agc_evm1,
  input  wire [ 7:0]  agc_evm2,
  input  wire [ 7:0]  agc_evm3,
  input  wire [ 7:0]  agc_evm4,
  
  /* note:forwarded towards MAC HW without any form of processing */
  input  wire         agc_rxrifsdetected,
  input  wire         agc_cca_primary20,
  input  wire         agc_cca_secondary20,
  input  wire         agc_cca_secondary40,
  
  /*****************************************************************************
  * Diag 
  *****************************************************************************/
  output reg   [31:0] diag_mac,
  output reg   [31:0] diag_mfsm,
  output reg   [31:0] diag_states
);

  /*****************************************************************************
  * DECLARATIONS
  *****************************************************************************/
  /* definitions */
  localparam NON_HT=4'd0,
             NON_HT_DUP=4'd1,
             HT_MM=4'd2,
             HT_GF=4'd3,
             VHT=4'd4,
             HE_SU=4'd5,
             HE_MU=4'd6,
             HE_EXT_SU=4'd7,
             HE_TB=4'd8;
             
  /* tx state */
  localparam TX_IDLE=3'd0,
             TX_RECEIVE_VECTOR=3'd1,
             TX_RECEIVE_DATA=3'd2,
             TX_END=3'd3,
             TX_CLOSE=3'd4;

  reg [ 2:0] tx_state;

  /* rx state */
  localparam       RX_IDLE=4'd0,
                   RX_WAIT_VECTOR=4'd1,
                   RX_SEND_VECTOR1=4'd2,
                   RX_SEND_DATA=4'd3,
                   RX_TIMING_BARRIER=4'd4,
                   RX_SEND_VECTOR2=4'd5,
                   RX_END=4'd6,
                   RX_ERROR=4'd7,
                   RX_ABORT=4'd8,
                   RX_CLOSE=4'd9;

  reg  [3:0]       rx_state;
 
  /* timing relief */
  reg         mac_macdatavalid_1t;
  reg  [ 7:0] mac_txdata_1t;
  
  /* txv */
  reg         tx_done;
  reg         txv_captured;
  wire [19:0] txv_total_length;
  reg  [ 4:0] txv_count;
  wire [ 4:0] n_txv_count;
 
  /* txfifo */
  wire [19:0]  n_txfifo_rq_count;           
  wire [19:0]  n_txfifo_wr_count;           
  wire [19:0]  n_txfifo_rd_count;           
  reg  [19:0]  txfifo_rq_count;             
  reg  [19:0]  txfifo_wr_count;             
  reg  [19:0]  txfifo_rd_count;             
  reg  [127:0] txfifo;
  reg  [127:0] n_txfifo;
  wire         txfifo_rq_done;
  wire         txfifo_wr_done;
  wire         txfifo_rd_done;
  wire         txfifo_rq_full;
  wire         txfifo_empty;
  wire [ 7:0]  n_tx_data;
  wire         n_tx_last;

  /* mfsm */
  reg          mfsm_sendrxv1_1t;
  reg          mfsm_sendrxv2_1t;
  
  /* rxv */
  reg          rxendfortiming_state;
  reg  [ 4:0]  rxv_count;
  reg  [ 7:0]  n_rxv;
  wire [ 4:0]  n_rxv_count;
  reg  [19:0]  rxv_total_length;
  reg          rxv1_sent;

  /* rxfifo */
  reg  [15:0]  n_rxfifo;
  reg  [15:0]  rxfifo;
  reg  [19:0]  rxfifo_wr_count;       
  reg  [19:0]  rxfifo_rd_count;       
  wire [19:0]  n_rxfifo_wr_count;       
  wire [19:0]  n_rxfifo_rd_count;
  wire         rxfifo_wr_done;
  wire         rxfifo_rd_done;
  wire         rxfifo_full;
  wire         rxfifo_empty;

  wire [ 7:0]  n_mac_rxdata;

  /* agc parameter capture */
  reg  [ 7:0]  agclat_rx_antennaset;
  reg  [ 7:0]  agclat_rssi1,agclat_rssi2,agclat_rssi3,agclat_rssi4; 
  reg  [ 7:0]  agclat_rcpi;
  reg  [ 7:0]  agclat_evm1,agclat_evm2,agclat_evm3,agclat_evm4;

  /* scrambler init */
  reg  [ 6:0]  scramblerinit;
  reg  [ 6:0]  n_scramblerinit;
  
  /* watch_dog */
  reg  [13:0]      watchdog_rxend_count;
  reg              watchdog_rxend_active;
  reg  [ 4:0]      watchdog_assert_count;
  reg              watchdog_assert;

  /*****************************************************************************
  * TXV DECODING
  *****************************************************************************/
  assign txv1_scrambler_initial_state = scramblerinit;
  assign n_txv_count = txv_count + 5'd1;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      txv_captured                <= 1'b0;
      txv_count                   <= 5'd0;
      txv1_update                 <= 1'b0;                  
      txv2_update                 <= 1'b0;              
      txv3_update                 <= 1'b0;                    
     
      txv1_format                 <= 4'b0;
      txv1_ch_bandwidth           <= 3'b0;
      txv1_preamble_type          <= 1'b0;
      txv1_antenna_set            <= 8'b0;
      txv1_txpwr_level_index      <= 8'b0;
      txv1_n_tx                   <= 3'b0;
      txv1_time_of_departure_requested <= 1'b0;          
      txv1_l_length               <=12'b0;           
      txv1_l_rate                 <= 4'b0;              
      txv1_service                <=16'b0;            
      txv1_trigger_responding     <= 1'b0;
      txv2_sounding               <= 1'b0;            
      txv2_smoothing              <= 1'b0;           
      txv2_gi_type                <= 2'b0;             
      txv2_aggregation            <= 1'b0;         
      txv2_stbc                   <= 1'b0;                
      txv2_num_ext_ss             <= 2'b0;          
      txv2_smmindex               <= 8'b0;            
      txv2_mcs                    <= 7'b0;                 
      txv2_fec_coding             <= 1'b0;          
      txv2_beamformed             <= 1'b0;          
      txv2_doze_not_allowed       <= 1'b0;    
      txv2_partial_aid            <= 9'b0;          
      txv2_group_id               <= 6'b0;             
      txv2_n_user                 <= 8'b0;              
      txv2_nss                    <= 3'b0;                 
      txv2_user_position          <= 5'b0;       
      txv2_uplink_flag            <= 1'b0;         
      txv2_beam_change            <= 1'b0;         
      txv2_dcm                    <= 1'b0;                 
      txv2_he_ltf_type            <= 2'b0;         
      txv2_doppler                <= 1'b0;             
      txv2_midamble               <= 1'b0;             
      txv2_bss_color              <= 6'b0;           
      txv2_txop_duration          <= 7'b0;       
      txv2_spatial_reuse1         <= 4'b0;       
      txv2_spatial_reuse2         <= 4'b0;       
      txv2_spatial_reuse3         <= 4'b0;       
      txv2_spatial_reuse4         <= 4'b0;       
      txv2_sig_b_compression_mode <= 1'b0;    
      txv2_dcm_sig_b              <= 1'b0;                 
      txv2_mcs_sig_b              <= 3'b0;                 
      txv2_ru_allocation1         <= 8'b0;             
      txv2_ru_allocation2         <= 8'b0;             
      txv2_ru_allocation3         <= 8'b0;             
      txv2_ru_allocation4         <= 8'b0;             
      txv2_staid                  <=11'b0;                     
      txv2_he_siga_reserved       <= 9'b0;          
      txv2_num_he_ltf             <= 3'b0;                
      txv2_he_ltf_mode            <= 1'b0;               
      txv2_ldpc_extra_symbol      <= 1'b0;         
      txv2_starting_sts_num       <= 3'b0;          
      txv3_length                 <=20'b0;                   
      txv3_packet_extension       <= 3'b0;          
      txv3_trigger_method         <= 1'b0;            
      txv3_ru_tone_set_index      <= 7'b0;         
      txv3_feedback_status        <= 1'b0;                      
    end
    else if(tx_state==TX_IDLE)
    begin
      txv_count                   <= 5'd0;
      txv1_update                 <= 1'b0;
      txv2_update                 <= 1'b0;
      txv3_update                 <= 1'b0;
      txv_captured                <= 1'b0;
      
      txv1_format                 <= 4'b0;
      txv1_ch_bandwidth           <= 3'b0;
      txv1_preamble_type          <= 1'b0;
      txv1_antenna_set            <= 8'b0;
      txv1_txpwr_level_index      <= 8'b0;
      txv1_n_tx                   <= 3'b0;
      txv1_time_of_departure_requested <= 1'b0;          
      txv1_l_length               <=12'b0;           
      txv1_l_rate                 <= 4'b0;              
      txv1_service                <=16'b0;            
      txv1_trigger_responding     <= 1'b0;
      txv2_sounding               <= 1'b0;            
      txv2_smoothing              <= 1'b0;           
      txv2_gi_type                <= 2'b0;             
      txv2_aggregation            <= 1'b0;         
      txv2_stbc                   <= 1'b0;                
      txv2_num_ext_ss             <= 2'b0;          
      txv2_smmindex               <= 8'b0;            
      txv2_mcs                    <= 7'b0;                 
      txv2_fec_coding             <= 1'b0;          
      txv2_beamformed             <= 1'b0;          
      txv2_doze_not_allowed       <= 1'b0;    
      txv2_partial_aid            <= 9'b0;          
      txv2_group_id               <= 6'b0;             
      txv2_n_user                 <= 8'b0;              
      txv2_nss                    <= 3'b0;                 
      txv2_user_position          <= 5'b0;       
      txv2_uplink_flag            <= 1'b0;         
      txv2_beam_change            <= 1'b0;         
      txv2_dcm                    <= 1'b0;                 
      txv2_he_ltf_type            <= 2'b0;         
      txv2_doppler                <= 1'b0;             
      txv2_midamble               <= 1'b0;             
      txv2_bss_color              <= 6'b0;           
      txv2_txop_duration          <= 7'b0;       
      txv2_spatial_reuse1         <= 4'b0;       
      txv2_spatial_reuse2         <= 4'b0;       
      txv2_spatial_reuse3         <= 4'b0;       
      txv2_spatial_reuse4         <= 4'b0;       
      txv2_sig_b_compression_mode <= 1'b0;    
      txv2_dcm_sig_b              <= 1'b0;                 
      txv2_mcs_sig_b              <= 3'b0;                 
      txv2_ru_allocation1         <= 8'b0;             
      txv2_ru_allocation2         <= 8'b0;             
      txv2_ru_allocation3         <= 8'b0;             
      txv2_ru_allocation4         <= 8'b0;             
      txv2_staid                  <=11'b0;                     
      txv2_he_siga_reserved       <= 9'b0;          
      txv2_num_he_ltf             <= 3'b0;                
      txv2_he_ltf_mode            <= 1'b0;               
      txv2_ldpc_extra_symbol      <= 1'b0;         
      txv2_starting_sts_num       <= 3'b0;          
      txv3_length                 <=20'b0;                   
      txv3_packet_extension       <= 3'b0;          
      txv3_trigger_method         <= 1'b0;            
      txv3_ru_tone_set_index      <= 7'b0;         
      txv3_feedback_status        <= 1'b0;                      
     
    end
    else if(tx_state==TX_RECEIVE_VECTOR && !txv_captured && mac_macdatavalid_1t)
    begin
      txv_count <= n_txv_count;
      if(txv_count<5'd8)
      begin
        /*********************************************************************
        * TXV COMMON
        *********************************************************************/
        case(txv_count)
          5'd0:
          begin 
            txv1_preamble_type               <= mac_txdata_1t[7];
            txv1_ch_bandwidth                <= mac_txdata_1t[6:4];
            txv1_format                      <= mac_txdata_1t[3:0];
          end
          5'd1: 
          begin
            txv1_antenna_set                 <= mac_txdata_1t; 
          end
          5'd2: 
          begin
            txv1_txpwr_level_index           <= mac_txdata_1t; 
          end
          5'd3: 
          begin
            txv1_time_of_departure_requested <= mac_txdata_1t[6];
            txv1_n_tx                        <= mac_txdata_1t[2:0]; 
          end
          5'd4: 
          begin
            txv1_l_length[7:0]               <= mac_txdata_1t;
          end
          5'd5: 
          begin
            txv1_l_rate                      <= mac_txdata_1t[7:4]; 
            txv1_l_length[11:8]              <= mac_txdata_1t[3:0]; 
          end
          5'd6: 
          begin
            txv1_service[7:0]                <= mac_txdata_1t;     
          end
          default:
          begin
            
            if(txv1_format==HE_TB)
              txv1_trigger_responding <= 1'b1;
          
            if(txv1_format!=NON_HT && txv1_format!=NON_HT_DUP)
              txv1_update                      <= 1'b1;    //  trigger_responding is in txv1         
            
            txv1_service[15:8]               <= mac_txdata_1t;     
           end
        endcase
      end
      else
      begin
        case(txv1_format)
          /*******************************************************************
          * TXV NON_HT
          *******************************************************************/
          NON_HT,NON_HT_DUP:
          begin
            case(txv_count)
              5'd8: 
              begin
                txv1_update             <= 1'b1;          
                txv1_trigger_responding <= mac_txdata_1t[0];
              end
              default:
              begin
                txv_captured            <= 1'b1;
                txv2_update             <= 1'b1;
                txv3_update             <= 1'b1;
                txv2_smmindex           <= mac_txdata_1t;
              end
            endcase
          end
          /*******************************************************************
          * TXV HT
          *******************************************************************/
          HT_MM,HT_GF:
          begin
            case(txv_count)
              5'd8:
              begin 
                txv2_num_ext_ss   <= mac_txdata_1t[6:5];
                txv2_stbc         <= mac_txdata_1t[4];
                txv2_aggregation  <= mac_txdata_1t[3];
                txv2_gi_type      <= {1'b0,mac_txdata_1t[2]}; /* TODO: align with RX encoding */
                txv2_smoothing    <= mac_txdata_1t[1];
                txv2_sounding     <= mac_txdata_1t[0];
              end
              5'd9: 
              begin
                txv2_smmindex     <= mac_txdata_1t;
              end
              5'd10: 
              begin
                txv2_fec_coding   <= mac_txdata_1t[7];
                txv2_mcs          <= mac_txdata_1t[6:0];
              end
              5'd11: 
              begin
                txv3_length[ 7:0] <= mac_txdata_1t;
              end
              default: 
              begin
                txv_captured      <= 1'b1;
                txv2_update       <= 1'b1;
                txv3_update       <= 1'b1;
                txv3_length[15: 8]<= mac_txdata_1t;
                txv3_length[19:16]<= 4'b0;
              end
            endcase
          end
          /*******************************************************************
          * TXV VHT
          *******************************************************************/
          VHT:
          begin
            case(txv_count)                                                                                                                   
              5'd8:                                                                                                                           
              begin                                                                                                                           
                txv2_doze_not_allowed <= mac_txdata_1t[5];                                                                                    
                txv2_stbc             <= mac_txdata_1t[4];                                                                                    
                txv2_gi_type          <= {1'b0,mac_txdata_1t[2]};                                                                             
                txv2_beamformed       <= mac_txdata_1t[1];                                                                                    
                txv2_sounding         <= mac_txdata_1t[0];                                                                                    
              end                                                                                                                             
              5'd9:                                                                                                                           
              begin                                                                                                                           
                txv2_partial_aid[7:0] <= mac_txdata_1t;                                                                                       
              end                                                                                                                             
              5'd10:                                                                                                                          
              begin                                                                                                                           
                txv2_group_id         <= mac_txdata_1t[6:1];                                                                                  
                txv2_partial_aid[8]   <= mac_txdata_1t[0];                                                                                    
              end                                                                                                                             
              5'd11:                                                                                                                          
              begin                                                                                                                           
                txv2_n_user           <= mac_txdata_1t;                                                                                       
              end                                                                                                                             
              5'd12:                                                                                                                          
              begin                                                                                                                           
                txv2_smmindex         <= mac_txdata_1t;                                                                                       
              end
              5'd13:                                                                                                                          
              begin                                                                                                                           
                txv2_fec_coding       <= mac_txdata_1t[7];                                                                                       
                txv2_nss              <= mac_txdata_1t[ 6:4];                                                                                       
                txv2_mcs              <= {3'b0,mac_txdata_1t[ 3:0]};
              end                                                                                                                             
              5'd14: 
              begin
                txv3_length[ 7: 0]    <= mac_txdata_1t; 
              end                                                                                       
              5'd15: 
              begin
                txv3_length[15: 8]    <= mac_txdata_1t;                                                                                        
              end
              default: 
              begin
                txv2_user_position    <= {3'b0,mac_txdata_1t[7:6]};
                txv3_length[19:16]    <= mac_txdata_1t[3:0];
                txv_captured          <= 1'b1;
                txv2_update           <= 1'b1;
                txv3_update           <= 1'b1;
              end   
            endcase
          end
          /*******************************************************************
          * TXV HE_SU,HE_EXT_SU
          *******************************************************************/
          HE_SU,HE_EXT_SU:
          begin
            case(txv_count)
              5'd8:                                     
              begin                                    
                txv2_stbc            <= mac_txdata_1t[4];       
                txv2_gi_type         <= mac_txdata_1t[3:2];     
                txv2_beamformed      <= mac_txdata_1t[1];       
                txv2_sounding        <= mac_txdata_1t[0];       
              end                                         
              5'd9:                                        
              begin                                       
                txv2_midamble        <= mac_txdata_1t[6];       
                txv2_doppler         <= mac_txdata_1t[5];       
                txv2_he_ltf_type     <= mac_txdata_1t[4:3];     
                txv2_dcm             <= mac_txdata_1t[2];       
                txv2_beam_change     <= mac_txdata_1t[1];       
                txv2_uplink_flag     <= mac_txdata_1t[0];       
              end                                       
              5'd10:                                     
              begin                                     
                txv2_bss_color       <= mac_txdata_1t[5:0];      
              end                                       
              5'd11: 
              begin
                txv2_txop_duration   <= mac_txdata_1t[6:0]; 
              end
              5'd12:
              begin
                txv2_spatial_reuse1  <= mac_txdata_1t[3:0]; 
              end
              5'd13:
              begin
                txv2_smmindex        <= mac_txdata_1t;
              end 
              5'd14:
              begin
                txv2_fec_coding      <= mac_txdata_1t[7];
                txv2_nss             <= mac_txdata_1t[6:4];
                txv2_mcs             <= {3'b0,mac_txdata_1t[3:0]};
              end
              5'd15:
              begin
                txv3_length[ 7: 0]   <= mac_txdata_1t;
              end
              5'd16:
              begin
                txv3_length[15: 8]   <= mac_txdata_1t;
              end
              default: 
              begin
                txv3_packet_extension<= mac_txdata_1t[6:4];
                txv3_length[19:16]   <= mac_txdata_1t[3:0];
                txv_captured         <= 1'b1;
                txv2_update          <= 1'b1;
                txv3_update          <= 1'b1;
              end
            endcase
          end
          /*******************************************************************
          * TXV HE_MU
          *******************************************************************/
          HE_MU:
          begin
            case(txv_count)
              5'd8:
              begin
                txv2_stbc            <= mac_txdata_1t[4];
                txv2_gi_type         <= mac_txdata_1t[3:2];
                txv2_beamformed      <= mac_txdata_1t[1];
                txv2_sounding        <= mac_txdata_1t[0];
              end
              5'd9: 
              begin
                txv2_midamble        <= mac_txdata_1t[6];       
                txv2_doppler         <= mac_txdata_1t[5];
                txv2_he_ltf_type     <= mac_txdata_1t[4:3];
                txv2_dcm             <= mac_txdata_1t[2];
                txv2_beam_change     <= mac_txdata_1t[1];
                txv2_uplink_flag     <= mac_txdata_1t[0]; 
              end
              5'd10: 
              begin
                txv2_bss_color       <= mac_txdata_1t[5:0]; 
              end
              5'd11:
              begin
                txv2_txop_duration   <= mac_txdata_1t[6:0]; 
              end
              5'd12:
              begin
                txv2_spatial_reuse1  <= mac_txdata_1t[3:0]; 
              end
              5'd13:
              begin
                txv2_mcs_sig_b              <= mac_txdata_1t[4:2];
                txv2_dcm_sig_b              <= mac_txdata_1t[1];
                txv2_sig_b_compression_mode <= mac_txdata_1t[0];
              end
              5'd14:
              begin
                txv2_ru_allocation1  <= mac_txdata_1t;
              end
              5'd15:
              begin
                txv2_ru_allocation2  <= mac_txdata_1t; 
              end
              5'd16:
              begin
                txv2_ru_allocation3  <= mac_txdata_1t; 
              end
              5'd17: 
              begin
                txv2_ru_allocation4  <= mac_txdata_1t;
              end
              5'd18:
              begin
                txv2_n_user          <= mac_txdata_1t;
              end  
              5'd19:
              begin
                txv2_smmindex        <= mac_txdata_1t;
              end
              5'd20:
              begin
                txv2_fec_coding      <= mac_txdata_1t[7];
                txv2_nss             <= mac_txdata_1t[6:4];
                txv2_mcs             <= {3'b0,mac_txdata_1t[3:0]};
              end
              5'd21:
              begin
                txv3_length[ 7: 0]   <= mac_txdata_1t;
              end
              5'd22:
              begin
                txv3_length[15: 8]   <= mac_txdata_1t;
              end
              5'd23:
              begin
                txv3_packet_extension <= mac_txdata_1t[6:4];
                txv3_length[19:16]    <= mac_txdata_1t[3:0];
              end
              5'd24:
              begin
                txv2_staid[7:0]      <= mac_txdata_1t;       
              end
              default: 
              begin
                txv_captured         <= 1'b1;                
                txv2_update          <= 1'b1;                
                txv3_update          <= 1'b1;                
                txv2_user_position   <= mac_txdata_1t[7:3];  
                txv2_staid[10:8]     <= mac_txdata_1t[2:0];  
              end
            endcase
          end
          /*******************************************************************
          * TXV HE_TB
          *******************************************************************/
          default:
          begin
            case(txv_count)
              5'd8:
              begin
                txv2_stbc            <= mac_txdata_1t[4];
                txv2_gi_type         <= mac_txdata_1t[3:2];
                txv2_beamformed      <= mac_txdata_1t[1];
                txv2_sounding        <= mac_txdata_1t[0];
              end
              5'd9: 
              begin
                txv2_midamble        <= mac_txdata_1t[6];
                txv2_doppler         <= mac_txdata_1t[5];
                txv2_he_ltf_type     <= mac_txdata_1t[4:3];
                txv2_dcm             <= mac_txdata_1t[2];
                txv2_beam_change     <= mac_txdata_1t[1];
                txv2_uplink_flag     <= mac_txdata_1t[0]; 
              end
              5'd10: 
              begin
                txv2_bss_color       <= mac_txdata_1t[5:0]; 
              end
              5'd11:
              begin
                txv2_txop_duration   <= mac_txdata_1t[6:0]; 
              end
              5'd12:
              begin
                txv2_spatial_reuse2  <= mac_txdata_1t[7:4]; 
                txv2_spatial_reuse1  <= mac_txdata_1t[3:0]; 
              end
              5'd13: 
              begin
                txv2_spatial_reuse4  <= mac_txdata_1t[7:4]; 
                txv2_spatial_reuse3  <= mac_txdata_1t[3:0]; 
              end
              5'd14: 
              begin
                txv2_he_siga_reserved[7:0] <= mac_txdata_1t; 
              end
              5'd15: 
              begin
                txv2_ldpc_extra_symbol   <= mac_txdata_1t[5];
                txv2_he_ltf_mode         <= mac_txdata_1t[4];
                txv2_num_he_ltf          <= mac_txdata_1t[3:1];
                txv2_he_siga_reserved[8] <= mac_txdata_1t[0];
              end 
              5'd16:
              begin
                txv2_starting_sts_num    <= mac_txdata_1t[2:0];
              end
              5'd17:
              begin
                txv2_ru_allocation1      <= mac_txdata_1t;
              end
              5'd18:
              begin
                txv2_smmindex            <= mac_txdata_1t;
              end
              5'd19: 
              begin
                txv2_update              <= 1'b1;
                txv2_fec_coding          <= mac_txdata_1t[7];
                txv2_nss                 <= mac_txdata_1t[6:4];
                txv2_mcs                 <= {3'b0,mac_txdata_1t[3:0]};
              end
              5'd20: 
              begin
                txv3_length[ 7: 0] <= mac_txdata_1t;
              end
              5'd21: 
              begin
                txv3_length[15: 8] <= mac_txdata_1t;
              end
              5'd22: 
              begin
                txv3_trigger_method   <= mac_txdata_1t[7];
                txv3_packet_extension <= mac_txdata_1t[6:4];
                txv3_length[19:16]    <= mac_txdata_1t[3:0];
              end
              default: 
              begin
                txv_captured           <= 1'b1;
                txv3_update            <= 1'b1;
                txv3_feedback_status   <= mac_txdata_1t[7];
                txv3_ru_tone_set_index <= mac_txdata_1t[6:0];
              end
            endcase
          end
        endcase
      end
    end
  end

  assign txv_total_length = 
    (txv1_format==NON_HT || txv1_format==NON_HT_DUP)?{8'd0,txv1_l_length}:txv3_length;


  /*****************************************************************************
  * MAC PATH FIFO / 16 entries
  *****************************************************************************/
  assign n_txfifo_rq_count = txfifo_rq_count + 20'd1;                                                           
  assign n_txfifo_wr_count = txfifo_wr_count + 20'd1;                                                           
  assign n_txfifo_rd_count = txfifo_rd_count + 20'd1;                                                           
 
  /* tx fifo write port */
  always @(*)
  begin
    n_txfifo = txfifo;
    n_txfifo[8*txfifo_wr_count[3:0] +: 8] = mac_txdata_1t;  
  end

  /* tx fifo read port */
  assign n_tx_data = txfifo[ 8*txfifo_rd_count[3:0] +: 8];
  assign n_tx_last = n_txfifo_rd_count==txv_total_length;                                  

  /* txfifo flags */
  assign txfifo_rq_full    = {~txfifo_rq_count[4],txfifo_rq_count[3:0]}==txfifo_rd_count[4:0];                
  assign txfifo_empty      = txfifo_wr_count[4:0] == txfifo_rd_count[4:0];                                          
  assign txfifo_rq_done    = txfifo_rq_count==txv_total_length;                            
  assign txfifo_wr_done    = txfifo_wr_count==txv_total_length;                            
  assign txfifo_rd_done    = txfifo_rd_count==txv_total_length;                                
  
  /*****************************************************************************
  * TX FIFO
  *****************************************************************************/
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      tx_data          <=   8'b0;
      tx_last          <=   1'b0;
      tx_valid         <=   1'b0;
      tx_done          <=   1'b0;
      txfifo           <= 128'b0;
      txfifo_rd_count  <=  20'b0;
      txfifo_wr_count  <=  20'b0;
    end
    else if(tx_state==TX_RECEIVE_DATA)
    begin
      /*************************************************************************
      * OUTPUT SLOTS
      *************************************************************************/
      if(tx_ready)
      begin
        /* tx_data output slot is consumed */
        tx_data        <= 16'd0;
        tx_last        <= 1'b0;
        tx_valid       <= 1'b0;
        /* update slot done */
        if(tx_valid && tx_last || (txv_total_length==20'd0))
        begin
          tx_done <= 1'b1;
        end
      end

      /*************************************************************************
      * TXFIFO write port
      *************************************************************************/
      if(mac_macdatavalid_1t && !txfifo_wr_done)                                                
      begin                                                                                     
        txfifo          <= n_txfifo;                                         
        txfifo_wr_count <= n_txfifo_wr_count;                                      
      end                                                                                      
     
      /*************************************************************************
      * TXFIFO read ports to OUTPUT SLOTS
      *************************************************************************/
      if(tx_ready || !tx_valid)                                           
      begin
        if(!txfifo_empty && !txfifo_rd_done)                                                
        begin                                                                               
          tx_data          <= n_tx_data;                                              
          tx_last          <= n_tx_last;                                         
          tx_valid         <= 1'b1;
          txfifo_rd_count  <= n_txfifo_rd_count;
        end                                          
      end                                                                                       
    end                             
    else                            
    begin                           
      /* default */
      tx_data          <=  8'b0;  
      tx_last          <=  1'b0;
      tx_valid         <=  1'b0;
      tx_done          <=  1'b0;
      txfifo_rd_count  <= 20'b0;  
      txfifo_wr_count  <= 20'b0;  
    end                             
  end

  /*****************************************************************************
  * RXVECTOR
  *****************************************************************************/
  always @(*)
  begin
    n_rxv     = 8'd0;
    rxv1_sent = 1'd0;
    if(rxv_count<5'd6)
    begin
      case(rxv_count)
        5'd0:
        begin
          n_rxv[7]    = rxv1_preamble_type;
          n_rxv[6:4]  = rxv1_ch_bandwidth;
          n_rxv[3:0]  = rxv1_format;
        end
        5'd1:
        begin
          n_rxv      = agclat_rx_antennaset;
        end
        5'd2:
        begin
          n_rxv      = agclat_rssi1;
        end
        5'd3:
        begin
          n_rxv      = rxv2_l_length[7:0];
        end
        5'd4:
        begin
          n_rxv[7:4] = rxv2_l_rate;
          n_rxv[3:0] = rxv2_l_length[11:8];
        end
        default:
        begin
          n_rxv      = rxv2_rssi;
        end
      endcase
    end
    else
    begin
      case(rxv1_format)
        NON_HT,NON_HT_DUP:
        begin
          n_rxv[7]    = rxv2_l_sig_valid;
          n_rxv[2:1]  = rxv2_ch_bandwidth_in_non_ht;
          n_rxv[0]    = rxv2_dyn_bandwidth_in_non_ht;
          rxv1_sent   = 1'd1;
        end
        HT_MM,HT_GF:
        begin
          case(rxv_count)
            5'd6:
            begin
              n_rxv[7]   = rxv2_l_sig_valid;
              n_rxv[6:5] = rxv2_num_ext_ss;
              n_rxv[4]   = rxv2_stbc;
              n_rxv[3]   = rxv2_aggregation;
              n_rxv[2]   = rxv2_gi_type==2'b0;
              n_rxv[1]   = rxv2_smoothing;
              n_rxv[0]   = rxv2_sounding;
            end
            5'd7:
            begin
              n_rxv[7]   = rxv2_fec_coding;
              n_rxv[6:0] = rxv2_mcs[6:0];
            end
            5'd8:
            begin
              n_rxv      = rxv2_length[7:0];
            end
            default:
            begin
              n_rxv       = rxv2_length[15:8];
              rxv1_sent   = 1'd1;
            end
          endcase
        end
        VHT:
        begin
          case(rxv_count)
            5'd6:
            begin
              n_rxv[7]   = 1'b0;
              n_rxv[6]   = rxv2_first_user;
              n_rxv[5]   = rxv2_doze_not_allowed;
              n_rxv[4]   = rxv2_stbc;
              n_rxv[3]   = 1'b0;
              n_rxv[2]   = rxv2_gi_type==2'b0;
              n_rxv[1]   = rxv2_beamformed;
              n_rxv[0]   = rxv2_sounding;
            end
            5'd7:
            begin
              n_rxv      = rxv2_partial_aid[7:0];
            end
            5'd8:
            begin
              n_rxv[6:1] = rxv2_group_id[5:0];
              n_rxv[0]   = rxv2_partial_aid[8];
            end
            5'd9:
            begin
              n_rxv[7]   = rxv2_fec_coding;
              n_rxv[6:4] = rxv2_nss;
              n_rxv[3:0] = rxv2_mcs[3:0];
            end
            5'd10:
            begin
              n_rxv      = rxv2_length[7:0];
            end
            5'd11:
            begin
              n_rxv      = rxv2_length[15:8];
            end
            default:
            begin
              n_rxv       = {4'b0,rxv2_length[19:16]};
              rxv1_sent   = 1'd1;
            end
          endcase
        end
        default:
        begin
          case(rxv_count)
            5'd6:
            begin
              n_rxv[4]   = rxv2_stbc;
              n_rxv[3:2] = (rxv2_gi_type==2'd1) ? 2'd0 :
                           (rxv2_gi_type==2'd2) ? 2'd1 : 2'd2;
              n_rxv[1]   = rxv2_beamformed;
              n_rxv[0]   = rxv2_sounding;
            end
            5'd7:
            begin
              n_rxv[5]   = rxv2_doppler;
              n_rxv[4:3] = rxv2_he_ltf_type;
              n_rxv[2]   = rxv2_dcm;
              n_rxv[1]   = rxv2_beam_change;
              n_rxv[0]   = rxv2_uplink_flag;
            end
            5'd8:
            begin
              n_rxv[5:0] = rxv2_bss_color;
            end
            5'd9:
            begin
              n_rxv[6:0] = rxv2_txop_duration;
            end
            5'd10:
            begin
              n_rxv[7:4] = rxv2_spatial_reuse;
              n_rxv[3:0] = rxv2_pe_duration;
            end
            5'd11:
            begin
              case(rxv1_format)
                HE_MU:
                begin
                  n_rxv[7:5] = rxv2_rulen;
                  n_rxv[4:2] = rxv2_mcs_sig_b;
                  n_rxv[1]   = rxv2_dcm_sig_b;
                  n_rxv[0]   = rxv2_sig_b_compression_mode;
                end
                HE_TB:
                begin
                  n_rxv      = rxv2_n_user;
                  rxv1_sent  = 1'd1; // $todo : temporary fix #9351
                end
                default: ;
              endcase 
            end
            5'd12:
            begin
              n_rxv[7]   = rxv2_fec_coding;
              n_rxv[6:4] = rxv2_nss;
              n_rxv[3:0] = rxv2_mcs[3:0];
            end
            5'd13:
            begin
              n_rxv      = rxv2_length[7:0];
            end
            5'd14:
            begin
              n_rxv      = rxv2_length[15:8];
            end
            5'd15:
            begin
              n_rxv      = {4'b0,rxv2_length[19:16]};
              rxv1_sent  = rxv1_format!=HE_TB;
            end
            5'd16:
            begin
              n_rxv      = rxv2_staid[7:0];
            end
            5'd17:
            begin
              n_rxv[2:0] = rxv2_staid[10:8];
            end
            default: ;
          endcase
        end
      endcase
    end
  end
 
  assign n_rxv_count = rxv_count + 5'd1;
 
  /* alias */
  always @(*)
  begin
    if(rxv1_format==NON_HT || rxv1_format==NON_HT_DUP)
    begin
      rxv_total_length = {8'b0,rxv2_l_length};
    end
    else
    begin
      rxv_total_length = rxv2_length;
    end
  end

  /*****************************************************************************
  * RX DATA FIFO / 2 entries
  ******************************************************************************/
  always @(*)
  begin
    n_rxfifo = rxfifo;
    if(!rxfifo_wr_count[0])
    begin
      n_rxfifo[7: 0] = rx_data;
    end
    else
    begin
      n_rxfifo[15:8] = rx_data;
    end
  end

  assign n_rxfifo_wr_count = rxfifo_wr_count + 20'd1;
  assign n_rxfifo_rd_count = rxfifo_rd_count + 20'd1;
  assign rxfifo_wr_done    = rxfifo_wr_count == rxv_total_length;
  assign rxfifo_rd_done    = rxfifo_rd_count == rxv_total_length;
  assign rxfifo_full       = {~rxfifo_wr_count[1],rxfifo_wr_count[0]}==rxfifo_rd_count[1:0];   
  assign rxfifo_empty      = rxfifo_wr_count[1:0]==rxfifo_rd_count[1:0];   
  assign n_mac_rxdata      = rxfifo_rd_count[0]?rxfifo[15:8]:rxfifo[7:0];
  assign rx_ready          = !rxfifo_full && rx_state==RX_SEND_DATA;

  /*****************************************************************************
  * RX FIFO
  *****************************************************************************/
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      rxfifo             <= 16'b0;
      rxfifo_wr_count    <= 20'b0; 
    end
    else
    begin
      /*************************************************************************  
      * PHY0/1 RX DATA
      * note: phy1_rxdata_ready/phy0_rxdata_ready are derived from rxfifo_full
      *************************************************************************/  
      if(rx_state==RX_SEND_DATA)                                                  
      begin                                                                       
        if(!rxfifo_wr_done)
        begin
          if(rx_ready && rx_valid)                              
          begin                                                                   
            rxfifo          <= n_rxfifo;                                          
            rxfifo_wr_count <= n_rxfifo_wr_count;                                 
          end                                                                     
        end                                                                      
      end
      else
      begin
        rxfifo_wr_count   <= 20'b0;  
      end                                                                         
    end
  end

  /*****************************************************************************
  * FSM
  *****************************************************************************/
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      mac_phyrdy          <= 1'b0;        
      mac_txdata_1t       <= 8'b0;        
      mac_macdatavalid_1t <= 1'b0;        
      txfifo_rq_count     <= 20'b0;       

      mac_txend            <= 1'b0;        
      mac_phyerr           <= 1'b0;        
      mfsm_txreq           <= 1'b0;        
      mfsm_txabort         <= 1'b0;        
      mfsm_sendrxv1_1t     <= 1'b0;        
      mfsm_sendrxv2_1t     <= 1'b0;        
    
      tx_state             <= TX_IDLE;     
      
      mfsm_rxreq           <= 1'b0;        
      mfsm_rxvector1_done  <= 1'b0;        
      mfsm_rxend           <= 1'b0;        
      mac_rxrifsdetected   <= 1'b0;        
      mac_rxdata           <= 8'b0;        
      mac_rxerr            <= 1'b0;        
      mac_rxend            <= 1'b0;        
      mac_rxendfortiming   <= 1'b0;        
      rxendfortiming_state <= 1'b0;        
      rxfifo_rd_count      <= 20'b0;  
      rxv_count            <= 5'b0;
      rx_state             <= RX_IDLE;     

      agclat_rx_antennaset <= 8'b0;        
      agclat_rssi1         <= 8'b0;        
      agclat_rssi2         <= 8'b0;        
      agclat_rssi3         <= 8'b0;        
      agclat_rssi4         <= 8'b0;        
      agclat_rcpi          <= 8'b0;        
      agclat_evm1          <= 8'b0;        
      agclat_evm2          <= 8'b0;        
      agclat_evm3          <= 8'b0;        
      agclat_evm4          <= 8'b0;        

      mac_cca_primary20    <= 1'b0;        
      mac_cca_secondary20  <= 1'b0;        
      mac_cca_secondary40  <= 1'b0;        
      mfsm_keeprfon        <= 1'b0;        

      scramblerinit        <= 7'd1;
      
    end
    else
    begin
      /*************************************************************************
      * RTZ for pulse
      * important: FSMs below shall not assign the following signals to zero 
      *************************************************************************/
      mac_txend            <= 1'b0;
      mac_phyerr           <= 1'b0;
      mac_phyrdy           <= 1'b0;

      mac_rxerr            <= 1'b0;
      mac_rxend            <= 1'b0;
      mac_rxendfortiming   <= 1'b0;
      
      /* because of large fanout (fifo), re-registered input */
      mac_txdata_1t        <= mac_txdata;
      mac_macdatavalid_1t  <= mac_macdatavalid;

      /* edge detection */
      mfsm_sendrxv1_1t     <= mfsm_sendrxv1;
      mfsm_sendrxv2_1t     <= mfsm_sendrxv2;
     
      /*************************************************************************
      * TX FSM
      *************************************************************************/
      case(tx_state)
        /***********************************************************************
        * TX_IDLE
        ***********************************************************************/
        TX_IDLE:
        begin
          mfsm_txreq        <= 1'b0;
          mfsm_txabort      <= 1'b0;
          if(mac_txreq)
          begin 
            mfsm_txreq <= 1'b1;
            tx_state   <= TX_RECEIVE_VECTOR;
          end
        end

        /***********************************************************************
        * TX_RECEIVE_VECTOR
        ***********************************************************************/
        TX_RECEIVE_VECTOR:
        begin
          if(!mac_txreq)
          begin
            /* TX ABORT */
            mfsm_txabort <= 1'b1;
            tx_state     <= TX_END;
          end
          else if(mfsm_phyerr)
          begin
            /* TX PHYERR */
            mac_phyrdy   <= 1'b0;
            mac_phyerr   <= 1'b1;
            tx_state     <= TX_END;
          end
          else if(txv_captured)
          begin 
            tx_state <= TX_RECEIVE_DATA;                                                           
          end
        end
        
        /***********************************************************************
        * TX_RECEIVE_DATA
        *********************txv_coun**************************************************/
        TX_RECEIVE_DATA:
        begin
          /* mac user path */                      
          if(!txfifo_rq_full && !txfifo_rq_done)    
          begin                                     
            mac_phyrdy      <= 1'b1;                
            txfifo_rq_count <= n_txfifo_rq_count;   
          end                                       
          /* state transition */
          if(!mac_txreq)
          begin
            /* TX ABORT */
            mac_phyrdy   <= 1'b0;
            mfsm_txabort <= 1'b1;
            tx_state     <= TX_END;
          end
          else if(mfsm_phyerr)
          begin
            /* TX PHYERR */
            mac_phyrdy   <= 1'b0;
            mac_phyerr   <= 1'b1;
            tx_state     <= TX_END;
          end
          else if(tx_done)   
          begin
            /* NORMAL TERMINATION */
            tx_state  <= TX_END;
          end
        end
       
        /***********************************************************************
        * TX_END
        ***********************************************************************/
        TX_END:
        begin
          if(mfsm_txend)
          begin
            mac_txend <= 1'b1;
            tx_state  <= TX_CLOSE;
          end
          else if(!mac_txreq)
          begin
            mfsm_txabort <= 1'b1;
          end
          else if(mfsm_phyerr)
          begin
            mac_phyerr   <= 1'b1;
          end
        end

        /***********************************************************************
        * TX_CLOSE
        ***********************************************************************/
        default:
        begin
          if(!mac_txreq)
          begin
            scramblerinit     <= n_scramblerinit;
            mfsm_txreq        <= 1'b0;
            mfsm_txabort      <= 1'b0;
            txfifo_rq_count   <= 20'b0;
            tx_state          <= TX_IDLE;
          end
        end
      endcase

      /*************************************************************************
      * RXENDFORTIMING FSM
      * The FSM generates the mac_rxendfortiming pulse in expected contiguous windows: 
      * rx_state is any of[RX_SEND_VECTOR1,RX_SEND_DATA,RX_SEND_VECTOR2,RX_END,RX_ERR]
      * ,and the FSM remind that the pulse has been generated by setting the correspond
      * rxendfortiming_state.
      * In case of RX_ABORT, the RX FSM will generate the pulse if not previously generated
      * by assigning:
      *       mac_rxendfortiming <= ~rxendfor_timing state;
      *************************************************************************/
      if(rx_state==RX_IDLE)
      begin
        rxendfortiming_state <= 1'b0;
      end
      else if(!rxendfortiming_state)
      begin
        /* mac_rxendfortiming not yet been sent */
        if(mfsm_rxendfortiming && 
           ((rx_state==RX_SEND_VECTOR1) || (rx_state==RX_SEND_DATA) || (rx_state==RX_TIMING_BARRIER) || (rx_state==RX_ERROR)))
        begin
          /* send mac_rxendfortiming pulse */
          mac_rxendfortiming   <= 1'b1;
          rxendfortiming_state <= 1'b1;
        end
      end
      
      /*************************************************************************
      * RX FSM 
      *************************************************************************/
      case(rx_state)
        /***********************************************************************
        * RX_IDLE
        ***********************************************************************/
        RX_IDLE:
        begin
          if(mac_rxreq)
          begin
            /* MAC HW enters in RX 
             *
             * MAC side  : nothing has been pushed so nothing to do
             * MFSM side : mfsm_rxreq is asserted indicating MFSM to enter in RX
             */
            mfsm_rxreq  <= 1'b1;
            rx_state    <= RX_WAIT_VECTOR;
            rxv_count   <= 5'b0;
          end
          else
          begin
            mfsm_rxreq  <= 1'b0;
          end
        end
        /***********************************************************************
        * RX_WAIT_VECTOR
        ***********************************************************************/
        RX_WAIT_VECTOR:
        begin
          if(!mac_rxreq)
          begin
            /* MAC HW leaves RX
             * 
             * MAC side  : nothing has been pushed so nothing to do
             * MFSM side : because mfsm_rxreq is high, it is de-asserted
             *             indicating the PHY to cancel anything.
             *             if mfsm_sendrxv1 is asserted in this statement,it is ignored, 
             *              MFSM knows what to do because mfsmrxreq is assigned to low.
             */
            mfsm_rxreq <= 1'b0;
            rx_state   <= RX_CLOSE;
          end
          else if(mfsm_sendrxv1)
          begin
            /* MFSM indicates that a RXVECTOR1 is present
             * 
             * MAC side  : the first byte of RXVECTOR1 is pushed
             * MFSM side : nothing to do
             *
             */
            mac_phyrdy <= 1'b1;
            mac_rxdata <= n_rxv;
            rxv_count  <= n_rxv_count;
            rx_state   <= RX_SEND_VECTOR1;
          end
        end
        /***********************************************************************
        * RX_SEND_VECTOR1
        ***********************************************************************/
        RX_SEND_VECTOR1:
        begin
          if(!mac_rxreq)
          begin
            /* MAC HW leaves RX
             * 
             * MAC side  : because the first byte RXVECTOR1 byte has been pushed  but tnot the latest towards MAC,
             *    1) mac_rxerr pulse is sent to tell MAC that it will not receivedthe all expected 
             *       byte number (RXV1+DATA+RXV2).
             *    2) mac_rxendfortiming pulse is generated if it wasn't in the previous cycles (~rxendfortiming_state)
             *    3) mac_rxend pulse is generated.
             *
             * MFSM side : mfsm_rxreq is de-asserted, so the MFSM knows what to do
             *
             */
            mac_rxerr          <= 1'b1;
            mac_rxend          <= 1'b1;
            mac_rxendfortiming <= ~rxendfortiming_state;
            mfsm_rxreq         <= 1'b0;
            rx_state           <= RX_ABORT;
          end
          else if (rxv2_update || mfsm_rxerr)
          begin
           /* 
            *  for NON-HT in 11ac, the RXVECTOR1 may be paused (mac_phyrdy low) for
            *  a certain duration (from 0 to 16us) until the dynmic bandwidth info 
            *  info is available (phy0_rxvp2_update is then high).
            *  It can happen that the PHY report an RX incident while phy0_rxvp2_update is low
            *  by asserting mfsm_rxerr. In this case, the RXVECTOR1 is resumed. RX incident is then
            *  handled in the state following the end of RX_SEND_VECTOR1.
            */
            mac_phyrdy  <= 1'b1;
            rxv_count   <= n_rxv_count;
            mac_rxdata  <= n_rxv;
            if(rxv1_sent)
            begin
              /* last RXVECTOR1 byte pushed */
              mfsm_rxvector1_done <= 1'b1;
              rx_state            <= RX_SEND_DATA;
            end
          end
        end
        /***********************************************************************
        * RX_SEND_DATA
        ***********************************************************************/
        RX_SEND_DATA:
        begin
          if(!mac_rxreq)                                                         
          begin                                                                  
            /* MAC RX abort */
            mac_rxerr          <= 1'b1;
            mac_rxend          <= 1'b1;
            mac_rxendfortiming <= ~rxendfortiming_state;
            mfsm_rxreq         <= 1'b0;                                                  
            rx_state           <= RX_ABORT;                                              
          end                                                                    
          else if(mfsm_rxerr || watchdog_assert)                                                    
          begin                                                                  
            /* 1) RX incident reported by PHY 
            *  2) watchdog event: frame is finished for a while but because
            *     of an unexpected crash, all wanted bytes were not pushed
            */   
            mac_rxerr  <= 1'b1;
            rx_state   <= RX_ERROR;                                              
          end                                                                    
          else if(rxfifo_rd_done)                                                
          begin                                                                  
            /* no more payload  byte to pushed */
            rx_state   <= RX_TIMING_BARRIER;                                       
          end                                                                    
          else if(!rxfifo_empty)                                                 
          begin                                                                  
            /* there are stil payload data to push towards MAC */
            mac_phyrdy      <= 1'b1;                                             
            mac_rxdata      <= n_mac_rxdata;                                     
            rxfifo_rd_count <= n_rxfifo_rd_count;                                
          end                                                                    
        end
        /***********************************************************************
        * RX_TIMING_BARRIER
        ***********************************************************************/
        RX_TIMING_BARRIER:
        begin
          if(!mac_rxreq)
          begin
            /* MAC RX abort */
            mac_rxerr          <= 1'b1;
            mac_rxend          <= 1'b1;
            mac_rxendfortiming <= ~rxendfortiming_state;
            mfsm_rxreq         <= 1'b0;
            rx_state           <= RX_ABORT;
          end
          else if(mfsm_rxerr || watchdog_assert)                                                    
          begin                                                                  
            /* 1) RX incident reported by PHY 
            *  2) watchdog event: frame is finished for a while but because
            *     of an unexpected crash, sendrxv2 was not sent by mfsm
            */   
            mac_rxerr  <= 1'b1;
            rx_state   <= RX_ERROR;                                              
          end                                                                    
          else if(rxendfortiming_state && mfsm_sendrxv2)
          begin
            rx_state   <= RX_SEND_VECTOR2;
            mac_phyrdy <= 1'b1;
            mac_rxdata <= 8'hff;
            rxv_count  <= 5'd1;
          end
        end
        
        /***********************************************************************
        * RX_ERROR
        ***********************************************************************/
        RX_ERROR:
        begin
          if(!mac_rxreq)
          begin   
            mac_rxend          <= 1'b1;
            mac_rxendfortiming <= ~rxendfortiming_state;
            mfsm_rxreq         <= 1'b0;
            rx_state           <= RX_ABORT;
          end
          else if(rxendfortiming_state)
          begin
            /* rxendfor timing has been generated */
            mac_rxend  <= 1'b1;
            mfsm_rxend <= 1'b1;
            rx_state   <= RX_CLOSE;
          end
        end 
       
        /***********************************************************************
        * RX_SEND_VECTOR2
        ***********************************************************************/
        RX_SEND_VECTOR2:
        begin
           if(!mac_rxreq)
           begin   
            /* MAC RX abort */
             mac_rxerr          <= 1'b1;
             mac_rxend          <= 1'b1;
             mfsm_rxreq         <= 1'b0;
             rx_state           <= RX_ABORT;
           end
           else
           begin
             /* pushin RXVECTOR2 bytes */
             mac_phyrdy  <= 1'b1;
             mac_rxdata  <= 8'd0;
             rxv_count   <= n_rxv_count;
             if(n_rxv_count==5'd8)
               rx_state  <= RX_END;
           end
        end
      
        /***********************************************************************
        * RX_END
        ***********************************************************************/
        RX_END:
        begin
          if(!mac_rxreq)
          begin   
            /* note: mac_rxerr not generated because the last byte of RXVECTOR2 
             *       has been pushed.
             */
            mac_rxend  <= 1'b1;
            mfsm_rxreq <= 1'b0;
            rx_state   <= RX_ABORT;
          end
          else
          begin
            mac_rxend  <= 1'b1;
            mfsm_rxend <= 1'b1;
            rx_state   <= RX_CLOSE;
          end
        end
          
        /***********************************************************************
        * RX_ABORT
        ***********************************************************************/
        RX_ABORT:
        begin
          /* note: all pulses mac_rxendfortiming, max_rxend are generated 
           *       when entering RX_ABORT. 
           * note: mac_rxerr pulse is generated if the latest RXVECTOR2 
           *       has not been pushed.
           */
          rx_state <= RX_CLOSE;
        end
        
        /***********************************************************************
        * RX_CLOSE
        ***********************************************************************/
        default: 
        begin
          mfsm_rxreq          <= mac_rxreq;
          mac_rxdata          <= 8'b0;
          rxv_count           <= 5'b0;
          rxfifo_rd_count     <= 20'b0;

          /* wait mfsm to close rx */
          if(!mfsm_sendrxv1)
          begin
            mfsm_rxvector1_done <= 1'b0;
            mfsm_rxend          <= 1'b0;
            rx_state            <= RX_IDLE;
          end
        end
      endcase
      
      /*************************************************************************
      * capture RXVECTOR1 & RXVECTOR2 fields
      *************************************************************************/
      if(!mfsm_sendrxv1_1t && mfsm_sendrxv1)
      begin
        agclat_rx_antennaset <= agc_rx_antennaset;
        agclat_rssi1         <= agc_rssi1;          
        agclat_rssi2         <= agc_rssi2;          
        agclat_rssi3         <= agc_rssi3;          
        agclat_rssi4         <= agc_rssi4;          
      end  
        
      if(!mfsm_sendrxv2_1t && mfsm_sendrxv2)
      begin
        agclat_rcpi          <= agc_rcpi;          
        agclat_evm1          <= agc_evm1;          
        agclat_evm2          <= agc_evm2;          
        agclat_evm3          <= agc_evm3;          
        agclat_evm4          <= agc_evm4;          
      end
     
      /*************************************************************************
      * CCA 
      *************************************************************************/
      /* forwarded without any form of processing */
      mac_rxrifsdetected  <= agc_rxrifsdetected;
      mac_cca_primary20   <= agc_cca_primary20; 
      mac_cca_secondary20 <= agc_cca_secondary20;  
      mac_cca_secondary40 <= agc_cca_secondary40;  
      
      /*************************************************************************
      * KEEPRFON 
      *************************************************************************/
      /* forwarded without any form of processing */
      mfsm_keeprfon       <= mac_keeprfon;
    end
  end

  /* generate a non null scrambler init sequence */
  always @(*)
    if(scramblerinit==7'h7f)
      n_scramblerinit = 7'h01;
    else
      n_scramblerinit = scramblerinit + 7'd1;

  /*****************************************************************************
  * watchdog
  *
  * detect situation where the modem has crashed
  *
  *
  * 6400 ('h19600) cycles 
  *
  *  160M   40us     
  *  120M   63us
  *   60M  106us     
  *   30M  213us
  *
  *****************************************************************************/
  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      watchdog_reset_req    <= 1'b0;
      watchdog_rxend_count  <= 14'd0;
      watchdog_rxend_active <= 1'b0;
      watchdog_assert_count <= 5'd0;
      watchdog_assert       <= 1'd0;
    end
    else
    begin
      /* RTZ */
      watchdog_reset_req    <= 1'b0;

      if(!watchdog_assert)
      begin
        watchdog_assert_count <= 5'd0;
        /* missing rxend assertion */                                
        if(mac_rxreq)                                                
        begin                                                        
          /* enable rxend guard */                                   
          if(mac_rxendfortiming)                                     
          begin                                                      
            watchdog_rxend_active <= 1'b1;                           
            watchdog_rxend_count  <= 14'd0;                          
          end                                                        
                                                                     
          /* disable rxend guard */                                  
          if(mac_rxend)                                              
          begin                                                      
            watchdog_rxend_active <= 1'b0;                           
            watchdog_rxend_count  <= 14'd0;                          
          end                                                        
                                                                     
          /* cound rxend guard */
          if(watchdog_rxend_active)                                  
          begin                                                      
            if(watchdog_rxend_count==14'd6400)
            begin                       
              /* missing rxend assertion detected */                 
              watchdog_assert      <= 1'b1;
            end
            else                                                     
              watchdog_rxend_count <= watchdog_rxend_count + 14'd1;  
          end                                                        
        end                                                          
        else                                                         
        begin                                                        
          watchdog_rxend_count  <= 14'd0;                            
          watchdog_rxend_active <= 1'b0;                             
        end 
      end
      else
      begin
        /* 32 cycles before reseting, this lets enough time to the generated rxend/rxerr pulse
        *  to leave the logic that is going to be reset 
        */
        if(watchdog_assert_count==5'h1f)
        begin
          /* reset */
          watchdog_reset_req    <= 1'b1;
          watchdog_assert_count <= 5'd0;
          watchdog_assert       <= 1'd0;
          watchdog_rxend_count  <= 14'd0;                            
          watchdog_rxend_active <= 1'b0;
        end
        else
        begin
          watchdog_assert_count <= watchdog_assert_count + 5'd1;
        end 
      end                                                         
    end
  end

  /*****************************************************************************
  * diagnostics
  *****************************************************************************/
  /* diag and assert */
  reg  [31:0] diag_mac_m2t,diag_mac_m1t;
  reg  [31:0] diag_mfsm_m2t,diag_mfsm_m1t;
  reg  [31:0] diag_states_m2t,diag_states_m1t;

  always @(posedge clk,negedge rst_n)
    if(!rst_n)
    begin
      diag_mac_m2t    <= 32'b0;
      diag_mac_m1t    <= 32'b0;
      diag_mac        <= 32'b0;
      diag_mfsm_m2t   <= 32'b0;
      diag_mfsm_m1t   <= 32'b0;
      diag_mfsm       <= 32'b0;
      diag_states_m2t <= 32'b0;
      diag_states_m1t <= 32'b0;
      diag_states     <= 32'b0;
    end
    else
    begin
      /* mac probes */
      diag_mac_m2t[31:16] <= 
        {1'b0,mac_txreq,mac_rxreq,mac_keeprfon,mac_phyrdy,mac_mimocmdvalid,
         mac_macdatavalid,mac_txend,mac_phyerr,mac_rxerr,mac_rxend,mac_rxendfortiming,mac_rxrifsdetected,
         mac_cca_primary20,mac_cca_secondary20,mac_cca_secondary40};
      diag_mac_m2t[15: 8] <= mac_txdata;
      diag_mac_m2t[ 7: 0] <= mac_rxdata;
      diag_mac_m1t        <= diag_mac_m2t;
      diag_mac            <= diag_mac_m1t;
      
      /* mfsm/rxv probes */
      diag_mfsm_m2t[31:16] <= 
        {5'b0,
         rxv2_update,rxv1_update,rx_last,rx_ready,rx_valid,
         txv3_update,txv2_update,txv1_update,tx_last,tx_ready,tx_valid};
      diag_mfsm_m2t[15: 0] <= 
        {watchdog_rxend_active,watchdog_assert,watchdog_reset_req, 
         mfsm_keeprfon,agc_rxrifsdetected,
         mfsm_txreq,mfsm_txabort,mfsm_phyerr,mfsm_txend,mfsm_rxreq,
         mfsm_sendrxv2,mfsm_sendrxv1,mfsm_rxendfortiming,mfsm_rxend,mfsm_rxerr,
         mfsm_rxvector1_done};
      diag_mfsm_m1t        <= diag_mfsm_m2t;
      diag_mfsm            <= diag_mfsm_m1t;
      
      /* states probes */
      diag_states_m2t <= 
        {rxv1_format[3:0],rxv2_smoothing,rxv1_ch_bandwidth[1:0],
         rxv2_sounding,rxv2_update,
         txfifo_wr_count[3:0],txfifo_rq_count[3:0],txfifo_rd_count[3:0],
         rxfifo_wr_count[1:0],rxfifo_rd_count[1:0],tx_state[2:0],rx_state[3:0]};
      diag_states_m1t <= diag_states_m2t;
      diag_states     <= diag_states_m1t;
      
    end

`ifdef RW_SIMU_ON
  /*****************************************************************************
  * SIMU
  *****************************************************************************/
  reg [32*8-1:0] str_tx_state;
  reg [32*8-1:0] str_rx_state;
  always @(*)
  begin
    case(tx_state)
      TX_IDLE:           str_tx_state = "TX_IDLE";
      TX_RECEIVE_VECTOR: str_tx_state = "TX_RECEIVE_VECTOR";
      TX_RECEIVE_DATA:   str_tx_state = "TX_RECEIVE_DATA";
      TX_END:            str_tx_state = "TX_END";
      TX_CLOSE:          str_tx_state = "TX_CLOSE";
      default:           str_tx_state = "XXXXXXXXXXXXXX";
    endcase
  
    case(rx_state)
      RX_IDLE:           str_rx_state = "RX_IDLE";
      RX_WAIT_VECTOR:    str_rx_state = "RX_WAIT_VECTOR";
      RX_SEND_VECTOR1:   str_rx_state = "RX_SEND_VECTOR1";
      RX_SEND_DATA:      str_rx_state = "RX_SEND_DATA";
      RX_TIMING_BARRIER: str_rx_state = "RX_TIMING_BARRIER";
      RX_SEND_VECTOR2:   str_rx_state = "RX_SEND_VECTOR2";
      RX_END:            str_rx_state = "RX_END";
      RX_ERROR:          str_rx_state = "RX_ERROR";
      RX_ABORT:          str_rx_state = "RX_ABORT";
      RX_CLOSE:          str_rx_state = "RX_CLOSE";
      default:           str_rx_state = "XXXXXXXXXXXXXX";
    endcase
  end
`endif

endmodule
`default_nettype wire
