//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 21263 $
// $Date: 2015-09-09 16:28:21 +0200 (Wed, 09 Sep 2015) $
// ---------------------------------------------------------------------------
// Dependencies     : 
// Description      : ArcTan Table for Cordic Phase Calculator
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MDMCOMMON/DSP/verilog/rtl/ArcTanLUT.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module ArcTanLUT #(parameter ANGLEWIDTH = 10,
                   parameter SCALING =  0
                  )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input   wire     [4:0]                         Index, //Index for LUT from Cordic

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output  wire     [ANGLEWIDTH-1:0]              ArcTan //Value of ArcTan to Cordic
            );

//////////////////////////////////////////////////////////////////////////////
// Internal Registred Declarations
//////////////////////////////////////////////////////////////////////////////
reg                [31:0]              ArcTanInt;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Calculates ArcTan(2^-Index) * 2^32.
assign ArcTan = ArcTanInt[31:(31 - ANGLEWIDTH + 1)];

generate
   if(SCALING == 0)
     begin : gen_sc_eq_0
      //NO SCALING
      //2^32 * ArcTan(2^-Index)
      always @ (*)
         begin: ArcTanLUT_Blk
            case (Index[4:0])
               5'd0:    ArcTanInt = 32'b11001001000011111101101010100010;
               5'd1:    ArcTanInt = 32'b01110110101100011001110000010110;
               5'd2:    ArcTanInt = 32'b00111110101101101110101111110010;
               5'd3:    ArcTanInt = 32'b00011111110101011011101010011011;
               5'd4:    ArcTanInt = 32'b00001111111110101010110111011100;
               5'd5:    ArcTanInt = 32'b00000111111111110101010101101111;
               5'd6:    ArcTanInt = 32'b00000011111111111110101010101011;
               5'd7:    ArcTanInt = 32'b00000001111111111111110101010101;
               5'd8:    ArcTanInt = 32'b00000000111111111111111110101011;
               5'd9:    ArcTanInt = 32'b00000000011111111111111111110101;
               5'd10:   ArcTanInt = 32'b00000000001111111111111111111111;
               5'd11:   ArcTanInt = 32'b00000000001000000000000000000000;
               5'd12:   ArcTanInt = 32'b00000000000100000000000000000000;
               5'd13:   ArcTanInt = 32'b00000000000010000000000000000000;
               5'd14:   ArcTanInt = 32'b00000000000001000000000000000000;
               5'd15:   ArcTanInt = 32'b00000000000000100000000000000000;
               5'd16:   ArcTanInt = 32'b00000000000000010000000000000000;
               5'd17:   ArcTanInt = 32'b00000000000000001000000000000000;
               5'd18:   ArcTanInt = 32'b00000000000000000100000000000000;
               5'd19:   ArcTanInt = 32'b00000000000000000010000000000000;
               5'd20:   ArcTanInt = 32'b00000000000000000001000000000000;
               5'd21:   ArcTanInt = 32'b00000000000000000000100000000000;
               5'd22:   ArcTanInt = 32'b00000000000000000000010000000000;
               5'd23:   ArcTanInt = 32'b00000000000000000000001000000000;
               5'd24:   ArcTanInt = 32'b00000000000000000000000100000000;
               5'd25:   ArcTanInt = 32'b00000000000000000000000010000000;
               5'd26:   ArcTanInt = 32'b00000000000000000000000001000000;
               5'd27:   ArcTanInt = 32'b00000000000000000000000000100000;
               5'd28:   ArcTanInt = 32'b00000000000000000000000000010000;
               5'd29:   ArcTanInt = 32'b00000000000000000000000000001000;
               5'd30:   ArcTanInt = 32'b00000000000000000000000000000100;
               5'd31:   ArcTanInt = 32'b00000000000000000000000000000010;
               default: ArcTanInt = 32'b00000000000000000000000000000001;
            endcase
         end //ArcTanLUT_Blk
     end //Generate
   else 
     begin : gen_sc_neq_0
      //SCALING = pi/4 = 111111111111111
      //2^32 * ArcTan(2^-Index) * 4/pi
      always @ (*)
         begin: ArcTanLUT_Sc_Blk
            case (Index[4:0])

               5'd0:    ArcTanInt = 32'b11111111111111111111111111111111;
               5'd1:    ArcTanInt = 32'b10010111001000000010100011101101;
               5'd2:    ArcTanInt = 32'b01001111110110011100001011011011;
               5'd3:    ArcTanInt = 32'b00101000100010001000111010100001;
               5'd4:    ArcTanInt = 32'b00010100010110000110101000011000;
               5'd5:    ArcTanInt = 32'b00001010001011101011111100001011;
               5'd6:    ArcTanInt = 32'b00000101000101111011000011110011;
               5'd7:    ArcTanInt = 32'b00000010100010111110001010101001;
               5'd8:    ArcTanInt = 32'b00000001010001011111001010011010;
               5'd9:    ArcTanInt = 32'b00000000101000101111100101110110;
               5'd10:   ArcTanInt = 32'b00000000010100010111110011000000;
               5'd11:   ArcTanInt = 32'b00000000001010001011111001100001;
               5'd12:   ArcTanInt = 32'b00000000000101000101111100110000;
               5'd13:   ArcTanInt = 32'b00000000000010100010111110011000;
               5'd14:   ArcTanInt = 32'b00000000000001010001011111001100;
               5'd15:   ArcTanInt = 32'b00000000000000101000101111100110;
               5'd16:   ArcTanInt = 32'b00000000000000010100010111110011;
               5'd17:   ArcTanInt = 32'b00000000000000001010001011111010;
               5'd18:   ArcTanInt = 32'b00000000000000000101000101111101;
               5'd19:   ArcTanInt = 32'b00000000000000000010100010111110;
               5'd20:   ArcTanInt = 32'b00000000000000000001010001011111;
               5'd21:   ArcTanInt = 32'b00000000000000000000101000110000;
               5'd22:   ArcTanInt = 32'b00000000000000000000010100011000;
               5'd23:   ArcTanInt = 32'b00000000000000000000001010001100;
               5'd24:   ArcTanInt = 32'b00000000000000000000000101000110;
               5'd25:   ArcTanInt = 32'b00000000000000000000000010100011;
               5'd26:   ArcTanInt = 32'b00000000000000000000000001010001;
               5'd27:   ArcTanInt = 32'b00000000000000000000000000101001;
               5'd28:   ArcTanInt = 32'b00000000000000000000000000010100;
               5'd29:   ArcTanInt = 32'b00000000000000000000000000001010;
               5'd30:   ArcTanInt = 32'b00000000000000000000000000000101;
               5'd31:   ArcTanInt = 32'b00000000000000000000000000000011;
               default: ArcTanInt = 32'b00000000000000000000000000000001;

            endcase
         end //ArcTanLUT_Sc_Blk
     end // Generate
endgenerate


endmodule //ArcTanLUT

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
