//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: asboui $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 2950 $
// $Date: 2012-07-03 13:30:35 +0200 (Tue, 03 Jul 2012) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Cordic Prerotation (Quadrant Fixing) Module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://oringot@svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/IPs/HW/Modem/Src/ofdm/FFT128/verilog/CordicQuadRot.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module CordicQuadRot #(parameter  DATAWIDTH = 14 // Input Data Size
                      )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Control Signals
            input   wire              [1:0]                QuadRot, //Quadrant Fixing

            //Data
            input   wire   signed     [DATAWIDTH-1:0]      ReDataIn, //Real Component of Data
            input   wire   signed     [DATAWIDTH-1:0]      ImDataIn, //Imag Component of Data

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output  reg signed  [DATAWIDTH-1:0]            ReDataOut,
            output  reg signed  [DATAWIDTH-1:0]            ImDataOut
            );


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This modules performs the prerotation operation on the Input Data. This is
//same as fixing the quadrant of the output. The QuadRot value indicates the
//rotation that is required. 00 = 1; 01 = j; 10 = -1; 11 = -j;

always @(*)
   begin: QuadRot_Block
      case (QuadRot[1:0])

         2'd0: begin
            ReDataOut = ReDataIn;
            ImDataOut = ImDataIn;
         end

         2'd1: begin
            ReDataOut = -ImDataIn;
            ImDataOut = ReDataIn;
         end

         2'd2: begin
            ReDataOut = -ReDataIn;
            ImDataOut = -ImDataIn;
         end

         default: begin
            ReDataOut = ImDataIn;
            ImDataOut = -ReDataIn;
         end
      endcase
   end //QuadRot_Block


endmodule //CordicQuadRot

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
