//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 21263 $
// $Date: 2015-09-09 16:28:21 +0200 (Wed, 09 Sep 2015) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Delay Line with variable datawidth and latency
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MDMCOMMON/DSP/verilog/rtl/DelayLine.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module DelayLine #(parameter DATAWIDTH = 14, //Width of Input Data
                   parameter LATENCY   = 14 //Latency in terms of PhyClk
                  )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input   wire                                   nPhyRst,  //Active Low Reset
            input   wire                                   PhyClk,   //Phy Clock
            //Control
            input   wire                                   Bypass,  //Bypass the delay line
            //Data
            input   wire        [DATAWIDTH-1:0]            DataIn,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Data
            output  wire       [DATAWIDTH-1:0]             DataOut
            );

//////////////////////////////////////////////////////////////////////////////
// Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                [DATAWIDTH-1:0]     ShiftReg[LATENCY-1:0];

//Integers
integer i,j;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Delay Block
always @ (posedge PhyClk or negedge nPhyRst)
   begin: Delay_Blk
      if (nPhyRst == 1'b0) begin
         for (i=0; i<LATENCY; i=i+1) begin
            ShiftReg[i] <= {DATAWIDTH{1'b0}};
         end
      end
      else begin
         ShiftReg[0] <= DataIn;
         for (j=1; j<LATENCY; j=j+1) begin
            ShiftReg[j] <= ShiftReg[j-1];
         end
      end
   end

//Assign Output depending on Bypass signal
assign DataOut = (Bypass) ? DataIn:ShiftReg[LATENCY-1];


endmodule //DelayLine

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
