////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 25514 $
// $Date: 2016-03-30 17:18:31 +0200 (Wed, 30 Mar 2016) $
// -------------------------------------------------------------------------
// Dependencies     :
// Description      : Generates approx absolute value of a complex no.
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :                                    
// References       :
// Revision History :
// -------------------------------------------------------------------------
//                                                                        
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MDMCOMMON/DSP/verilog/rtl/ModApprox.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

`default_nettype none

module ModApprox #(parameter SUM_WIDTH = 11,
                   parameter CORRVAL_WIDTH = 11
                  )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input   wire                        PhyClk,
            input   wire                        nPhyRst,
            //Control
            input   wire                        ComputeOn,
            //Data
            input   wire signed [SUM_WIDTH-1:0] ISum,
            input   wire signed [SUM_WIDTH-1:0] QSum,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   reg    [CORRVAL_WIDTH-1:0] CorrVal
            );


//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declaration
//////////////////////////////////////////////////////////////////////////////
localparam       [SUM_WIDTH-1:0]      SUM_WIDTH_0     = {{SUM_WIDTH}{1'b0}};
localparam       [CORRVAL_WIDTH-1:0]  CORRVAL_WIDTH_0 = {{CORRVAL_WIDTH}{1'b0}};

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires & Registers declarations
//////////////////////////////////////////////////////////////////////////////
wire                                   Compare;
wire              [SUM_WIDTH-1:0]      ModI;
wire              [SUM_WIDTH-1:0]      ModQ;
wire              [CORRVAL_WIDTH-1:0]  CorrValRound;
reg               [SUM_WIDTH-1:0]      Max;
reg               [SUM_WIDTH-1:0]      Min;
reg               [SUM_WIDTH+2:0]      Z;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This circuit computes the approximate value of the |ISum + jQSum|. 
//It is calculated using following steps:
//
//1. Find minimum (m) and maximum (M) among abs(ISum) and abs(QSum)
//2. If  (M > 2*m), then compute Z=8*M + 2*m;Else, Z=8*M - M + 4*m
//3. Result = Z/8; Round this to the required number of bits


//Step 1:
//First compute the absolute value of ISum and QSum
assign ModI = (ISum[SUM_WIDTH-1]) ? -ISum : ISum;
assign ModQ = (QSum[SUM_WIDTH-1]) ? -QSum : QSum;

//Next find Min and Max among ModI and ModQ
assign Compare = (ModI > ModQ) ? 1'b1:1'b0;


always @ (posedge PhyClk or negedge nPhyRst)
   begin: MM_Block 
      if (nPhyRst == 1'b0) begin
         Min <= SUM_WIDTH_0; // 'b0;
         Max <= SUM_WIDTH_0; // 'b0;
      end
      else if (ComputeOn == 1'b0) begin
         Min <= SUM_WIDTH_0; // 'b0;
         Max <= SUM_WIDTH_0; // 'b0;
      end
      else begin
         if(Compare == 1'b1) begin
            Min <= ModQ;
            Max <= ModI;
         end
         else begin
            Min <= ModI;
            Max <= ModQ;
         end
      end
   end //MM_Block

//Step 2
//Compute Z as given above in (2)
always @ (*)
   begin: Z_Block
      if({1'b0,Max} > {Min,1'b0})
         Z = {Max,3'b0} + {2'b0,Min,1'b0};
      else
         Z = {Max,3'b0} - {3'b0,Max} + {1'b0,Min,2'b0};
   end //Z_Block

//Step 3
//Round to CORRVAL_WIDTH
//Since we are rounding by 3 bits in this case, the output will be Round(Z/8)

USgnRound #(
        .INPUT_WIDTH(SUM_WIDTH+3),
        .OUTPUT_WIDTH(CORRVAL_WIDTH)
       )
       U_ROUND1
               (
                .InputData(Z),
                .RoundData(CorrValRound)
               );

//Register the output
always @ (posedge PhyClk or negedge nPhyRst)
   begin: Rounding_Block
      if (nPhyRst == 1'b0)
         CorrVal <= CORRVAL_WIDTH_0; //'b0;
      else if (ComputeOn == 1'b0)
         CorrVal <= CORRVAL_WIDTH_0; //'b0;
      else
         CorrVal <= CorrValRound;
   end //Rounding_Block

endmodule //ModApprox

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
