////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: asboui $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 3181 $
// $Date: 2012-07-12 17:10:36 +0200 (Thu, 12 Jul 2012) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Block to perform LSB Rounding             
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                        
// $HeadURL: https://dbchef@svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/HW/Modem/Src/ofdm/TxFreqDomain/verilog/Round.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


`default_nettype none

module Round #(parameter INPUT_WIDTH  = 15,
               parameter OUTPUT_WIDTH = 14
              )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input   wire   signed    [INPUT_WIDTH-1:0]    InputData,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   reg   signed    [OUTPUT_WIDTH-1:0]   RoundData
            );

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This block performs rounding operation on the input data stream depending
//on the number of bits specified
//There are three possible cases:
//a)Width of output is more than input - no rounding is required
//b)Overflow - directly truncate LSBs
//c)Normal - Add the most significant bit among the LSBs being removed

generate
  if((OUTPUT_WIDTH-1) >= (INPUT_WIDTH-1)) begin : NO_ROUND_GEN
    always @ (*)
    begin: No_Round_Block
      //If Rounding Width is more than or equal to the input width
      //then directly assign with sign extension
      RoundData = InputData;
    end //No_Round_Block
  end
endgenerate

generate
  if((INPUT_WIDTH-1) > (OUTPUT_WIDTH-1)) begin : ROUND_GEN
    always @ (*)
    begin: Round_Block
      if ((InputData[INPUT_WIDTH-1] == 1'b0)
               && (&InputData[(INPUT_WIDTH-2):
               ((INPUT_WIDTH-2)-(OUTPUT_WIDTH-1))] == 1'b1)) begin
         //Overflow Case - truncate the LSBs rather than round
         RoundData = $signed(InputData[(INPUT_WIDTH-1):((INPUT_WIDTH-1)-(OUTPUT_WIDTH-1))]);
      end
      else begin
         //Add the most significant bit among those being rounded
         RoundData = $signed(InputData[(INPUT_WIDTH-1):((INPUT_WIDTH-1)-(OUTPUT_WIDTH-1))])
                   + $signed({{OUTPUT_WIDTH-1{1'b0}},InputData[(INPUT_WIDTH-1) - OUTPUT_WIDTH]});
      end
    end //Round_Block
  end
endgenerate


endmodule //Round

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
