////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: asboui $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 3173 $
// $Date: 2012-07-12 11:17:35 +0200 (Thu, 12 Jul 2012) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Signed Symmetric Saturation Block (IPWIDTH = OPWIDTH)            
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                        
// $HeadURL: https://dbchef@svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/HW/Modem/Src/ofdm/TDFO/verilog/SatEquSigned.v $
//
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

`default_nettype none

module SatEquSigned #(parameter INPUT_WIDTH  = 10,
                      parameter OUTPUT_WIDTH = 10
                     )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input   wire   signed    [INPUT_WIDTH-1:0]     InputData,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   reg   signed    [OUTPUT_WIDTH-1:0]    SatSymData
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam signed  [INPUT_WIDTH-1:0]     CONST_1      = {{{(INPUT_WIDTH-1)}{1'b0}},1'b1};

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This Block performs symmetric saturation when the output width is equal to
//the input width - Special Case when there is only one possible saturation
//The negative maximum is changed to negative max-1

generate
  if(INPUT_WIDTH != OUTPUT_WIDTH) begin : NO_SATEQU_GEN
    always @ (*)
    begin: NoSat_Block
      //No Saturation Required
      SatSymData = $signed(InputData[(OUTPUT_WIDTH-1):0]);
    end //NoSat_Block
  end
endgenerate

generate
  if(INPUT_WIDTH == OUTPUT_WIDTH) begin : SATEQU_GEN
    always @ (*)
    begin: Sat_Block
      if ((InputData[INPUT_WIDTH-1] == 1'b1) &&
         (|InputData[(INPUT_WIDTH-2):0] == 1'b0))
        SatSymData = InputData + CONST_1;
      else
        SatSymData = InputData;
    end //Sat_Block
  end
endgenerate


endmodule //Sat_Signed

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
