////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: asboui $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 2880 $
// $Date: 2012-06-29 11:16:42 +0200 (Fri, 29 Jun 2012) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Signed Saturation Block             
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                        
// $HeadURL: https://dbchef@svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/HW/Modem/Src/common/TxRxFrontend/verilog/SatSigned.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

`default_nettype none

module SatSigned #(parameter INPUT_WIDTH  = 14,
                   parameter OUTPUT_WIDTH = 11)
            (
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input   wire signed    [INPUT_WIDTH-1:0]    InputData,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output  reg signed    [OUTPUT_WIDTH-1:0]   SatData
            );


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This block performs signed saturation by comparing the input with
//the max possible positive number and the min possible negative
//number that can be represented at the output bit width.
//It is the equivalent of SC_SAT used in System C

always @ (*)
   begin: Sat_Block
      if((InputData[INPUT_WIDTH-1] == 1'b0) &&
         (InputData[(INPUT_WIDTH-2):(OUTPUT_WIDTH-1)] != {{((INPUT_WIDTH-2)-(OUTPUT_WIDTH-1)+1)}{1'b0}}))
         //Positive Saturation
         SatData = $signed({1'b0,{(OUTPUT_WIDTH-1){1'b1}}});
      else if((InputData[INPUT_WIDTH-1] == 1'b1) &&
              (&InputData[(INPUT_WIDTH-2):(OUTPUT_WIDTH-1)] != 1'b1))
         //Negative Saturation
         SatData = $signed({1'b1,{(OUTPUT_WIDTH-1){1'b0}}});
      else
         //No Saturation Required
         SatData = $signed(InputData[(OUTPUT_WIDTH-1):0]);
   end //Sat_Block

endmodule //SatSigned

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
