////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: asboui $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 3181 $
// $Date: 2012-07-12 17:10:36 +0200 (Thu, 12 Jul 2012) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Signed Symmetric Saturation Block             
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                        
// $HeadURL: https://dbchef@svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/HW/Modem/Src/ofdm/TxFreqDomain/verilog/SatSymSigned.v $
//
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

`default_nettype none

module SatSymSigned #(parameter INPUT_WIDTH  = 12,
                      parameter OUTPUT_WIDTH = 5
                     )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input   wire signed    [INPUT_WIDTH-1:0]       InputData,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output  reg signed    [OUTPUT_WIDTH-1:0]       SatSymData
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam    signed [(INPUT_WIDTH-OUTPUT_WIDTH-1):0] CONST_ZERO_INOUTWIDTH   = {{(INPUT_WIDTH-OUTPUT_WIDTH)}{1'b0}};
localparam    signed [OUTPUT_WIDTH-1:0]               CONST_OUTPUT_WIDTH_NS1  = {1'b0,{{(OUTPUT_WIDTH-1)}{1'b1}}};

localparam    signed [OUTPUT_WIDTH-2:0]   CONST_OUTPUT_WIDTH_NS0  = {{(OUTPUT_WIDTH-1)}{1'b0}};
localparam    signed [OUTPUT_WIDTH-1:0]   CONST_OUTPUT_WIDTH_S0   = {1'b1,{{(OUTPUT_WIDTH-1)}{1'b0}}};
localparam    signed [OUTPUT_WIDTH-1:0]   CONST_OUTPUT_WIDTH_S1   = {{{(OUTPUT_WIDTH-1)}{1'b0}},1'b1};


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This block performs signed symmetric saturation by comparing the input
//with the max possible positive number and the min possible negative
//number(read exception below) that can be represented at the output bit
//width.The only exception being that the output is symmetric about 0,
//so the min signed number will be one more than the theoretical
//range. For example, if the saturation is to 11 bits, the max positive
//number is 1023 and min negative number is -1024. However in this case,
//the min negative number will be fixed to -1023.
//It is the equivalent of SC_SatSyM used in System C

always @ (*)
   begin: Sat_Block
      if((InputData[INPUT_WIDTH-1] == 1'b0) &&
         (InputData[(INPUT_WIDTH-2):(OUTPUT_WIDTH-1)] != CONST_ZERO_INOUTWIDTH))
         //Positive Saturation
         SatSymData = CONST_OUTPUT_WIDTH_NS1;
      else if(((InputData[INPUT_WIDTH-1] == 1'b1) &&
              (&InputData[(INPUT_WIDTH-2):(OUTPUT_WIDTH-1)] != 1'b1)) ||
              ((InputData[INPUT_WIDTH-1] == 1'b1) &&
              (&InputData[(INPUT_WIDTH-2):(OUTPUT_WIDTH-1)] == 1'b1) &&
              (InputData[(OUTPUT_WIDTH-2):0] == CONST_OUTPUT_WIDTH_NS0)))
         //Negative Symmetric Saturation
         SatSymData = CONST_OUTPUT_WIDTH_S0 + CONST_OUTPUT_WIDTH_S1;
      else
         //No Saturation Required
         SatSymData = $signed(InputData[OUTPUT_WIDTH-1:0]);
   end //Sat_Block

endmodule //Sat_Signed

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
