////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: asboui $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 3106 $
// $Date: 2012-07-10 10:20:22 +0200 (Tue, 10 Jul 2012) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Signed Saturation Block             
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                        
// $HeadURL: https://dbchef@svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/HW/Modem/Src/ofdm/MimoEqualiser/verilog/SatUnsigned.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

`default_nettype none

module SatUnsigned #(parameter INPUT_WIDTH  = 14,
                     parameter OUTPUT_WIDTH = 11
                    )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input   wire       [INPUT_WIDTH-1:0]    InputData,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   reg       [OUTPUT_WIDTH-1:0]   SatData
            );


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////


//This block performs signed saturation by comparing the input with
//the max possible positive number

always @ (*)
   begin: Sat_Block
      if(InputData[(INPUT_WIDTH - 1):(OUTPUT_WIDTH)] != {{((INPUT_WIDTH-1)-(OUTPUT_WIDTH)+1)}{1'b0}})
         //Positive Saturation
         SatData = {(OUTPUT_WIDTH){1'b1}};
      else
         //No Saturation Required
         SatData = InputData[(OUTPUT_WIDTH-1):0];
   end //Sat_Block

endmodule //SatSigned

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
