//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: rblanc $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 9857 $
// $Date: 2013-08-28 15:13:05 +0200 (Wed, 28 Aug 2013) $
// ---------------------------------------------------------------------------
// Dependencies     : 
// Description      : Shift Add Stage for Rotation Cordic
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       : shift_adder module from RW_WLAN RefIP
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/Common/DSP/verilog/ShiftAdder.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module ShiftAdder #(parameter STAGE  = 0,
                    parameter SADATAWIDTH = 18
                   )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input    wire                                  ZSign, //1= Neg; 0 = Pos
            input    wire    [SADATAWIDTH-1:0]             XIn, //Real Component
            input    wire    [SADATAWIDTH-1:0]             YIn, //Imaginary Component

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   wire      [SADATAWIDTH-1:0]           XOut, //Real Component
            output   wire      [SADATAWIDTH-1:0]           YOut //Imaginary Component
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam signed  [SADATAWIDTH-1:0]   CONST_1   = {{{(SADATAWIDTH-1)}{1'b0}},1'b1};

//////////////////////////////////////////////////////////////////////////////
// Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire               [SADATAWIDTH-1:0]   XInInt;
wire               [SADATAWIDTH-1:0]   YInInt;

//////////////////////////////////////////////////////////////////////////////
// Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
wire               [SADATAWIDTH-1:0]   XInShift;
wire               [SADATAWIDTH-1:0]   YInShift;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//The inputs are right shifted by STAGE bits (*2^(-STAGE))
//XInShift = 2^(-STAGE)*XIn
assign XInShift[SADATAWIDTH-1:(SADATAWIDTH-STAGE)-1]= {{(STAGE + 1)}{XIn[SADATAWIDTH-1]}};
assign XInShift[(SADATAWIDTH-STAGE)-2:0]            = XIn[SADATAWIDTH-2:STAGE];

//YInShift = 2^(-STAGE)*YIn
assign YInShift[SADATAWIDTH-1:(SADATAWIDTH-STAGE)-1]= {{(STAGE + 1)}{YIn[SADATAWIDTH-1]}};
assign YInShift[(SADATAWIDTH-STAGE)-2:0]            = YIn[SADATAWIDTH-2:STAGE];

//XInShift and YInShift are 2s complemented.
//XInInt = (1-2*ZSign)*XInShift
assign XInInt = (!ZSign) ? XInShift : ~(XInShift) + CONST_1;

//YInInt = -(1-2*ZSign)*YInShift
assign YInInt = (ZSign)  ? YInShift : ~(YInShift) + CONST_1;

//Outputs gen
assign XOut = XIn + YInInt;
assign YOut = YIn + XInInt;


endmodule //ShiftAdder

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
