////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: asboui $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 3064 $
// $Date: 2012-07-06 15:41:19 +0200 (Fri, 06 Jul 2012) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Block to perform LSB Rounding of Unsigned Numbers             
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                        
// $HeadURL: https://dbchef@svn.frso.rivierawaves.com:/svn/rw_wlan_nx/trunk/IPs/HW/Modem/Src/ofdm/TDFO/verilog/USgnRound.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


`default_nettype none

module USgnRound #(parameter INPUT_WIDTH  = 15,
                   parameter OUTPUT_WIDTH = 14
                  )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input   wire     [INPUT_WIDTH-1:0]       InputData,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   reg     [OUTPUT_WIDTH-1:0]      RoundData
            );


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This block performs rounding operation on the input data stream depending
//on the number of bits specified
//There are three possible cases:
//a)Width of output is more than input - no rounding is required
//b)Overflow - directly truncate LSBs
//c)Normal - Add the most significant bit among the LSBs being removed

generate
  if((OUTPUT_WIDTH-1) >= (INPUT_WIDTH-1)) begin : NO_USGNROUND_GEN
    always @ (*)
    begin: No_USgnRound_Block
      //If Rounding Width is more than or equal to the input width
      //then directly assign with zero extension
      RoundData = InputData;
    end //No_USgnRound_Block
  end
endgenerate

generate
  if((INPUT_WIDTH-1) > (OUTPUT_WIDTH-1)) begin : USGNROUND_GEN
    always @ (*)
       begin: USgnRound_Block
          if (&InputData[(INPUT_WIDTH-1):
                   ((INPUT_WIDTH-1)-(OUTPUT_WIDTH-1))] == 1'b1) begin
             //Overflow Case - truncate the LSBs rather than round
             RoundData = InputData[(INPUT_WIDTH-1):
                                   ((INPUT_WIDTH-1)-(OUTPUT_WIDTH-1))];
          end
          else begin 
             //Add the most significant bit among those being rounded
             RoundData = InputData[(INPUT_WIDTH-1):((INPUT_WIDTH-1)-(OUTPUT_WIDTH-1))]
                       + {{OUTPUT_WIDTH-1{1'b0}},InputData[(INPUT_WIDTH-1) - OUTPUT_WIDTH]};
          end
       end //USgnRound_Block
  end
endgenerate


endmodule //USgnRound

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
