////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 15272 $
// $Date: 2014-06-11 10:50:04 +0200 (Wed, 11 Jun 2014) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : AGC & CCA FSM Top Level
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/AGCCCAFSMTop.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module AGCCCAFSMTop #(parameter NRX             =  4, // Number of Rx Chains (1 to 4)
                      parameter AGCRAMWIDTH     = 32, // Datawidth of AGC RAM
                      parameter BW_PARAM        = 80, // Bandwidth (20/40/80)
                      parameter DATAOUTOFDMAC   = 22, // OFDM Auto  Corr Width
                      parameter DATAOUTOFDMCC   = 20, // OFDM Cross Corr Width
                      parameter DATAOUTDSSSAC   = 22, // DSSS Auto  Corr Width
                      parameter DATAOUTDSSSCC   = 20, // DSSS Cross Corr Width
                      parameter DATAOUTOFDMREF  = 19, // OFDM Reference  Width
                      parameter DATAOUTDSSSREF  = 20, // DSSS Reference  Width
                      parameter DBVPOW_WIDTH    = 12, // Data width of dBV power
                      parameter DBMPOW_WIDTH    = 13  // Data width of dBm power
                      )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            // Clock and Reset
            input    wire                                  AGCClk,    //AGC Clock
            input    wire                                  nAGCRst,   //Active Low Reset

            // From AGC RAM
            input    wire              [AGCRAMWIDTH-1:0]   AGCMemRdData, //To AGC FSM Core

            // External control signals
            input    wire                                  HTSTFStartEstimP,    //HTSTF start estimation request
            input    wire                                  HTSTFGainUpdateP,    //HTSTF gain update request
            input    wire                                  RxEndTimingP,        //End of Packet on Air
            input    wire                                  LSIGValid,           //Legacy Signal Field Valid
            input    wire                                  HTSIGValid,          //HT Signal Field Valid
            input    wire                                  SFDFound,            //SFD Complete
            input    wire                                  DemodRun,            //Demodulation is running
            input    wire                                  RifsEn,              //RIFS Detection Enable
            input    wire                                  BWDetected,          //Bandwidth detected
            input    wire                                  BWSup20,             //Bandwidth is 40MHz or 80MHz
            input    wire                                  BWEq20,              //Bandwidth is 20MHz
            input    wire                                  BWEq40,              //Bandwidth is 40MHz
            input    wire                                  BWEq80,              //Bandwidth is 80MHz
            input    wire                                  VHTSig,              //VHT Packet
            input    wire                                  NoACIMargin,         //Packet with no ACI margin
            input    wire              [6:0]               HTSIGMCS,            //MCS from HTSIG field
            input    wire                                  InbdPowStartCaptureP,//Capture Inband power
            input    wire                                  StatusTrigConf,      //Confirmation for status register capture

            // From Radar
            input    wire                                  FomSing,      // FOM singuliar status
            input    wire                                  FomHigh,      // FOM high status
            input    wire                                  FomMed,       // FOM low status
            input    wire                                  FreqSing,     // Frequency singuliar status
            input    wire                                  FreqDC,       // Frequency DC status
            input    wire                                  FreqLow,      // Frequency low status
            input    wire                                  FreqHigh,     // Frequency high status
            input    wire                                  LengthLow,    // Timer length low status
            input    wire                                  LengthHigh,   // Timer length high status
            input    wire                                  Meas1Done,    // Measure 1 done status
            input    wire                                  Meas2Done,    // Measure 2 done status
            input    wire                                  Meas3Done,    // Measure 3 done status

            // From Radio Controller
            input    wire                                  RCProgRFDone, // Programming Done
            input    wire                                  AGCRFGainCompDone,  // Effective RF gain Done
            input    wire              [7:0]               RFGain0dB,    // Effective RF gain for Rx Chain 0
            input    wire              [7:0]               RFGain1dB,    // Effective RF gain for Rx Chain 1
            input    wire              [7:0]               RFGain2dB,    // Effective RF gain for Rx Chain 2
            input    wire              [7:0]               RFGain3dB,    // Effective RF gain for Rx Chain 3
`ifdef RW_NX_AGC_SNR_EN
            input    wire              [5:0]               RFGainNF0dB,  // Noise Factor for Rx Chain 0
            input    wire              [5:0]               RFGainNF1dB,  // Noise Factor for Rx Chain 1
            input    wire              [5:0]               RFGainNF2dB,  // Noise Factor for Rx Chain 2
            input    wire              [5:0]               RFGainNF3dB,  // Noise Factor for Rx Chain 3
`endif // RW_NX_AGC_SNR_EN
            input    wire                                  RCExtDetect0, // External Tigger Rx Chain 0
            input    wire                                  RCExtDetect1, // External Tigger Rx Chain 1
            input    wire                                  RCExtDetect2, // External Tigger Rx Chain 2
            input    wire                                  RCExtDetect3, // External Tigger Rx Chain 3

            // From Power Estimation Blocks
            // ADC Power Estimate in dBVrms
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx0, //Power in Rx Chain 0
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx1, //Power in Rx Chain 1
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx2, //Power in Rx Chain 2
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx3, //Power in Rx Chain 3

            // ADC Power Estimate in dBm
            input    wire   signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx0, //Power in Rx Chain 0
            input    wire   signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx1, //Power in Rx Chain 1
            input    wire   signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx2, //Power in Rx Chain 2
            input    wire   signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx3, //Power in Rx Chain 3

            // ADC Power Estimate - for saturation detection in dBVrms
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCSatPowdBVRx0, //Power in Rx Chain 0
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCSatPowdBVRx1, //Power in Rx Chain 1
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCSatPowdBVRx2, //Power in Rx Chain 2
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCSatPowdBVRx3, //Power in Rx Chain 3

            // In Band Power in dBm for 20 MHz packet
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx0, //Power in Rx Chain 0
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx1, //Power in Rx Chain 1
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx2, //Power in Rx Chain 2
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx3, //Power in Rx Chain 3

            // In Band Power in dBm for 20 MHz packet in Secondary Channel
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20SecPowdBm,

            // In Band Power in dBm for 40 MHz packet
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd40SecPowdBm,

            // Control Signals - Power Valid
            input    wire                                  ADCPowdBVValid,    //ADC Power in dBV Valid
            input    wire                                  ADCSatPowdBmValid, //ADC Sat Power in dBm Valid
            input    wire                                  ADCSatPowValid,    //ADC Sat Power Valid
            input    wire                                  InBd20PowValid,    //InBd 20 Pri Power Valid
            input    wire                                  InBd20PowCCAValid, //InBd 20 Pri Power Valid for CCA
            input    wire                                  InBd20SecPowValid, //InBd 20 Sec Power Valid
            input    wire                                  InBd40SecPowValid, //InBd 40 Sec Power Valid

            // Correlation and Reference Values
            input    wire             [DATAOUTOFDMAC-1:0]  OfdmACAccSum,// OFDM Auto Correlation Sum
            input    wire             [DATAOUTOFDMCC-1:0]  OfdmCCAccSum,// OFDM Cross Corr Sum
            input    wire             [DATAOUTDSSSAC-1:0]  DsssACAccSum,// DSSS Auto Correlation Sum
            input    wire             [DATAOUTDSSSCC-1:0]  DsssCCAccSum,// DSSS Cross Corr Sum
            input    wire             [DATAOUTDSSSREF-1:0] RefLevDsss,  // DSSS Reference Value
            input    wire             [DATAOUTOFDMREF-1:0] RefLevOfdm,  // OFDM Reference Value
            input    wire                                  RefLevDataEn,// Reference Value Valid
            
            // DSSS Continuous Correlation and Reference Values
            input    wire              [21:0]              DsssContCCAccSum,   // DSSS Continuous Cross Corr Sum
            input    wire              [21:0]              RefLevDsssCont,     // DSSS Continuous Reference Value
            input    wire                                  RefLevDsssContValid,// Reference Value Valid

            // Config Registers
            input    wire                                  Force20,             //Force 20 Mode
            input    wire                                  Force40,             //Force 40 Mode

            // AGC Registers
            input    wire              [31:0]              FSMEvent0Reg,     //Event 0 Condition
            input    wire              [31:0]              FSMEvent1Reg,     //Event 1 Condition
            input    wire              [31:0]              FSMEvent2Reg,     //Event 2 Condition
            input    wire              [31:0]              FSMEvent3Reg,     //Event 3 Condition
            input    wire              [11:0]              AGCFSMCtrl,       //AGC FSM Control
            input    wire              [25:0]              CCACtrl,          //CCA Control
            input    wire              [10:0]              RxStateCca20PSel, //CCA primary modem state
            input    wire              [10:0]              RxStateCca20SSel, //CCA secondary 20 modem state
            input    wire              [10:0]              RxStateCca40SSel, //CCA secondary 40 modem state

            input    wire              [31:0]              CCATimeoutReg, //CCA Time Out
            input    wire   signed     [9:0]               SatLowThr,     //Low Threshold
            input    wire   signed     [9:0]               SatDynHighThr, //Dynamic Low Threshold
            input    wire   signed     [9:0]               SatDynLowThr,  //Dynamic High Threshold
            input    wire              [6:0]               SatDelayCount, //Delay Counter
            input    wire   signed     [7:0]               RegDetPlat, //Plateau Detect Value in qdBm
            input    wire   signed     [7:0]               RegDetRampUp, //Ramp Up Detect Value
            input    wire   signed     [7:0]               RegDetRampDown,//Ramp Down Detect Value
            input    wire   signed     [5:0]               RegCCADetRampUp, //CCA Ramp Up Detect
            input    wire   signed     [5:0]               RegCCADetRampDown,//CCA Ramp Down Det
            input    wire              [2:0]               DelRampUpTap, //Delay line tap out
            input    wire              [2:0]               DelRampDownTap, //Delay line tap out
            input    wire              [2:0]               DelPlatTap, //Delay line tap out
            input    wire              [2:0]               DelCCARampUpTap, //Delay line tap out
            input    wire              [2:0]               DelCCARampDownTap, //Delay line tap out
            input    wire   signed     [9:0]               RegDetRiseThrqdBm,  //Threshold Rise Detection
            input    wire   signed     [9:0]               RegDetFallThrqdBm,  //Threshold Fall Detection
            input    wire   signed     [6:0]               RegADCPowDisThrdBV, //Threshold Pow Disappearance
            input    wire              [3:0]               RegADCPowDisNdl, //Delay line tap out
            input    wire   signed     [8:0]               RegInbdCCA20PPowMindBm, //CCA 20P InBand Threshold
            input    wire   signed     [7:0]               RegCCA20PRiseThrdBm,    //CCA 20P Rise Threshold
            input    wire   signed     [7:0]               RegCCA20PFallThrdBm,    //CCA 20P Fall Threshold
            input    wire   signed     [8:0]               RegInbdCCA20SPowMindBm, //CCA 20S InBand Threshold
            input    wire   signed     [7:0]               RegCCA20SFallThrdBm,    //CCA 20S Rise Threshold
            input    wire   signed     [7:0]               RegCCA20SRiseThrdBm,    //CCA 20S Fall Threshold
            input    wire   signed     [8:0]               RegInbdCCA40SPowMindBm, //CCA 40S InBand Threshold
            input    wire   signed     [7:0]               RegCCA40SFallThrdBm,    //CCA 40S Rise Threshold
            input    wire   signed     [7:0]               RegCCA40SRiseThrdBm,    //CCA 40S Fall Threshold
            input    wire              [6:0]               RegRFGainMax4Det,     // RF gain maximum for detection in dB
            input    wire   signed     [6:0]               RegRFGainMin4Det,     // RF gain minimum for detection in dB
            input    wire              [6:0]               RegRFGainMax,         // RF gain maximum in dB
            input    wire   signed     [6:0]               RegRFGainMin,         // RF gain minimum in dB
            input    wire              [3:0]               RegAntLossdB0, //Antenna Loss in dB
            input    wire              [3:0]               RegAntLossdB1, //Antenna Loss in dB
            input    wire              [3:0]               RegAntLossdB2, //Antenna Loss in dB
            input    wire              [3:0]               RegAntLossdB3, //Antenna Loss in dB
            input    wire   signed     [3:0]               RegDigGain40vs20, // Digital gain adjustment for 40MHz
            input    wire   signed     [3:0]               RegDigGain80vs20, // Digital gain adjustment for 80MHz
`ifdef RW_NX_AGC_SNR_EN
            input    wire                                  SNRMeasSel,        //SNR Min or Max Selection
`endif // RW_NX_AGC_SNR_EN
            input    wire              [7:0]               IdInBdPowGapDnqdBm,//InBand Power Gap Down
            input    wire              [7:0]               IdInBdPowGapUpqdBm,//InBand Power Gap Up
            input    wire              [7:0]               InBdPowInfThrdBm, //InBand Power Inferior Threshold
            input    wire              [7:0]               InBdPowSupThrdBm, //InBand Power Superior Threshold
            input    wire              [7:0]               ADCPowInfThrdBV, //ADC Power in dBV Inferior Threshold
            input    wire              [7:0]               ADCPowSupThrdBV, //ADC Power in dBV Superior Threshold
            input    wire              [7:0]               ADCPowInfThrdBm, //ADC Power in dBm Inferior Threshold
            input    wire              [7:0]               ADCPowSupThrdBm, //ADC Power in dBm Superior Threshold
            input    wire              [5:0]               RegACI20MargMCS9, //ACI margin in 20MHz for MCS9 (11ac)
            input    wire              [5:0]               RegACI20MargMCS8, //ACI margin in 20MHz for MCS8 (11ac)
            input    wire              [5:0]               RegACI20MargMCS7, //ACI margin in 20MHz for MCS7/15 (11n)
            input    wire              [5:0]               RegACI20MargMCS6, //ACI margin in 20MHz for MCS6/14 (11n)
            input    wire              [5:0]               RegACI20MargMCS5, //ACI margin in 20MHz for MCS5/13 (11n)
            input    wire              [5:0]               RegACI20MargMCS4, //ACI margin in 20MHz for MCS4/12 (11n)
            input    wire              [5:0]               RegACI20MargMCS3, //ACI margin in 20MHz for MCS3/11 (11n)
            input    wire              [5:0]               RegACI20MargMCS2, //ACI margin in 20MHz for MCS2/10 (11n)
            input    wire              [5:0]               RegACI20MargMCS1, //ACI margin in 20MHz for MCS1/9 (11n)
            input    wire              [5:0]               RegACI20MargMCS0, //ACI margin in 20MHz for MCS0/8 (11n)
            input    wire              [5:0]               RegACI40MargMCS9, //ACI margin in 40MHz for MCS9 (11ac)
            input    wire              [5:0]               RegACI40MargMCS8, //ACI margin in 40MHz for MCS8 (11ac)
            input    wire              [5:0]               RegACI40MargMCS7, //ACI margin in 40MHz for MCS7/15 (11n)
            input    wire              [5:0]               RegACI40MargMCS6, //ACI margin in 40MHz for MCS6/14 (11n)
            input    wire              [5:0]               RegACI40MargMCS5, //ACI margin in 40MHz for MCS5/13 (11n)
            input    wire              [5:0]               RegACI40MargMCS4, //ACI margin in 40MHz for MCS4/12 (11n)
            input    wire              [5:0]               RegACI40MargMCS3, //ACI margin in 40MHz for MCS3/11 (11n)
            input    wire              [5:0]               RegACI40MargMCS2, //ACI margin in 40MHz for MCS2/10 (11n)
            input    wire              [5:0]               RegACI40MargMCS1, //ACI margin in 40MHz for MCS1/9 (11n)
            input    wire              [5:0]               RegACI40MargMCS0, //ACI margin in 40MHz for MCS0/8 (11n)
            input    wire              [5:0]               RegACI80MargMCS9, //ACI margin in 80MHz for MCS9 (11ac)
            input    wire              [5:0]               RegACI80MargMCS8, //ACI margin in 80MHz for MCS8 (11ac)
            input    wire              [5:0]               RegACI80MargMCS7, //ACI margin in 80MHz for MCS7/15 (11n)
            input    wire              [5:0]               RegACI80MargMCS6, //ACI margin in 80MHz for MCS6/14 (11n)
            input    wire              [5:0]               RegACI80MargMCS5, //ACI margin in 80MHz for MCS5/13 (11n)
            input    wire              [5:0]               RegACI80MargMCS4, //ACI margin in 80MHz for MCS4/12 (11n)
            input    wire              [5:0]               RegACI80MargMCS3, //ACI margin in 80MHz for MCS3/11 (11n)
            input    wire              [5:0]               RegACI80MargMCS2, //ACI margin in 80MHz for MCS2/10 (11n)
            input    wire              [5:0]               RegACI80MargMCS1, //ACI margin in 80MHz for MCS1/9 (11n)
            input    wire              [5:0]               RegACI80MargMCS0, //ACI margin in 80MHz for MCS0/8 (11n)

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            // Address for AGC RAM
            output   wire              [8:0]              AGCMemAddr, //Read Address

            // Controls
            output   wire              [14:0]             DSPEn,            //Enable for DSP Blocks
            output   reg                                  DelLineClr,       //Clear Delay Lines
            output   wire              [1:0]              AntSelDSSS,       //Antenna Mode Select for DSSS-CCK modem
            output   wire              [1:0]              AntSelBWEst,      //Antenna Mode Select for BW estimator
            output   wire                                 IQEstGainAccEn,   //IQ Imbalance gain accu enable
            output   wire                                 IQEstPhaseAccEn,  //IQ Imbalance phase accu enable

            // Interface with Radio Controller
            output   wire                                 RCProgRF,         //Program RF in single access mode
            output   wire                                 AGCRFGainCompReq, // RF Gain computation request
            output   wire              [7:0]              AGCGainTgt0,      // AGC Target Gain for Rx Chain 0
            output   wire              [7:0]              AGCGainTgt1,      // AGC Target Gain for Rx Chain 1
            output   wire              [7:0]              AGCGainTgt2,      // AGC Target Gain for Rx Chain 2
            output   wire              [7:0]              AGCGainTgt3,      // AGC Target Gain for Rx Chain 3

            // Digital Gain (in dB)
            output   wire   signed     [6:0]              DigitalGaindB20Rx0, //For Rx Chain 0 20MHz BW
            output   wire   signed     [6:0]              DigitalGaindB20Rx1, //For Rx Chain 1 20MHz BW
            output   wire   signed     [6:0]              DigitalGaindB20Rx2, //For Rx Chain 2 20MHz BW
            output   wire   signed     [6:0]              DigitalGaindB20Rx3, //For Rx Chain 3 20MHz BW
            output   wire   signed     [6:0]              DigitalGaindB40Rx0, //For Rx Chain 0 40MHz BW
            output   wire   signed     [6:0]              DigitalGaindB40Rx1, //For Rx Chain 1 40MHz BW
            output   wire   signed     [6:0]              DigitalGaindB40Rx2, //For Rx Chain 2 40MHz BW
            output   wire   signed     [6:0]              DigitalGaindB40Rx3, //For Rx Chain 3 40MHz BW
            output   wire   signed     [6:0]              DigitalGaindB80Rx0, //For Rx Chain 0 80MHz BW
            output   wire   signed     [6:0]              DigitalGaindB80Rx1, //For Rx Chain 1 80MHz BW
            output   wire   signed     [6:0]              DigitalGaindB80Rx2, //For Rx Chain 2 80MHz BW
            output   wire   signed     [6:0]              DigitalGaindB80Rx3, //For Rx Chain 3 80MHz BW

            // Interface with Modem
            output   wire                                 AGCOFDMLock,   //AGC OFDM Lock Indication
            output   wire                                 AGCOFDMHTSTF,  //AGC OFDM HTSTF Indication
            output   wire                                 AGCDSSSLock,   //AGC DSSS Lock Indication
            output   wire                                 RifsDetected,  //OFDM RIFS Indication

            // DSP Registers Dynamic Configuration - Delay Line Tap Out
            output   wire              [1:0]              ADCSWLSatConfig,    //ADC Sat Power 
            output   wire              [1:0]              ADCSWLConfig,       //ADC Power
            output   wire              [2:0]              InBd20SWLConfig,    //InBand 20 Pri Power
            output   wire              [2:0]              InBd20SecSWLConfig, //InBand 20 Sec Power
            output   wire              [2:0]              InBd40SecSWLConfig, //InBand 40 Sec Power
            
            // Power estimators
            output   wire              [7:0]              RxGain0,      //Gain for Rx Chain 0
            output   wire              [7:0]              RxGain1,      //Gain for Rx Chain 1
            output   wire              [7:0]              RxGain2,      //Gain for Rx Chain 2
            output   wire              [7:0]              RxGain3,      //Gain for Rx Chain 3

`ifdef RW_NX_AGC_SNR_EN
            //Noise Variance and SNR Related
            output   wire signed       [7:0]              NoiseVardB,       //Noise variance in dB
            output   wire                                 NoiseVardBValid,  //Qualifies NoiseVariance
            output   wire              [7:0]              SNR,              //SNR
            output   wire                                 SNRValid,         //Qualifies SNR
`endif // RW_NX_AGC_SNR_EN

            // Mode Select for Autocorrelation modules
            output   wire              [1:0]              OFDMACModeSel, //OFDM Auto Corr
            output   wire                                 DSSSACModeSel, //DSSS Auto Corr

            // To DC Estimation Module
            output   wire              [1:0]              DCMode, //Select DC Estimation mode

            // Mode Select for DSSS Continuous correlation module
            output   wire              [2:0]              DSSSContCorrModeSel, //DSSS Cont Corr

            // Interface with Radar
            output   wire              [7:0]              AGCCommand,  //Commands to Radar Module
            output   wire              [23:0]             AGCParam,    //Command Parameter
            output   wire                                 AGCCmdValid, //AGC Command Valid

            // CCA Related
            output   wire                                 CCAPrimary,        //CCA on Primary Channel
            output   wire                                 CCASecondary20,    //CCA on Secondary 20MHz Channel
            output   wire                                 CCASecondary40,    //CCA on Secondary 40MHz Channel
            output   wire                                 CCATimeOutErr,     //CCA TimeOut Error

            //Interface with status registers
            output   wire                                 StatusTrigReq,       //Request for status register capture
            output   wire signed      [9:0]               InBd20PowqdBmAnt0,   //In Band Power 20P in qdBm for Rx Chain 0
            output   wire signed      [9:0]               InBd20PowqdBmAnt1,   //In Band Power 20P in qdBm for Rx Chain 1
            output   wire signed      [9:0]               InBd20PowqdBmAnt2,   //In Band Power 20P in qdBm for Rx Chain 2
            output   wire signed      [9:0]               InBd20PowqdBmAnt3,   //In Band Power 20P in qdBm for Rx Chain 3
            output   wire                                 InBd20PowqdBmUpdate, //In Band Power 20P valid

            output   wire signed      [9:0]               InBd20SecPowqdBmAnt, //In Band Power 20S in qdBm

            output   wire signed      [9:0]               InBd40SecPowqdBmAnt, //In Band Power 40S in qdBm
            
            output   wire signed      [8:0]               ADCPowqdBVAnt0, //ADC Power Estimate in qdBVrms for Rx Chain 0
            output   wire signed      [8:0]               ADCPowqdBVAnt1, //ADC Power Estimate in qdBVrms for Rx Chain 1
            output   wire signed      [8:0]               ADCPowqdBVAnt2, //ADC Power Estimate in qdBVrms for Rx Chain 2
            output   wire signed      [8:0]               ADCPowqdBVAnt3, //ADC Power Estimate in qdBVrms for Rx Chain 3

            output   wire signed      [9:0]               InBd20PowNoiseqdBmAnt0,   //In Band Power 20P in qdBm for Rx Chain 0 for noise floor
            output   wire signed      [9:0]               InBd20PowNoiseqdBmAnt1,   //In Band Power 20P in qdBm for Rx Chain 1 for noise floor
            output   wire signed      [9:0]               InBd20PowNoiseqdBmAnt2,   //In Band Power 20P in qdBm for Rx Chain 2 for noise floor
            output   wire signed      [9:0]               InBd20PowNoiseqdBmAnt3,   //In Band Power 20P in qdBm for Rx Chain 3 for noise floor
            output   wire                                 InBd20PowNoiseqdBmUpdate, //In Band Power Noise 20P valid

            output   wire signed      [9:0]               InBd20SecPowNoiseqdBmAnt, //In Band Power 20S in qdBm for noise floor

            output   wire signed      [9:0]               InBd40SecPowNoiseqdBmAnt, //In Band Power 40S in qdBm for noise floor

            output   wire             [7:0]               RxGainAnt0,      //Gain for Rx Chain 0 in dB
            output   wire             [7:0]               RxGainAnt1,      //Gain for Rx Chain 1 in dB
            output   wire             [7:0]               RxGainAnt2,      //Gain for Rx Chain 2 in dB
            output   wire             [7:0]               RxGainAnt3,      //Gain for Rx Chain 3 in dB
                                                    
            output   wire             [7:0]               RFGainAnt0,      //RF Gain for Rx Chain 0
            output   wire             [7:0]               RFGainAnt1,      //RF Gain for Rx Chain 1
            output   wire             [7:0]               RFGainAnt2,      //RF Gain for Rx Chain 2
            output   wire             [7:0]               RFGainAnt3,      //RF Gain for Rx Chain 3

            // To external block
            output   wire                                 AGCFSMExtEn,   // AGC External enable
            
            // Debug port
            output   wire             [15:0]              DbgAgc,     // AGC status registers
            output   wire             [8:0]               DbgAgcFsm,  // FSM address index
            output   wire             [15:0]              DbgCca      // CCA internal generation
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires & Registers Declarations
//////////////////////////////////////////////////////////////////////////////
wire               [3:0]               ChCombMode;
wire                                   SatDetectRx0;
wire                                   SatDetectRx1;
wire                                   SatDetectRx2;
wire                                   SatDetectRx3;
wire                                   ExtDetectRx0;
wire                                   ExtDetectRx1;
wire                                   ExtDetectRx2;
wire                                   ExtDetectRx3;
wire                                   PlatDetEn;
wire                                   PlatDetRx0;
wire                                   PlatDetRx1;
wire                                   PlatDetRx2;
wire                                   PlatDetRx3;
wire signed        [DBMPOW_WIDTH-1:0]  InBdPowdBmDL0Rx0;
wire                                   InBdPowDL0ValidRx0;
wire signed        [DBMPOW_WIDTH-1:0]  InBdPowdBmDL0Rx1;
wire signed        [DBMPOW_WIDTH-1:0]  InBdPowdBmDL0Rx2;
wire signed        [DBMPOW_WIDTH-1:0]  InBdPowdBmDL0Rx3;
wire signed        [DBMPOW_WIDTH-1:0]  InBdPowdBmDL1Rx0;
wire                                   InBdPowDL1ValidRx0;
wire signed        [DBMPOW_WIDTH-1:0]  InBdPowdBmDL1Rx1;
wire signed        [DBMPOW_WIDTH-1:0]  InBdPowdBmDL1Rx2;
wire signed        [DBMPOW_WIDTH-1:0]  InBdPowdBmDL1Rx3;
wire                                   CorrDetEn;
wire                                   OFDMACDiff;
wire                                   OFDMCCDiff;
wire                                   BarkerACDiff;
wire                                   BarkerCCDiff;
wire                                   DSSSDetect;
wire                                   RFGainSetDoneP;
wire                                   NoGainUpdateP;
wire                                   SNREstStrtP;
wire               [1:0]               ADCPowdBVMaxIndex;
wire               [1:0]               ADCPowdBVMinIndex;
wire               [1:0]               InbandPowMaxIndex;
wire               [1:0]               InbandPowMinIndex;
wire                                   DetCrossUpRx0;
wire                                   DetCrossUpRx1;
wire                                   DetCrossUpRx2;
wire                                   DetCrossUpRx3;
wire                                   DetCrossDownRx0;
wire                                   DetCrossDownRx1;
wire                                   DetCrossDownRx2;
wire                                   DetCrossDownRx3;
wire                                   DetRampUpRx0;
wire                                   DetRampUpRx1;
wire                                   DetRampUpRx2;
wire                                   DetRampUpRx3;
wire                                   DetRampDownRx0;
wire                                   DetRampDownRx1;
wire                                   DetRampDownRx2;
wire                                   DetRampDownRx3;
wire                                   ADCPowDisRx0;
wire                                   ADCPowDisRx1;
wire                                   ADCPowDisRx2;
wire                                   ADCPowDisRx3;
wire                                   RFGainCp2MaxRx0;
wire                                   RFGainCp2MaxRx1;
wire                                   RFGainCp2MaxRx2;
wire                                   RFGainCp2MaxRx3;
wire                                   RFGainCp2MinRx0;
wire                                   RFGainCp2MinRx1;
wire                                   RFGainCp2MinRx2;
wire                                   RFGainCp2MinRx3;
wire                                   RFGainCp2Min4SatRx0;
wire                                   RFGainCp2Min4SatRx1;
wire                                   RFGainCp2Min4SatRx2;
wire                                   RFGainCp2Min4SatRx3;
wire                                   RadarDet;
wire                                   ModeA;
wire                                   ModeB;
wire               [3:0]               GPSetting;
wire                                   AGCFSMSftRst;
wire               [2:0]               CCAEnergyEn;
wire               [2:0]               CCARampUpDnEn;
wire                                   CCADisEn;
wire                                   CCASatEn;
wire                                   CCADemod;
wire                                   CCACSEn;
wire                                   CSFlagValidP;
wire                                   CSFlagAHigh;
wire                                   CSFlagALow;
wire                                   CSFlagBHigh;
wire                                   CSFlagBLow;
wire               [1:0]               CSFlagNum;
wire               [3:0]               CCAFlag0Ctrl;
wire               [3:0]               CCAFlag1Ctrl;
wire               [3:0]               CCAFlag2Ctrl;
wire               [3:0]               CCAFlag3Ctrl;
wire                                   SatDetEn;
wire    signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx0Mux;
wire    signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx1Mux;
wire    signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx2Mux;
wire    signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx3Mux;
wire    signed     [DBMPOW_WIDTH-1:0]  InBandPowRx0;
wire    signed     [DBMPOW_WIDTH-1:0]  InBandPowRx1;
wire    signed     [DBMPOW_WIDTH-1:0]  InBandPowRx2;
wire    signed     [DBMPOW_WIDTH-1:0]  InBandPowRx3;
wire                                   RampUpDetEn;
wire                                   RampDownDetEn;
wire                                   DetCrossUpEn;
wire                                   DetCrossDownEn;
wire                                   ADCPowDisDetEn;
wire                                   DSSSDetEn;
wire               [6:0]               DSSSContCCThr;
wire               [7:0]               RxGainInt0;
wire               [7:0]               RxGainInt1;
wire               [7:0]               RxGainInt2;
wire               [7:0]               RxGainInt3;
wire               [14:0]              DSPEnInt;
wire                                   EventSat;
wire                                   EventDis;
wire                                   IdPowEn;
wire                                   InBdPowSupRx0;
wire                                   InBdPowSupRx1;
wire                                   InBdPowSupRx2;
wire                                   InBdPowSupRx3;
wire                                   InBdPowInfRx0;
wire                                   InBdPowInfRx1;
wire                                   InBdPowInfRx2;
wire                                   InBdPowInfRx3;
wire                                   IdPowRx0;
wire                                   IdPowRx1;
wire                                   IdPowRx2;
wire                                   IdPowRx3;
wire                                   ADCPowdBVSupRx0;
wire                                   ADCPowdBVSupRx1;
wire                                   ADCPowdBVSupRx2;
wire                                   ADCPowdBVSupRx3;
wire                                   ADCPowdBVInfRx0;
wire                                   ADCPowdBVInfRx1;
wire                                   ADCPowdBVInfRx2;
wire                                   ADCPowdBVInfRx3;
wire                                   ADCPowdBmSupRx0;
wire                                   ADCPowdBmSupRx1;
wire                                   ADCPowdBmSupRx2;
wire                                   ADCPowdBmSupRx3;
wire                                   ADCPowdBmInfRx0;
wire                                   ADCPowdBmInfRx1;
wire                                   ADCPowdBmInfRx2;
wire                                   ADCPowdBmInfRx3;
wire    signed     [DBMPOW_WIDTH-1:0]  IdThrqdBmRx0;
wire    signed     [DBMPOW_WIDTH-1:0]  IdThrqdBmRx1;
wire    signed     [DBMPOW_WIDTH-1:0]  IdThrqdBmRx2;
wire    signed     [DBMPOW_WIDTH-1:0]  IdThrqdBmRx3;
wire                                   GreaterThanOne;
wire                                   GreaterThanZero;
wire                                   CmdCtrlFlag;
wire    signed     [7:0]               DetThrRampUp;
wire    signed     [7:0]               DetThrRampDown;
wire    signed     [12:0]              DetThrCrossUp;
wire    signed     [12:0]              DetThrCrossDown;
wire    signed     [11:0]              ADCPowDisThr;

reg                                    CCAFSMRst;

reg                                    ExtDetectReg0;
reg                                    ExtDetectReg1;
reg                                    ExtDetectReg2;
reg                                    ExtDetectReg3;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// This module instantiates the following AGC & CCA FSM related blocks:
//  1. AGC FSM
//  2. CCA FSM
//  3. Correlation Comparator
//  4. Saturation Detector
//  5. RF Gain Settings Block
//  6. RF Gain Comparator Block
//  7. CS Flags Register
//  8. Modem Interface Register
//  9. DSP Dynamic Configuration Block
// 10. Detection Threshold Register
// 11. Plateau and RampUp/RampDown Detectors
// 12. Threshold Detectors
// 13. Energy Comparator Block
// This block will be instantiated in the AGC Top level module, which
// interfaces with the rest of the modem and the radio controller.

// Instantiate AGCFSMTop
AGCFSMTop # (
             // Parameters
             .NRX(NRX),
             .AGCRAMWIDTH(AGCRAMWIDTH)
            ) U_AGCFSMTop (
                           // Inputs
                           .AGCClk(AGCClk),
                           .nAGCRst(nAGCRst),
                           .AGCFSMSftRst(AGCFSMSftRst),
                           .SatDetectRx0(SatDetectRx0),
                           .SatDetectRx1(SatDetectRx1),
                           .SatDetectRx2(SatDetectRx2),
                           .SatDetectRx3(SatDetectRx3),
                           .ExtDetectRx0(ExtDetectRx0),
                           .ExtDetectRx1(ExtDetectRx1),
                           .ExtDetectRx2(ExtDetectRx2),
                           .ExtDetectRx3(ExtDetectRx3),
                           .PlatDetRx0(PlatDetRx0),
                           .PlatDetRx1(PlatDetRx1),
                           .PlatDetRx2(PlatDetRx2),
                           .PlatDetRx3(PlatDetRx3),
                           .OFDMACDiff(OFDMACDiff),
                           .OFDMCCDiff(OFDMCCDiff),
                           .BarkerACDiff(BarkerACDiff),
                           .BarkerCCDiff(BarkerCCDiff),
                           .DSSSDetect(DSSSDetect),
                           .RFGainSetDoneP(RFGainSetDoneP),
                           .NoGainUpdateP(NoGainUpdateP),
                           .DetCrossUpRx0(DetCrossUpRx0),
                           .DetCrossUpRx1(DetCrossUpRx1),
                           .DetCrossUpRx2(DetCrossUpRx2),
                           .DetCrossUpRx3(DetCrossUpRx3),
                           .DetCrossDownRx0(DetCrossDownRx0),
                           .DetCrossDownRx1(DetCrossDownRx1),
                           .DetCrossDownRx2(DetCrossDownRx2),
                           .DetCrossDownRx3(DetCrossDownRx3),
                           .DetRampUpRx0(DetRampUpRx0),
                           .DetRampUpRx1(DetRampUpRx1),
                           .DetRampUpRx2(DetRampUpRx2),
                           .DetRampUpRx3(DetRampUpRx3),
                           .DetRampDownRx0(DetRampDownRx0),
                           .DetRampDownRx1(DetRampDownRx1),
                           .DetRampDownRx2(DetRampDownRx2),
                           .DetRampDownRx3(DetRampDownRx3),
                           .ADCPowDisRx0(ADCPowDisRx0),
                           .ADCPowDisRx1(ADCPowDisRx1),
                           .ADCPowDisRx2(ADCPowDisRx2),
                           .ADCPowDisRx3(ADCPowDisRx3),
                           .RFGainCp2MaxRx0(RFGainCp2MaxRx0),
                           .RFGainCp2MaxRx1(RFGainCp2MaxRx1),
                           .RFGainCp2MaxRx2(RFGainCp2MaxRx2),
                           .RFGainCp2MaxRx3(RFGainCp2MaxRx3),
                           .RFGainCp2MinRx0(RFGainCp2MinRx0),
                           .RFGainCp2MinRx1(RFGainCp2MinRx1),
                           .RFGainCp2MinRx2(RFGainCp2MinRx2),
                           .RFGainCp2MinRx3(RFGainCp2MinRx3),
                           .RFGainCp2Min4SatRx0(RFGainCp2Min4SatRx0),
                           .RFGainCp2Min4SatRx1(RFGainCp2Min4SatRx1),
                           .RFGainCp2Min4SatRx2(RFGainCp2Min4SatRx2),
                           .RFGainCp2Min4SatRx3(RFGainCp2Min4SatRx3),
                           .CmdCtrlFlag(CmdCtrlFlag),
                           .InBdPowSupRx0(InBdPowSupRx0),
                           .InBdPowSupRx1(InBdPowSupRx1),
                           .InBdPowSupRx2(InBdPowSupRx2),
                           .InBdPowSupRx3(InBdPowSupRx3),
                           .InBdPowInfRx0(InBdPowInfRx0),
                           .InBdPowInfRx1(InBdPowInfRx1),
                           .InBdPowInfRx2(InBdPowInfRx2),
                           .InBdPowInfRx3(InBdPowInfRx3),
                           .IdPowRx0(IdPowRx0),
                           .IdPowRx1(IdPowRx1),
                           .IdPowRx2(IdPowRx2),
                           .IdPowRx3(IdPowRx3),
                           .ADCPowdBVSupRx0(ADCPowdBVSupRx0),
                           .ADCPowdBVSupRx1(ADCPowdBVSupRx1),
                           .ADCPowdBVSupRx2(ADCPowdBVSupRx2),
                           .ADCPowdBVSupRx3(ADCPowdBVSupRx3),
                           .ADCPowdBVInfRx0(ADCPowdBVInfRx0),
                           .ADCPowdBVInfRx1(ADCPowdBVInfRx1),
                           .ADCPowdBVInfRx2(ADCPowdBVInfRx2),
                           .ADCPowdBVInfRx3(ADCPowdBVInfRx3),
                           .ADCPowdBmSupRx0(ADCPowdBmSupRx0),
                           .ADCPowdBmSupRx1(ADCPowdBmSupRx1),
                           .ADCPowdBmSupRx2(ADCPowdBmSupRx2),
                           .ADCPowdBmSupRx3(ADCPowdBmSupRx3),
                           .ADCPowdBmInfRx0(ADCPowdBmInfRx0),
                           .ADCPowdBmInfRx1(ADCPowdBmInfRx1),
                           .ADCPowdBmInfRx2(ADCPowdBmInfRx2),
                           .ADCPowdBmInfRx3(ADCPowdBmInfRx3),
                           .HTSTFStartEstimP(HTSTFStartEstimP),
                           .HTSTFGainUpdateP(HTSTFGainUpdateP),
                           .RxEndTimingP(RxEndTimingP),
                           .LSIGValid(LSIGValid),
                           .HTSIGValid(HTSIGValid),
                           .SFDFound(SFDFound),
                           .DemodRun(DemodRun),
                           .RifsEn(RifsEn),
                           .RadarDet(RadarDet),
                           .ModeA(ModeA),
                           .ModeB(ModeB),
                           .GPSetting(GPSetting),
                           .Force20(Force20),
                           .Force40(Force40),
                           .FomSing(FomSing),
                           .FomHigh(FomHigh),
                           .FomMed(FomMed),
                           .FreqSing(FreqSing),
                           .FreqDC(FreqDC),
                           .FreqLow(FreqLow),
                           .FreqHigh(FreqHigh),
                           .LengthLow(LengthLow),
                           .LengthHigh(LengthHigh),
                           .Meas1Done(Meas1Done),
                           .Meas2Done(Meas2Done),
                           .Meas3Done(Meas3Done),
                           .ChCombMode(ChCombMode),
                           .FSMEvent0Reg(FSMEvent0Reg),
                           .FSMEvent1Reg(FSMEvent1Reg),
                           .FSMEvent2Reg(FSMEvent2Reg),
                           .FSMEvent3Reg(FSMEvent3Reg),
                           .AGCMemRdData(AGCMemRdData),

                           // Outputs
                           .AGCMemAddr(AGCMemAddr),
                           .AGCCommand(AGCCommand),
                           .AGCCmdValid(AGCCmdValid),
                           .AGCParam(AGCParam),
                           .DSPEn(DSPEnInt),
                           .EventSat(EventSat),
                           .EventDis(EventDis),
                           .AGCFSMExtEn(AGCFSMExtEn),
                           .DbgAgc(DbgAgc),
                           .DbgAgcFsm(DbgAgcFsm)
                           );

// Instantiate CcaFsmTop
CcaFsmTop # (
             // Parameter
             .BW_PARAM(BW_PARAM),
             .NRX(NRX),
             .DBMPOW_WIDTH(DBMPOW_WIDTH)
            ) U_CCAFSMTop (
                           // Inputs
                           .AGCClk(AGCClk),
                           .nAGCRst(nAGCRst),
                           .FsmRst(CCAFSMRst),
                           .Force20(Force20),
                           .Force40(Force40),
                           .CcaEnergyEn(CCAEnergyEn),
                           .CcaRampUpEn(CCARampUpDnEn),
                           .CcaCsEn(CCACSEn),
                           .CcaDemodEn(CCADemod),
                           .CcaSatEn(CCASatEn),
                           .CcaDisEn(CCADisEn),
                           .RxStateCca20PSel(RxStateCca20PSel),
                           .RxStateCca20SSel(RxStateCca20SSel),
                           .RxStateCca40SSel(RxStateCca40SSel),
                           .CcaFlag0Ctrl(CCAFlag0Ctrl),
                           .CcaFlag1Ctrl(CCAFlag1Ctrl),
                           .CcaFlag2Ctrl(CCAFlag2Ctrl),
                           .CcaFlag3Ctrl(CCAFlag3Ctrl),
                           .CcaTimeoutReg(CCATimeoutReg),
                           .RegInbdCCA20PPowMindBm(RegInbdCCA20PPowMindBm),
                           .RegCCA20PRiseThrdBm(RegCCA20PRiseThrdBm),
                           .RegCCA20PFallThrdBm(RegCCA20PFallThrdBm),
                           .RegInbdCCA20SPowMindBm(RegInbdCCA20SPowMindBm),
                           .RegCCA20SFallThrdBm(RegCCA20SFallThrdBm),
                           .RegCCA20SRiseThrdBm(RegCCA20SRiseThrdBm),
                           .RegInbdCCA40SPowMindBm(RegInbdCCA40SPowMindBm),
                           .RegCCA40SFallThrdBm(RegCCA40SFallThrdBm),
                           .RegCCA40SRiseThrdBm(RegCCA40SRiseThrdBm),
                           .RegCCADetRampUp(RegCCADetRampUp),
                           .RegCCADetRampDown(RegCCADetRampDown),
                           .DelCCARampUpTap(DelCCARampUpTap),
                           .DelCCARampDownTap(DelCCARampDownTap),
                           .BWDetected(BWDetected),
                           .BWSup20(BWSup20),
                           .BWEq40(BWEq40),
                           .BWEq80(BWEq80),
                           .AGCOFDMLock(AGCOFDMLock),
                           .AGCDSSSLock(AGCDSSSLock),
                           .SFDFound(SFDFound),
                           .LSIGValid(LSIGValid),
                           .HTSIGValid(HTSIGValid),
                           .RxEndTimingP(RxEndTimingP),
                           .CsValidP(CSFlagValidP),
                           .CsFlagNr(CSFlagNum),
                           .CaDetHigh(CSFlagAHigh),
                           .CaDetLow(CSFlagALow),
                           .CbDetHigh(CSFlagBHigh),
                           .CbDetLow(CSFlagBLow),
                           .EventSat(EventSat),
                           .EventDis(EventDis),
                           .InBd20PowdBmRx0(InBd20PowdBmRx0Mux),
                           .InBd20PowdBmRx1(InBd20PowdBmRx1Mux),
                           .InBd20PowdBmRx2(InBd20PowdBmRx2Mux),
                           .InBd20PowdBmRx3(InBd20PowdBmRx3Mux),
                           .InBd20PowValid(InBd20PowValid),
                           .InBd20PowCCAValid(InBd20PowCCAValid),
                           .InBd20SecPowdBm(InBd20SecPowdBm),
                           .InBd20SecPowValid(InBd20SecPowValid),
                           .InBd40SecPowdBm(InBd40SecPowdBm),
                           .InBd40SecPowValid(InBd40SecPowValid),

                           // Outputs
                           .CCAPrimary(CCAPrimary),
                           .CCASecondary20(CCASecondary20),
                           .CCASecondary40(CCASecondary40),
                           .TimeOutErr(CCATimeOutErr),
                           .InbandPowMaxIndex(InbandPowMaxIndex),
                           .InbandPowMinIndex(InbandPowMinIndex),
                           .DbgCca(DbgCca)
                          );

// Instantiate Correlation Comparator
CorrComp # (
            // Parameters
            .DATAOUTOFDMAC(DATAOUTOFDMAC),
            .DATAOUTOFDMCC(DATAOUTOFDMCC),
            .DATAOUTDSSSAC(DATAOUTDSSSAC), 
            .DATAOUTDSSSCC(DATAOUTDSSSCC),
            .DATAOUTOFDMREF(DATAOUTOFDMREF),
            .DATAOUTDSSSREF(DATAOUTDSSSREF)
            ) U_CorrComp (
                          // Inputs
                          .AGCClk(AGCClk),
                          .nAGCRst(nAGCRst),
                          .CorrDetEn(CorrDetEn),
                          .AGCCommand(AGCCommand),
                          .AGCCmdValid(AGCCmdValid),
                          .AGCParam(AGCParam),
                          .OfdmACAccSum(OfdmACAccSum),
                          .OfdmCCAccSum(OfdmCCAccSum),
                          .DsssACAccSum(DsssACAccSum),
                          .DsssCCAccSum(DsssCCAccSum),
                          .RefLevDataEn(RefLevDataEn),
                          .RefLevDsss(RefLevDsss),
                          .RefLevOfdm(RefLevOfdm),
                          // Outputs
                          .OFDMACDiff(OFDMACDiff),
                          .OFDMCCDiff(OFDMCCDiff),
                          .DSSSACDiff(BarkerACDiff),
                          .DSSSCCDiff(BarkerCCDiff)
                         );

assign CorrDetEn = DSPEnInt[11];

`ifdef RW_NX_DSSS_CORR_EN
// Instantiate DSSS Detector
DSSSDet U_DSSSDet (
                   // Inputs
                   .nAGCRst                (nAGCRst),
                   .AGCClk                 (AGCClk),
                   .DSSSDetEn              (DSSSDetEn),
                   .DSSSContCCThr          (DSSSContCCThr),
                   .DsssContCCAccSum       (DsssContCCAccSum),
                   .RefLevDsssCont         (RefLevDsssCont),
                   .RefLevDsssContValid    (RefLevDsssContValid),
                   // Outputs
                   .DSSSDetect             (DSSSDetect)
                   );
`else
assign DSSSDetect = 1'b0;
`endif

assign DSSSDetEn = DSPEnInt[4];

// Instantiate Saturation Detector
SatDetect # (
             // Parameters
             .DBVPOW_WIDTH(DBVPOW_WIDTH)
            ) U_SatDetect (
                           // Inputs
                           .AGCClk(AGCClk),
                           .nAGCRst(nAGCRst),
                           .ADCSatPowdBVRx0(ADCSatPowdBVRx0),
                           .ADCSatPowdBVRx1(ADCSatPowdBVRx1),
                           .ADCSatPowdBVRx2(ADCSatPowdBVRx2),
                           .ADCSatPowdBVRx3(ADCSatPowdBVRx3),
                           .ADCSatPowValid(ADCSatPowValid),
                           .SatLowThr(SatLowThr),
                           .SatDynHighThr(SatDynHighThr),
                           .SatDynLowThr(SatDynLowThr),
                           .SatDelayCount(SatDelayCount),
                           .SatDetEn(SatDetEn),
                           .AGCCommand(AGCCommand),
                           .AGCCmdValid(AGCCmdValid),

                           // Outputs
                           .SatDetectRx0(SatDetectRx0),
                           .SatDetectRx1(SatDetectRx1),
                           .SatDetectRx2(SatDetectRx2),
                           .SatDetectRx3(SatDetectRx3)
                           );

assign SatDetEn = DSPEnInt[7];

// Connect External Detector
always @ (posedge AGCClk or negedge nAGCRst)
   begin: ExtDetectReg_Blk
      if (nAGCRst == 1'b0) begin
        ExtDetectReg0 <= 1'b0;
        ExtDetectReg1 <= 1'b0;
        ExtDetectReg2 <= 1'b0;
        ExtDetectReg3 <= 1'b0;
      end
      else if (AGCFSMExtEn) begin
        ExtDetectReg0 <= RCExtDetect0;
        ExtDetectReg1 <= RCExtDetect1;
        ExtDetectReg2 <= RCExtDetect2;
        ExtDetectReg3 <= RCExtDetect3;
      end
      else begin
        ExtDetectReg0 <= 1'b0;
        ExtDetectReg1 <= 1'b0;
        ExtDetectReg2 <= 1'b0;
        ExtDetectReg3 <= 1'b0;
      end
   end // ExtDetectReg_Blk

assign ExtDetectRx0 = ExtDetectReg0 & AGCFSMExtEn;
assign ExtDetectRx1 = ExtDetectReg1 & AGCFSMExtEn;
assign ExtDetectRx2 = ExtDetectReg2 & AGCFSMExtEn;
assign ExtDetectRx3 = ExtDetectReg3 & AGCFSMExtEn;


// Instantiate RF Gain Settings Block
RFGainSet # (
             // Parameters
             .NRX(NRX),
             .DBMPOW_WIDTH(DBMPOW_WIDTH),
             .DBVPOW_WIDTH(DBVPOW_WIDTH)
            ) U_RFGainSet (
                           // Inputs
                           .AGCClk(AGCClk),
                           .nAGCRst(nAGCRst),
                           .BWEq20(BWEq20),
                           .BWEq40(BWEq40),
                           .BWEq80(BWEq80),
                           .VHTSig(VHTSig),
                           .NoACIMargin(NoACIMargin),
                           .HTSIGMCS(HTSIGMCS),
                           .RCProgRFDone(RCProgRFDone),
                           .RegRFGainMax4Det(RegRFGainMax4Det),
                           .RegRFGainMin4Det(RegRFGainMin4Det),
                           .RegRFGainMax(RegRFGainMax),
                           .RegRFGainMin(RegRFGainMin),
                           .RegAntLossdB0(RegAntLossdB0),
                           .RegAntLossdB1(RegAntLossdB1),
                           .RegAntLossdB2(RegAntLossdB2),
                           .RegAntLossdB3(RegAntLossdB3),
                           .RegDigGain40vs20(RegDigGain40vs20),
                           .RegDigGain80vs20(RegDigGain80vs20),
                           .RegACI20MargMCS9(RegACI20MargMCS9),
                           .RegACI20MargMCS8(RegACI20MargMCS8),
                           .RegACI20MargMCS7(RegACI20MargMCS7),
                           .RegACI20MargMCS6(RegACI20MargMCS6),
                           .RegACI20MargMCS5(RegACI20MargMCS5),
                           .RegACI20MargMCS4(RegACI20MargMCS4),
                           .RegACI20MargMCS3(RegACI20MargMCS3),
                           .RegACI20MargMCS2(RegACI20MargMCS2),
                           .RegACI20MargMCS1(RegACI20MargMCS1),
                           .RegACI20MargMCS0(RegACI20MargMCS0),
                           .RegACI40MargMCS9(RegACI40MargMCS9),
                           .RegACI40MargMCS8(RegACI40MargMCS8),
                           .RegACI40MargMCS7(RegACI40MargMCS7),
                           .RegACI40MargMCS6(RegACI40MargMCS6),
                           .RegACI40MargMCS5(RegACI40MargMCS5),
                           .RegACI40MargMCS4(RegACI40MargMCS4),
                           .RegACI40MargMCS3(RegACI40MargMCS3),
                           .RegACI40MargMCS2(RegACI40MargMCS2),
                           .RegACI40MargMCS1(RegACI40MargMCS1),
                           .RegACI40MargMCS0(RegACI40MargMCS0),
                           .RegACI80MargMCS9(RegACI80MargMCS9),
                           .RegACI80MargMCS8(RegACI80MargMCS8),
                           .RegACI80MargMCS7(RegACI80MargMCS7),
                           .RegACI80MargMCS6(RegACI80MargMCS6),
                           .RegACI80MargMCS5(RegACI80MargMCS5),
                           .RegACI80MargMCS4(RegACI80MargMCS4),
                           .RegACI80MargMCS3(RegACI80MargMCS3),
                           .RegACI80MargMCS2(RegACI80MargMCS2),
                           .RegACI80MargMCS1(RegACI80MargMCS1),
                           .RegACI80MargMCS0(RegACI80MargMCS0),
                           .Force20(Force20),
                           .Force40(Force40),
                           .AGCCommand(AGCCommand),
                           .AGCCmdValid(AGCCmdValid),
                           .AGCParam(AGCParam),
                           .ADCPowdBVRx0(ADCPowdBVRx0),
                           .ADCPowdBVRx1(ADCPowdBVRx1),
                           .ADCPowdBVRx2(ADCPowdBVRx2),
                           .ADCPowdBVRx3(ADCPowdBVRx3),
                           .InBd20PowdBmRx0(InBd20PowdBmRx0Mux),
                           .InBd20PowdBmRx1(InBd20PowdBmRx1Mux),
                           .InBd20PowdBmRx2(InBd20PowdBmRx2Mux),
                           .InBd20PowdBmRx3(InBd20PowdBmRx3Mux),
                           .AGCRFGainCompDone(AGCRFGainCompDone),
                           .RFGain0dB(RFGain0dB), 
                           .RFGain1dB(RFGain1dB), 
                           .RFGain2dB(RFGain2dB), 
                           .RFGain3dB(RFGain3dB), 

                           // Outputs
                           .AGCRFGainCompReq(AGCRFGainCompReq),
                           .AGCGainTgt0(AGCGainTgt0),
                           .AGCGainTgt1(AGCGainTgt1),
                           .AGCGainTgt2(AGCGainTgt2),
                           .AGCGainTgt3(AGCGainTgt3),
                           .SNREstStrtP(SNREstStrtP),
                           .InBandPowRx0(InBandPowRx0),
                           .InBandPowRx1(InBandPowRx1),
                           .InBandPowRx2(InBandPowRx2),
                           .InBandPowRx3(InBandPowRx3),
                           .RFGainSetDoneP(RFGainSetDoneP),
                           .NoGainUpdateP(NoGainUpdateP),
                           .ADCPowdBVMaxIndex(ADCPowdBVMaxIndex),
                           .ADCPowdBVMinIndex(ADCPowdBVMinIndex),
                           .RCProgRF(RCProgRF),
                           .RxGain0(RxGainInt0),
                           .RxGain1(RxGainInt1),
                           .RxGain2(RxGainInt2),
                           .RxGain3(RxGainInt3),
                           .DigitalGaindB20Rx0(DigitalGaindB20Rx0),
                           .DigitalGaindB20Rx1(DigitalGaindB20Rx1),
                           .DigitalGaindB20Rx2(DigitalGaindB20Rx2),
                           .DigitalGaindB20Rx3(DigitalGaindB20Rx3),
                           .DigitalGaindB40Rx0(DigitalGaindB40Rx0),
                           .DigitalGaindB40Rx1(DigitalGaindB40Rx1),
                           .DigitalGaindB40Rx2(DigitalGaindB40Rx2),
                           .DigitalGaindB40Rx3(DigitalGaindB40Rx3),
                           .DigitalGaindB80Rx0(DigitalGaindB80Rx0),
                           .DigitalGaindB80Rx1(DigitalGaindB80Rx1),
                           .DigitalGaindB80Rx2(DigitalGaindB80Rx2),
                           .DigitalGaindB80Rx3(DigitalGaindB80Rx3) 
                          );

// InBand Power muxed based on NRX
assign InBd20PowdBmRx0Mux = InBd20PowdBmRx0;
generate
   if (NRX > 3) begin : U_InBd20PowdBmNRx4_gen
      assign InBd20PowdBmRx1Mux = InBd20PowdBmRx1;
      assign InBd20PowdBmRx2Mux = InBd20PowdBmRx2;
      assign InBd20PowdBmRx3Mux = InBd20PowdBmRx3;
   end //NRX > 3
   else if (NRX == 3) begin : U_InBd20PowdBmNRx3_gen
      assign InBd20PowdBmRx1Mux = InBd20PowdBmRx1;
      assign InBd20PowdBmRx2Mux = InBd20PowdBmRx2;
      assign InBd20PowdBmRx3Mux = $signed({{DBMPOW_WIDTH}{1'b0}});
   end //NRX = 3 
   else if (NRX == 2) begin : U_InBd20PowdBmNRx2_gen
      assign InBd20PowdBmRx1Mux = InBd20PowdBmRx1;
      assign InBd20PowdBmRx2Mux = $signed({{DBMPOW_WIDTH}{1'b0}});
      assign InBd20PowdBmRx3Mux = $signed({{DBMPOW_WIDTH}{1'b0}});
   end //NRX = 2
   else begin : U_InBd20PowdBmNRx1_gen
      assign InBd20PowdBmRx1Mux = $signed({{DBMPOW_WIDTH}{1'b0}});
      assign InBd20PowdBmRx2Mux = $signed({{DBMPOW_WIDTH}{1'b0}});
      assign InBd20PowdBmRx3Mux = $signed({{DBMPOW_WIDTH}{1'b0}});
   end //NRX = 1
endgenerate


// Instantiate RF Gain Comparator Block
RFGainComp # (
             // Parameters
             .NRX(NRX)
            )  U_RFGainComp (
                           .AGCClk                 (AGCClk),
                           .nAGCRst                (nAGCRst),
                           .AGCCommand             (AGCCommand),
                           .AGCCmdValid            (AGCCmdValid),
                           .AGCParam               (AGCParam),
                           .RxGain0                (RxGainInt0),
                           .RxGain1                (RxGainInt1),
                           .RxGain2                (RxGainInt2),
                           .RxGain3                (RxGainInt3),
                           .RFGainCp2MaxRx0        (RFGainCp2MaxRx0),
                           .RFGainCp2MaxRx1        (RFGainCp2MaxRx1),
                           .RFGainCp2MaxRx2        (RFGainCp2MaxRx2),
                           .RFGainCp2MaxRx3        (RFGainCp2MaxRx3),
                           .RFGainCp2MinRx0        (RFGainCp2MinRx0),
                           .RFGainCp2MinRx1        (RFGainCp2MinRx1),
                           .RFGainCp2MinRx2        (RFGainCp2MinRx2),
                           .RFGainCp2MinRx3        (RFGainCp2MinRx3),
                           .RFGainCp2Min4SatRx0    (RFGainCp2Min4SatRx0),
                           .RFGainCp2Min4SatRx1    (RFGainCp2Min4SatRx1),
                           .RFGainCp2Min4SatRx2    (RFGainCp2Min4SatRx2),
                           .RFGainCp2Min4SatRx3    (RFGainCp2Min4SatRx3)
                           );
`ifdef RW_NX_AGC_SNR_EN
//Instantiate NoiseVarEst
NoiseVarEst # (
               //Parameters
               .NRX(NRX),
               .DBMPOW_WIDTH(DBMPOW_WIDTH)
              ) U_NoiseVarEst (
                               //Inputs
                               .AGCClk(AGCClk),
                               .nAGCRst(nAGCRst),
                               .SNRMeasSel(SNRMeasSel),
                               .RxGain0(RxGainInt0),
                               .RxGain1(RxGainInt1),
                               .RxGain2(RxGainInt2),
                               .RxGain3(RxGainInt3),
                               .RFGainNF0dB(RFGainNF0dB),
                               .RFGainNF1dB(RFGainNF1dB),
                               .RFGainNF2dB(RFGainNF2dB),
                               .RFGainNF3dB(RFGainNF3dB),
                               .SNREstStrtP(SNREstStrtP),
                               .InBd20PowdBmRx0(InBandPowRx0),
                               .InBd20PowdBmRx1(InBandPowRx1),
                               .InBd20PowdBmRx2(InBandPowRx2),
                               .InBd20PowdBmRx3(InBandPowRx3),
                               .DigGainRx0(DigitalGaindB20Rx0),
                               .DigGainRx1(DigitalGaindB20Rx1),
                               .DigGainRx2(DigitalGaindB20Rx2),
                               .DigGainRx3(DigitalGaindB20Rx3),

                               //Outputs
                               .NoiseVardB(NoiseVardB),
                               .NoiseVardBValid(NoiseVardBValid),
                               .SNR(SNR),
                               .SNRValid(SNRValid)
                              );
`endif // RW_NX_AGC_SNR_EN

// Instantiate CSFlagsReg module
CSFlagsReg U_CSFlagsReg (
                        //Inputs
                        .AGCClk(AGCClk),
                        .nAGCRst(nAGCRst),
                        .AGCCommand(AGCCommand),
                        .AGCCmdValid(AGCCmdValid),
                        .AGCParam(AGCParam),

                        // Outputs
                        .CSFlagAHigh(CSFlagAHigh),
                        .CSFlagALow(CSFlagALow),
                        .CSFlagBHigh(CSFlagBHigh),
                        .CSFlagBLow(CSFlagBLow),
                        .CSFlagValidP(CSFlagValidP),
                        .CSFlagNum(CSFlagNum)
                        );

// Instantiate ModemIFReg module
ModemIFReg U_ModemIFReg (
                        // Inputs
                        .AGCClk(AGCClk),
                        .nAGCRst(nAGCRst),
                        .AGCFSMSftRst(AGCFSMSftRst),
                        .AGCCommand(AGCCommand),
                        .AGCCmdValid(AGCCmdValid),
                        .AGCParam(AGCParam),
                        .RFGain0(RFGain0dB),
                        .RFGain1(RFGain1dB),
                        .RFGain2(8'b0),
                        .RFGain3(8'b0),
                        .RxGain0(RxGainInt0),
                        .RxGain1(RxGainInt1),
                        .RxGain2(RxGainInt2),
                        .RxGain3(RxGainInt3),

                        // Outputs
                        .AGCOFDMLock(AGCOFDMLock),
                        .AGCOFDMHTSTF(AGCOFDMHTSTF),
                        .AGCDSSSLock(AGCDSSSLock),
                        .RifsDetected(RifsDetected),
                        .RxGainAnt0(RxGainAnt0),
                        .RxGainAnt1(RxGainAnt1),
                        .RxGainAnt2(RxGainAnt2),
                        .RxGainAnt3(RxGainAnt3),
                        .RFGainAnt0(RFGainAnt0),
                        .RFGainAnt1(RFGainAnt1),
                        .RFGainAnt2(RFGainAnt2),
                        .RFGainAnt3(RFGainAnt3)
                       );

// Instantiate DSPDynConfig module
DSPDynConfig # (  // Parameter
                  .DBMPOW_WIDTH(DBMPOW_WIDTH),
                  .DBVPOW_WIDTH(DBVPOW_WIDTH)
                 ) U_DSPDynConfig (
                             // Inputs
                             .AGCClk(AGCClk),
                             .nAGCRst(nAGCRst),
                             .AGCCommand(AGCCommand),
                             .AGCCmdValid(AGCCmdValid),
                             .AGCParam(AGCParam),
                             .InbdPowStartCaptureP(InbdPowStartCaptureP),
                             .StatusTrigConf(StatusTrigConf),
                             .AGCOFDMLock(AGCOFDMLock),
                             .AGCDSSSLock(AGCDSSSLock),
                             .InBd20PowdBmRx0(InBd20PowdBmRx0Mux),
                             .InBd20PowdBmRx1(InBd20PowdBmRx1Mux),
                             .InBd20PowdBmRx2(InBd20PowdBmRx2Mux),
                             .InBd20PowdBmRx3(InBd20PowdBmRx3Mux),
                             .InBd20SecPowdBm(InBd20SecPowdBm),
                             .InBd40SecPowdBm(InBd40SecPowdBm),
                             .ADCPowdBVRx0(ADCPowdBVRx0),
                             .ADCPowdBVRx1(ADCPowdBVRx1),
                             .ADCPowdBVRx2(ADCPowdBVRx2),
                             .ADCPowdBVRx3(ADCPowdBVRx3),
                             .ADCPowdBVMaxIndex(ADCPowdBVMaxIndex),
                             .ADCPowdBVMinIndex(ADCPowdBVMinIndex),
                             .InbandPowMaxIndex(InbandPowMaxIndex),
                             .InbandPowMinIndex(InbandPowMinIndex),

                             // Outputs
                             .InBd20SWLConfig(InBd20SWLConfig),
                             .InBd20SecSWLConfig(InBd20SecSWLConfig),
                             .InBd40SecSWLConfig(InBd40SecSWLConfig),
                             .ADCSWLSatConfig(ADCSWLSatConfig),
                             .ADCSWLConfig(ADCSWLConfig),
                             .OFDMACModeSel(OFDMACModeSel),
                             .DSSSACModeSel(DSSSACModeSel),
                             .DCMode(DCMode),
                             .AntSelDSSS(AntSelDSSS),
                             .AntSelBWEst(AntSelBWEst),
                             .DSSSContCorrModeSel(DSSSContCorrModeSel),
                             .DSSSContCCThr(DSSSContCCThr),
                             .IQEstGainAccEn(IQEstGainAccEn),
                             .IQEstPhaseAccEn(IQEstPhaseAccEn),
                             .StatusTrigReq(StatusTrigReq),
                             .InBd20PowqdBmAnt0(InBd20PowqdBmAnt0),
                             .InBd20PowqdBmAnt1(InBd20PowqdBmAnt1),
                             .InBd20PowqdBmAnt2(InBd20PowqdBmAnt2),
                             .InBd20PowqdBmAnt3(InBd20PowqdBmAnt3),
                             .InBd20PowqdBmUpdate(InBd20PowqdBmUpdate),
                             .InBd20SecPowqdBmAnt(InBd20SecPowqdBmAnt),
                             .InBd40SecPowqdBmAnt(InBd40SecPowqdBmAnt),
                             .ADCPowqdBVAnt0(ADCPowqdBVAnt0),
                             .ADCPowqdBVAnt1(ADCPowqdBVAnt1),
                             .ADCPowqdBVAnt2(ADCPowqdBVAnt2),
                             .ADCPowqdBVAnt3(ADCPowqdBVAnt3),
                             .InBd20PowNoiseqdBmAnt0(InBd20PowNoiseqdBmAnt0), 
                             .InBd20PowNoiseqdBmAnt1(InBd20PowNoiseqdBmAnt1), 
                             .InBd20PowNoiseqdBmAnt2(InBd20PowNoiseqdBmAnt2), 
                             .InBd20PowNoiseqdBmAnt3(InBd20PowNoiseqdBmAnt3), 
                             .InBd20PowNoiseqdBmUpdate(InBd20PowNoiseqdBmUpdate), 
                             .InBd20SecPowNoiseqdBmAnt(InBd20SecPowNoiseqdBmAnt),
                             .InBd40SecPowNoiseqdBmAnt(InBd40SecPowNoiseqdBmAnt),
                             .IdThrqdBmRx0(IdThrqdBmRx0),
                             .IdThrqdBmRx1(IdThrqdBmRx1),
                             .IdThrqdBmRx2(IdThrqdBmRx2),
                             .IdThrqdBmRx3(IdThrqdBmRx3)
                            );

// Instantiate CmdCtrlFlagReg module
CmdCtrlFlagReg U_CmdCtrlFlagReg (
                        //Inputs
                        .AGCClk(AGCClk),
                        .nAGCRst(nAGCRst),
                        .AGCCommand(AGCCommand),
                        .AGCCmdValid(AGCCmdValid),

                        // Outputs
                        .CmdCtrlFlag(CmdCtrlFlag)
                        );

// Instantiate DetectionThrReg module
DetectionThrReg U_DetectionThrReg (
                        //Inputs
                        .AGCClk(AGCClk),
                        .nAGCRst(nAGCRst),
                        .AGCCommand(AGCCommand),
                        .AGCParam(AGCParam),
                        .AGCCmdValid(AGCCmdValid),
                        .RegDetRampUp(RegDetRampUp),
                        .RegDetRampDown(RegDetRampDown),
                        .RegDetRiseThrqdBm(RegDetRiseThrqdBm),
                        .RegDetFallThrqdBm(RegDetFallThrqdBm),
                        .RegADCPowDisThrdBV(RegADCPowDisThrdBV),

                        // Outputs
                        .DetThrRampUp(DetThrRampUp),
                        .DetThrRampDown(DetThrRampDown),
                        .DetThrCrossUp(DetThrCrossUp),
                        .DetThrCrossDown(DetThrCrossDown),
                        .ADCPowDisThr(ADCPowDisThr)
                        );

// Instantiate PlatRampDetect module (1 per Rx Chain)
PlatRampDetect # (
                  // Parameter
                  .DBMPOW_WIDTH(DBMPOW_WIDTH)
                 ) U_PlatRampDet0 (
                                   // Inputs
                                   .AGCClk(AGCClk),
                                   .nAGCRst(nAGCRst),
                                   .InBdPowdBm(InBd20PowdBmRx0Mux),
                                   .InBdPowValid(InBd20PowValid),
                                   .RegDetPlat(RegDetPlat),
                                   .DelRampUpTap(DelRampUpTap),
                                   .DelRampDownTap(DelRampDownTap),
                                   .DelPlatTap(DelPlatTap),
                                   .RampUpDetEn (RampUpDetEn),
                                   .RampDownDetEn (RampDownDetEn),
                                   .PlatDetEn (PlatDetEn),
                                   .AGCCommand(AGCCommand),
                                   .AGCCmdValid(AGCCmdValid),
                                   .DetThrRampUp(DetThrRampUp),
                                   .DetThrRampDown(DetThrRampDown),

                                   // Outputs
                                   .RampUpDet(DetRampUpRx0),
                                   .RampDownDet(DetRampDownRx0),
                                   .PlateauDet(PlatDetRx0),
                                   .InBdPowdBmDL0(InBdPowdBmDL0Rx0),
                                   .InBdPowDL0Valid (InBdPowDL0ValidRx0),
                                   .InBdPowdBmDL1(InBdPowdBmDL1Rx0),
                                   .InBdPowDL1Valid (InBdPowDL1ValidRx0)
                                  );

assign RampUpDetEn   = DSPEnInt[8];
assign RampDownDetEn = DSPEnInt[9];
assign PlatDetEn     = DSPEnInt[10];

generate
   if (NRX > 1) begin : U_PlatRampDet_gen1
      PlatRampDetect # (
                        // Parameter
                        .DBMPOW_WIDTH(DBMPOW_WIDTH)
                       ) U_PlatRampDet1 (
                                         // Inputs
                                         .AGCClk(AGCClk),
                                         .nAGCRst(nAGCRst),
                                         .InBdPowdBm(InBd20PowdBmRx1Mux),
                                         .InBdPowValid(InBd20PowValid),
                                         .RegDetPlat(RegDetPlat),
                                         .DelRampUpTap(DelRampUpTap),
                                         .DelRampDownTap(DelRampDownTap),
                                         .DelPlatTap(DelPlatTap),
                                         .RampUpDetEn (RampUpDetEn),
                                         .RampDownDetEn (RampDownDetEn),
                                         .PlatDetEn (PlatDetEn),
                                         .AGCCommand(AGCCommand),
                                         .AGCCmdValid(AGCCmdValid),
                                         .DetThrRampUp(DetThrRampUp),
                                         .DetThrRampDown(DetThrRampDown),

                                         // Outputs
                                         .RampUpDet(DetRampUpRx1),
                                         .RampDownDet(DetRampDownRx1),
                                         .PlateauDet(PlatDetRx1),
                                         .InBdPowdBmDL0(InBdPowdBmDL0Rx1),
                                         .InBdPowDL0Valid (),
                                         .InBdPowdBmDL1(InBdPowdBmDL1Rx1),
                                         .InBdPowDL1Valid ()
                                        );

   end
   else begin : U_PlatRampDet_nogen1
      assign DetRampUpRx1       = 1'b0;
      assign DetRampDownRx1     = 1'b0;
      assign PlatDetRx1         = 1'b0;
   end //NRX > 1

   if (NRX > 2) begin : U_PlatRampDet_gen2
      PlatRampDetect # (
                        // Parameter
                        .DBMPOW_WIDTH(DBMPOW_WIDTH)
                       ) U_PlatRampDet2 (
                                         // Inputs
                                         .AGCClk(AGCClk),
                                         .nAGCRst(nAGCRst),
                                         .InBdPowdBm(InBd20PowdBmRx2Mux),
                                         .InBdPowValid(InBd20PowValid),
                                         .RegDetPlat(RegDetPlat),
                                         .DelRampUpTap(DelRampUpTap),
                                         .DelRampDownTap(DelRampDownTap),
                                         .DelPlatTap(DelPlatTap),
                                         .RampUpDetEn (RampUpDetEn),
                                         .RampDownDetEn (RampDownDetEn),
                                         .PlatDetEn (PlatDetEn),
                                         .AGCCommand(AGCCommand),
                                         .AGCCmdValid(AGCCmdValid),
                                         .DetThrRampUp(DetThrRampUp),
                                         .DetThrRampDown(DetThrRampDown),

                                         // Outputs
                                         .RampUpDet(DetRampUpRx2),
                                         .RampDownDet(DetRampDownRx2),
                                         .PlateauDet(PlatDetRx2),
                                         .InBdPowdBmDL0(InBdPowdBmDL0Rx2),
                                         .InBdPowDL0Valid (),
                                         .InBdPowdBmDL1(InBdPowdBmDL1Rx2),
                                         .InBdPowDL1Valid ()
                                        );

   end
   else begin : U_PlatRampDet_nogen2
      assign DetRampUpRx2       = 1'b0;
      assign DetRampDownRx2     = 1'b0;
      assign PlatDetRx2         = 1'b0;
   end //NRX > 2

   if (NRX > 3) begin : U_PlatRampDet_gen3
      PlatRampDetect # (
                        // Parameter
                        .DBMPOW_WIDTH(DBMPOW_WIDTH)
                       ) U_PlatRampDet3 (
                                         // Inputs
                                         .AGCClk(AGCClk),
                                         .nAGCRst(nAGCRst),
                                         .InBdPowdBm(InBd20PowdBmRx3Mux),
                                         .InBdPowValid(InBd20PowValid),
                                         .RegDetPlat(RegDetPlat),
                                         .DelRampUpTap(DelRampUpTap),
                                         .DelRampDownTap(DelRampDownTap),
                                         .DelPlatTap(DelPlatTap),
                                         .RampUpDetEn (RampUpDetEn),
                                         .RampDownDetEn (RampDownDetEn),
                                         .PlatDetEn (PlatDetEn),
                                         .AGCCommand(AGCCommand),
                                         .AGCCmdValid(AGCCmdValid),
                                         .DetThrRampUp(DetThrRampUp),
                                         .DetThrRampDown(DetThrRampDown),

                                         // Outputs
                                         .RampUpDet(DetRampUpRx3),
                                         .RampDownDet(DetRampDownRx3),
                                         .PlateauDet(PlatDetRx3),
                                         .InBdPowdBmDL0(InBdPowdBmDL0Rx3),
                                         .InBdPowDL0Valid (),
                                         .InBdPowdBmDL1(InBdPowdBmDL1Rx3),
                                         .InBdPowDL1Valid ()
                                        );

   end
   else begin : U_PlatRampDet_nogen3
      assign DetRampUpRx3       = 1'b0;
      assign DetRampDownRx3     = 1'b0;
      assign PlatDetRx3         = 1'b0;
   end //NRX > 3
endgenerate


// Instantiate InBand Power Crossing Detector (Upwards) - one per Rx Chain.
// This should be checked even if InBdPower is converging, hence the
// DSPValueValid signal is tied to 1, instead of connecting to InBdPowValid
ThreshDetSgnFSM # (
                   // Parameter
                   .DATAWIDTH(DBMPOW_WIDTH)
                  ) U_InBdDetCrsUp0 (
                                     // Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DSPValueIn0(InBdPowdBmDL1Rx0),
                                     .DSPValueIn1(InBdPowdBmDL0Rx0),
                                     .DetThrReg(DetThrCrossUp),
                                     .GreaterThan(GreaterThanOne),
                                     .DetEnable(DetCrossUpEn),

                                     // Output
                                     .ThreshDetOut(DetCrossUpRx0)
                                    );

assign DetCrossUpEn = DSPEnInt[8] & InBdPowDL0ValidRx0;


generate
   if (NRX > 1) begin : U_InBdDetCrsUp_gen1
      ThreshDetSgnFSM # (
                         // Parameter
                         .DATAWIDTH(DBMPOW_WIDTH)
                        ) U_InBdDetCrsUp1 (
                                           // Inputs
                                           .AGCClk(AGCClk),
                                           .nAGCRst(nAGCRst),
                                           .DSPValueIn0(InBdPowdBmDL1Rx1),
                                           .DSPValueIn1(InBdPowdBmDL0Rx1),
                                           .DetThrReg(DetThrCrossUp),
                                           .GreaterThan(GreaterThanOne),
                                           .DetEnable(DetCrossUpEn),

                                           // Output
                                           .ThreshDetOut(DetCrossUpRx1)
                                          );

   end
   else begin : U_InBdDetCrsUp_nogen1
      assign DetCrossUpRx1 = 1'b0;
   end //NRX > 1

   if (NRX > 2) begin : U_InBdDetCrsUp_gen2
      ThreshDetSgnFSM # (
                         // Parameter
                         .DATAWIDTH(DBMPOW_WIDTH)
                        ) U_InBdDetCrsUp2 (
                                           // Inputs
                                           .AGCClk(AGCClk),
                                           .nAGCRst(nAGCRst),
                                           .DSPValueIn0(InBdPowdBmDL1Rx2),
                                           .DSPValueIn1(InBdPowdBmDL0Rx2),
                                           .DetThrReg(DetThrCrossUp),
                                           .GreaterThan(GreaterThanOne),
                                           .DetEnable(DetCrossUpEn),

                                           // Output
                                           .ThreshDetOut(DetCrossUpRx2)
                                          );

   end
   else begin : U_InBdDetCrsUp_nogen2
      assign DetCrossUpRx2 = 1'b0;
   end //NRX > 2

   if (NRX > 3) begin : U_InBdDetCrsUp_gen3
      ThreshDetSgnFSM # (
                         // Parameter
                         .DATAWIDTH(DBMPOW_WIDTH)
                        ) U_InBdDetCrsUp3 (
                                           // Inputs
                                           .AGCClk(AGCClk),
                                           .nAGCRst(nAGCRst),
                                           .DSPValueIn0(InBdPowdBmDL1Rx3),
                                           .DSPValueIn1(InBdPowdBmDL0Rx3),
                                           .DetThrReg(DetThrCrossUp),
                                           .GreaterThan(GreaterThanOne),
                                           .DetEnable(DetCrossUpEn),

                                           // Output
                                           .ThreshDetOut(DetCrossUpRx3)
                                          );

   end
   else begin : U_InBdDetCrsUp_nogen3
      assign DetCrossUpRx3 = 1'b0;
   end //NRX > 3

endgenerate

// Instantiate InBand Power Crossing Detector (Downwards) - one per Rx Chain.
ThreshDetSgnFSM # (
                   // Parameter
                   .DATAWIDTH(DBMPOW_WIDTH)
                  ) U_InBdDetCrsDn0 (
                                     // Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DSPValueIn0(InBdPowdBmDL1Rx0),
                                     .DSPValueIn1(InBdPowdBmDL0Rx0),
                                     .DetThrReg(DetThrCrossDown),
                                     .GreaterThan(GreaterThanZero),
                                     .DetEnable(DetCrossDownEn),

                                     // Output
                                     .ThreshDetOut(DetCrossDownRx0)
                                    );

assign DetCrossDownEn = DSPEnInt[9] & InBdPowDL0ValidRx0;

generate
   if (NRX > 1) begin : U_InBdDetCrsDn_gen1
      ThreshDetSgnFSM # (
                         // Parameter
                         .DATAWIDTH(DBMPOW_WIDTH)
                        ) U_InBdDetCrsDn1 (
                                           // Inputs
                                           .AGCClk(AGCClk),
                                           .nAGCRst(nAGCRst),
                                           .DSPValueIn0(InBdPowdBmDL1Rx1),
                                           .DSPValueIn1(InBdPowdBmDL0Rx1),
                                           .DetThrReg(DetThrCrossDown),
                                           .GreaterThan(GreaterThanZero),
                                           .DetEnable(DetCrossDownEn),

                                           // Output
                                           .ThreshDetOut(DetCrossDownRx1)
                                          );
   end
   else begin : U_InBdDetCrsDn_nogen1
      assign DetCrossDownRx1 = 1'b0;
   end //NRX > 1

   if (NRX > 2) begin : U_InBdDetCrsDn_gen2
      ThreshDetSgnFSM # (
                         // Parameter
                         .DATAWIDTH(DBMPOW_WIDTH)
                        ) U_InBdDetCrsDn2 (
                                           // Inputs
                                           .AGCClk(AGCClk),
                                           .nAGCRst(nAGCRst),
                                           .DSPValueIn0(InBdPowdBmDL1Rx2),
                                           .DSPValueIn1(InBdPowdBmDL0Rx2),
                                           .DetThrReg(DetThrCrossDown),
                                           .GreaterThan(GreaterThanZero),
                                           .DetEnable(DetCrossDownEn),

                                           // Output
                                           .ThreshDetOut(DetCrossDownRx2)
                                          );
   end
   else begin : U_InBdDetCrsDn_nogen2
      assign DetCrossDownRx2 = 1'b0;
   end //NRX > 2

   if (NRX > 3) begin : U_InBdDetCrsDn_gen3
      ThreshDetSgnFSM # (
                         // Parameter
                         .DATAWIDTH(DBMPOW_WIDTH)
                        ) U_InBdDetCrsDn3 (
                                           // Inputs
                                           .AGCClk(AGCClk),
                                           .nAGCRst(nAGCRst),
                                           .DSPValueIn0(InBdPowdBmDL1Rx3),
                                           .DSPValueIn1(InBdPowdBmDL0Rx3),
                                           .DetThrReg(DetThrCrossDown),
                                           .GreaterThan(GreaterThanZero),
                                           .DetEnable(DetCrossDownEn),

                                           // Output
                                           .ThreshDetOut(DetCrossDownRx3)
                                          );
   end
   else begin : U_InBdDetCrsDn_nogen3
      assign DetCrossDownRx3 = 1'b0;
   end //NRX > 3
endgenerate

// Instantiate ADC Power Disappearance Detector (1 Per Rx Chain).
ThreshDisSgnFSM # (
                   // Parameter
                   .DBVPOW_WIDTH(DBVPOW_WIDTH)
                  ) U_ADCPowDisapr0 (
                                     // Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .ADCPowdBV(ADCPowdBVRx0),
                                     .ADCPowValid(ADCPowdBVValid),
                                     .RegADCPowDisThrdBV(ADCPowDisThr),
                                     .RegADCPowDisNdl(RegADCPowDisNdl),
                                     .ADCPowDisDetEn(ADCPowDisDetEn),
                                     .AGCCommand(AGCCommand),
                                     .AGCCmdValid(AGCCmdValid),

                                     // Output
                                     .ADCPowDis(ADCPowDisRx0)
                                    );

assign ADCPowDisDetEn = DSPEnInt[9];

generate
   if (NRX > 1) begin : U_ADCPowDisapr_gen1
      ThreshDisSgnFSM # (
                         // Parameter
                         .DBVPOW_WIDTH(DBVPOW_WIDTH)
                        ) U_ADCPowDisapr1 (
                                           // Inputs
                                           .AGCClk(AGCClk),
                                           .nAGCRst(nAGCRst),
                                           .ADCPowdBV(ADCPowdBVRx1),
                                           .ADCPowValid(ADCPowdBVValid),
                                           .RegADCPowDisThrdBV(ADCPowDisThr),
                                           .RegADCPowDisNdl(RegADCPowDisNdl),
                                           .ADCPowDisDetEn(ADCPowDisDetEn),
                                           .AGCCommand(AGCCommand),
                                           .AGCCmdValid(AGCCmdValid),

                                           // Output
                                           .ADCPowDis(ADCPowDisRx1)
                                          );
   end
   else begin : U_ADCPowDisapr_nogen1
      assign ADCPowDisRx1 = 1'b0;
   end //NRX > 1

   if (NRX > 2) begin : U_ADCPowDisapr_gen2
      ThreshDisSgnFSM # (
                         // Parameter
                         .DBVPOW_WIDTH(DBVPOW_WIDTH)
                        ) U_ADCPowDisapr2 (
                                           // Inputs
                                           .AGCClk(AGCClk),
                                           .nAGCRst(nAGCRst),
                                           .ADCPowdBV(ADCPowdBVRx2),
                                           .ADCPowValid(ADCPowdBVValid),
                                           .RegADCPowDisThrdBV(ADCPowDisThr),
                                           .RegADCPowDisNdl(RegADCPowDisNdl),
                                           .ADCPowDisDetEn(ADCPowDisDetEn),
                                           .AGCCommand(AGCCommand),
                                           .AGCCmdValid(AGCCmdValid),

                                           // Output
                                           .ADCPowDis(ADCPowDisRx2)
                                          );
   end
   else begin : U_ADCPowDisapr_nogen2
      assign ADCPowDisRx2 = 1'b0;
   end //NRX > 2

   if (NRX > 3) begin : U_ADCPowDisapr_gen3
      ThreshDisSgnFSM # (
                         // Parameter
                         .DBVPOW_WIDTH(DBVPOW_WIDTH)
                        ) U_ADCPowDisapr3 (
                                           // Inputs
                                           .AGCClk(AGCClk),
                                           .nAGCRst(nAGCRst),
                                           .ADCPowdBV(ADCPowdBVRx3),
                                           .ADCPowValid(ADCPowdBVValid),
                                           .RegADCPowDisThrdBV(ADCPowDisThr),
                                           .RegADCPowDisNdl(RegADCPowDisNdl),
                                           .ADCPowDisDetEn(ADCPowDisDetEn),
                                           .AGCCommand(AGCCommand),
                                           .AGCCmdValid(AGCCmdValid),

                                           // Output
                                           .ADCPowDis(ADCPowDisRx3)
                                          );
   end
   else begin : U_ADCPowDisapr_nogen3
      assign ADCPowDisRx3 = 1'b0;
   end //NRX > 3

endgenerate


// Instantiate Energy Comparator Block
EnergyComp # (
             // Parameters
             .DBMPOW_WIDTH(DBMPOW_WIDTH),
             .DBVPOW_WIDTH(DBVPOW_WIDTH)
            ) U_EnergyComp (
                 //Inputs
                 .AGCClk(AGCClk),
                 .nAGCRst(nAGCRst),
                 .IdInBdPowGapDnqdBm(IdInBdPowGapDnqdBm),
                 .IdInBdPowGapUpqdBm(IdInBdPowGapUpqdBm),
                 .InBdPowInfThrdBm(InBdPowInfThrdBm),
                 .InBdPowSupThrdBm(InBdPowSupThrdBm),
                 .ADCPowInfThrdBV(ADCPowInfThrdBV),
                 .ADCPowSupThrdBV(ADCPowSupThrdBV),
                 .ADCPowInfThrdBm(ADCPowInfThrdBm),
                 .ADCPowSupThrdBm(ADCPowSupThrdBm),
                 .IdPowEn(IdPowEn),
                 .ADCPowdBVRx0(ADCPowdBVRx0), 
                 .ADCPowdBVRx1(ADCPowdBVRx1), 
                 .ADCPowdBVRx2(ADCPowdBVRx2), 
                 .ADCPowdBVRx3(ADCPowdBVRx3), 
                 .ADCSatPowdBmRx0(ADCSatPowdBmRx0), 
                 .ADCSatPowdBmRx1(ADCSatPowdBmRx1), 
                 .ADCSatPowdBmRx2(ADCSatPowdBmRx2), 
                 .ADCSatPowdBmRx3(ADCSatPowdBmRx3), 
                 .InBd20PowdBmRx0(InBd20PowdBmRx0Mux),
                 .InBd20PowdBmRx1(InBd20PowdBmRx1Mux),
                 .InBd20PowdBmRx2(InBd20PowdBmRx2Mux),
                 .InBd20PowdBmRx3(InBd20PowdBmRx3Mux),
                 .InBdPowValid(InBd20PowValid),
                 .IdThrqdBmRx0(IdThrqdBmRx0),
                 .IdThrqdBmRx1(IdThrqdBmRx1),
                 .IdThrqdBmRx2(IdThrqdBmRx2),
                 .IdThrqdBmRx3(IdThrqdBmRx3),

                 //Outputs
                 .InBdPowSupRx0(InBdPowSupRx0),
                 .InBdPowSupRx1(InBdPowSupRx1),
                 .InBdPowSupRx2(InBdPowSupRx2),
                 .InBdPowSupRx3(InBdPowSupRx3),
                 .InBdPowInfRx0(InBdPowInfRx0),
                 .InBdPowInfRx1(InBdPowInfRx1),
                 .InBdPowInfRx2(InBdPowInfRx2),
                 .InBdPowInfRx3(InBdPowInfRx3),
                 .IdPowRx0(IdPowRx0),
                 .IdPowRx1(IdPowRx1),
                 .IdPowRx2(IdPowRx2),
                 .IdPowRx3(IdPowRx3),
                 //
                 .ADCPowdBVSupRx0(ADCPowdBVSupRx0),
                 .ADCPowdBVSupRx1(ADCPowdBVSupRx1),
                 .ADCPowdBVSupRx2(ADCPowdBVSupRx2),
                 .ADCPowdBVSupRx3(ADCPowdBVSupRx3),
                 .ADCPowdBVInfRx0(ADCPowdBVInfRx0),
                 .ADCPowdBVInfRx1(ADCPowdBVInfRx1),
                 .ADCPowdBVInfRx2(ADCPowdBVInfRx2),
                 .ADCPowdBVInfRx3(ADCPowdBVInfRx3),
                 .ADCPowdBmSupRx0(ADCPowdBmSupRx0),
                 .ADCPowdBmSupRx1(ADCPowdBmSupRx1),
                 .ADCPowdBmSupRx2(ADCPowdBmSupRx2),
                 .ADCPowdBmSupRx3(ADCPowdBmSupRx3),
                 .ADCPowdBmInfRx0(ADCPowdBmInfRx0),
                 .ADCPowdBmInfRx1(ADCPowdBmInfRx1),
                 .ADCPowdBmInfRx2(ADCPowdBmInfRx2),
                 .ADCPowdBmInfRx3(ADCPowdBmInfRx3)
                 );

assign IdPowEn = DSPEnInt[3];


// Reset for CCA FSM
always @ (posedge AGCClk or negedge nAGCRst)
   begin: CCAFSMRst_Blk
      if (nAGCRst == 1'b0)
         CCAFSMRst <= 1'b0;
      else if (AGCFSMSftRst == 1'b1)
         CCAFSMRst <= 1'b1;
      else if (AGCCommand == 8'd1 && AGCCmdValid == 1'b1)
         CCAFSMRst <= 1'b1;
      else
         CCAFSMRst <= 1'b0;
   end //CCAFSMRst_Blk

// From Config Registers
// AGCFSMCTRL Register
assign AGCFSMSftRst  = AGCFSMCtrl[0];
assign RadarDet      = AGCFSMCtrl[1];
assign ModeA         = AGCFSMCtrl[2];
assign ModeB         = AGCFSMCtrl[3];
assign GPSetting     = AGCFSMCtrl[7:4];
assign ChCombMode    = AGCFSMCtrl[11:8];

// CCACTRL Register
assign CCAEnergyEn   = CCACtrl[2:0];
assign CCARampUpDnEn = CCACtrl[5:3];
assign CCACSEn       = CCACtrl[6];
assign CCADemod      = CCACtrl[7];
assign CCASatEn      = CCACtrl[8];
assign CCADisEn      = CCACtrl[9];
assign CCAFlag0Ctrl  = CCACtrl[13:10];
assign CCAFlag1Ctrl  = CCACtrl[17:14];
assign CCAFlag2Ctrl  = CCACtrl[21:18];
assign CCAFlag3Ctrl  = CCACtrl[25:22];

// Outputs assignment
assign DSPEn         = DSPEnInt;
assign RxGain0       = RxGainInt0;
assign RxGain1       = RxGainInt1;
assign RxGain2       = RxGainInt2;
assign RxGain3       = RxGainInt3;

// Constant assignment
assign GreaterThanOne  = 1'b1;
assign GreaterThanZero = 1'b0;

// DelLineClr
always @ (posedge AGCClk or negedge nAGCRst)
   begin: DelLineClr_Blk
      if (nAGCRst == 1'b0)
         DelLineClr <= 1'b0;
      else if ((AGCCommand == 8'd1) && (AGCCmdValid == 1'b1))
         DelLineClr <= 1'b1;
      else
         DelLineClr <= 1'b0;
   end // DelLineClr_Blk

endmodule // AGCCCAFSMTop

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
