////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 15449 $
// $Date: 2014-07-03 11:58:45 +0200 (Thu, 03 Jul 2014) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : AGC & CCA Top Level
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/AGCCCATop.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module AGCCCATop #(parameter NRX      =  4, //Number of Rx Chains (1 to 4)
                   parameter BW_PARAM = 80  //Bandwidth (20/40/80)
                  )(
            ///////////////////////////////////////////////
            // Clock and Reset
            ///////////////////////////////////////////////
            input    wire                                  AGCClk,       // AGC Clock 80MHz
            input    wire                                  ADCPowClk,    // ADC Power Clock (max of 40/80/160MHz support)
            input    wire                                  nAGCRst,      // Active Low Reset
            //
`ifdef RW_RADAR_EN
            input    wire                                  RadarTimClk,  // Radar Timer Clock 80MHz
            input    wire                                  nRadarTimRst, // Active Low Reset
            //
            input    wire                                  HClk,         // AHB Clock
            input    wire                                  nHRst,        // Active Low Reset
`endif // RW_RADAR_EN

            ///////////////////////////////////////////////
            // AGC RAM
            ///////////////////////////////////////////////
            input    wire      [31:0]                      AGCMemRdData, // read data
            output   wire      [8:0]                       AGCMemAddr,   // Read Address

`ifdef RW_RADAR_EN
            ///////////////////////////////////////////////
            // Radar RAM
            ///////////////////////////////////////////////
            input    wire      [9:0]                       RadarMemRdData, // Radar RAM read data
            //
            output   wire      [9:0]                       RadarMemWrData,   // Data to Radar RAM
            output   wire      [8:0]                       RadarMemAddr,     // Address to Radar RAM
            output   wire                                  RadarMemWriteEn,  // Write enable to Radar RAM
            output   wire                                  RadarMemEn,       // Enable to Radar RAM

            ///////////////////////////////////////////////
            // Radar pulse FIFO
            ///////////////////////////////////////////////
            input    wire                                  RadarFifoRdEn,   // Read signal
            output   wire      [31:0]                      RadarFifoRdData,  // Read data
            output   wire                                  RadarFifoEmpty,  //Radar FIFO is empty
            
            output   wire                                  RadarIrq,       // Radar interrupt
`endif // RW_RADAR_EN

            ///////////////////////////////////////////////
            // External control signals
            ///////////////////////////////////////////////
            input    wire                                  HTSTFStartEstimP,    //HTSTF start estimation request
            input    wire                                  HTSTFGainUpdateP,    //HTSTF gain update request
            input    wire                                  RxEndTimingP,        //End of Packet on Air
            input    wire                                  LSIGValid,           //Legacy Signal Field Valid
            input    wire                                  HTSIGValid,          //HT Signal Field Valid
            input    wire                                  SFDFound,            //SFD Complete
            input    wire                                  DemodRun,            //Demodulation is running
            input    wire                                  RifsEn,              //Enable RIFS detection
            input    wire                                  BWDetected,          //Bandwidth detected
            input    wire                                  BWSup20,             //Bandwidth is 40MHz or 80MHz
            input    wire                                  BWEq20,              //Bandwidth is 20MHz
            input    wire                                  BWEq40,              //Bandwidth is 40MHz
            input    wire                                  BWEq80,              //Bandwidth is 80MHz
            input    wire                                  VHTSig,              //VHT Packet
            input    wire                                  NoACIMargin,         //Packet with no ACI margin
            input    wire        [6:0]                     HTSIGMCS,            //MCS from HTSIG field
            input    wire                                  InbdPowStartCaptureP,//Capture Inband power
            //
            output   wire                                  AGCOFDMLock,         //AGC OFDM Lock Indication
            output   wire                                  AGCOFDMHTSTF,        //AGC OFDM HTSTF Indication
            output   wire                                  AGCDSSSLock,         //AGC DSSS Lock Indication
            output   wire                                  RifsDetected,        //OFDM RIFS Indication
            output   wire        [1:0]                     AntSelDSSS,          //Antenna Mode Select for DSSS-CCK modem
            output   wire        [1:0]                     AntSelBWEst,         //Antenna Mode Select for BW estimator
            output   wire                                  AGCFSMExtEn,         //AGC External enable
`ifdef RW_NX_AGC_SNR_EN
            output   wire signed [7:0]                     NoiseVardB,          //Noise variance in dB
            output   wire                                  NoiseVardBValid,     //Qualifies NoiseVariance
            output   wire        [7:0]                     SNR,                 //SNR
            output   wire                                  SNRValid,            //Qualifies SNR
`endif // RW_NX_AGC_SNR_EN

            ///////////////////////////////////////////////
            // Radio Controller
            ///////////////////////////////////////////////
            input    wire                                  RCProgRFDone,      // Programming Done
            input    wire                                  AGCRFGainCompDone, // Effective RF gain Done
            input    wire        [7:0]                     RFGain0dB,         // Effective RF gain for Rx Chain 0
            input    wire        [7:0]                     RFGain1dB,         // Effective RF gain for Rx Chain 1
            input    wire        [7:0]                     RFGain2dB,         // Effective RF gain for Rx Chain 2
            input    wire        [7:0]                     RFGain3dB,         // Effective RF gain for Rx Chain 3
`ifdef RW_NX_AGC_SNR_EN
            input    wire        [5:0]                     RFGainNF0dB,       // Noise Factor for Rx Chain 0
            input    wire        [5:0]                     RFGainNF1dB,       // Noise Factor for Rx Chain 1
            input    wire        [5:0]                     RFGainNF2dB,       // Noise Factor for Rx Chain 2
            input    wire        [5:0]                     RFGainNF3dB,       // Noise Factor for Rx Chain 3
`endif // RW_NX_AGC_SNR_EN
            input    wire                                  RCExtDetect0,      // External Tigger Rx Chain 0
            input    wire                                  RCExtDetect1,      // External Tigger Rx Chain 1
            input    wire                                  RCExtDetect2,      // External Tigger Rx Chain 2
            input    wire                                  RCExtDetect3,      // External Tigger Rx Chain 3
            //
            output   wire                                  RCProgRF,          // Program RF in single access mode
            output   wire                                  AGCRFGainCompReq,  // RF Gain computation request
            output   wire        [7:0]                     AGCGainTgt0,       // AGC Target Gain for Rx Chain 0
            output   wire        [7:0]                     AGCGainTgt1,       // AGC Target Gain for Rx Chain 1
            output   wire        [7:0]                     AGCGainTgt2,       // AGC Target Gain for Rx Chain 2
            output   wire        [7:0]                     AGCGainTgt3,       // AGC Target Gain for Rx Chain 3

            ///////////////////////////////////////////////
            // Configuration Registers
            ///////////////////////////////////////////////
            input    wire                                  Force20,      // Force 20 Mode
            input    wire                                  Force40,      // Force 40 Mode

            ///////////////////////////////////////////////
            // AGC Registers
            ///////////////////////////////////////////////
            input    wire        [31:0]                    FSMEvent0Reg,  //Event 0 Condition
            input    wire        [31:0]                    FSMEvent1Reg,  //Event 1 Condition
            input    wire        [31:0]                    FSMEvent2Reg,  //Event 2 Condition
            input    wire        [31:0]                    FSMEvent3Reg,  //Event 3 Condition
            input    wire        [11:0]                    AGCFSMCtrl,    //AGC FSM Control
            input    wire        [25:0]                    CCACtrl,       //CCA Control
            input    wire        [1:0]                     RegAntSelCCA20s, //Antenna Mode Select for 20MHz secondary
            input    wire        [1:0]                     RegAntSelCCA40s, //Antenna Mode Select for 40MHz secondary
            input    wire        [10:0]                    RxStateCca20PSel, //CCA primary modem state
            input    wire        [10:0]                    RxStateCca20SSel, //CCA secondary 20 modem state
            input    wire        [10:0]                    RxStateCca40SSel, //CCA secondary 40 modem state
            input    wire        [31:0]                    CCATimeoutReg, //CCA Time Out
            input    wire signed [9:0]                     SatLowThr,     //Low Threshold
            input    wire signed [9:0]                     SatDynHighThr, //Dynamic High Threshold
            input    wire signed [9:0]                     SatDynLowThr,  //Dynamic Low Threshold
            input    wire        [6:0]                     SatDelayCount, //Delay Counter
            input    wire signed [7:0]                     RegDetPlat,    //Plateau Detect Value
            input    wire signed [7:0]                     RegDetRampUp,  //Ramp Up Detect Value
            input    wire signed [7:0]                     RegDetRampDown, //Ramp Down Detect Value
            input    wire signed [5:0]                     RegCCADetRampUp, //CCA Ramp Up Detect
            input    wire signed [5:0]                     RegCCADetRampDown,//CCA Ramp Down Det
            input    wire        [2:0]                     DelRampUpTap, //Delay line tap out
            input    wire        [2:0]                     DelRampDownTap, //Delay line tap out
            input    wire        [2:0]                     DelPlatTap, //Delay line tap out
            input    wire        [2:0]                     DelCCARampUpTap, //Delay line tap out
            input    wire        [2:0]                     DelCCARampDownTap, //Delay line tap out
            input    wire signed [9:0]                     RegDetRiseThrqdBm,  //Threshold Rise Detection
            input    wire signed [9:0]                     RegDetFallThrqdBm,  //Threshold Fall Detection
            input    wire signed [6:0]                     RegADCPowDisThrdBV, //Pow Disappearance
            input    wire        [3:0]                     RegADCPowDisNdl, //Delay line tap out
            input    wire signed [8:0]                     RegInbdCCA20PPowMindBm, //CCA 20P InBand Threshold
            input    wire signed [7:0]                     RegCCA20PRiseThrdBm,    //CCA 20P Rise Threshold
            input    wire signed [7:0]                     RegCCA20PFallThrdBm,    //CCA 20P Fall Threshold
            input    wire signed [8:0]                     RegInbdCCA20SPowMindBm, //CCA 20S InBand Threshold
            input    wire signed [7:0]                     RegCCA20SFallThrdBm,    //CCA 20S Rise Threshold
            input    wire signed [7:0]                     RegCCA20SRiseThrdBm,    //CCA 20S Fall Threshold
            input    wire signed [8:0]                     RegInbdCCA40SPowMindBm, //CCA 40S InBand Threshold
            input    wire signed [7:0]                     RegCCA40SFallThrdBm,    //CCA 40S Rise Threshold
            input    wire signed [7:0]                     RegCCA40SRiseThrdBm,    //CCA 40S Fall Threshold
            input    wire        [6:0]                     RegRFGainMax4Det,     // RF gain maximum for detection in dB
            input    wire signed [6:0]                     RegRFGainMin4Det,     // RF gain minimum for detection in dB
            input    wire        [6:0]                     RegRFGainMax,         // RF gain maximum in dB
            input    wire signed [6:0]                     RegRFGainMin,         // RF gain minimum in dB
            input    wire        [6:0]                     RegDelStableDC, //Initial delay for DC estimation
            input    wire        [6:0]                     dcHoldTimeADC,//Hold time after which DC Estimation value is hold for ADC.
            input    wire        [1:0]                     dcCompTypeADC,//Compensation Type for ADC.
            input    wire        [6:0]                     dcForceZeroCntADC,//Zero compensation counter value for ADC.
            input    wire        [3:0]                     RegAntLossdB0, //Antenna Loss (Chain 0)
            input    wire        [3:0]                     RegAntLossdB1, //Antenna Loss (Chain 1) 
            input    wire        [3:0]                     RegAntLossdB2, //Antenna Loss (Chain 2) 
            input    wire        [3:0]                     RegAntLossdB3, //Antenna Loss (Chain 3)
            input    wire signed [3:0]                     RegDigGain40vs20, // Digital gain adjustment for 40MHz
            input    wire signed [3:0]                     RegDigGain80vs20, // Digital gain adjustment for 80MHz
`ifdef RW_NX_AGC_SNR_EN
            input    wire                                  SNRMeasSel, //SNR Min or Max Selection
`endif // RW_NX_AGC_SNR_EN
            input    wire        [7:0]                     IdInBdPowGapDnqdBm,//InBand Power Gap Down
            input    wire        [7:0]                     IdInBdPowGapUpqdBm,//InBand Power Gap Up
            input    wire        [7:0]                     InBdPowInfThrdBm, //InBand Power Inferior Threshold
            input    wire        [7:0]                     InBdPowSupThrdBm, //InBand Power Superior Threshold
            input    wire        [7:0]                     ADCPowInfThrdBV, //ADC Power in dBV Inferior Threshold
            input    wire        [7:0]                     ADCPowSupThrdBV, //ADC Power in dBV Superior Threshold
            input    wire        [7:0]                     ADCPowInfThrdBm, //ADC Power in dBm Inferior Threshold
            input    wire        [7:0]                     ADCPowSupThrdBm, //ADC Power in dBm Superior Threshold
            input    wire        [3:0]                     NBitADC, //Effective ADC Width
            input    wire signed [7:0]                     VPeakADCqdBV, //ADC Peak Voltage in dB
            input    wire        [1:0]                     RegInBdRnd, //Rounding for InBand Power
            input    wire signed [7:0]                     RegADCPowBiasqdBV, //Bias for ADC Power in dBV
            input    wire signed [8:0]                     RegADCPowBiasqdBm, //Bias for ADC Power in dBm
            input    wire signed [8:0]                     RegInBd40SecPowBiasqdBm, //Bias for InBd 40 sec
            input    wire signed [8:0]                     RegInBd20PowBiasqdBm, //Bias for InBd20 pri
            input    wire signed [8:0]                     RegInBd20SecPowBiasqdBm,//Bias for InBd20 sec
            input    wire signed [9:0]                     InBddBVThr,  //InBand dBVrms Threshold
            input    wire signed [10:0]                    InBddBmThr, //InBand dBm Threshold
            input    wire signed [9:0]                     ADCdBVThr,  //ADC dBVrms Threshold
            input    wire signed [10:0]                    ADCdBmThr,  //ADC dBm Threshold
            input    wire signed [7:0]                     FE20Gain, //Gain of Half Band Filter in 20MHz
            input    wire signed [7:0]                     FE40Gain, //Gain of Half Band Filter in 40MHz
            input    wire        [5:0]                     RegACI20MargMCS9, //ACI margin in 20MHz for MCS9 (11ac)
            input    wire        [5:0]                     RegACI20MargMCS8, //ACI margin in 20MHz for MCS8 (11ac)
            input    wire        [5:0]                     RegACI20MargMCS7, //ACI margin in 20MHz for MCS7/15 (11n)
            input    wire        [5:0]                     RegACI20MargMCS6, //ACI margin in 20MHz for MCS6/14 (11n)
            input    wire        [5:0]                     RegACI20MargMCS5, //ACI margin in 20MHz for MCS5/13 (11n)
            input    wire        [5:0]                     RegACI20MargMCS4, //ACI margin in 20MHz for MCS4/12 (11n)
            input    wire        [5:0]                     RegACI20MargMCS3, //ACI margin in 20MHz for MCS3/11 (11n)
            input    wire        [5:0]                     RegACI20MargMCS2, //ACI margin in 20MHz for MCS2/10 (11n)
            input    wire        [5:0]                     RegACI20MargMCS1, //ACI margin in 20MHz for MCS1/9 (11n)
            input    wire        [5:0]                     RegACI20MargMCS0, //ACI margin in 20MHz for MCS0/8 (11n)
            input    wire        [5:0]                     RegACI40MargMCS9, //ACI margin in 40MHz for MCS9 (11ac)
            input    wire        [5:0]                     RegACI40MargMCS8, //ACI margin in 40MHz for MCS8 (11ac)
            input    wire        [5:0]                     RegACI40MargMCS7, //ACI margin in 40MHz for MCS7/15 (11n)
            input    wire        [5:0]                     RegACI40MargMCS6, //ACI margin in 40MHz for MCS6/14 (11n)
            input    wire        [5:0]                     RegACI40MargMCS5, //ACI margin in 40MHz for MCS5/13 (11n)
            input    wire        [5:0]                     RegACI40MargMCS4, //ACI margin in 40MHz for MCS4/12 (11n)
            input    wire        [5:0]                     RegACI40MargMCS3, //ACI margin in 40MHz for MCS3/11 (11n)
            input    wire        [5:0]                     RegACI40MargMCS2, //ACI margin in 40MHz for MCS2/10 (11n)
            input    wire        [5:0]                     RegACI40MargMCS1, //ACI margin in 40MHz for MCS1/9 (11n)
            input    wire        [5:0]                     RegACI40MargMCS0, //ACI margin in 40MHz for MCS0/8 (11n)
            input    wire        [5:0]                     RegACI80MargMCS9, //ACI margin in 80MHz for MCS9 (11ac)
            input    wire        [5:0]                     RegACI80MargMCS8, //ACI margin in 80MHz for MCS8 (11ac)
            input    wire        [5:0]                     RegACI80MargMCS7, //ACI margin in 80MHz for MCS7/15 (11n)
            input    wire        [5:0]                     RegACI80MargMCS6, //ACI margin in 80MHz for MCS6/14 (11n)
            input    wire        [5:0]                     RegACI80MargMCS5, //ACI margin in 80MHz for MCS5/13 (11n)
            input    wire        [5:0]                     RegACI80MargMCS4, //ACI margin in 80MHz for MCS4/12 (11n)
            input    wire        [5:0]                     RegACI80MargMCS3, //ACI margin in 80MHz for MCS3/11 (11n)
            input    wire        [5:0]                     RegACI80MargMCS2, //ACI margin in 80MHz for MCS2/10 (11n)
            input    wire        [5:0]                     RegACI80MargMCS1, //ACI margin in 80MHz for MCS1/9 (11n)
            input    wire        [5:0]                     RegACI80MargMCS0, //ACI margin in 80MHz for MCS0/8 (11n)
`ifdef RW_RADAR_EN
            input    wire        [7:0]                     RegFreqSing,        // Radar Frequency Singuliar value
            input    wire        [3:0]                     RegFreqSingGap,     // Radar Frequency Gap
            input    wire        [7:0]                     RegFomSing,         // Radar Figure Of Merite Singuliar value
            input    wire        [3:0]                     RegFomSingGap,      // Radar Figure Of Merite Gap
            input    wire        [2:0]                     RegPulseIrqThr,     // FIFO Threshold for Radar IRQ generation
            input    wire        [7:0]                     RegPulseIrqTimeOut, // Time-out for Radar IRQ generation (in 128us)
            input    wire                                  RegPulseTimerClear, // Clear Radar time stamp timer
`endif // RW_RADAR_EN

            ///////////////////////////////////////////////
            // ADC
            ///////////////////////////////////////////////
            input    wire signed [11:0]                    ADCReRx0, //Real Component
            input    wire signed [11:0]                    ADCImRx0, //Imaginary Component
            input    wire signed [11:0]                    ADCReRx1, //Real Component
            input    wire signed [11:0]                    ADCImRx1, //Imaginary Component
            input    wire signed [11:0]                    ADCReRx2, //Real Component
            input    wire signed [11:0]                    ADCImRx2, //Imaginary Component
            input    wire signed [11:0]                    ADCReRx3, //Real Component
            input    wire signed [11:0]                    ADCImRx3, //Imaginary Component

            ///////////////////////////////////////////////
            // FrontEnd
            ///////////////////////////////////////////////
            //From FE Primary 20MHz
            input    wire signed [12:0]                    RxAGC20PriReRx0, //Real Component
            input    wire signed [12:0]                    RxAGC20PriImRx0, //Imaginary Component
            input    wire signed [12:0]                    RxAGC20PriReRx1, //Real Component
            input    wire signed [12:0]                    RxAGC20PriImRx1, //Imaginary Component
            input    wire signed [12:0]                    RxAGC20PriReRx2, //Real Component
            input    wire signed [12:0]                    RxAGC20PriImRx2, //Imaginary Component
            input    wire signed [12:0]                    RxAGC20PriReRx3, //Real Component
            input    wire signed [12:0]                    RxAGC20PriImRx3, //Imaginary Component

            //From FE Secondary 20MHz
            input    wire signed [12:0]                    RxAGC20SecReRx0, //Real Component
            input    wire signed [12:0]                    RxAGC20SecImRx0, //Imaginary Component
            input    wire signed [12:0]                    RxAGC20SecReRx1, //Real Component
            input    wire signed [12:0]                    RxAGC20SecImRx1, //Imaginary Component
            input    wire signed [12:0]                    RxAGC20SecReRx2, //Real Component
            input    wire signed [12:0]                    RxAGC20SecImRx2, //Imaginary Component
            input    wire signed [12:0]                    RxAGC20SecReRx3, //Real Component
            input    wire signed [12:0]                    RxAGC20SecImRx3, //Imaginary Component

            //From FE Secondary 40MHz
            input    wire signed [12:0]                    RxAGC40SecReRx0, //Real Component
            input    wire signed [12:0]                    RxAGC40SecImRx0, //Imaginary Component
            input    wire signed [12:0]                    RxAGC40SecReRx1, //Real Component
            input    wire signed [12:0]                    RxAGC40SecImRx1, //Imaginary Component
            input    wire signed [12:0]                    RxAGC40SecReRx2, //Real Component
            input    wire signed [12:0]                    RxAGC40SecImRx2, //Imaginary Component
            input    wire signed [12:0]                    RxAGC40SecReRx3, //Real Component
            input    wire signed [12:0]                    RxAGC40SecImRx3, //Imaginary Component

`ifdef RW_RADAR_EN
            //From FE Primary 20/40/80MHz
            input    wire        [12:0]                    RxRadI,        // Real Component
            input    wire        [12:0]                    RxRadQ,        // Imaginary Component
`endif // RW_RADAR_EN

`ifdef RW_NX_DSSS_CORR_EN
            //From FE Filter for DSSS Continuous Correlator
            input    wire        [9:0]                     RxFilt4CorrI,    // Real Component
            input    wire        [9:0]                     RxFilt4CorrQ,    // Imaginary Component
            input    wire                                  RxFilt4CorrValid,
`endif

            //Digital Gain for 20MHz path
            output   wire      [3:0]                       DigGain6dB20Rx0, //For Rx Chain 0
            output   wire      [3:0]                       DigGain6dB20Rx1, //For Rx Chain 1
            output   wire      [3:0]                       DigGain6dB20Rx2, //For Rx Chain 2
            output   wire      [3:0]                       DigGain6dB20Rx3, //For Rx Chain 3
            output   wire      [5:0]                       DigGainLin20Rx0, //For Rx Chain 0
            output   wire      [5:0]                       DigGainLin20Rx1, //For Rx Chain 1
            output   wire      [5:0]                       DigGainLin20Rx2, //For Rx Chain 2
            output   wire      [5:0]                       DigGainLin20Rx3, //For Rx Chain 3

            //Digital Gain for 40MHz path
            output   wire      [3:0]                       DigGain6dB40Rx0, //For Rx Chain 0
            output   wire      [3:0]                       DigGain6dB40Rx1, //For Rx Chain 1
            output   wire      [3:0]                       DigGain6dB40Rx2, //For Rx Chain 2
            output   wire      [3:0]                       DigGain6dB40Rx3, //For Rx Chain 3
            output   wire      [5:0]                       DigGainLin40Rx0, //For Rx Chain 0
            output   wire      [5:0]                       DigGainLin40Rx1, //For Rx Chain 1
            output   wire      [5:0]                       DigGainLin40Rx2, //For Rx Chain 2
            output   wire      [5:0]                       DigGainLin40Rx3, //For Rx Chain 3

            //Digital Gain for 80MHz path
            output   wire      [3:0]                       DigGain6dB80Rx0, //For Rx Chain 0
            output   wire      [3:0]                       DigGain6dB80Rx1, //For Rx Chain 1
            output   wire      [3:0]                       DigGain6dB80Rx2, //For Rx Chain 2
            output   wire      [3:0]                       DigGain6dB80Rx3, //For Rx Chain 3
            output   wire      [5:0]                       DigGainLin80Rx0, //For Rx Chain 0
            output   wire      [5:0]                       DigGainLin80Rx1, //For Rx Chain 1
            output   wire      [5:0]                       DigGainLin80Rx2, //For Rx Chain 2
            output   wire      [5:0]                       DigGainLin80Rx3, //For Rx Chain 3

            output   wire                                  OFDMFEEn,        //Enable for OFDM Front End
            output   wire                                  DSSSFEEn,        //Enable for DSSS Front End

`ifdef RW_NX_IQ_COMP_EN
            output   wire                                  IQGnPhCompEn,    //Enable for IQ Imbalance compensation
            output   wire                                  IQEstGainAccEn,  //IQ Imbalance gain accu enable
            output   wire                                  IQEstPhaseAccEn, //IQ Imbalance phase accu enable
`endif
            
            output   wire signed [11:0]                    DCEstReRx0, //DC Estimation Real Component      
            output   wire signed [11:0]                    DCEstImRx0, //DC Estimation Imaginary Component 
            output   wire signed [11:0]                    DCEstReRx1, //DC Estimation Real Component      
            output   wire signed [11:0]                    DCEstImRx1, //DC Estimation Imaginary Component 
            output   wire signed [11:0]                    DCEstReRx2, //DC Estimation Real Component      
            output   wire signed [11:0]                    DCEstImRx2, //DC Estimation Imaginary Component 
            output   wire signed [11:0]                    DCEstReRx3, //DC Estimation Real Component      
            output   wire signed [11:0]                    DCEstImRx3, //DC Estimation Imaginary Component 
            output   wire                                  DCEstValid, //Qualifies DC Estimation           
            
            ///////////////////////////////////////////////
            // CCA Related
            ///////////////////////////////////////////////
            output   wire                                  CCAPrimary, //CCA on Primary Channel
            output   wire                                  CCASecondary20, //CCA on 20MHz Secondary Chan
            output   wire                                  CCASecondary40, //CCA on 40MHz Secondary Chan
            output   wire                                  CCATimeOutErr, //CCA TimeOut Error

            ///////////////////////////////////////////////
            // Interface with Status registers
            ///////////////////////////////////////////////
            input    wire                                  StatusTrigConf,      //Confirmation for status register capture
            output   wire                                  StatusTrigReq,       //Request for status register capture
            
            output   wire signed   [9:0]                   InBd20PowqdBmAnt0,   //In Band Power 20P in qdBm for Rx Chain 0
            output   wire signed   [9:0]                   InBd20PowqdBmAnt1,   //In Band Power 20P in qdBm for Rx Chain 1
            output   wire signed   [9:0]                   InBd20PowqdBmAnt2,   //In Band Power 20P in qdBm for Rx Chain 2
            output   wire signed   [9:0]                   InBd20PowqdBmAnt3,   //In Band Power 20P in qdBm for Rx Chain 3
            output   wire                                  InBd20PowqdBmUpdate, //In Band Power 20P valid

            output   wire signed   [9:0]                   InBd20SecPowqdBmAnt, //In Band Power 20S in qdBm

            output   wire signed   [9:0]                   InBd40SecPowqdBmAnt, //In Band Power 40S in qdBm
            
            output   wire signed   [8:0]                   ADCPowqdBVAnt0, //ADC Power Estimate in qdBVrms for Rx Chain 0
            output   wire signed   [8:0]                   ADCPowqdBVAnt1, //ADC Power Estimate in qdBVrms for Rx Chain 1
            output   wire signed   [8:0]                   ADCPowqdBVAnt2, //ADC Power Estimate in qdBVrms for Rx Chain 2
            output   wire signed   [8:0]                   ADCPowqdBVAnt3, //ADC Power Estimate in qdBVrms for Rx Chain 3

            output   wire signed   [9:0]                   InBd20PowNoiseqdBmAnt0,   //In Band Power 20P in qdBm for Rx Chain 0 for noise floor
            output   wire signed   [9:0]                   InBd20PowNoiseqdBmAnt1,   //In Band Power 20P in qdBm for Rx Chain 1 for noise floor
            output   wire signed   [9:0]                   InBd20PowNoiseqdBmAnt2,   //In Band Power 20P in qdBm for Rx Chain 2 for noise floor
            output   wire signed   [9:0]                   InBd20PowNoiseqdBmAnt3,   //In Band Power 20P in qdBm for Rx Chain 3 for noise floor
            output   wire                                  InBd20PowNoiseqdBmUpdate, //In Band Power Noise 20P valid

            output   wire signed   [9:0]                   InBd20SecPowNoiseqdBmAnt, //In Band Power 20S in qdBm for noise floor

            output   wire signed   [9:0]                   InBd40SecPowNoiseqdBmAnt, //In Band Power 40S in qdBm for noise floor

            output   wire signed   [6:0]                   DigGaindB20Ant0, //Digital gain in dB for 20MHz Rx Chain 0
            output   wire signed   [6:0]                   DigGaindB20Ant1, //Digital gain in dB for 20MHz Rx Chain 1
            output   wire signed   [6:0]                   DigGaindB20Ant2, //Digital gain in dB for 20MHz Rx Chain 2
            output   wire signed   [6:0]                   DigGaindB20Ant3, //Digital gain in dB for 20MHz Rx Chain 3
            output   wire signed   [6:0]                   DigGaindB40Ant0, //Digital gain in dB for 40MHz Rx Chain 0
            output   wire signed   [6:0]                   DigGaindB40Ant1, //Digital gain in dB for 40MHz Rx Chain 1
            output   wire signed   [6:0]                   DigGaindB40Ant2, //Digital gain in dB for 40MHz Rx Chain 2
            output   wire signed   [6:0]                   DigGaindB40Ant3, //Digital gain in dB for 40MHz Rx Chain 3
            output   wire signed   [6:0]                   DigGaindB80Ant0, //Digital gain in dB for 80MHz Rx Chain 0
            output   wire signed   [6:0]                   DigGaindB80Ant1, //Digital gain in dB for 80MHz Rx Chain 1
            output   wire signed   [6:0]                   DigGaindB80Ant2, //Digital gain in dB for 80MHz Rx Chain 2
            output   wire signed   [6:0]                   DigGaindB80Ant3, //Digital gain in dB for 80MHz Rx Chain 3

            output   wire          [7:0]                   RxGainAnt0,      //Gain for Rx Chain 0 in dB
            output   wire          [7:0]                   RxGainAnt1,      //Gain for Rx Chain 1 in dB
            output   wire          [7:0]                   RxGainAnt2,      //Gain for Rx Chain 2 in dB
            output   wire          [7:0]                   RxGainAnt3,      //Gain for Rx Chain 3 in dB

            output   wire          [7:0]                   RFGainAnt0,      //RF Gain for Rx Chain 0
            output   wire          [7:0]                   RFGainAnt1,      //RF Gain for Rx Chain 1
            output   wire          [7:0]                   RFGainAnt2,      //RF Gain for Rx Chain 2
            output   wire          [7:0]                   RFGainAnt3,      //RF Gain for Rx Chain 3

            ///////////////////////////////////////////////
            // Debug
            ///////////////////////////////////////////////
`ifdef RW_RADAR_EN
            output   wire      [15:0]                      DbgAgc5,  // Radar
`endif // RW_RADAR_EN
            output   wire      [15:0]                      DbgAgc0,  // AGC status registers
            output   wire      [15:0]                      DbgAgc1,  // AGC Inbd power
            output   wire      [8:0]                       DbgAgc2,  // FSM address index
            output   wire      [15:0]                      DbgAgc3,  // AGC gain
            output   wire      [6:0]                       DbgAgc4,  // AGC digital gain
            output   wire      [15:0]                      DbgCca    // CCA internal generation
            );

  /***************************************************************************
  * constant
  ***************************************************************************/            
  localparam DATAOUTOFDMAC     = 22; //OFDM Auto  Corr Width
  localparam DATAOUTOFDMCC     = 20; //OFDM Cross Corr Width
  localparam DATAOUTDSSSAC     = 22; //DSSS Auto  Corr Width
  localparam DATAOUTDSSSCC     = 20; //DSSS Cross Corr Width
  localparam DATAOUTOFDMREF    = 19; //OFDM Reference  Width
  localparam DATAOUTDSSSREF    = 20; //DSSS Reference  Width
  localparam DBVPOW_WIDTH      = 12; //Data width of dBV power
  localparam DBMPOW_WIDTH      = 13; //Data width of dBm power
  localparam ADCPOWSAT_WIDTH   = 14; //Data width of ADC Power for Sat detect
  localparam INBD_WIDTH        = 13; //Front End Output Width
  localparam FSB_ITER          =  6; //Iterations for finding FSB
  localparam INBDPOW_WIDTH     = 24; //Data width of In Band Power
  localparam ADCPOW_WIDTH      = 30; //Data width of ADC Power
  localparam ADC_WIDTH         = 12; //ADC Data Width
  localparam AGCRAMWIDTH       = 32; //Datawidth of AGC RAM

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire    signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx0;
wire    signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx1;
wire    signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx2;
wire    signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx3;
wire    signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx0;
wire    signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx1;
wire    signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx2;
wire    signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx3;
wire    signed     [DBVPOW_WIDTH-1:0]  ADCSatPowdBVRx0;
wire    signed     [DBVPOW_WIDTH-1:0]  ADCSatPowdBVRx1;
wire    signed     [DBVPOW_WIDTH-1:0]  ADCSatPowdBVRx2;
wire    signed     [DBVPOW_WIDTH-1:0]  ADCSatPowdBVRx3;
wire    signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx0;
wire    signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx1;
wire    signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx2;
wire    signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx3;
wire    signed     [DBMPOW_WIDTH-1:0]  InBd40SecPowdBm;
wire    signed     [DBMPOW_WIDTH-1:0]  InBd20SecPowdBm;
wire                                   ADCPowdBVValid;
wire                                   ADCSatPowdBmValid;
wire                                   ADCSatPowValid;
wire                                   InBd20SecPowValid;
wire                                   InBd40SecPowValid;
wire                                   InBd20PowValid;
wire                                   InBd20PowCCAValid;
wire               [7:0]               RxGain0Int;
wire               [7:0]               RxGain1Int;
wire               [7:0]               RxGain2Int;
wire               [7:0]               RxGain3Int;
wire    signed     [6:0]               DigitalGaindB20Rx0;
wire    signed     [6:0]               DigitalGaindB20Rx1;
wire    signed     [6:0]               DigitalGaindB20Rx2;
wire    signed     [6:0]               DigitalGaindB20Rx3;
wire    signed     [6:0]               DigitalGaindB40Rx0;
wire    signed     [6:0]               DigitalGaindB40Rx1;
wire    signed     [6:0]               DigitalGaindB40Rx2;
wire    signed     [6:0]               DigitalGaindB40Rx3;
wire    signed     [6:0]               DigitalGaindB80Rx0;
wire    signed     [6:0]               DigitalGaindB80Rx1;
wire    signed     [6:0]               DigitalGaindB80Rx2;
wire    signed     [6:0]               DigitalGaindB80Rx3;
wire               [1:0]               OFDMACModeSel;
wire                                   DSSSACModeSel;
wire               [2:0]               DSSSContCorrModeSel;
wire               [1:0]               ADCSWLSatConfig;
wire               [1:0]               ADCSWLConfig;
wire               [2:0]               InBd20SWLConfig;
wire               [2:0]               InBd20SecSWLConfig;
wire               [2:0]               InBd40SecSWLConfig;
wire               [14:0]              DSPEn;
wire               [2:0]               DSPEnAligned;
wire                                   ADCPowEstEn;
wire                                   RadarEn;
wire                                   InBd20PowEstEn;
wire                                   InBdSecPowEstEn;
wire                                   OFDMCorrEn;
wire                                   DSSSCorrEn;
wire                                   RefLevBlockEn;
wire                                   AGCDelayLineEn;
wire    signed     [INBD_WIDTH-1:0]    DataIn1DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn1DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn2DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn2DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn3DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn3DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn4DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn4DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn5DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn5DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn6DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn6DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn7DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn7DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn8DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn8DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn9DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn9DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn10DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn10DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn11DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn11DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn12DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn12DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn13DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn13DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn14DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn14DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn15DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn15DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn16DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn16DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn17DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn17DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn18DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn18DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn19DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn19DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn20DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn20DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn32DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn32DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn40DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn40DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn48DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn48DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn60DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn60DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn64DI1;
wire    signed     [INBD_WIDTH-1:0]    DataIn64DQ1;
wire    signed     [INBD_WIDTH-1:0]    DataIn1DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn1DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn2DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn2DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn3DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn3DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn4DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn4DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn5DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn5DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn6DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn6DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn7DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn7DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn8DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn8DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn9DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn9DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn10DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn10DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn11DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn11DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn12DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn12DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn13DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn13DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn14DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn14DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn15DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn15DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn16DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn16DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn17DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn17DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn18DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn18DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn19DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn19DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn20DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn20DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn32DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn32DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn40DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn40DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn48DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn48DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn60DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn60DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn64DI2;
wire    signed     [INBD_WIDTH-1:0]    DataIn64DQ2;
wire    signed     [INBD_WIDTH-1:0]    DataIn1DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn1DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn2DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn2DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn3DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn3DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn4DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn4DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn5DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn5DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn6DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn6DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn7DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn7DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn8DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn8DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn9DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn9DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn10DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn10DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn11DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn11DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn12DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn12DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn13DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn13DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn14DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn14DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn15DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn15DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn16DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn16DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn17DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn17DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn18DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn18DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn19DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn19DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn20DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn20DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn32DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn32DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn40DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn40DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn48DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn48DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn60DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn60DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn64DI3;
wire    signed     [INBD_WIDTH-1:0]    DataIn64DQ3;
wire    signed     [INBD_WIDTH-1:0]    DataIn1DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn1DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn2DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn2DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn3DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn3DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn4DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn4DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn5DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn5DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn6DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn6DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn7DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn7DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn8DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn8DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn9DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn9DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn10DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn10DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn11DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn11DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn12DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn12DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn13DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn13DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn14DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn14DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn15DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn15DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn16DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn16DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn17DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn17DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn18DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn18DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn19DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn19DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn20DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn20DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn32DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn32DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn40DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn40DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn48DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn48DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn60DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn60DQ4;
wire    signed     [INBD_WIDTH-1:0]    DataIn64DI4;
wire    signed     [INBD_WIDTH-1:0]    DataIn64DQ4;
wire              [DATAOUTOFDMAC-1:0]  OfdmACAccSum;
wire              [DATAOUTOFDMCC-1:0]  OfdmCCAccSum;
wire              [DATAOUTDSSSAC-1:0]  DsssACAccSum;
wire              [DATAOUTDSSSCC-1:0]  DsssCCAccSum;
wire                                   RefLevDataEn;
wire              [DATAOUTDSSSREF-1:0] RefLevDsss;
wire              [DATAOUTOFDMREF-1:0] RefLevOfdm;
wire                            [21:0] DsssContCCAccSum;
wire                            [21:0] RefLevDsssCont;
wire                                   RefLevDsssContValid;
wire                                   ZeroOutOFDMCntGt0;
wire                                   ZeroOutDSSSCntGt0;
wire                                   ZeroOutOFDM;
wire                                   ZeroOutDSSS;
wire                                   AddZeroOFDMACCntGt0;
wire                                   AddZeroDSSSACCntGt0;
wire                                   AddZeroOFDMAC;
wire                                   AddZeroDSSSAC;
wire                                   OFDMSubZeroRefCntGt0;
wire                                   DSSSSubZeroRefCntGt0;
wire                                   OFDMSubZeroRef;
wire                                   DSSSSubZeroRef;
wire                                   DelLineClr;
wire                                   DCEstEn;
wire               [1:0]               DCMode;
wire    signed     [ADC_WIDTH-1:0]     DCEstReRx0Int;
wire    signed     [ADC_WIDTH-1:0]     DCEstImRx0Int;
wire    signed     [ADC_WIDTH-1:0]     DCEstReRx1Int;
wire    signed     [ADC_WIDTH-1:0]     DCEstImRx1Int;
wire    signed     [ADC_WIDTH-1:0]     DCEstReRx2Int;
wire    signed     [ADC_WIDTH-1:0]     DCEstImRx2Int;
wire    signed     [ADC_WIDTH-1:0]     DCEstReRx3Int;
wire    signed     [ADC_WIDTH-1:0]     DCEstImRx3Int;
wire    signed     [ADC_WIDTH+1:0]     DCEstReRx0IntExt;
wire    signed     [ADC_WIDTH+1:0]     DCEstImRx0IntExt;
wire    signed     [ADC_WIDTH+1:0]     DCEstReRx1IntExt;
wire    signed     [ADC_WIDTH+1:0]     DCEstImRx1IntExt;
wire    signed     [ADC_WIDTH+1:0]     DCEstReRx2IntExt;
wire    signed     [ADC_WIDTH+1:0]     DCEstImRx2IntExt;
wire    signed     [ADC_WIDTH+1:0]     DCEstReRx3IntExt;
wire    signed     [ADC_WIDTH+1:0]     DCEstImRx3IntExt;
wire                                   DCEstValidInt;
wire    signed     [ADC_WIDTH-1:0]     DCCompReRx0;
wire    signed     [ADC_WIDTH-1:0]     DCCompImRx0;
wire    signed     [ADC_WIDTH-1:0]     DCCompReRx1;
wire    signed     [ADC_WIDTH-1:0]     DCCompImRx1;
wire    signed     [ADC_WIDTH-1:0]     DCCompReRx2;
wire    signed     [ADC_WIDTH-1:0]     DCCompImRx2;
wire    signed     [ADC_WIDTH-1:0]     DCCompReRx3;
wire    signed     [ADC_WIDTH-1:0]     DCCompImRx3;
wire    signed     [ADC_WIDTH+1:0]     ADCReRx0Ext;
wire    signed     [ADC_WIDTH+1:0]     ADCImRx0Ext;
wire    signed     [ADC_WIDTH+1:0]     ADCReRx1Ext;
wire    signed     [ADC_WIDTH+1:0]     ADCImRx1Ext;
wire    signed     [ADC_WIDTH+1:0]     ADCReRx2Ext;
wire    signed     [ADC_WIDTH+1:0]     ADCImRx2Ext;
wire    signed     [ADC_WIDTH+1:0]     ADCReRx3Ext;
wire    signed     [ADC_WIDTH+1:0]     ADCImRx3Ext;
wire                                   RefLevBlockEn1D;
wire                                   DataInEn;
wire                                   RxAGC20SecDataValid;
wire                                   RxAGC40SecDataValid;
wire               [7:0]               AGCCommand;
wire               [23:0]              AGCParam;
wire                                   AGCCmdValid;
wire                                   FomSing;
wire                                   FomHigh;
wire                                   FomMed;
wire                                   FreqSing;
wire                                   FreqDC;
wire                                   FreqLow;
wire                                   FreqHigh;
wire                                   LengthLow;
wire                                   LengthHigh;
wire                                   Meas1Done;
wire                                   Meas2Done;
wire                                   Meas3Done;
`ifdef RW_RADAR_EN
wire                                   RadarDetEn;
wire                                   RxRadValid;
`endif // RW_RADAR_EN

//////////////////////////////////////////////////////////////////////////////
// Internal Registers Declaration
//////////////////////////////////////////////////////////////////////////////
reg                [3:0]               ZeroOutOFDMCnt;
reg                [4:0]               ZeroOutDSSSCnt;
reg                [5:0]               AddZeroOFDMACCnt;
reg                [5:0]               AddZeroDSSSACCnt;
reg                [4:0]               OFDMSubZeroRefCnt;
reg                [4:0]               DSSSSubZeroRefCnt;
reg                                    OFDMCorrEnD;
reg                                    DSSSCorrEnD;
reg                                    DataInEn1D;
reg                                    DataInEn2D;
reg                                    DataInEn3D;
reg                [1:0]               DataInEnCnt;
reg                [2:0]               DSPEnSync;
reg signed [INBD_WIDTH-1:0]            RxAGC20PriReRx0D;
reg signed [INBD_WIDTH-1:0]            RxAGC20PriImRx0D;
reg signed [INBD_WIDTH-1:0]            RxAGC20PriReRx1D;
reg signed [INBD_WIDTH-1:0]            RxAGC20PriImRx1D;
reg signed [INBD_WIDTH-1:0]            RxAGC20PriReRx2D;
reg signed [INBD_WIDTH-1:0]            RxAGC20PriImRx2D;
reg signed [INBD_WIDTH-1:0]            RxAGC20PriReRx3D;
reg signed [INBD_WIDTH-1:0]            RxAGC20PriImRx3D;
reg signed [INBD_WIDTH-1:0]            RxAGC20SecReRx0D;
reg signed [INBD_WIDTH-1:0]            RxAGC20SecImRx0D;
reg signed [INBD_WIDTH-1:0]            RxAGC20SecReRx1D;
reg signed [INBD_WIDTH-1:0]            RxAGC20SecImRx1D;
reg signed [INBD_WIDTH-1:0]            RxAGC20SecReRx2D;
reg signed [INBD_WIDTH-1:0]            RxAGC20SecImRx2D;
reg signed [INBD_WIDTH-1:0]            RxAGC20SecReRx3D;
reg signed [INBD_WIDTH-1:0]            RxAGC20SecImRx3D;
reg signed [INBD_WIDTH-1:0]            RxAGC40SecReRx0D;
reg signed [INBD_WIDTH-1:0]            RxAGC40SecImRx0D;
reg signed [INBD_WIDTH-1:0]            RxAGC40SecReRx1D;
reg signed [INBD_WIDTH-1:0]            RxAGC40SecImRx1D;
reg signed [INBD_WIDTH-1:0]            RxAGC40SecReRx2D;
reg signed [INBD_WIDTH-1:0]            RxAGC40SecImRx2D;
reg signed [INBD_WIDTH-1:0]            RxAGC40SecReRx3D;
reg signed [INBD_WIDTH-1:0]            RxAGC40SecImRx3D;
`ifdef RW_RADAR_EN
reg                [1:0]               RadarDataInEnCnt;
reg signed [12:0]                      RxRadID;
reg signed [12:0]                      RxRadQD;
`endif // RW_RADAR_EN

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This module serves as the Top Level of the AGC & CCA modules.
//It instantiates the following blocks:
//1.  AGCCCAFSMTop
//2.  AGCPowEstTop
//3.  AgcCorrTop
//4.  AGCDelLine (NRX instances)
//5.  DigGainConv (NRX instances)
//6.  DCIIRFilterEstTop (NRX instances)
//7.  DCIIRFilterCompTop (NRX instances)
//8.  Radar

//Instantiate AGCCCAFSMTop
AGCCCAFSMTop # (
                //Parameters
                .NRX(NRX),
                .AGCRAMWIDTH(AGCRAMWIDTH),
                .BW_PARAM(BW_PARAM),
                .DATAOUTOFDMAC(DATAOUTOFDMAC),
                .DATAOUTOFDMCC(DATAOUTOFDMCC),
                .DATAOUTDSSSAC(DATAOUTDSSSAC),
                .DATAOUTDSSSCC(DATAOUTDSSSCC),
                .DATAOUTOFDMREF(DATAOUTOFDMREF),
                .DATAOUTDSSSREF(DATAOUTDSSSREF),
                .DBVPOW_WIDTH(DBVPOW_WIDTH),
                .DBMPOW_WIDTH(DBMPOW_WIDTH)
               ) U_AGCCCAFSMTop (
                                 //Inputs
                                 .AGCClk(AGCClk),
                                 .nAGCRst(nAGCRst),
                                 .AGCMemRdData(AGCMemRdData),
                                 .HTSTFStartEstimP(HTSTFStartEstimP),
                                 .HTSTFGainUpdateP(HTSTFGainUpdateP),
                                 .RxEndTimingP(RxEndTimingP),
                                 .LSIGValid(LSIGValid),
                                 .HTSIGValid(HTSIGValid),
                                 .SFDFound(SFDFound),
                                 .DemodRun(DemodRun),
                                 .Force20(Force20),
                                 .Force40(Force40),
                                 .RifsEn(RifsEn),
                                 .BWDetected(BWDetected),
                                 .BWSup20(BWSup20),
                                 .BWEq20(BWEq20),
                                 .BWEq40(BWEq40),
                                 .BWEq80(BWEq80),
                                 .VHTSig(VHTSig),
                                 .NoACIMargin(NoACIMargin),
                                 .HTSIGMCS(HTSIGMCS),
                                 .InbdPowStartCaptureP(InbdPowStartCaptureP),
                                 .StatusTrigConf(StatusTrigConf),
                                 .FomSing(FomSing),
                                 .FomHigh(FomHigh),
                                 .FomMed(FomMed),
                                 .FreqSing(FreqSing),
                                 .FreqDC(FreqDC),
                                 .FreqLow(FreqLow),
                                 .FreqHigh(FreqHigh),
                                 .LengthLow(LengthLow),
                                 .LengthHigh(LengthHigh),
                                 .Meas1Done(Meas1Done),
                                 .Meas2Done(Meas2Done),
                                 .Meas3Done(Meas3Done),
                                 .RCProgRFDone(RCProgRFDone),
                                 .AGCRFGainCompDone(AGCRFGainCompDone),
                                 .RFGain0dB(RFGain0dB),
                                 .RFGain1dB(RFGain1dB),
                                 .RFGain2dB(RFGain2dB),
                                 .RFGain3dB(RFGain3dB),
`ifdef RW_NX_AGC_SNR_EN
                                 .RFGainNF0dB(RFGainNF0dB),
                                 .RFGainNF1dB(RFGainNF1dB),
                                 .RFGainNF2dB(RFGainNF2dB),
                                 .RFGainNF3dB(RFGainNF3dB),
`endif // RW_NX_AGC_SNR_EN
                                 .RCExtDetect0(RCExtDetect0),
                                 .RCExtDetect1(RCExtDetect1),
                                 .RCExtDetect2(RCExtDetect2),
                                 .RCExtDetect3(RCExtDetect3),
                                 .RegACI20MargMCS9(RegACI20MargMCS9),
                                 .RegACI20MargMCS8(RegACI20MargMCS8),
                                 .RegACI20MargMCS7(RegACI20MargMCS7),
                                 .RegACI20MargMCS6(RegACI20MargMCS6),
                                 .RegACI20MargMCS5(RegACI20MargMCS5),
                                 .RegACI20MargMCS4(RegACI20MargMCS4),
                                 .RegACI20MargMCS3(RegACI20MargMCS3),
                                 .RegACI20MargMCS2(RegACI20MargMCS2),
                                 .RegACI20MargMCS1(RegACI20MargMCS1),
                                 .RegACI20MargMCS0(RegACI20MargMCS0),
                                 .RegACI40MargMCS9(RegACI40MargMCS9),
                                 .RegACI40MargMCS8(RegACI40MargMCS8),
                                 .RegACI40MargMCS7(RegACI40MargMCS7),
                                 .RegACI40MargMCS6(RegACI40MargMCS6),
                                 .RegACI40MargMCS5(RegACI40MargMCS5),
                                 .RegACI40MargMCS4(RegACI40MargMCS4),
                                 .RegACI40MargMCS3(RegACI40MargMCS3),
                                 .RegACI40MargMCS2(RegACI40MargMCS2),
                                 .RegACI40MargMCS1(RegACI40MargMCS1),
                                 .RegACI40MargMCS0(RegACI40MargMCS0),
                                 .RegACI80MargMCS9(RegACI80MargMCS9),
                                 .RegACI80MargMCS8(RegACI80MargMCS8),
                                 .RegACI80MargMCS7(RegACI80MargMCS7),
                                 .RegACI80MargMCS6(RegACI80MargMCS6),
                                 .RegACI80MargMCS5(RegACI80MargMCS5),
                                 .RegACI80MargMCS4(RegACI80MargMCS4),
                                 .RegACI80MargMCS3(RegACI80MargMCS3),
                                 .RegACI80MargMCS2(RegACI80MargMCS2),
                                 .RegACI80MargMCS1(RegACI80MargMCS1),
                                 .RegACI80MargMCS0(RegACI80MargMCS0),
                                 .ADCPowdBVRx0(ADCPowdBVRx0),
                                 .ADCPowdBVRx1(ADCPowdBVRx1),
                                 .ADCPowdBVRx2(ADCPowdBVRx2),
                                 .ADCPowdBVRx3(ADCPowdBVRx3),
                                 .ADCSatPowdBmRx0(ADCSatPowdBmRx0),
                                 .ADCSatPowdBmRx1(ADCSatPowdBmRx1),
                                 .ADCSatPowdBmRx2(ADCSatPowdBmRx2),
                                 .ADCSatPowdBmRx3(ADCSatPowdBmRx3),
                                 .ADCSatPowdBVRx0(ADCSatPowdBVRx0),
                                 .ADCSatPowdBVRx1(ADCSatPowdBVRx1),
                                 .ADCSatPowdBVRx2(ADCSatPowdBVRx2),
                                 .ADCSatPowdBVRx3(ADCSatPowdBVRx3),
                                 .InBd20PowdBmRx0(InBd20PowdBmRx0),
                                 .InBd20PowdBmRx1(InBd20PowdBmRx1),
                                 .InBd20PowdBmRx2(InBd20PowdBmRx2),
                                 .InBd20PowdBmRx3(InBd20PowdBmRx3),
                                 .InBd40SecPowdBm(InBd40SecPowdBm),
                                 .InBd20SecPowdBm(InBd20SecPowdBm),
                                 .ADCPowdBVValid(ADCPowdBVValid),
                                 .ADCSatPowdBmValid(ADCSatPowdBmValid),
                                 .ADCSatPowValid(ADCSatPowValid),
                                 .InBd20PowValid(InBd20PowValid),
                                 .InBd20PowCCAValid(InBd20PowCCAValid),
                                 .InBd20SecPowValid(InBd20SecPowValid),
                                 .InBd40SecPowValid(InBd40SecPowValid),
                                 .OfdmACAccSum(OfdmACAccSum),
                                 .OfdmCCAccSum(OfdmCCAccSum),
                                 .DsssACAccSum(DsssACAccSum),
                                 .DsssCCAccSum(DsssCCAccSum),
                                 .RefLevDsss(RefLevDsss),
                                 .RefLevOfdm(RefLevOfdm),
                                 .RefLevDataEn(RefLevDataEn),
                                 .DsssContCCAccSum(DsssContCCAccSum),
                                 .RefLevDsssCont(RefLevDsssCont),
                                 .RefLevDsssContValid(RefLevDsssContValid),
                                 .FSMEvent0Reg(FSMEvent0Reg),
                                 .FSMEvent1Reg(FSMEvent1Reg),
                                 .FSMEvent2Reg(FSMEvent2Reg),
                                 .FSMEvent3Reg(FSMEvent3Reg),
                                 .AGCFSMCtrl(AGCFSMCtrl),
                                 .CCACtrl(CCACtrl),
                                 .RxStateCca20PSel(RxStateCca20PSel),
                                 .RxStateCca20SSel(RxStateCca20SSel),
                                 .RxStateCca40SSel(RxStateCca40SSel),
                                 .CCATimeoutReg(CCATimeoutReg),
                                 .SatLowThr(SatLowThr),
                                 .SatDynHighThr(SatDynHighThr),
                                 .SatDynLowThr(SatDynLowThr),
                                 .SatDelayCount(SatDelayCount),
                                 .RegDetPlat(RegDetPlat),
                                 .RegDetRampUp(RegDetRampUp),
                                 .RegDetRampDown(RegDetRampDown),
                                 .RegCCADetRampUp(RegCCADetRampUp),
                                 .RegCCADetRampDown(RegCCADetRampDown),
                                 .DelRampUpTap(DelRampUpTap),
                                 .DelRampDownTap(DelRampDownTap),
                                 .DelPlatTap(DelPlatTap),
                                 .DelCCARampUpTap(DelCCARampUpTap),
                                 .DelCCARampDownTap(DelCCARampDownTap),
                                 .RegDetRiseThrqdBm(RegDetRiseThrqdBm),
                                 .RegDetFallThrqdBm(RegDetFallThrqdBm),
                                 .RegADCPowDisThrdBV(RegADCPowDisThrdBV),
                                 .RegADCPowDisNdl(RegADCPowDisNdl),
                                 .RegInbdCCA20PPowMindBm(RegInbdCCA20PPowMindBm),
                                 .RegCCA20PRiseThrdBm(RegCCA20PRiseThrdBm),
                                 .RegCCA20PFallThrdBm(RegCCA20PFallThrdBm),
                                 .RegInbdCCA20SPowMindBm(RegInbdCCA20SPowMindBm),
                                 .RegCCA20SFallThrdBm(RegCCA20SFallThrdBm),
                                 .RegCCA20SRiseThrdBm(RegCCA20SRiseThrdBm),
                                 .RegInbdCCA40SPowMindBm(RegInbdCCA40SPowMindBm),
                                 .RegCCA40SFallThrdBm(RegCCA40SFallThrdBm),
                                 .RegCCA40SRiseThrdBm(RegCCA40SRiseThrdBm),
                                 .RegRFGainMax4Det(RegRFGainMax4Det),
                                 .RegRFGainMin4Det(RegRFGainMin4Det),
                                 .RegRFGainMax(RegRFGainMax),
                                 .RegRFGainMin(RegRFGainMin),
                                 .RegAntLossdB0(RegAntLossdB0),
                                 .RegAntLossdB1(RegAntLossdB1),
                                 .RegAntLossdB2(RegAntLossdB2),
                                 .RegAntLossdB3(RegAntLossdB3),
                                 .RegDigGain40vs20(RegDigGain40vs20),
                                 .RegDigGain80vs20(RegDigGain80vs20),
`ifdef RW_NX_AGC_SNR_EN
                                 .SNRMeasSel(SNRMeasSel),
`endif // RW_NX_AGC_SNR_EN
                                 .IdInBdPowGapDnqdBm(IdInBdPowGapDnqdBm),
                                 .IdInBdPowGapUpqdBm(IdInBdPowGapUpqdBm),
                                 .InBdPowInfThrdBm(InBdPowInfThrdBm),
                                 .InBdPowSupThrdBm(InBdPowSupThrdBm),
                                 .ADCPowInfThrdBV(ADCPowInfThrdBV),
                                 .ADCPowSupThrdBV(ADCPowSupThrdBV),
                                 .ADCPowInfThrdBm(ADCPowInfThrdBm),
                                 .ADCPowSupThrdBm(ADCPowSupThrdBm),

                                 //Outputs
                                 .DSPEn(DSPEn),
                                 .DelLineClr(DelLineClr),
`ifdef RW_NX_IQ_COMP_EN
                                 .IQEstGainAccEn(IQEstGainAccEn),
                                 .IQEstPhaseAccEn(IQEstPhaseAccEn),
`else
                                 .IQEstGainAccEn(),
                                 .IQEstPhaseAccEn(),
`endif // RW_NX_IQ_COMP_EN
                                 .AGCMemAddr(AGCMemAddr),
                                 .RxGain0(RxGain0Int),
                                 .RxGain1(RxGain1Int),
                                 .RxGain2(RxGain2Int),
                                 .RxGain3(RxGain3Int),
                                 .RCProgRF(RCProgRF),
                                 .AGCRFGainCompReq(AGCRFGainCompReq),
                                 .AGCGainTgt0(AGCGainTgt0),
                                 .AGCGainTgt1(AGCGainTgt1),
                                 .AGCGainTgt2(AGCGainTgt2),
                                 .AGCGainTgt3(AGCGainTgt3),
                                 .DigitalGaindB20Rx0(DigitalGaindB20Rx0),
                                 .DigitalGaindB20Rx1(DigitalGaindB20Rx1),
                                 .DigitalGaindB20Rx2(DigitalGaindB20Rx2),
                                 .DigitalGaindB20Rx3(DigitalGaindB20Rx3),
                                 .DigitalGaindB40Rx0(DigitalGaindB40Rx0),
                                 .DigitalGaindB40Rx1(DigitalGaindB40Rx1),
                                 .DigitalGaindB40Rx2(DigitalGaindB40Rx2),
                                 .DigitalGaindB40Rx3(DigitalGaindB40Rx3),
                                 .DigitalGaindB80Rx0(DigitalGaindB80Rx0),
                                 .DigitalGaindB80Rx1(DigitalGaindB80Rx1),
                                 .DigitalGaindB80Rx2(DigitalGaindB80Rx2),
                                 .DigitalGaindB80Rx3(DigitalGaindB80Rx3),
                                 .AGCOFDMLock(AGCOFDMLock),
                                 .AGCOFDMHTSTF(AGCOFDMHTSTF),
                                 .AGCDSSSLock(AGCDSSSLock),
                                 .RifsDetected(RifsDetected),
`ifdef RW_NX_AGC_SNR_EN
                                 .NoiseVardB(NoiseVardB),
                                 .NoiseVardBValid(NoiseVardBValid),
                                 .SNR(SNR),
                                 .SNRValid(SNRValid),
`endif // RW_NX_AGC_SNR_EN
                                 .OFDMACModeSel(OFDMACModeSel),
                                 .DSSSACModeSel(DSSSACModeSel),
                                 .DSSSContCorrModeSel(DSSSContCorrModeSel),
                                 .ADCSWLSatConfig(ADCSWLSatConfig),
                                 .ADCSWLConfig(ADCSWLConfig),
                                 .InBd20SWLConfig(InBd20SWLConfig),
                                 .InBd20SecSWLConfig(InBd20SecSWLConfig),
                                 .InBd40SecSWLConfig(InBd40SecSWLConfig),
                                 .AntSelDSSS(AntSelDSSS),
                                 .AntSelBWEst(AntSelBWEst),
                                 .DCMode(DCMode),
                                 .AGCCommand(AGCCommand),
                                 .AGCParam(AGCParam), 
                                 .AGCCmdValid(AGCCmdValid),
                                 .CCAPrimary(CCAPrimary),
                                 .CCASecondary20(CCASecondary20),
                                 .CCASecondary40(CCASecondary40),
                                 .CCATimeOutErr(CCATimeOutErr),
                                 .StatusTrigReq(StatusTrigReq),
                                 .InBd20PowqdBmAnt0(InBd20PowqdBmAnt0),
                                 .InBd20PowqdBmAnt1(InBd20PowqdBmAnt1),
                                 .InBd20PowqdBmAnt2(InBd20PowqdBmAnt2),
                                 .InBd20PowqdBmAnt3(InBd20PowqdBmAnt3),
                                 .InBd20PowqdBmUpdate(InBd20PowqdBmUpdate),
                                 .InBd20SecPowqdBmAnt(InBd20SecPowqdBmAnt),
                                 .InBd40SecPowqdBmAnt(InBd40SecPowqdBmAnt),
                                 .ADCPowqdBVAnt0(ADCPowqdBVAnt0),
                                 .ADCPowqdBVAnt1(ADCPowqdBVAnt1),
                                 .ADCPowqdBVAnt2(ADCPowqdBVAnt2),
                                 .ADCPowqdBVAnt3(ADCPowqdBVAnt3),
                                 .InBd20PowNoiseqdBmAnt0(InBd20PowNoiseqdBmAnt0), 
                                 .InBd20PowNoiseqdBmAnt1(InBd20PowNoiseqdBmAnt1), 
                                 .InBd20PowNoiseqdBmAnt2(InBd20PowNoiseqdBmAnt2), 
                                 .InBd20PowNoiseqdBmAnt3(InBd20PowNoiseqdBmAnt3), 
                                 .InBd20PowNoiseqdBmUpdate(InBd20PowNoiseqdBmUpdate), 
                                 .InBd20SecPowNoiseqdBmAnt(InBd20SecPowNoiseqdBmAnt),
                                 .InBd40SecPowNoiseqdBmAnt(InBd40SecPowNoiseqdBmAnt),
                                 .RxGainAnt0(RxGainAnt0),
                                 .RxGainAnt1(RxGainAnt1),
                                 .RxGainAnt2(RxGainAnt2),
                                 .RxGainAnt3(RxGainAnt3),
                                 .RFGainAnt0(RFGainAnt0),
                                 .RFGainAnt1(RFGainAnt1),
                                 .RFGainAnt2(RFGainAnt2),
                                 .RFGainAnt3(RFGainAnt3),
                                 .AGCFSMExtEn(AGCFSMExtEn),
                                 .DbgAgc(DbgAgc0),
                                 .DbgAgcFsm(DbgAgc2),
                                 .DbgCca(DbgCca)
                                );

//Instantiate AGCPowEstTop
AGCPowEstTop # (
                //Parameters
                .ADC_WIDTH(ADC_WIDTH),
                .INBD_WIDTH(INBD_WIDTH),
                .BW_PARAM(BW_PARAM),
                .FSB_ITER(FSB_ITER),
                .INBDPOW_WIDTH(INBDPOW_WIDTH),
                .ADCPOWSAT_WIDTH(ADCPOWSAT_WIDTH),
                .ADCPOW_WIDTH(ADCPOW_WIDTH),
                .DBVPOW_WIDTH(DBVPOW_WIDTH),
                .DBMPOW_WIDTH(DBMPOW_WIDTH),
                .NRX(NRX)
               ) U_AGCPowEstTop (
                                 //Inputs
                                 .nAGCRst(nAGCRst),
                                 .AGCClk(AGCClk),
                                 .ADCPowClk(ADCPowClk),
                                 //Controls
                                 .Force20(Force20),
                                 .Force40(Force40),
                                 .DelLineClr(DelLineClr),
                                 .RxAGC20PriDataValid(DataInEn),
                                 .RxAGC20SecDataValid(RxAGC20SecDataValid),
                                 .RxAGC40SecDataValid(RxAGC40SecDataValid),
                                 .RxGaindB0(RxGain0Int),
                                 .RxGaindB1(RxGain1Int),
                                 .RxGaindB2(RxGain2Int),
                                 .RxGaindB3(RxGain3Int),
                                 .ADCPowEstEn(ADCPowEstEn),
                                 .InBdSecPowEstEn(InBdSecPowEstEn),
                                 .InBd20PowEstEn(InBd20PowEstEn),
                                 .AntSelCCA20s(RegAntSelCCA20s),
                                 .AntSelCCA40s(RegAntSelCCA40s),
                                 //Registers
                                 .ADCSWLSatConfig(ADCSWLSatConfig),
                                 .ADCSWLConfig(ADCSWLConfig),
                                 .InBd20SWLConfig(InBd20SWLConfig),
                                 .InBd20SecSWLConfig(InBd20SecSWLConfig),
                                 .InBd40SecSWLConfig(InBd40SecSWLConfig),
                                 .NBitADC(NBitADC),
                                 .VPeakADCqdBV(VPeakADCqdBV),
                                 .AntLossdB0(RegAntLossdB0),
                                 .AntLossdB1(RegAntLossdB1),
                                 .AntLossdB2(RegAntLossdB2),
                                 .AntLossdB3(RegAntLossdB3),
                                 .RegInBdRnd(RegInBdRnd),
                                 .RegADCPowBiasqdBV(RegADCPowBiasqdBV),
                                 .RegADCPowBiasqdBm(RegADCPowBiasqdBm),
                                 .RegInBd40SecPowBiasqdBm(RegInBd40SecPowBiasqdBm),
                                 .RegInBd20PowBiasqdBm(RegInBd20PowBiasqdBm),
                                 .RegInBd20SecPowBiasqdBm(RegInBd20SecPowBiasqdBm),
                                 .InBddBVThr(InBddBVThr),
                                 .InBddBmThr(InBddBmThr),
                                 .ADCdBVThr(ADCdBVThr),
                                 .ADCdBmThr(ADCdBmThr),
                                 .FE20Gain(FE20Gain),
                                 .FE40Gain(FE40Gain),
                                 //From ADC
                                 .ADCReRx0(DCCompReRx0),
                                 .ADCImRx0(DCCompImRx0),
                                 .ADCReRx1(DCCompReRx1),
                                 .ADCImRx1(DCCompImRx1),
                                 .ADCReRx2(DCCompReRx2),
                                 .ADCImRx2(DCCompImRx2),
                                 .ADCReRx3(DCCompReRx3),
                                 .ADCImRx3(DCCompImRx3),
                                 //From FE Primary 20MHz
                                 .RxAGC20PriReRx0(RxAGC20PriReRx0D),
                                 .RxAGC20PriImRx0(RxAGC20PriImRx0D),
                                 .RxAGC20PriReRx1(RxAGC20PriReRx1D),
                                 .RxAGC20PriImRx1(RxAGC20PriImRx1D),
                                 .RxAGC20PriReRx2(RxAGC20PriReRx2D),
                                 .RxAGC20PriImRx2(RxAGC20PriImRx2D),
                                 .RxAGC20PriReRx3(RxAGC20PriReRx3D),
                                 .RxAGC20PriImRx3(RxAGC20PriImRx3D),
                                 //From FE Secondary 20MHz
                                 .RxAGC20SecReRx0(RxAGC20SecReRx0D),
                                 .RxAGC20SecImRx0(RxAGC20SecImRx0D),
                                 .RxAGC20SecReRx1(RxAGC20SecReRx1D),
                                 .RxAGC20SecImRx1(RxAGC20SecImRx1D),
                                 .RxAGC20SecReRx2(RxAGC20SecReRx2D),
                                 .RxAGC20SecImRx2(RxAGC20SecImRx2D),
                                 .RxAGC20SecReRx3(RxAGC20SecReRx3D),
                                 .RxAGC20SecImRx3(RxAGC20SecImRx3D),
                                 //From FE Secondary 40MHz
                                 .RxAGC40SecReRx0(RxAGC40SecReRx0D),
                                 .RxAGC40SecImRx0(RxAGC40SecImRx0D),
                                 .RxAGC40SecReRx1(RxAGC40SecReRx1D),
                                 .RxAGC40SecImRx1(RxAGC40SecImRx1D),
                                 .RxAGC40SecReRx2(RxAGC40SecReRx2D),
                                 .RxAGC40SecImRx2(RxAGC40SecImRx2D),
                                 .RxAGC40SecReRx3(RxAGC40SecReRx3D),
                                 .RxAGC40SecImRx3(RxAGC40SecImRx3D),
                                 //Inputs from Shared Delay Line
                                 .AGCRe8DRx0(DataIn8DI1),
                                 .AGCIm8DRx0(DataIn8DQ1),
                                 .AGCRe16DRx0(DataIn16DI1),
                                 .AGCIm16DRx0(DataIn16DQ1),
                                 .AGCRe32DRx0(DataIn32DI1),
                                 .AGCIm32DRx0(DataIn32DQ1),
                                 .AGCRe48DRx0(DataIn48DI1),
                                 .AGCIm48DRx0(DataIn48DQ1),
                                 .AGCRe64DRx0(DataIn64DI1),
                                 .AGCIm64DRx0(DataIn64DQ1),
                                 .AGCRe8DRx1(DataIn8DI2),
                                 .AGCIm8DRx1(DataIn8DQ2),
                                 .AGCRe16DRx1(DataIn16DI2),
                                 .AGCIm16DRx1(DataIn16DQ2),
                                 .AGCRe32DRx1(DataIn32DI2),
                                 .AGCIm32DRx1(DataIn32DQ2),
                                 .AGCRe48DRx1(DataIn48DI2),
                                 .AGCIm48DRx1(DataIn48DQ2),
                                 .AGCRe64DRx1(DataIn64DI2),
                                 .AGCIm64DRx1(DataIn64DQ2),
                                 .AGCRe8DRx2(DataIn8DI3),
                                 .AGCIm8DRx2(DataIn8DQ3),
                                 .AGCRe16DRx2(DataIn16DI3),
                                 .AGCIm16DRx2(DataIn16DQ3),
                                 .AGCRe32DRx2(DataIn32DI3),
                                 .AGCIm32DRx2(DataIn32DQ3),
                                 .AGCRe48DRx2(DataIn48DI3),
                                 .AGCIm48DRx2(DataIn48DQ3),
                                 .AGCRe64DRx2(DataIn64DI3),
                                 .AGCIm64DRx2(DataIn64DQ3),
                                 .AGCRe8DRx3(DataIn8DI4),
                                 .AGCIm8DRx3(DataIn8DQ4),
                                 .AGCRe16DRx3(DataIn16DI4),
                                 .AGCIm16DRx3(DataIn16DQ4),
                                 .AGCRe32DRx3(DataIn32DI4),
                                 .AGCIm32DRx3(DataIn32DQ4),
                                 .AGCRe48DRx3(DataIn48DI4),
                                 .AGCIm48DRx3(DataIn48DQ4),
                                 .AGCRe64DRx3(DataIn64DI4),
                                 .AGCIm64DRx3(DataIn64DQ4),
                                 //Outputs
                                 //Control Signals - Power Valid
                                 .ADCPowdBVValid(ADCPowdBVValid),
                                 .ADCSatPowdBmValid(ADCSatPowdBmValid),
                                 .ADCSatPowValid(ADCSatPowValid),
                                 .InBd20PowValid(InBd20PowValid),
                                 .InBd20PowCCAValid(InBd20PowCCAValid),
                                 .InBd20SecPowValid(InBd20SecPowValid),
                                 .InBd40SecPowValid(InBd40SecPowValid),
                                 //ADC Power Estimate in dBVrms
                                 .ADCPowdBVRx0(ADCPowdBVRx0),
                                 .ADCPowdBVRx1(ADCPowdBVRx1),
                                 .ADCPowdBVRx2(ADCPowdBVRx2),
                                 .ADCPowdBVRx3(ADCPowdBVRx3),
                                 //ADC Sat Power Estimate in dBm
                                 .ADCSatPowdBmRx0(ADCSatPowdBmRx0),
                                 .ADCSatPowdBmRx1(ADCSatPowdBmRx1),
                                 .ADCSatPowdBmRx2(ADCSatPowdBmRx2),
                                 .ADCSatPowdBmRx3(ADCSatPowdBmRx3),
                                 //ADC Power Estimate in dBVrms - for saturation detection
                                 .ADCSatPowdBVRx0(ADCSatPowdBVRx0),
                                 .ADCSatPowdBVRx1(ADCSatPowdBVRx1),
                                 .ADCSatPowdBVRx2(ADCSatPowdBVRx2),
                                 .ADCSatPowdBVRx3(ADCSatPowdBVRx3),
                                 //In Band Power in dBm for 20 MHz Primary channel
                                 .InBd20PowdBmRx0(InBd20PowdBmRx0),
                                 .InBd20PowdBmRx1(InBd20PowdBmRx1),
                                 .InBd20PowdBmRx2(InBd20PowdBmRx2),
                                 .InBd20PowdBmRx3(InBd20PowdBmRx3),
                                 //In Band Power in dBm for 40 MHz channel
                                 .InBd40SecPowdBm(InBd40SecPowdBm),
                                 //In Band Power in dBm for 20 MHz Secondary channel
                                 .InBd20SecPowdBm(InBd20SecPowdBm)
                                );
 
//Instantiate AgcCorrTop
AgcCorrTop # (
              //Parameters
              .NRX(NRX),
              .DATAINWIDTH(INBD_WIDTH),
              .DATAOUTOFDMAC(DATAOUTOFDMAC),
              .DATAOUTOFDMCC(DATAOUTOFDMCC),
              .DATAOUTDSSSAC(DATAOUTDSSSAC),
              .DATAOUTDSSSCC(DATAOUTDSSSCC),
              .DATAOUTOFDMREF(DATAOUTOFDMREF),
              .DATAOUTDSSSREF(DATAOUTDSSSREF)
             ) U_AGCCorrTop (
                             //Inputs
                             .AGCClk(AGCClk),
                             .nAGCRst(nAGCRst),
                             .OfdmCCBlockEn(OFDMCorrEn),
                             .OfdmACBlockEn(OFDMCorrEn),
                             .DsssCCBlockEn(DSSSCorrEn),
                             .DsssACBlockEn(DSSSCorrEn),
                             .RefLevBlockEn(RefLevBlockEn),
                             .ZeroOutOfdmCC(ZeroOutOFDM),
                             .ZeroOutOfdmAC(ZeroOutOFDM), 
                             .ZeroOutDsssCC(ZeroOutDSSS),
                             .ZeroOutDsssAC(ZeroOutDSSS), 
                             .AddZeroOfdmAC(AddZeroOFDMAC), 
                             .AddZeroDsssAC(AddZeroDSSSAC), 
                             .DsssSubZeroRef(DSSSSubZeroRef), 
                             .OfdmSubZeroRef(OFDMSubZeroRef), 
                             .OfdmACModeSel(OFDMACModeSel),
                             .DsssACModeSel(DSSSACModeSel),
                             .DataInEn(DataInEn),
                             .DataInI1(RxAGC20PriReRx0D),
                             .DataInQ1(RxAGC20PriImRx0D),
                             .DataIn1DI1(DataIn1DI1),
                             .DataIn1DQ1(DataIn1DQ1),
                             .DataIn2DI1(DataIn2DI1),
                             .DataIn2DQ1(DataIn2DQ1),
                             .DataIn3DI1(DataIn3DI1),
                             .DataIn3DQ1(DataIn3DQ1),
                             .DataIn4DI1(DataIn4DI1),
                             .DataIn4DQ1(DataIn4DQ1),
                             .DataIn5DI1(DataIn5DI1),
                             .DataIn5DQ1(DataIn5DQ1),
                             .DataIn6DI1(DataIn6DI1),
                             .DataIn6DQ1(DataIn6DQ1),
                             .DataIn7DI1(DataIn7DI1),
                             .DataIn7DQ1(DataIn7DQ1),
                             .DataIn8DI1(DataIn8DI1),
                             .DataIn8DQ1(DataIn8DQ1),
                             .DataIn9DI1(DataIn9DI1),
                             .DataIn9DQ1(DataIn9DQ1),
                             .DataIn10DI1(DataIn10DI1),
                             .DataIn10DQ1(DataIn10DQ1),
                             .DataIn11DI1(DataIn11DI1),
                             .DataIn11DQ1(DataIn11DQ1),
                             .DataIn12DI1(DataIn12DI1),
                             .DataIn12DQ1(DataIn12DQ1),
                             .DataIn13DI1(DataIn13DI1),
                             .DataIn13DQ1(DataIn13DQ1),
                             .DataIn14DI1(DataIn14DI1),
                             .DataIn14DQ1(DataIn14DQ1),
                             .DataIn15DI1(DataIn15DI1),
                             .DataIn15DQ1(DataIn15DQ1),
                             .DataIn16DI1(DataIn16DI1),
                             .DataIn16DQ1(DataIn16DQ1),
                             .DataIn17DI1(DataIn17DI1),
                             .DataIn17DQ1(DataIn17DQ1),
                             .DataIn18DI1(DataIn18DI1),
                             .DataIn18DQ1(DataIn18DQ1),
                             .DataIn19DI1(DataIn19DI1),
                             .DataIn19DQ1(DataIn19DQ1),
                             .DataIn20DI1(DataIn20DI1),
                             .DataIn20DQ1(DataIn20DQ1),
                             .DataIn32DI1(DataIn32DI1),
                             .DataIn32DQ1(DataIn32DQ1),
                             .DataIn40DI1(DataIn40DI1),
                             .DataIn40DQ1(DataIn40DQ1),
                             .DataIn48DI1(DataIn48DI1),
                             .DataIn48DQ1(DataIn48DQ1),
                             .DataIn60DI1(DataIn60DI1),
                             .DataIn60DQ1(DataIn60DQ1),
                             .DataIn64DI1(DataIn64DI1),
                             .DataIn64DQ1(DataIn64DQ1),
                             .DataInI2(RxAGC20PriReRx1D),
                             .DataInQ2(RxAGC20PriImRx1D),
                             .DataIn1DI2(DataIn1DI2),
                             .DataIn1DQ2(DataIn1DQ2),
                             .DataIn2DI2(DataIn2DI2),
                             .DataIn2DQ2(DataIn2DQ2),
                             .DataIn3DI2(DataIn3DI2),
                             .DataIn3DQ2(DataIn3DQ2),
                             .DataIn4DI2(DataIn4DI2),
                             .DataIn4DQ2(DataIn4DQ2),
                             .DataIn5DI2(DataIn5DI2),
                             .DataIn5DQ2(DataIn5DQ2),
                             .DataIn6DI2(DataIn6DI2),
                             .DataIn6DQ2(DataIn6DQ2),
                             .DataIn7DI2(DataIn7DI2),
                             .DataIn7DQ2(DataIn7DQ2),
                             .DataIn8DI2(DataIn8DI2),
                             .DataIn8DQ2(DataIn8DQ2),
                             .DataIn9DI2(DataIn9DI2),
                             .DataIn9DQ2(DataIn9DQ2),
                             .DataIn10DI2(DataIn10DI2),
                             .DataIn10DQ2(DataIn10DQ2),
                             .DataIn11DI2(DataIn11DI2),
                             .DataIn11DQ2(DataIn11DQ2),
                             .DataIn12DI2(DataIn12DI2),
                             .DataIn12DQ2(DataIn12DQ2),
                             .DataIn13DI2(DataIn13DI2),
                             .DataIn13DQ2(DataIn13DQ2),
                             .DataIn14DI2(DataIn14DI2),
                             .DataIn14DQ2(DataIn14DQ2),
                             .DataIn15DI2(DataIn15DI2),
                             .DataIn15DQ2(DataIn15DQ2),
                             .DataIn16DI2(DataIn16DI2),
                             .DataIn16DQ2(DataIn16DQ2),
                             .DataIn17DI2(DataIn17DI2),
                             .DataIn17DQ2(DataIn17DQ2),
                             .DataIn18DI2(DataIn18DI2),
                             .DataIn18DQ2(DataIn18DQ2),
                             .DataIn19DI2(DataIn19DI2),
                             .DataIn19DQ2(DataIn19DQ2),
                             .DataIn20DI2(DataIn20DI2),
                             .DataIn20DQ2(DataIn20DQ2),
                             .DataIn32DI2(DataIn32DI2),
                             .DataIn32DQ2(DataIn32DQ2),
                             .DataIn40DI2(DataIn40DI2),
                             .DataIn40DQ2(DataIn40DQ2),
                             .DataIn48DI2(DataIn48DI2),
                             .DataIn48DQ2(DataIn48DQ2),
                             .DataIn60DI2(DataIn60DI2),
                             .DataIn60DQ2(DataIn60DQ2),
                             .DataIn64DI2(DataIn64DI2),
                             .DataIn64DQ2(DataIn64DQ2),
                             .DataInI3(RxAGC20PriReRx2D),
                             .DataInQ3(RxAGC20PriImRx2D),
                             .DataIn1DI3(DataIn1DI3),
                             .DataIn1DQ3(DataIn1DQ3),
                             .DataIn2DI3(DataIn2DI3),
                             .DataIn2DQ3(DataIn2DQ3),
                             .DataIn3DI3(DataIn3DI3),
                             .DataIn3DQ3(DataIn3DQ3),
                             .DataIn4DI3(DataIn4DI3),
                             .DataIn4DQ3(DataIn4DQ3),
                             .DataIn5DI3(DataIn5DI3),
                             .DataIn5DQ3(DataIn5DQ3),
                             .DataIn6DI3(DataIn6DI3),
                             .DataIn6DQ3(DataIn6DQ3),
                             .DataIn7DI3(DataIn7DI3),
                             .DataIn7DQ3(DataIn7DQ3),
                             .DataIn8DI3(DataIn8DI3),
                             .DataIn8DQ3(DataIn8DQ3),
                             .DataIn9DI3(DataIn9DI3),
                             .DataIn9DQ3(DataIn9DQ3),
                             .DataIn10DI3(DataIn10DI3),
                             .DataIn10DQ3(DataIn10DQ3),
                             .DataIn11DI3(DataIn11DI3),
                             .DataIn11DQ3(DataIn11DQ3),
                             .DataIn12DI3(DataIn12DI3),
                             .DataIn12DQ3(DataIn12DQ3),
                             .DataIn13DI3(DataIn13DI3),
                             .DataIn13DQ3(DataIn13DQ3),
                             .DataIn14DI3(DataIn14DI3),
                             .DataIn14DQ3(DataIn14DQ3),
                             .DataIn15DI3(DataIn15DI3),
                             .DataIn15DQ3(DataIn15DQ3),
                             .DataIn16DI3(DataIn16DI3),
                             .DataIn16DQ3(DataIn16DQ3),
                             .DataIn17DI3(DataIn17DI3),
                             .DataIn17DQ3(DataIn17DQ3),
                             .DataIn18DI3(DataIn18DI3),
                             .DataIn18DQ3(DataIn18DQ3),
                             .DataIn19DI3(DataIn19DI3),
                             .DataIn19DQ3(DataIn19DQ3),
                             .DataIn20DI3(DataIn20DI3),
                             .DataIn20DQ3(DataIn20DQ3),
                             .DataIn32DI3(DataIn32DI3),
                             .DataIn32DQ3(DataIn32DQ3),
                             .DataIn40DI3(DataIn40DI3),
                             .DataIn40DQ3(DataIn40DQ3),
                             .DataIn48DI3(DataIn48DI3),
                             .DataIn48DQ3(DataIn48DQ3),
                             .DataIn60DI3(DataIn60DI3),
                             .DataIn60DQ3(DataIn60DQ3),
                             .DataIn64DI3(DataIn64DI3),
                             .DataIn64DQ3(DataIn64DQ3),
                             .DataInI4(RxAGC20PriReRx3D),
                             .DataInQ4(RxAGC20PriImRx3D),
                             .DataIn1DI4(DataIn1DI4),
                             .DataIn1DQ4(DataIn1DQ4),
                             .DataIn2DI4(DataIn2DI4),
                             .DataIn2DQ4(DataIn2DQ4),
                             .DataIn3DI4(DataIn3DI4),
                             .DataIn3DQ4(DataIn3DQ4),
                             .DataIn4DI4(DataIn4DI4),
                             .DataIn4DQ4(DataIn4DQ4),
                             .DataIn5DI4(DataIn5DI4),
                             .DataIn5DQ4(DataIn5DQ4),
                             .DataIn6DI4(DataIn6DI4),
                             .DataIn6DQ4(DataIn6DQ4),
                             .DataIn7DI4(DataIn7DI4),
                             .DataIn7DQ4(DataIn7DQ4),
                             .DataIn8DI4(DataIn8DI4),
                             .DataIn8DQ4(DataIn8DQ4),
                             .DataIn9DI4(DataIn9DI4),
                             .DataIn9DQ4(DataIn9DQ4),
                             .DataIn10DI4(DataIn10DI4),
                             .DataIn10DQ4(DataIn10DQ4),
                             .DataIn11DI4(DataIn11DI4),
                             .DataIn11DQ4(DataIn11DQ4),
                             .DataIn12DI4(DataIn12DI4),
                             .DataIn12DQ4(DataIn12DQ4),
                             .DataIn13DI4(DataIn13DI4),
                             .DataIn13DQ4(DataIn13DQ4),
                             .DataIn14DI4(DataIn14DI4),
                             .DataIn14DQ4(DataIn14DQ4),
                             .DataIn15DI4(DataIn15DI4),
                             .DataIn15DQ4(DataIn15DQ4),
                             .DataIn16DI4(DataIn16DI4),
                             .DataIn16DQ4(DataIn16DQ4),
                             .DataIn17DI4(DataIn17DI4),
                             .DataIn17DQ4(DataIn17DQ4),
                             .DataIn18DI4(DataIn18DI4),
                             .DataIn18DQ4(DataIn18DQ4),
                             .DataIn19DI4(DataIn19DI4),
                             .DataIn19DQ4(DataIn19DQ4),
                             .DataIn20DI4(DataIn20DI4),
                             .DataIn20DQ4(DataIn20DQ4),
                             .DataIn32DI4(DataIn32DI4),
                             .DataIn32DQ4(DataIn32DQ4),
                             .DataIn40DI4(DataIn40DI4),
                             .DataIn40DQ4(DataIn40DQ4),
                             .DataIn48DI4(DataIn48DI4),
                             .DataIn48DQ4(DataIn48DQ4),
                             .DataIn60DI4(DataIn60DI4),
                             .DataIn60DQ4(DataIn60DQ4),
                             .DataIn64DI4(DataIn64DI4),
                             .DataIn64DQ4(DataIn64DQ4),

                             //Outputs
                             .OfdmACAccSum(OfdmACAccSum),
                             .OfdmACDataEn(), // Unused
                             .OfdmCCAccSum(OfdmCCAccSum),
                             .OfdmCCDataEn(), // Unused
                             .DsssACAccSum(DsssACAccSum),
                             .DsssACDataEn(), // Unused
                             .DsssCCAccSum(DsssCCAccSum),
                             .DsssCCDataEn(), // Unused
                             .RefLevDsss(RefLevDsss),
                             .RefLevOfdm(RefLevOfdm),
                             .RefLevDataEn(RefLevDataEn)
                            );

//Instantiate NRX instances of AGCDelLine
   //First Rx Chain
   
   // Capture data from FE in order to be aligned with DataInEn
   always @ (posedge AGCClk or negedge nAGCRst)
   begin: Data20In0_Blk
      if (nAGCRst == 1'b0) begin
         RxAGC20PriReRx0D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20PriImRx0D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20SecReRx0D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20SecImRx0D <= $signed({INBD_WIDTH{1'b0}});
      end
      else if (AGCDelayLineEn == 1'b0) begin
         RxAGC20PriReRx0D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20PriImRx0D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20SecReRx0D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20SecImRx0D <= $signed({INBD_WIDTH{1'b0}});
      end
      else if (DataInEnCnt == 2'b0) begin
         RxAGC20PriReRx0D <= RxAGC20PriReRx0;
         RxAGC20PriImRx0D <= RxAGC20PriImRx0;
         RxAGC20SecReRx0D <= RxAGC20SecReRx0;
         RxAGC20SecImRx0D <= RxAGC20SecImRx0;
      end
   end //Data20In0_Blk
   
   always @ (posedge AGCClk or negedge nAGCRst)
   begin: Data40In0_Blk
      if (nAGCRst == 1'b0) begin
         RxAGC40SecReRx0D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC40SecImRx0D <= $signed({INBD_WIDTH{1'b0}});
      end
      else if (AGCDelayLineEn == 1'b0) begin
         RxAGC40SecReRx0D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC40SecImRx0D <= $signed({INBD_WIDTH{1'b0}});
      end
      else if (!DataInEnCnt[0]) begin
         RxAGC40SecReRx0D <= RxAGC40SecReRx0;
         RxAGC40SecImRx0D <= RxAGC40SecImRx0;
      end
   end //Data40In0_Blk

   AGCDelLine # (
                 //Parameters
                 .INPUT_WIDTH(INBD_WIDTH)
                 ) U_AGCDelLine0 (
                                  //Inputs
                                  .AGCClk(AGCClk),
                                  .nAGCRst(nAGCRst),
                                  .AGCEn(AGCDelayLineEn), 
                                  .RxDataValid(DataInEn),
                                  .DelLineClr(DelLineClr),
                                  .RxAGCRe(RxAGC20PriReRx0D),
                                  .RxAGCIm(RxAGC20PriImRx0D),

                                  //Outputs
                                  .RxAGCRe1D(DataIn1DI1),
                                  .RxAGCIm1D(DataIn1DQ1),
                                  .RxAGCRe2D(DataIn2DI1),
                                  .RxAGCIm2D(DataIn2DQ1),
                                  .RxAGCRe3D(DataIn3DI1),
                                  .RxAGCIm3D(DataIn3DQ1),
                                  .RxAGCRe4D(DataIn4DI1),
                                  .RxAGCIm4D(DataIn4DQ1),
                                  .RxAGCRe5D(DataIn5DI1),
                                  .RxAGCIm5D(DataIn5DQ1),
                                  .RxAGCRe6D(DataIn6DI1),
                                  .RxAGCIm6D(DataIn6DQ1),
                                  .RxAGCRe7D(DataIn7DI1),
                                  .RxAGCIm7D(DataIn7DQ1),
                                  .RxAGCRe8D(DataIn8DI1),
                                  .RxAGCIm8D(DataIn8DQ1),
                                  .RxAGCRe9D(DataIn9DI1),
                                  .RxAGCIm9D(DataIn9DQ1),
                                  .RxAGCRe10D(DataIn10DI1),
                                  .RxAGCIm10D(DataIn10DQ1),
                                  .RxAGCRe11D(DataIn11DI1),
                                  .RxAGCIm11D(DataIn11DQ1),
                                  .RxAGCRe12D(DataIn12DI1),
                                  .RxAGCIm12D(DataIn12DQ1),
                                  .RxAGCRe13D(DataIn13DI1),
                                  .RxAGCIm13D(DataIn13DQ1),
                                  .RxAGCRe14D(DataIn14DI1),
                                  .RxAGCIm14D(DataIn14DQ1),
                                  .RxAGCRe15D(DataIn15DI1),
                                  .RxAGCIm15D(DataIn15DQ1),
                                  .RxAGCRe16D(DataIn16DI1),
                                  .RxAGCIm16D(DataIn16DQ1),
                                  .RxAGCRe17D(DataIn17DI1),
                                  .RxAGCIm17D(DataIn17DQ1),
                                  .RxAGCRe18D(DataIn18DI1),
                                  .RxAGCIm18D(DataIn18DQ1),
                                  .RxAGCRe19D(DataIn19DI1),
                                  .RxAGCIm19D(DataIn19DQ1),
                                  .RxAGCRe20D(DataIn20DI1),
                                  .RxAGCIm20D(DataIn20DQ1),
                                  .RxAGCRe32D(DataIn32DI1),
                                  .RxAGCIm32D(DataIn32DQ1),
                                  .RxAGCRe40D(DataIn40DI1),
                                  .RxAGCIm40D(DataIn40DQ1),
                                  .RxAGCRe48D(DataIn48DI1),
                                  .RxAGCIm48D(DataIn48DQ1),
                                  .RxAGCRe60D(DataIn60DI1),
                                  .RxAGCIm60D(DataIn60DQ1),
                                  .RxAGCRe64D(DataIn64DI1),
                                  .RxAGCIm64D(DataIn64DQ1)
                                 );

   // Capture data from FE in order to be aligned with DataInEn
   always @ (posedge AGCClk or negedge nAGCRst)
   begin: Data20In1_Blk
      if (nAGCRst == 1'b0) begin
         RxAGC20PriReRx1D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20PriImRx1D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20SecReRx1D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20SecImRx1D <= $signed({INBD_WIDTH{1'b0}});
      end
      else if (DataInEnCnt == 2'b0) begin
         RxAGC20PriReRx1D <= RxAGC20PriReRx1;
         RxAGC20PriImRx1D <= RxAGC20PriImRx1;
         RxAGC20SecReRx1D <= RxAGC20SecReRx1;
         RxAGC20SecImRx1D <= RxAGC20SecImRx1;
      end
   end //Data20In1_Blk
   always @ (posedge AGCClk or negedge nAGCRst)
   begin: Data40In1_Blk
      if (nAGCRst == 1'b0) begin
         RxAGC40SecReRx1D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC40SecImRx1D <= $signed({INBD_WIDTH{1'b0}});
      end
      else if (!DataInEnCnt[0]) begin
         RxAGC40SecReRx1D <= RxAGC40SecReRx1;
         RxAGC40SecImRx1D <= RxAGC40SecImRx1;
      end
   end //Data40In1_Blk

generate
   if (NRX > 1) begin : U_AGCDelLine_gen1 //Second Rx Chain
      AGCDelLine # (
                    //Parameters
                    .INPUT_WIDTH(INBD_WIDTH)
                    ) U_AGCDelLine1 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .RxAGCRe(RxAGC20PriReRx1D),
                                     .RxAGCIm(RxAGC20PriImRx1D),
                                     .RxDataValid(DataInEn),
                                     .AGCEn(AGCDelayLineEn), 
                                     .DelLineClr(DelLineClr),

                                     //Outputs
                                     .RxAGCRe1D(DataIn1DI2),
                                     .RxAGCIm1D(DataIn1DQ2),
                                     .RxAGCRe2D(DataIn2DI2),
                                     .RxAGCIm2D(DataIn2DQ2),
                                     .RxAGCRe3D(DataIn3DI2),
                                     .RxAGCIm3D(DataIn3DQ2),
                                     .RxAGCRe4D(DataIn4DI2),
                                     .RxAGCIm4D(DataIn4DQ2),
                                     .RxAGCRe5D(DataIn5DI2),
                                     .RxAGCIm5D(DataIn5DQ2),
                                     .RxAGCRe6D(DataIn6DI2),
                                     .RxAGCIm6D(DataIn6DQ2),
                                     .RxAGCRe7D(DataIn7DI2),
                                     .RxAGCIm7D(DataIn7DQ2),
                                     .RxAGCRe8D(DataIn8DI2),
                                     .RxAGCIm8D(DataIn8DQ2),
                                     .RxAGCRe9D(DataIn9DI2),
                                     .RxAGCIm9D(DataIn9DQ2),
                                     .RxAGCRe10D(DataIn10DI2),
                                     .RxAGCIm10D(DataIn10DQ2),
                                     .RxAGCRe11D(DataIn11DI2),
                                     .RxAGCIm11D(DataIn11DQ2),
                                     .RxAGCRe12D(DataIn12DI2),
                                     .RxAGCIm12D(DataIn12DQ2),
                                     .RxAGCRe13D(DataIn13DI2),
                                     .RxAGCIm13D(DataIn13DQ2),
                                     .RxAGCRe14D(DataIn14DI2),
                                     .RxAGCIm14D(DataIn14DQ2),
                                     .RxAGCRe15D(DataIn15DI2),
                                     .RxAGCIm15D(DataIn15DQ2),
                                     .RxAGCRe16D(DataIn16DI2),
                                     .RxAGCIm16D(DataIn16DQ2),
                                     .RxAGCRe17D(DataIn17DI2),
                                     .RxAGCIm17D(DataIn17DQ2),
                                     .RxAGCRe18D(DataIn18DI2),
                                     .RxAGCIm18D(DataIn18DQ2),
                                     .RxAGCRe19D(DataIn19DI2),
                                     .RxAGCIm19D(DataIn19DQ2),
                                     .RxAGCRe20D(DataIn20DI2),
                                     .RxAGCIm20D(DataIn20DQ2),
                                     .RxAGCRe32D(DataIn32DI2),
                                     .RxAGCIm32D(DataIn32DQ2),
                                     .RxAGCRe40D(DataIn40DI2),
                                     .RxAGCIm40D(DataIn40DQ2),
                                     .RxAGCRe48D(DataIn48DI2),
                                     .RxAGCIm48D(DataIn48DQ2),
                                     .RxAGCRe60D(DataIn60DI2),
                                     .RxAGCIm60D(DataIn60DQ2),
                                     .RxAGCRe64D(DataIn64DI2),
                                     .RxAGCIm64D(DataIn64DQ2)
                                    );
   end
   else begin
      assign DataIn1DI2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn1DQ2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn2DI2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn2DQ2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn3DI2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn3DQ2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn4DI2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn4DQ2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn5DI2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn5DQ2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn6DI2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn6DQ2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn7DI2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn7DQ2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn8DI2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn8DQ2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn9DI2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn9DQ2  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn10DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn10DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn11DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn11DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn12DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn12DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn13DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn13DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn14DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn14DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn15DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn15DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn16DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn16DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn17DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn17DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn18DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn18DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn19DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn19DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn20DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn20DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn32DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn32DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn40DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn40DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn48DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn48DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn60DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn60DQ2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn64DI2 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn64DQ2 = $signed({INBD_WIDTH{1'b0}});
   end //Second Rx Chain

   // Capture data from FE in order to be aligned with DataInEn
   always @ (posedge AGCClk or negedge nAGCRst)
   begin: Data20In2_Blk
      if (nAGCRst == 1'b0) begin
         RxAGC20PriReRx2D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20PriImRx2D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20SecReRx2D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20SecImRx2D <= $signed({INBD_WIDTH{1'b0}});
      end
      else if (DataInEnCnt == 2'b0) begin
         RxAGC20PriReRx2D <= RxAGC20PriReRx2;
         RxAGC20PriImRx2D <= RxAGC20PriImRx2;
         RxAGC20SecReRx2D <= RxAGC20SecReRx2;
         RxAGC20SecImRx2D <= RxAGC20SecImRx2;
      end
   end //Data20In2_Blk
   always @ (posedge AGCClk or negedge nAGCRst)
   begin: Data40In2_Blk
      if (nAGCRst == 1'b0) begin
         RxAGC40SecReRx2D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC40SecImRx2D <= $signed({INBD_WIDTH{1'b0}});
      end
      else if (!DataInEnCnt[0]) begin
         RxAGC40SecReRx2D <= RxAGC40SecReRx2;
         RxAGC40SecImRx2D <= RxAGC40SecImRx2;
      end
   end //Data40In2_Blk

   if (NRX > 2) begin : U_AGCDelLine_gen2 //Third Rx Chain
      AGCDelLine # (
                    //Parameters
                    .INPUT_WIDTH(INBD_WIDTH)
                    ) U_AGCDelLine2 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .RxAGCRe(RxAGC20PriReRx2D),
                                     .RxAGCIm(RxAGC20PriImRx2D),
                                     .RxDataValid(DataInEn),
                                     .AGCEn(AGCDelayLineEn),
                                     .DelLineClr(DelLineClr),

                                     //Outputs
                                     .RxAGCRe1D(DataIn1DI3),
                                     .RxAGCIm1D(DataIn1DQ3),
                                     .RxAGCRe2D(DataIn2DI3),
                                     .RxAGCIm2D(DataIn2DQ3),
                                     .RxAGCRe3D(DataIn3DI3),
                                     .RxAGCIm3D(DataIn3DQ3),
                                     .RxAGCRe4D(DataIn4DI3),
                                     .RxAGCIm4D(DataIn4DQ3),
                                     .RxAGCRe5D(DataIn5DI3),
                                     .RxAGCIm5D(DataIn5DQ3),
                                     .RxAGCRe6D(DataIn6DI3),
                                     .RxAGCIm6D(DataIn6DQ3),
                                     .RxAGCRe7D(DataIn7DI3),
                                     .RxAGCIm7D(DataIn7DQ3),
                                     .RxAGCRe8D(DataIn8DI3),
                                     .RxAGCIm8D(DataIn8DQ3),
                                     .RxAGCRe9D(DataIn9DI3),
                                     .RxAGCIm9D(DataIn9DQ3),
                                     .RxAGCRe10D(DataIn10DI3),
                                     .RxAGCIm10D(DataIn10DQ3),
                                     .RxAGCRe11D(DataIn11DI3),
                                     .RxAGCIm11D(DataIn11DQ3),
                                     .RxAGCRe12D(DataIn12DI3),
                                     .RxAGCIm12D(DataIn12DQ3),
                                     .RxAGCRe13D(DataIn13DI3),
                                     .RxAGCIm13D(DataIn13DQ3),
                                     .RxAGCRe14D(DataIn14DI3),
                                     .RxAGCIm14D(DataIn14DQ3),
                                     .RxAGCRe15D(DataIn15DI3),
                                     .RxAGCIm15D(DataIn15DQ3),
                                     .RxAGCRe16D(DataIn16DI3),
                                     .RxAGCIm16D(DataIn16DQ3),
                                     .RxAGCRe17D(DataIn17DI3),
                                     .RxAGCIm17D(DataIn17DQ3),
                                     .RxAGCRe18D(DataIn18DI3),
                                     .RxAGCIm18D(DataIn18DQ3),
                                     .RxAGCRe19D(DataIn19DI3),
                                     .RxAGCIm19D(DataIn19DQ3),
                                     .RxAGCRe20D(DataIn20DI3),
                                     .RxAGCIm20D(DataIn20DQ3),
                                     .RxAGCRe32D(DataIn32DI3),
                                     .RxAGCIm32D(DataIn32DQ3),
                                     .RxAGCRe40D(DataIn40DI3),
                                     .RxAGCIm40D(DataIn40DQ3),
                                     .RxAGCRe48D(DataIn48DI3),
                                     .RxAGCIm48D(DataIn48DQ3),
                                     .RxAGCRe60D(DataIn60DI3),
                                     .RxAGCIm60D(DataIn60DQ3),
                                     .RxAGCRe64D(DataIn64DI3),
                                     .RxAGCIm64D(DataIn64DQ3)
                                    );
   end
   else begin
      assign DataIn1DI3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn1DQ3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn2DI3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn2DQ3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn3DI3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn3DQ3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn4DI3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn4DQ3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn5DI3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn5DQ3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn6DI3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn6DQ3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn7DI3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn7DQ3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn8DI3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn8DQ3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn9DI3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn9DQ3  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn10DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn10DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn11DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn11DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn12DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn12DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn13DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn13DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn14DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn14DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn15DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn15DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn16DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn16DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn17DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn17DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn18DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn18DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn19DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn19DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn20DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn20DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn32DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn32DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn40DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn40DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn48DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn48DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn60DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn60DQ3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn64DI3 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn64DQ3 = $signed({INBD_WIDTH{1'b0}});
   end //Third Rx Chain

   // Capture data from FE in order to be aligned with DataInEn
   always @ (posedge AGCClk or negedge nAGCRst)
   begin: Data20In3_Blk
      if (nAGCRst == 1'b0) begin
         RxAGC20PriReRx3D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20PriImRx3D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20SecReRx3D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC20SecImRx3D <= $signed({INBD_WIDTH{1'b0}});
      end
      else if (DataInEnCnt == 2'b0) begin
         RxAGC20PriReRx3D <= RxAGC20PriReRx3;
         RxAGC20PriImRx3D <= RxAGC20PriImRx3;
         RxAGC20SecReRx3D <= RxAGC20SecReRx3;
         RxAGC20SecImRx3D <= RxAGC20SecImRx3;
      end
   end //Data20In3_Blk
   always @ (posedge AGCClk or negedge nAGCRst)
   begin: Data40In3_Blk
      if (nAGCRst == 1'b0) begin
         RxAGC40SecReRx3D <= $signed({INBD_WIDTH{1'b0}});
         RxAGC40SecImRx3D <= $signed({INBD_WIDTH{1'b0}});
      end
      else if (!DataInEnCnt[0]) begin
         RxAGC40SecReRx3D <= RxAGC40SecReRx3;
         RxAGC40SecImRx3D <= RxAGC40SecImRx3;
      end
   end //Data40In3_Blk

   if (NRX > 3) begin : U_AGCDelLine_gen3 //Fourth Rx Chain
      AGCDelLine # (
                    //Parameters
                    .INPUT_WIDTH(INBD_WIDTH)
                    ) U_AGCDelLine3 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .RxAGCRe(RxAGC20PriReRx3D),
                                     .RxAGCIm(RxAGC20PriImRx3D),
                                     .RxDataValid(DataInEn),
                                     .AGCEn(AGCDelayLineEn), 
                                     .DelLineClr(DelLineClr),

                                     //Outputs
                                     .RxAGCRe1D(DataIn1DI4),
                                     .RxAGCIm1D(DataIn1DQ4),
                                     .RxAGCRe2D(DataIn2DI4),
                                     .RxAGCIm2D(DataIn2DQ4),
                                     .RxAGCRe3D(DataIn3DI4),
                                     .RxAGCIm3D(DataIn3DQ4),
                                     .RxAGCRe4D(DataIn4DI4),
                                     .RxAGCIm4D(DataIn4DQ4),
                                     .RxAGCRe5D(DataIn5DI4),
                                     .RxAGCIm5D(DataIn5DQ4),
                                     .RxAGCRe6D(DataIn6DI4),
                                     .RxAGCIm6D(DataIn6DQ4),
                                     .RxAGCRe7D(DataIn7DI4),
                                     .RxAGCIm7D(DataIn7DQ4),
                                     .RxAGCRe8D(DataIn8DI4),
                                     .RxAGCIm8D(DataIn8DQ4),
                                     .RxAGCRe9D(DataIn9DI4),
                                     .RxAGCIm9D(DataIn9DQ4),
                                     .RxAGCRe10D(DataIn10DI4),
                                     .RxAGCIm10D(DataIn10DQ4),
                                     .RxAGCRe11D(DataIn11DI4),
                                     .RxAGCIm11D(DataIn11DQ4),
                                     .RxAGCRe12D(DataIn12DI4),
                                     .RxAGCIm12D(DataIn12DQ4),
                                     .RxAGCRe13D(DataIn13DI4),
                                     .RxAGCIm13D(DataIn13DQ4),
                                     .RxAGCRe14D(DataIn14DI4),
                                     .RxAGCIm14D(DataIn14DQ4),
                                     .RxAGCRe15D(DataIn15DI4),
                                     .RxAGCIm15D(DataIn15DQ4),
                                     .RxAGCRe16D(DataIn16DI4),
                                     .RxAGCIm16D(DataIn16DQ4),
                                     .RxAGCRe17D(DataIn17DI4),
                                     .RxAGCIm17D(DataIn17DQ4),
                                     .RxAGCRe18D(DataIn18DI4),
                                     .RxAGCIm18D(DataIn18DQ4),
                                     .RxAGCRe19D(DataIn19DI4),
                                     .RxAGCIm19D(DataIn19DQ4),
                                     .RxAGCRe20D(DataIn20DI4),
                                     .RxAGCIm20D(DataIn20DQ4),
                                     .RxAGCRe32D(DataIn32DI4),
                                     .RxAGCIm32D(DataIn32DQ4),
                                     .RxAGCRe40D(DataIn40DI4),
                                     .RxAGCIm40D(DataIn40DQ4),
                                     .RxAGCRe48D(DataIn48DI4),
                                     .RxAGCIm48D(DataIn48DQ4),
                                     .RxAGCRe60D(DataIn60DI4),
                                     .RxAGCIm60D(DataIn60DQ4),
                                     .RxAGCRe64D(DataIn64DI4),
                                     .RxAGCIm64D(DataIn64DQ4)
                                    );
   end
   else begin
      assign DataIn1DI4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn1DQ4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn2DI4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn2DQ4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn3DI4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn3DQ4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn4DI4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn4DQ4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn5DI4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn5DQ4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn6DI4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn6DQ4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn7DI4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn7DQ4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn8DI4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn8DQ4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn9DI4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn9DQ4  = $signed({INBD_WIDTH{1'b0}});
      assign DataIn10DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn10DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn11DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn11DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn12DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn12DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn13DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn13DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn14DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn14DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn15DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn15DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn16DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn16DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn17DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn17DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn18DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn18DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn19DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn19DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn20DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn20DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn32DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn32DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn40DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn40DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn48DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn48DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn60DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn60DQ4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn64DI4 = $signed({INBD_WIDTH{1'b0}});
      assign DataIn64DQ4 = $signed({INBD_WIDTH{1'b0}});
   end //Fourth Rx Chain
endgenerate

`ifdef RW_NX_DSSS_CORR_EN
//Instantiate DSSSContCorr
DSSSContCorr U_DSSSContCorr ( 
                            //Inputs
                            .clk(         AGCClk),
                            .reset_n(     nAGCRst),
                            .cb_en(       DSSSFEEn),
                            .cb_config(   DSSSContCorrModeSel),
                            .sampl_i(     RxFilt4CorrI),
                            .sampl_q(     RxFilt4CorrQ),
                            .sampl_valid( RxFilt4CorrValid),
                            //Outputs
                            .cb_bc(       DsssContCCAccSum),
                            .cb_rl(       RefLevDsssCont),
                            .cb_rl_valid( RefLevDsssContValid)
                            );
`else
assign DsssContCCAccSum    = 22'b0;
assign RefLevDsssCont      = 22'b0;
assign RefLevDsssContValid = 1'b0;
`endif

//Instantiate NRX instances of DigGainConv modules
//First Rx Chain
DigGainConv U_DigGain20Conv0 (
                            //Inputs
                            .AGCClk(AGCClk),
                            .nAGCRst(nAGCRst),
                            .DigGaindBIn(DigitalGaindB20Rx0),

                            //Outputs
                            .DigGain6dB(DigGain6dB20Rx0),
                            .DigGainLin(DigGainLin20Rx0)
                           );

generate 
   if (BW_PARAM == 80) begin : U_DigGainBW80_gen0 //80MHz
      DigGainConv U_DigGain40Conv0 (
                                  //Inputs
                                  .AGCClk(AGCClk),
                                  .nAGCRst(nAGCRst),
                                  .DigGaindBIn(DigitalGaindB40Rx0),

                                  //Outputs
                                  .DigGain6dB(DigGain6dB40Rx0),
                                  .DigGainLin(DigGainLin40Rx0)
                                 );
      DigGainConv U_DigGain80Conv0 (
                                  //Inputs
                                  .AGCClk(AGCClk),
                                  .nAGCRst(nAGCRst),
                                  .DigGaindBIn(DigitalGaindB80Rx0),

                                  //Outputs
                                  .DigGain6dB(DigGain6dB80Rx0),
                                  .DigGainLin(DigGainLin80Rx0)
                                 );
   end
   else if (BW_PARAM == 40) begin : U_DigGainBW40_gen0 //40MHz
      DigGainConv U_DigGain40Conv0 (
                                  //Inputs
                                  .AGCClk(AGCClk),
                                  .nAGCRst(nAGCRst),
                                  .DigGaindBIn(DigitalGaindB40Rx0),

                                  //Outputs
                                  .DigGain6dB(DigGain6dB40Rx0),
                                  .DigGainLin(DigGainLin40Rx0)
                                 );
      assign DigGain6dB80Rx0 = 4'd0;
      assign DigGainLin80Rx0 = 6'd0;
   end
   else begin //20MHz
      assign DigGain6dB40Rx0 = 4'd0;
      assign DigGainLin40Rx0 = 6'd0;
      assign DigGain6dB80Rx0 = 4'd0;
      assign DigGainLin80Rx0 = 6'd0;
   end
endgenerate

//Second Rx Chain
generate 
   if (NRX > 1) begin : U_DigGain_gen1
      DigGainConv U_DigGain20Conv1 (
                                  //Inputs
                                  .AGCClk(AGCClk),
                                  .nAGCRst(nAGCRst),
                                  .DigGaindBIn(DigitalGaindB20Rx1),

                                  //Outputs
                                  .DigGain6dB(DigGain6dB20Rx1),
                                  .DigGainLin(DigGainLin20Rx1)
                                 );
      if (BW_PARAM == 80) begin : U_DigGainBW80_gen1 //80MHz
         DigGainConv U_DigGain40Conv1 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DigGaindBIn(DigitalGaindB40Rx1),

                                     //Outputs
                                     .DigGain6dB(DigGain6dB40Rx1),
                                     .DigGainLin(DigGainLin40Rx1)
                                    );
         DigGainConv U_DigGain80Conv1 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DigGaindBIn(DigitalGaindB80Rx1),

                                     //Outputs
                                     .DigGain6dB(DigGain6dB80Rx1),
                                     .DigGainLin(DigGainLin80Rx1)
                                    );
      end
      else if (BW_PARAM == 40) begin : U_DigGainBW40_gen1 //40MHz
         DigGainConv U_DigGain40Conv1 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DigGaindBIn(DigitalGaindB40Rx1),

                                     //Outputs
                                     .DigGain6dB(DigGain6dB40Rx1),
                                     .DigGainLin(DigGainLin40Rx1)
                                    );
         assign DigGain6dB80Rx1 = 4'd0;
         assign DigGainLin80Rx1 = 6'd0;
      end
      else begin //20MHz
         assign DigGain6dB40Rx1 = 4'd0;
         assign DigGainLin40Rx1 = 6'd0;
         assign DigGain6dB80Rx1 = 4'd0;
         assign DigGainLin80Rx1 = 6'd0;
      end
   end
   else begin
      assign DigGain6dB20Rx1 = 4'd0;
      assign DigGainLin20Rx1 = 6'd0;
      assign DigGain6dB40Rx1 = 4'd0;
      assign DigGainLin40Rx1 = 6'd0;
      assign DigGain6dB80Rx1 = 4'd0;
      assign DigGainLin80Rx1 = 6'd0;
   end //Second Rx Chain

//Third Rx Chain
   if (NRX > 2) begin : U_DigGain_gen2
      DigGainConv U_DigGain20Conv2 (
                                  //Inputs
                                  .AGCClk(AGCClk),
                                  .nAGCRst(nAGCRst),
                                  .DigGaindBIn(DigitalGaindB20Rx2),

                                  //Outputs
                                  .DigGain6dB(DigGain6dB20Rx2),
                                  .DigGainLin(DigGainLin20Rx2)
                                 );
      if (BW_PARAM == 80) begin : U_DigGainBW80_gen2 //80MHz
         DigGainConv U_DigGain40Conv2 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DigGaindBIn(DigitalGaindB40Rx2),

                                     //Outputs
                                     .DigGain6dB(DigGain6dB40Rx2),
                                     .DigGainLin(DigGainLin40Rx2)
                                    );
         DigGainConv U_DigGain80Conv2 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DigGaindBIn(DigitalGaindB80Rx2),

                                     //Outputs
                                     .DigGain6dB(DigGain6dB80Rx2),
                                     .DigGainLin(DigGainLin80Rx2)
                                    );
      end
      else if (BW_PARAM == 40) begin : U_DigGainBW40_gen2 //40MHz
         DigGainConv U_DigGain40Conv2 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DigGaindBIn(DigitalGaindB40Rx2),

                                     //Outputs
                                     .DigGain6dB(DigGain6dB40Rx2),
                                     .DigGainLin(DigGainLin40Rx2)
                                    );
         assign DigGain6dB80Rx2 = 4'd0;
         assign DigGainLin80Rx2 = 6'd0;
      end
      else begin //20MHz
         assign DigGain6dB40Rx2 = 4'd0;
         assign DigGainLin40Rx2 = 6'd0;
         assign DigGain6dB80Rx2 = 4'd0;
         assign DigGainLin80Rx2 = 6'd0;
      end
   end
   else begin
      assign DigGain6dB20Rx2 = 4'd0;
      assign DigGainLin20Rx2 = 6'd0;
      assign DigGain6dB40Rx2 = 4'd0;
      assign DigGainLin40Rx2 = 6'd0;
      assign DigGain6dB80Rx2 = 4'd0;
      assign DigGainLin80Rx2 = 6'd0;
   end //Third Rx Chain

//Fourth Rx Chain
   if (NRX > 3) begin  : U_DigGain_gen3
      DigGainConv U_DigGain20Conv3 (
                                  //Inputs
                                  .AGCClk(AGCClk),
                                  .nAGCRst(nAGCRst),
                                  .DigGaindBIn(DigitalGaindB20Rx3),

                                  //Outputs
                                  .DigGain6dB(DigGain6dB20Rx3),
                                  .DigGainLin(DigGainLin20Rx3)
                                 );
      if (BW_PARAM == 80) begin : U_DigGainBW80_gen3 //80MHz
         DigGainConv U_DigGain40Conv3 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DigGaindBIn(DigitalGaindB40Rx3),

                                     //Outputs
                                     .DigGain6dB(DigGain6dB40Rx3),
                                     .DigGainLin(DigGainLin40Rx3)
                                    );
         DigGainConv U_DigGain80Conv3 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DigGaindBIn(DigitalGaindB80Rx3),

                                     //Outputs
                                     .DigGain6dB(DigGain6dB80Rx3),
                                     .DigGainLin(DigGainLin80Rx3)
                                    );
      end
      else if (BW_PARAM == 40) begin : U_DigGainBW40_gen3 //40MHz
         DigGainConv U_DigGain40Conv3 (
                                     //Inputs
                                     .AGCClk(AGCClk),
                                     .nAGCRst(nAGCRst),
                                     .DigGaindBIn(DigitalGaindB40Rx3),

                                     //Outputs
                                     .DigGain6dB(DigGain6dB40Rx3),
                                     .DigGainLin(DigGainLin40Rx3)
                                    );
         assign DigGain6dB80Rx3 = 4'd0;
         assign DigGainLin80Rx3 = 6'd0;
      end
      else begin //20MHz
         assign DigGain6dB40Rx3 = 4'd0;
         assign DigGainLin40Rx3 = 6'd0;
         assign DigGain6dB80Rx3 = 4'd0;
         assign DigGainLin80Rx3 = 6'd0;
      end
   end
   else begin
      assign DigGain6dB20Rx3 = 4'd0;
      assign DigGainLin20Rx3 = 6'd0;
      assign DigGain6dB40Rx3 = 4'd0;
      assign DigGainLin40Rx3 = 6'd0;
      assign DigGain6dB80Rx3 = 4'd0;
      assign DigGainLin80Rx3 = 6'd0;
   end //Fourth Rx Chain
endgenerate

//Digital gain connection to AGC status registers
assign DigGaindB20Ant0 = DigitalGaindB20Rx0;
assign DigGaindB20Ant1 = DigitalGaindB20Rx1;
assign DigGaindB20Ant2 = DigitalGaindB20Rx2;
assign DigGaindB20Ant3 = DigitalGaindB20Rx3;
assign DigGaindB40Ant0 = DigitalGaindB40Rx0;
assign DigGaindB40Ant1 = DigitalGaindB40Rx1;
assign DigGaindB40Ant2 = DigitalGaindB40Rx2;
assign DigGaindB40Ant3 = DigitalGaindB40Rx3;
assign DigGaindB80Ant0 = DigitalGaindB80Rx0;
assign DigGaindB80Ant1 = DigitalGaindB80Rx1;
assign DigGaindB80Ant2 = DigitalGaindB80Rx2;
assign DigGaindB80Ant3 = DigitalGaindB80Rx3;

//Instantiate NRX instances of DCIIRFilterEstTop and DCIIRFilterCompTop modules
//First Rx Chain
DCIIRFilterEstTop # (
              //Parameters
              .INPUTWIDTH(ADC_WIDTH)
              ) U_DCIIRFilterEstTop0 (
                            //Inputs
                            .PhyClk(ADCPowClk),
                            .nPhyRst(nAGCRst),
                            .EnableIn(DCEstEn),
                            .RxDataInRe(ADCReRx0),
                            .RxDataInIm(ADCImRx0),
                            .Mode(DCMode),
                            .DelStableDC(RegDelStableDC),

                            //Outputs
                            .DCEstRe(DCEstReRx0Int),
                            .DCEstIm(DCEstImRx0Int),
                            .DCEstValid(DCEstValidInt)
                           );

DCIIRFilterCompTop # (.INPUTWIDTH(ADC_WIDTH+2),
                      .BW_PARAM(BW_PARAM))
DCIIRFilterCompTopADC0(
   .PhyClk(ADCPowClk),
   .nPhyRst(nAGCRst),
   .RxDataInValid(ADCPowEstEn),
   .BlockEn(ADCPowEstEn),
   .DCEstValid(DCEstValidInt),
   .RxDataInRe(ADCReRx0Ext),
   .RxDataInIm(ADCImRx0Ext),
   .DCEstRe(DCEstReRx0IntExt),
   .DCEstIm(DCEstImRx0IntExt),
   .dcHoldTime(dcHoldTimeADC),
   .dcCompType(dcCompTypeADC),
   .dcForceZeroCnt(dcForceZeroCntADC),
   .DCOutNeutralScaleRe(DCCompReRx0),
   .DCOutNeutralScaleIm(DCCompImRx0),
   .DCOutValid());
   
//Second Rx Chain
generate 
   if (NRX > 1) begin : U_DCIIRFilter_gen1
      DCIIRFilterEstTop # (
                    //Parameters
                    .INPUTWIDTH(ADC_WIDTH)
                    ) U_DCIIRFilterEstTop1 (
                                  //Inputs
                                  .PhyClk(ADCPowClk),
                                  .nPhyRst(nAGCRst),
                                  .EnableIn(DCEstEn),
                                  .RxDataInRe(ADCReRx1),
                                  .RxDataInIm(ADCImRx1),
                                  .Mode(DCMode),
                                  .DelStableDC(RegDelStableDC),

                                  //Outputs
                                  .DCEstRe(DCEstReRx1Int),
                                  .DCEstIm(DCEstImRx1Int),
                                  .DCEstValid()
                                 );

      DCIIRFilterCompTop # (.INPUTWIDTH(ADC_WIDTH+2),
                            .BW_PARAM(BW_PARAM))
      DCIIRFilterCompTopADC1(
         .PhyClk(ADCPowClk),
         .nPhyRst(nAGCRst),
         .RxDataInValid(ADCPowEstEn),
         .BlockEn(ADCPowEstEn),
         .DCEstValid(DCEstValidInt),
         .RxDataInRe(ADCReRx1Ext),
         .RxDataInIm(ADCImRx1Ext),
         .DCEstRe(DCEstReRx1IntExt),
         .DCEstIm(DCEstImRx1IntExt),
         .dcHoldTime(dcHoldTimeADC),
         .dcCompType(dcCompTypeADC),
         .dcForceZeroCnt(dcForceZeroCntADC),
         .DCOutNeutralScaleRe(DCCompReRx1),
         .DCOutNeutralScaleIm(DCCompImRx1),
         .DCOutValid());
   end
   else begin
      assign DCEstReRx1Int = $signed({{ADC_WIDTH}{1'b0}});
      assign DCEstImRx1Int = $signed({{ADC_WIDTH}{1'b0}});
      assign DCCompReRx1   = $signed({{ADC_WIDTH}{1'b0}});
      assign DCCompImRx1   = $signed({{ADC_WIDTH}{1'b0}});
   end //Second Rx Chain

//Third Rx Chain
   if (NRX > 2) begin : U_DCIIRFilter_gen2
      DCIIRFilterEstTop # (
                    //Parameters
                    .INPUTWIDTH(ADC_WIDTH)
                    ) U_DCIIRFilterEstTop2 (
                                  //Inputs
                                  .PhyClk(ADCPowClk),
                                  .nPhyRst(nAGCRst),
                                  .EnableIn(DCEstEn),
                                  .RxDataInRe(ADCReRx2),
                                  .RxDataInIm(ADCImRx2),
                                  .Mode(DCMode),
                                  .DelStableDC(RegDelStableDC),

                                  //Outputs
                                  .DCEstRe(DCEstReRx2Int),
                                  .DCEstIm(DCEstImRx2Int),
                                  .DCEstValid()
                                 );

      DCIIRFilterCompTop # (.INPUTWIDTH(ADC_WIDTH+2),
                            .BW_PARAM(BW_PARAM))
      DCIIRFilterCompTopADC2(
         .PhyClk(ADCPowClk),
         .nPhyRst(nAGCRst),
         .RxDataInValid(ADCPowEstEn),
         .BlockEn(ADCPowEstEn),
         .DCEstValid(DCEstValidInt),
         .RxDataInRe(ADCReRx2Ext),
         .RxDataInIm(ADCImRx2Ext),
         .DCEstRe(DCEstReRx2IntExt),
         .DCEstIm(DCEstImRx2IntExt),
         .dcHoldTime(dcHoldTimeADC),
         .dcCompType(dcCompTypeADC),
         .dcForceZeroCnt(dcForceZeroCntADC),
         .DCOutNeutralScaleRe(DCCompReRx2),
         .DCOutNeutralScaleIm(DCCompImRx2),
         .DCOutValid());
   end
   else begin
      assign DCEstReRx2Int = $signed({{ADC_WIDTH}{1'b0}});
      assign DCEstImRx2Int = $signed({{ADC_WIDTH}{1'b0}});
      assign DCCompReRx2   = $signed({{ADC_WIDTH}{1'b0}});
      assign DCCompImRx2   = $signed({{ADC_WIDTH}{1'b0}});
   end //Third Rx Chain

//Fourth Rx Chain
   if (NRX > 3) begin : U_DCIIRFilter_gen3
      DCIIRFilterEstTop # (
                    //Parameters
                    .INPUTWIDTH(ADC_WIDTH)
                    ) U_DCIIRFilterEstTop3 (
                                  //Inputs
                                  .PhyClk(ADCPowClk),
                                  .nPhyRst(nAGCRst),
                                  .EnableIn(DCEstEn),
                                  .RxDataInRe(ADCReRx3),
                                  .RxDataInIm(ADCImRx3),
                                  .Mode(DCMode),
                                  .DelStableDC(RegDelStableDC),

                                  //Outputs
                                  .DCEstRe(DCEstReRx3Int),
                                  .DCEstIm(DCEstImRx3Int),
                                  .DCEstValid()
                                 );

      DCIIRFilterCompTop # (.INPUTWIDTH(ADC_WIDTH+2),
                            .BW_PARAM(BW_PARAM))
      DCIIRFilterCompTopADC3(
         .PhyClk(ADCPowClk),
         .nPhyRst(nAGCRst),
         .RxDataInValid(ADCPowEstEn),
         .BlockEn(ADCPowEstEn),
         .DCEstValid(DCEstValidInt),
         .RxDataInRe(ADCReRx3Ext),
         .RxDataInIm(ADCImRx3Ext),
         .DCEstRe(DCEstReRx3IntExt),
         .DCEstIm(DCEstImRx3IntExt),
         .dcHoldTime(dcHoldTimeADC),
         .dcCompType(dcCompTypeADC),
         .dcForceZeroCnt(dcForceZeroCntADC),
         .DCOutNeutralScaleRe(DCCompReRx3),
         .DCOutNeutralScaleIm(DCCompImRx3),
         .DCOutValid());
   end
   else begin
      assign DCEstReRx3Int = $signed({{ADC_WIDTH}{1'b0}});
      assign DCEstImRx3Int = $signed({{ADC_WIDTH}{1'b0}});
      assign DCCompReRx3   = $signed({{ADC_WIDTH}{1'b0}});
      assign DCCompImRx3   = $signed({{ADC_WIDTH}{1'b0}});
   end //Fourth Rx Chain
endgenerate

// Extend data for DCIIRFilterCompTop
assign ADCReRx0Ext      = $signed({{2{ADCReRx0[ADC_WIDTH - 1]}},ADCReRx0[ADC_WIDTH-1:0]});
assign ADCImRx0Ext      = $signed({{2{ADCImRx0[ADC_WIDTH - 1]}},ADCImRx0[ADC_WIDTH-1:0]});
assign ADCReRx1Ext      = $signed({{2{ADCReRx1[ADC_WIDTH - 1]}},ADCReRx1[ADC_WIDTH-1:0]});
assign ADCImRx1Ext      = $signed({{2{ADCImRx1[ADC_WIDTH - 1]}},ADCImRx1[ADC_WIDTH-1:0]});
assign ADCReRx2Ext      = $signed({{2{ADCReRx2[ADC_WIDTH - 1]}},ADCReRx2[ADC_WIDTH-1:0]});
assign ADCImRx2Ext      = $signed({{2{ADCImRx2[ADC_WIDTH - 1]}},ADCImRx2[ADC_WIDTH-1:0]});
assign ADCReRx3Ext      = $signed({{2{ADCReRx3[ADC_WIDTH - 1]}},ADCReRx3[ADC_WIDTH-1:0]});
assign ADCImRx3Ext      = $signed({{2{ADCImRx3[ADC_WIDTH - 1]}},ADCImRx3[ADC_WIDTH-1:0]});
assign DCEstReRx0IntExt = $signed({{2{DCEstReRx0Int[ADC_WIDTH - 1]}},DCEstReRx0Int[ADC_WIDTH-1:0]});
assign DCEstImRx0IntExt = $signed({{2{DCEstImRx0Int[ADC_WIDTH - 1]}},DCEstImRx0Int[ADC_WIDTH-1:0]});
assign DCEstReRx1IntExt = $signed({{2{DCEstReRx1Int[ADC_WIDTH - 1]}},DCEstReRx1Int[ADC_WIDTH-1:0]});
assign DCEstImRx1IntExt = $signed({{2{DCEstImRx1Int[ADC_WIDTH - 1]}},DCEstImRx1Int[ADC_WIDTH-1:0]});
assign DCEstReRx2IntExt = $signed({{2{DCEstReRx2Int[ADC_WIDTH - 1]}},DCEstReRx2Int[ADC_WIDTH-1:0]});
assign DCEstImRx2IntExt = $signed({{2{DCEstImRx2Int[ADC_WIDTH - 1]}},DCEstImRx2Int[ADC_WIDTH-1:0]});
assign DCEstReRx3IntExt = $signed({{2{DCEstReRx3Int[ADC_WIDTH - 1]}},DCEstReRx3Int[ADC_WIDTH-1:0]});
assign DCEstImRx3IntExt = $signed({{2{DCEstImRx3Int[ADC_WIDTH - 1]}},DCEstImRx3Int[ADC_WIDTH-1:0]});

//Generate ZeroOutOFDM for 200ns
always @ (posedge AGCClk or negedge nAGCRst)
   begin: ZeroOutOFDMCnt_Blk
      if (nAGCRst == 1'b0)
         ZeroOutOFDMCnt <= 4'b0;
      else if (OFDMCorrEn == 1'b0)
         ZeroOutOFDMCnt <= 4'b0;
      else if (OFDMCorrEn == 1'b1 && OFDMCorrEnD == 1'b0)
         ZeroOutOFDMCnt <= 4'b1;
      else if (ZeroOutOFDMCnt == 4'd12)
         ZeroOutOFDMCnt <= 4'b0;
      else if (ZeroOutOFDMCnt != 4'b0)
         ZeroOutOFDMCnt <= ZeroOutOFDMCnt + 4'b1;
   end //ZeroOutOFDMCnt_Blk

assign ZeroOutOFDMCntGt0 = (ZeroOutOFDMCnt != 4'b0) ? 1'b1 : 1'b0;
assign ZeroOutOFDM       = (OFDMCorrEn & ~OFDMCorrEnD) | ZeroOutOFDMCntGt0;

//Generate ZeroOutDSSS for 250ns
always @ (posedge AGCClk or negedge nAGCRst)
   begin: ZeroOutDSSSCnt_Blk
      if (nAGCRst == 1'b0)
         ZeroOutDSSSCnt <= 5'b0;
      else if (DSSSCorrEn == 1'b0)
         ZeroOutDSSSCnt <= 5'b0;
      else if (DSSSCorrEn == 1'b1 && DSSSCorrEnD == 1'b0)
         ZeroOutDSSSCnt <= 5'b1;
      else if (ZeroOutDSSSCnt == 5'd16)
         ZeroOutDSSSCnt <= 5'b0;
      else if (ZeroOutDSSSCnt != 5'b0)
         ZeroOutDSSSCnt <= ZeroOutDSSSCnt + 5'b1;
   end //ZeroOutDSSSCnt_Blk

assign ZeroOutDSSSCntGt0 = (ZeroOutDSSSCnt != 5'b0) ? 1'b1 : 1'b0;
assign ZeroOutDSSS       = (DSSSCorrEn & ~DSSSCorrEnD) | ZeroOutDSSSCntGt0;
   
//Generate AddZeroOFDMAC
always @ (posedge AGCClk or negedge nAGCRst)
   begin: AddZeroOFDMACCnt_Blk
      if (nAGCRst == 1'b0)
         AddZeroOFDMACCnt <= 6'b0;
      else if (OFDMCorrEn == 1'b0)
         AddZeroOFDMACCnt <= 6'b0;
      else if (OFDMCorrEn == 1'b1 && OFDMCorrEnD == 1'b0 && DataInEn3D == 1'b1)
         AddZeroOFDMACCnt <= 6'b1;
      else if (AddZeroOFDMACCnt == 6'd15 && OFDMACModeSel == 2'h0 && DataInEn3D == 1'b1) // 0.8us
         AddZeroOFDMACCnt <= 6'b0;
      else if (AddZeroOFDMACCnt == 6'd31 && OFDMACModeSel == 2'h1 && DataInEn3D == 1'b1) // 1.6us
         AddZeroOFDMACCnt <= 6'b0;
      else if (AddZeroOFDMACCnt == 6'd47 && OFDMACModeSel == 2'h2 && DataInEn3D == 1'b1) // 2.4us
         AddZeroOFDMACCnt <= 6'b0;
      else if (AddZeroOFDMACCnt != 6'b0 && DataInEn3D == 1'b1)
         AddZeroOFDMACCnt <= AddZeroOFDMACCnt + 6'b1;
   end //AddZeroOFDMACCnt_Blk

assign AddZeroOFDMACCntGt0 = (AddZeroOFDMACCnt != 6'b0) ? 1'b1 : 1'b0;
assign AddZeroOFDMAC       = (OFDMCorrEn & ~OFDMCorrEnD) | AddZeroOFDMACCntGt0;

//Generate AddZeroDSSSAC
always @ (posedge AGCClk or negedge nAGCRst)
   begin: AddZeroDSSSACCnt_Blk
      if (nAGCRst == 1'b0)
         AddZeroDSSSACCnt <= 6'b0;
      else if (DSSSCorrEn == 1'b0)
         AddZeroDSSSACCnt <= 6'b0;
      else if (DSSSCorrEn == 1'b1 && DSSSCorrEnD == 1'b0 && DataInEn3D == 1'b1)
         AddZeroDSSSACCnt <= 6'b1;
      else if (AddZeroDSSSACCnt == 6'd19 && DSSSACModeSel == 1'b0 && DataInEn3D == 1'b1) // 1us
         AddZeroDSSSACCnt <= 6'b0;
      else if (AddZeroDSSSACCnt == 6'd39 && DSSSACModeSel == 1'b1 && DataInEn3D == 1'b1) // 2us
         AddZeroDSSSACCnt <= 6'b0;
      else if (AddZeroDSSSACCnt != 6'b0 && DataInEn3D == 1'b1)
         AddZeroDSSSACCnt <= AddZeroDSSSACCnt + 6'b1;
   end //AddZeroDSSSACCnt_Blk

assign AddZeroDSSSACCntGt0 = (AddZeroDSSSACCnt != 6'b0) ? 1'b1 : 1'b0;
assign AddZeroDSSSAC       = (DSSSCorrEn & ~DSSSCorrEnD) | AddZeroDSSSACCntGt0;
   
//Generate OFDMSubZeroRef
always @ (posedge AGCClk or negedge nAGCRst)
   begin: OFDMSubZeroRefCnt_Blk
      if (nAGCRst == 1'b0)
         OFDMSubZeroRefCnt <= 5'b0;
      else if (OFDMCorrEn == 1'b0 && DSSSCorrEn == 1'b0)
         OFDMSubZeroRefCnt <= 5'b0;
      else if (RefLevBlockEn == 1'b1 && RefLevBlockEn1D == 1'b0 && DataInEn3D == 1'b1)
         OFDMSubZeroRefCnt <= 5'b1;
      else if (OFDMSubZeroRefCnt == 5'd15 && DataInEn3D == 1'b1) // 0.8us
         OFDMSubZeroRefCnt <= 5'b0;
      else if (OFDMSubZeroRefCnt != 5'b0 && DataInEn3D == 1'b1)
         OFDMSubZeroRefCnt <= OFDMSubZeroRefCnt + 5'b1;
   end //OFDMSubZeroRefCnt_Blk

assign OFDMSubZeroRefCntGt0 = (OFDMSubZeroRefCnt != 5'b0) ? 1'b1 : 1'b0;
assign OFDMSubZeroRef       = (RefLevBlockEn & ~RefLevBlockEn1D) | OFDMSubZeroRefCntGt0;

//Generate DSSSSubZeroRef
always @ (posedge AGCClk or negedge nAGCRst)
   begin: DSSSSubZeroRefCnt_Blk
      if (nAGCRst == 1'b0)
         DSSSSubZeroRefCnt <= 5'b0;
      else if (OFDMCorrEn == 1'b0 && DSSSCorrEn == 1'b0)
         DSSSSubZeroRefCnt <= 5'b0;
      else if (RefLevBlockEn == 1'b1 && RefLevBlockEn1D == 1'b0 && DataInEn3D == 1'b1)
         DSSSSubZeroRefCnt <= 5'b1;
      else if (DSSSSubZeroRefCnt == 5'd19 && DataInEn3D == 1'b1) // 1us
         DSSSSubZeroRefCnt <= 5'b0;
      else if (DSSSSubZeroRefCnt != 5'b0 && DataInEn3D == 1'b1)
         DSSSSubZeroRefCnt <= DSSSSubZeroRefCnt + 5'b1;
   end //DSSSSubZeroRefCnt_Blk

assign DSSSSubZeroRefCntGt0 = (DSSSSubZeroRefCnt != 5'b0) ? 1'b1 : 1'b0;
assign DSSSSubZeroRef       = (RefLevBlockEn & ~RefLevBlockEn1D) | DSSSSubZeroRefCntGt0;

assign RefLevBlockEn   = OFDMCorrEn  | DSSSCorrEn;
assign RefLevBlockEn1D = OFDMCorrEnD | DSSSCorrEnD;

always @ (posedge AGCClk or negedge nAGCRst)
   begin: DataEn_Blk
      if (nAGCRst == 1'b0) begin
         OFDMCorrEnD <= 1'b0;
         DSSSCorrEnD <= 1'b0;
         DataInEn1D  <= 1'b0;
         DataInEn2D  <= 1'b0;
         DataInEn3D  <= 1'b0;
      end
      else begin
         if (DSSSCorrEn == 1'b0) begin
           DSSSCorrEnD <= 1'b0;
         end
         else if (DataInEn3D == 1'b1) begin
           DSSSCorrEnD <= DSSSCorrEn;
         end
         if (OFDMCorrEn == 1'b0) begin
           OFDMCorrEnD <= 1'b0;
         end
         else if (DataInEn3D == 1'b1) begin
           OFDMCorrEnD <= OFDMCorrEn;
         end
         DataInEn1D  <= DataInEn;
         DataInEn2D  <= DataInEn1D;
         DataInEn3D  <= DataInEn2D;
      end
   end //DataEn_Blk

//Generate data enable to the AGC Delay Lines, Power Estim and Correlators
//Downsample incoming data by 4 according to DataInEnCnt counter
always @ (posedge AGCClk or negedge nAGCRst)
begin: DataInEnCnt_Blk
   if (nAGCRst == 1'b0)
      DataInEnCnt <= 2'b0;
   else if (AGCFSMCtrl[0]) // AGC reset
      DataInEnCnt <= 2'b0;
   else 
      DataInEnCnt <= DataInEnCnt + 2'd1;
end //DataInEnCnt_Blk

assign DataInEn = (DataInEnCnt == 2'd1) ? 1'b1 : 1'b0;

//Generate data valid to the AGC Power Estim
generate
   if (BW_PARAM == 80) begin : U_DataValidBW80_gen
      assign RxAGC20SecDataValid = DataInEn;
      assign RxAGC40SecDataValid = DataInEnCnt[0];
   end // BW_PARAM == 80
   else if (BW_PARAM == 40) begin : U_DataValidBW40_gen
      assign RxAGC20SecDataValid = DataInEn;
      assign RxAGC40SecDataValid = 1'b0;
   end // BW_PARAM == 40
   else begin : U_DataValidBW20_gen
      assign RxAGC20SecDataValid = 1'b0;
      assign RxAGC40SecDataValid = 1'b0;
   end // BW_PARAM == 20
endgenerate

//Splitting DSPEn[14:0] into various block enables
assign DCEstEn         = DSPEn[0];
assign ADCPowEstEn     = DSPEn[1];
assign OFDMFEEn        = DSPEn[2];
assign AGCDelayLineEn  = DSPEn[2];
assign InBd20PowEstEn  = DSPEnAligned[0];// -> DSPEn[3]
assign InBdSecPowEstEn = DSPEnAligned[0];// -> DSPEn[3]
assign OFDMCorrEn      = DSPEnAligned[1];// -> DSPEn[5]
assign DSSSCorrEn      = DSPEnAligned[2];// -> DSPEn[6]
assign DSSSFEEn        = DSPEn[12];
assign RadarEn         = DSPEn[13];
`ifdef RW_NX_IQ_COMP_EN
assign IQGnPhCompEn    = DSPEn[14];
`endif // RW_NX_IQ_COMP_EN

// InBd20PowEstEn -> DSPEn[3]
assign DSPEnAligned[0] = (DSPEn[3] & DataInEn) | DSPEnSync[0];
// OFDMCorrEn -> DSPEn[5]
assign DSPEnAligned[1] = (DSPEn[5] & DataInEn) | DSPEnSync[1];
// DSSSCorrEn -> DSPEn[6]
assign DSPEnAligned[2] = (DSPEn[6] & DataInEn) | DSPEnSync[2];

// Synchronize DSPEn on 20MS/s
always @ (posedge AGCClk or negedge nAGCRst)
   begin: DSPEnSync_Blk
      if (nAGCRst == 1'b0)
         DSPEnSync <= 3'b0;
      else begin
         if (DataInEn == 1'b1) begin
           DSPEnSync[2:0] <= {DSPEn[6:5],DSPEn[3]};
         end
         if (!DSPEn[3])
           DSPEnSync[0] <= 1'b0;
         if (!DSPEn[5])
           DSPEnSync[1] <= 1'b0;
         if (!DSPEn[6])
           DSPEnSync[2] <= 1'b0;
      end
   end //DSPEnSync_Blk


//Outputs
assign DCEstReRx0 = DCEstReRx0Int;
assign DCEstImRx0 = DCEstImRx0Int;
assign DCEstReRx1 = DCEstReRx1Int;
assign DCEstImRx1 = DCEstImRx1Int;
assign DCEstReRx2 = DCEstReRx2Int;
assign DCEstImRx2 = DCEstImRx2Int;
assign DCEstReRx3 = DCEstReRx3Int;
assign DCEstImRx3 = DCEstImRx3Int;
assign DCEstValid = DCEstValidInt;

`ifdef RW_RADAR_EN

  //Instantiate RadarDetection
  RadarDetection U_RadarDetection	(
  			.nAGCRst              (nAGCRst),
  			.AGCClk               (AGCClk),
  			.nRadarTimRst         (nRadarTimRst),
  			.RadarTimClk          (RadarTimClk),
  			.nHRst                (nHRst),
  			.HClk                 (HClk),
  			.RadarEn              (RadarEn),
  			.AGCCommand           (AGCCommand),
  			.AGCParam             (AGCParam),
  			.AGCCmdValid          (AGCCmdValid),
  			.FomSing              (FomSing),
  			.FomHigh              (FomHigh),
  			.FomMed               (FomMed),
  			.FreqSing             (FreqSing),
  			.FreqDC               (FreqDC),
  			.FreqLow              (FreqLow),
  			.FreqHigh             (FreqHigh),
  			.LengthLow            (LengthLow),
  			.LengthHigh           (LengthHigh),
  			.Meas1Done            (Meas1Done),
  			.Meas2Done            (Meas2Done),
  			.Meas3Done            (Meas3Done),
  			.RegRadarDetEn        (RadarDetEn),
  			.RegFreqSing          (RegFreqSing),
  			.RegFreqSingGap       (RegFreqSingGap),
  			.RegFomSing           (RegFomSing),
  			.RegFomSingGap        (RegFomSingGap),
        .RegPulseIrqThr       (RegPulseIrqThr),
        .RegPulseIrqTimeOut   (RegPulseIrqTimeOut),
        .RegPulseTimerClear   (RegPulseTimerClear),
  			.RegForce20           (Force20),
  			.RegForce40           (Force40),
  			.RadarFifoEmpty       (RadarFifoEmpty),
  			.RxRadI               (RxRadID),
  			.RxRadQ               (RxRadQD),
  			.RxRadValid           (RxRadValid),
  			.RadarFifoRdEn        (RadarFifoRdEn),
  			.RadarFifoRdData      (RadarFifoRdData),
        .RadarMemRdData       (RadarMemRdData),
        .RadarMemWrData       (RadarMemWrData),
        .RadarMemAddr         (RadarMemAddr),
        .RadarMemWriteEn      (RadarMemWriteEn),
        .RadarMemEn           (RadarMemEn),
  			.RadarIrq             (RadarIrq),
  			.DbgRad               (DbgAgc5)
  			);

     // Capture data from FE in order to be aligned with RxRadValid
     always @ (posedge AGCClk or negedge nAGCRst)
     begin: RadIn0_Blk
        if (nAGCRst == 1'b0) begin
           RxRadID <= $signed({13{1'b0}});
           RxRadQD <= $signed({13{1'b0}});
        end
        else if ((!Force40 && !Force20) || (Force20 && (RadarDataInEnCnt == 2'd0)) || 
                                           (Force40 && (RadarDataInEnCnt[0] == 1'b0))) begin
           RxRadID <= RxRadI;
           RxRadQD <= RxRadQ;
        end
     end //RadIn0_Blk


  assign RxRadValid = (Force40 == 1'b0 && Force20 == 1'b0) ? 1'b1 :
                      (Force20 == 1'b1) ? (RadarDataInEnCnt == 2'd1) : RadarDataInEnCnt[0];

  assign RadarDetEn = AGCFSMCtrl[1];

  //Generate data enable to the Radar detection
  //Downsample incoming data by 4 according to RadarDataInEnCnt counter
  always @ (posedge AGCClk or negedge nAGCRst)
  begin: RadarDataInEnCnt_Blk
     if (nAGCRst == 1'b0)
        RadarDataInEnCnt <= 2'b0;
     else if (!RadarEn)
        RadarDataInEnCnt <= 2'b0;
     else 
        RadarDataInEnCnt <= RadarDataInEnCnt + 2'd1;
  end //RadarDataInEnCnt_Blk

`else

  assign FomSing    = 1'b0;
  assign FomHigh    = 1'b0;
  assign FomMed     = 1'b0;
  assign FreqSing   = 1'b0;
  assign FreqDC     = 1'b0;
  assign FreqLow    = 1'b0;
  assign FreqHigh   = 1'b0;
  assign LengthLow  = 1'b0;
  assign LengthHigh = 1'b0;
  assign Meas1Done  = 1'b0;
  assign Meas2Done  = 1'b0;
  assign Meas3Done  = 1'b0;

`endif // RW_RADAR_EN

// Debug port
assign DbgAgc1 = {AGCFSMCtrl[0],   // AGC reset
                  AGCDelayLineEn,  // Delay line Enable
                  InBd20PowEstEn,  // InBand Power Estim 20MHz Enable
                  DataInEn,        // Qualifies FE Data
                  InBd20PowValid,  // InBand Power Estim Valid
                  InBd20PowdBmRx0[12:2] // InBand Power Estim
                 };

assign DbgAgc3 = {RFGain0dB,       // Effective RF Gain
                  AGCGainTgt0};    // AGC target gain
                                
assign DbgAgc4 = DigitalGaindB20Rx0; // Digital Gain

endmodule //AGCCCATop

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
