////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: jandre $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 14736 $
// $Date: 2014-04-29 11:20:17 +0200 (Tue, 29 Apr 2014) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : AGC Status Register
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/AGCStatusRegister.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module AGCStatusRegister(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            // Clock and Reset
            input    wire                                  AGCClk,    // AGC Clock
            input    wire                                  nAGCRst,   // Active Low Reset

            // Controls
            // From Core FSM
            input    wire                                  AGCClear,  // Clear latched values
            
            // Saturation Detection
            input    wire                                  SatDetectRx0,
            input    wire                                  SatDetectRx1,
            input    wire                                  SatDetectRx2,
            input    wire                                  SatDetectRx3,
            input    wire              [2:0]               SatCount,

            // External Detection
            input    wire                                  ExtDetectRx0,
            input    wire                                  ExtDetectRx1,
            input    wire                                  ExtDetectRx2,
            input    wire                                  ExtDetectRx3,

            // Plateau Detection - Power Stable
            input    wire                                  PlatDetRx0,
            input    wire                                  PlatDetRx1,
            input    wire                                  PlatDetRx2,
            input    wire                                  PlatDetRx3,

            // From Correlators
            input    wire                                  OFDMACDiff,
            input    wire                                  OFDMCCDiff,
            input    wire                                  BarkerACDiff,
            input    wire                                  BarkerCCDiff,
            
            // From DSSS Continuous Correlator
            input    wire                                  DSSSDetect,

            // From TimeOut Counter
            input    wire                                  TimeOut,

            // From RF Gain Setting Block
            input    wire                                  RFGainSetDoneP,
            input    wire                                  NoGainUpdateP,

            // InBand Power Threshold Crossing Detection
            input    wire                                  DetCrossUpRx0,
            input    wire                                  DetCrossUpRx1,
            input    wire                                  DetCrossUpRx2,
            input    wire                                  DetCrossUpRx3,
            input    wire                                  DetCrossDownRx0,
            input    wire                                  DetCrossDownRx1,
            input    wire                                  DetCrossDownRx2,
            input    wire                                  DetCrossDownRx3,

            // InBand Power Ramp Up/Down Detection
            input    wire                                  DetRampUpRx0,
            input    wire                                  DetRampUpRx1,
            input    wire                                  DetRampUpRx2,
            input    wire                                  DetRampUpRx3,
            input    wire                                  DetRampDownRx0,
            input    wire                                  DetRampDownRx1,
            input    wire                                  DetRampDownRx2,
            input    wire                                  DetRampDownRx3,

            // Power Disappearance Detection
            input    wire                                  ADCPowDisRx0,
            input    wire                                  ADCPowDisRx1,
            input    wire                                  ADCPowDisRx2,
            input    wire                                  ADCPowDisRx3,

            // From RF Gain Comparator Block
            input    wire                                  RFGainCp2MaxRx0,
            input    wire                                  RFGainCp2MaxRx1,
            input    wire                                  RFGainCp2MaxRx2,
            input    wire                                  RFGainCp2MaxRx3,
            input    wire                                  RFGainCp2MinRx0,
            input    wire                                  RFGainCp2MinRx1,
            input    wire                                  RFGainCp2MinRx2,
            input    wire                                  RFGainCp2MinRx3,
            input    wire                                  RFGainCp2Min4SatRx0,
            input    wire                                  RFGainCp2Min4SatRx1,
            input    wire                                  RFGainCp2Min4SatRx2,
            input    wire                                  RFGainCp2Min4SatRx3,

            // From AGC Detector Block
            input    wire                                  CmdCtrlFlag,
            input    wire              [2:0]               GenCount,

            // From Energy Comparator Block
            input    wire                                  InBdPowSupRx0,
            input    wire                                  InBdPowSupRx1,
            input    wire                                  InBdPowSupRx2,
            input    wire                                  InBdPowSupRx3,
            input    wire                                  InBdPowInfRx0,
            input    wire                                  InBdPowInfRx1,
            input    wire                                  InBdPowInfRx2,
            input    wire                                  InBdPowInfRx3,
            input    wire                                  IdPowRx0,
            input    wire                                  IdPowRx1,
            input    wire                                  IdPowRx2,
            input    wire                                  IdPowRx3,
            //
            input    wire                                  ADCPowdBVSupRx0,
            input    wire                                  ADCPowdBVSupRx1,
            input    wire                                  ADCPowdBVSupRx2,
            input    wire                                  ADCPowdBVSupRx3,
            input    wire                                  ADCPowdBVInfRx0,
            input    wire                                  ADCPowdBVInfRx1,
            input    wire                                  ADCPowdBVInfRx2,
            input    wire                                  ADCPowdBVInfRx3,
            input    wire                                  ADCPowdBmSupRx0,
            input    wire                                  ADCPowdBmSupRx1,
            input    wire                                  ADCPowdBmSupRx2,
            input    wire                                  ADCPowdBmSupRx3,
            input    wire                                  ADCPowdBmInfRx0,
            input    wire                                  ADCPowdBmInfRx1,
            input    wire                                  ADCPowdBmInfRx2,
            input    wire                                  ADCPowdBmInfRx3,

            // From modem control
            input    wire                                  HTSTFStartEstimP,
            input    wire                                  HTSTFGainUpdateP,
            input    wire                                  RxEndTimingP,
            input    wire                                  LSIGValid,
            input    wire                                  HTSIGValid,
            input    wire                                  SFDFound,
            input    wire                                  DemodRun,
            
            // From registers
            input    wire                                  RifsEn,
            input    wire                                  RadarDet,
            input    wire                                  ModeA,
            input    wire                                  ModeB,
            input    wire              [3:0]               GPSetting,
            input    wire                                  Force20,
            input    wire                                  Force40,

            // From Radar
            input    wire                                  FomSing,      // FOM singuliar status
            input    wire                                  FomHigh,      // FOM high status
            input    wire                                  FomMed,       // FOM low status
            input    wire                                  FreqSing,     // Frequency singuliar status
            input    wire                                  FreqDC,       // Frequency DC status
            input    wire                                  FreqLow,      // Frequency low status
            input    wire                                  FreqHigh,     // Frequency high status
            input    wire                                  LengthLow,    // Timer length low status
            input    wire                                  LengthHigh,   // Timer length high status
            input    wire                                  Meas1Done,    // Measure 1 done status
            input    wire                                  Meas2Done,    // Measure 2 done status
            input    wire                                  Meas3Done,    // Measure 3 done status

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            // Status Register
            output    wire     [127:0]                     AGCStatusReg
            );


//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declaration
//////////////////////////////////////////////////////////////////////////////
localparam RESERVED = 1'b0; //Reserved Bit Value


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire                                   SatCount0;
wire                                   SatCount1;
wire                                   SatCount2;
wire                                   SatCount3;
wire                                   SatCount4;
wire                                   GenCount0;
wire                                   GenCount1;
wire                                   GenCount2;
wire                                   GenCount3;
wire                                   GenCount4;

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                                    DetSatRx0Reg;
reg                                    DetSatRx1Reg;
reg                                    DetSatRx2Reg;
reg                                    DetSatRx3Reg;
reg                                    DetCrossUpRx0Reg;
reg                                    DetCrossUpRx1Reg;
reg                                    DetCrossUpRx2Reg;
reg                                    DetCrossUpRx3Reg;
reg                                    DetCrossDownRx0Reg;
reg                                    DetCrossDownRx1Reg;
reg                                    DetCrossDownRx2Reg;
reg                                    DetCrossDownRx3Reg;
reg                                    DetRampUpRx0Reg;
reg                                    DetRampUpRx1Reg;
reg                                    DetRampUpRx2Reg;
reg                                    DetRampUpRx3Reg;
reg                                    DetRampDownRx0Reg;
reg                                    DetRampDownRx1Reg;
reg                                    DetRampDownRx2Reg;
reg                                    DetRampDownRx3Reg;
reg                                    ADCPowDisRx0Reg;
reg                                    ADCPowDisRx1Reg;
reg                                    ADCPowDisRx2Reg;
reg                                    ADCPowDisRx3Reg;
reg                                    TimeOutReg;
reg                                    RFInterfDoneReg;
reg                                    RxEndTimingReg;
reg                                    HTSTFStartEstimReg;
reg                                    HTSTFGainUpdateReg;
reg                                    SFDFoundReg;
reg                                    LSIGValidReg;
reg                                    HTSIGValidReg;
reg                                    NoGainUpdateReg;
reg                                    ExtDetectRx0Reg;
reg                                    ExtDetectRx1Reg;
reg                                    ExtDetectRx2Reg;
reg                                    ExtDetectRx3Reg;
reg                                    DSSSDetectReg;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// This module maintains the status of the various DSP blocks of the AGC. These
// values are used by the Transition/Event decoders. Values which are pulses at
// the input are latched until the FSM moves to a new state. This is required
// since the FSM can only check one transition per cycle.

assign AGCStatusReg[00]  =  1'b0;
assign AGCStatusReg[01]  =  1'b1;
assign AGCStatusReg[02]  =  DetSatRx0Reg;
assign AGCStatusReg[03]  =  DetSatRx1Reg;
assign AGCStatusReg[04]  =  DetSatRx2Reg;
assign AGCStatusReg[05]  =  DetSatRx3Reg;
assign AGCStatusReg[06]  =  SatCount0;
assign AGCStatusReg[07]  =  SatCount1;
assign AGCStatusReg[08]  =  SatCount2;
assign AGCStatusReg[09]  =  SatCount3;
assign AGCStatusReg[10]  =  SatCount4;
assign AGCStatusReg[11]  =  PlatDetRx0;
assign AGCStatusReg[12]  =  PlatDetRx1;
assign AGCStatusReg[13]  =  PlatDetRx2;
assign AGCStatusReg[14]  =  PlatDetRx3;
assign AGCStatusReg[15]  =  InBdPowSupRx0;
assign AGCStatusReg[16]  =  InBdPowSupRx1;
assign AGCStatusReg[17]  =  InBdPowSupRx2;
assign AGCStatusReg[18]  =  InBdPowSupRx3;
assign AGCStatusReg[19]  =  OFDMCCDiff;
assign AGCStatusReg[20]  =  OFDMACDiff;
assign AGCStatusReg[21]  =  BarkerCCDiff;
assign AGCStatusReg[22]  =  BarkerACDiff;
assign AGCStatusReg[23]  =  TimeOutReg;
assign AGCStatusReg[24]  =  RFInterfDoneReg;
assign AGCStatusReg[25]  =  DetCrossUpRx0Reg;
assign AGCStatusReg[26]  =  DetCrossUpRx1Reg;
assign AGCStatusReg[27]  =  DetCrossUpRx2Reg;
assign AGCStatusReg[28]  =  DetCrossUpRx3Reg;
assign AGCStatusReg[29]  =  DetCrossDownRx0Reg;
assign AGCStatusReg[30]  =  DetCrossDownRx1Reg;
assign AGCStatusReg[31]  =  DetCrossDownRx2Reg;
assign AGCStatusReg[32]  =  DetCrossDownRx3Reg;
assign AGCStatusReg[33]  =  DetRampUpRx0Reg;
assign AGCStatusReg[34]  =  DetRampUpRx1Reg;
assign AGCStatusReg[35]  =  DetRampUpRx2Reg;
assign AGCStatusReg[36]  =  DetRampUpRx3Reg;
assign AGCStatusReg[37]  =  DetRampDownRx0Reg;
assign AGCStatusReg[38]  =  DetRampDownRx1Reg;
assign AGCStatusReg[39]  =  DetRampDownRx2Reg;
assign AGCStatusReg[40]  =  DetRampDownRx3Reg;
assign AGCStatusReg[41]  =  ADCPowDisRx0Reg;
assign AGCStatusReg[42]  =  ADCPowDisRx1Reg;
assign AGCStatusReg[43]  =  ADCPowDisRx2Reg;
assign AGCStatusReg[44]  =  ADCPowDisRx3Reg;
assign AGCStatusReg[45]  =  InBdPowInfRx0;
assign AGCStatusReg[46]  =  InBdPowInfRx1;
assign AGCStatusReg[47]  =  InBdPowInfRx2;
assign AGCStatusReg[48]  =  InBdPowInfRx3;
assign AGCStatusReg[49]  =  GenCount0;
assign AGCStatusReg[50]  =  GenCount1;
assign AGCStatusReg[51]  =  GenCount2;
assign AGCStatusReg[52]  =  GenCount3;
assign AGCStatusReg[53]  =  GenCount4;
assign AGCStatusReg[54]  =  CmdCtrlFlag;
assign AGCStatusReg[55]  =  GPSetting[0];
assign AGCStatusReg[56]  =  SFDFoundReg;
assign AGCStatusReg[57]  =  RFGainCp2MaxRx0;
assign AGCStatusReg[58]  =  RFGainCp2MaxRx1;
assign AGCStatusReg[59]  =  RFGainCp2MaxRx2;
assign AGCStatusReg[60]  =  RFGainCp2MaxRx3;
assign AGCStatusReg[61]  =  RFGainCp2MinRx0;
assign AGCStatusReg[62]  =  RFGainCp2MinRx1;
assign AGCStatusReg[63]  =  RFGainCp2MinRx2;
assign AGCStatusReg[64]  =  RFGainCp2MinRx3;
assign AGCStatusReg[65]  =  RFGainCp2Min4SatRx0;
assign AGCStatusReg[66]  =  RFGainCp2Min4SatRx1;
assign AGCStatusReg[67]  =  RFGainCp2Min4SatRx2;
assign AGCStatusReg[68]  =  RFGainCp2Min4SatRx3;
assign AGCStatusReg[69]  =  HTSTFStartEstimReg | HTSTFStartEstimP;
assign AGCStatusReg[70]  =  RxEndTimingReg     | RxEndTimingP;
assign AGCStatusReg[71]  =  LSIGValidReg       | LSIGValid;
assign AGCStatusReg[72]  =  HTSIGValidReg      | HTSIGValid;
assign AGCStatusReg[73]  =  NoGainUpdateReg;
assign AGCStatusReg[74]  =  DSSSDetectReg;
assign AGCStatusReg[75]  =  DemodRun;
assign AGCStatusReg[76]  =  RESERVED;
assign AGCStatusReg[77]  =  RESERVED;
assign AGCStatusReg[78]  =  IdPowRx0;
assign AGCStatusReg[79]  =  IdPowRx1;
assign AGCStatusReg[80]  =  IdPowRx2;
assign AGCStatusReg[81]  =  IdPowRx3;
assign AGCStatusReg[82]  =  HTSTFGainUpdateReg | HTSTFGainUpdateP;
assign AGCStatusReg[83]  =  ExtDetectRx0Reg;
assign AGCStatusReg[84]  =  ExtDetectRx1Reg;
assign AGCStatusReg[85]  =  ExtDetectRx2Reg;
assign AGCStatusReg[86]  =  ExtDetectRx3Reg;
assign AGCStatusReg[87]  =  RifsEn;
assign AGCStatusReg[88]  =  RadarDet;
assign AGCStatusReg[89]  =  ModeA;
assign AGCStatusReg[90]  =  ModeB;
assign AGCStatusReg[91]  =  Force20;
assign AGCStatusReg[92]  =  Force40;
assign AGCStatusReg[93]  =  GPSetting[1];
assign AGCStatusReg[94]  =  FomHigh;
assign AGCStatusReg[95]  =  FomMed;
assign AGCStatusReg[96]  =  FomSing;
assign AGCStatusReg[97]  =  FreqHigh;
assign AGCStatusReg[98]  =  FreqLow;
assign AGCStatusReg[99]  =  FreqSing;
assign AGCStatusReg[100] =  FreqDC;
assign AGCStatusReg[101] =  LengthHigh;
assign AGCStatusReg[102] =  LengthLow;
assign AGCStatusReg[103] =  Meas1Done;
assign AGCStatusReg[104] =  Meas2Done;
assign AGCStatusReg[105] =  Meas3Done;
assign AGCStatusReg[106] =  ADCPowdBVSupRx0;
assign AGCStatusReg[107] =  ADCPowdBVSupRx1;
assign AGCStatusReg[108] =  ADCPowdBVSupRx2;
assign AGCStatusReg[109] =  ADCPowdBVSupRx3;
assign AGCStatusReg[110] =  ADCPowdBVInfRx0;
assign AGCStatusReg[111] =  ADCPowdBVInfRx1;
assign AGCStatusReg[112] =  ADCPowdBVInfRx2;
assign AGCStatusReg[113] =  ADCPowdBVInfRx3;
assign AGCStatusReg[114] =  ADCPowdBmSupRx0;
assign AGCStatusReg[115] =  ADCPowdBmSupRx1;
assign AGCStatusReg[116] =  ADCPowdBmSupRx2;
assign AGCStatusReg[117] =  ADCPowdBmSupRx3;
assign AGCStatusReg[118] =  ADCPowdBmInfRx0;
assign AGCStatusReg[119] =  ADCPowdBmInfRx1;
assign AGCStatusReg[120] =  ADCPowdBmInfRx2;
assign AGCStatusReg[121] =  ADCPowdBmInfRx3;

assign AGCStatusReg[127:122]  = {6{RESERVED}};

// Retain pulse signals until end of state
// Priority to pulse instead of AGC clear else
// pulse can be missed
always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetSatRx0Reg <= 1'b0;
   else if (SatDetectRx0 == 1'b1)
      DetSatRx0Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetSatRx0Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetSatRx1Reg <= 1'b0;
   else if (SatDetectRx1 == 1'b1)
      DetSatRx1Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetSatRx1Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetSatRx2Reg <= 1'b0;
   else if (SatDetectRx2 == 1'b1)
      DetSatRx2Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetSatRx2Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetSatRx3Reg <= 1'b0;
   else if (SatDetectRx3 == 1'b1)
      DetSatRx3Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetSatRx3Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetCrossUpRx0Reg <= 1'b0;
   else if (DetCrossUpRx0 == 1'b1)
      DetCrossUpRx0Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetCrossUpRx0Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetCrossUpRx1Reg <= 1'b0;
   else if (DetCrossUpRx1 == 1'b1)
      DetCrossUpRx1Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetCrossUpRx1Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetCrossUpRx2Reg <= 1'b0;
   else if (DetCrossUpRx2 == 1'b1)
      DetCrossUpRx2Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetCrossUpRx2Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetCrossUpRx3Reg <= 1'b0;
   else if (DetCrossUpRx3 == 1'b1)
      DetCrossUpRx3Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetCrossUpRx3Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetCrossDownRx0Reg <= 1'b0;
   else if (DetCrossDownRx0 == 1'b1)
      DetCrossDownRx0Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetCrossDownRx0Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetCrossDownRx1Reg <= 1'b0;
   else if (DetCrossDownRx1 == 1'b1)
      DetCrossDownRx1Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetCrossDownRx1Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetCrossDownRx2Reg <= 1'b0;
   else if (DetCrossDownRx2 == 1'b1)
      DetCrossDownRx2Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetCrossDownRx2Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetCrossDownRx3Reg <= 1'b0;
   else if (DetCrossDownRx3 == 1'b1)
      DetCrossDownRx3Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetCrossDownRx3Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetRampUpRx0Reg <= 1'b0;
   else if (DetRampUpRx0 == 1'b1)
      DetRampUpRx0Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetRampUpRx0Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetRampUpRx1Reg <= 1'b0;
   else if (DetRampUpRx1 == 1'b1)
      DetRampUpRx1Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetRampUpRx1Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetRampUpRx2Reg <= 1'b0;
   else if (DetRampUpRx2 == 1'b1)
      DetRampUpRx2Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetRampUpRx2Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetRampUpRx3Reg <= 1'b0;
   else if (DetRampUpRx3 == 1'b1)
      DetRampUpRx3Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetRampUpRx3Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetRampDownRx0Reg <= 1'b0;
   else if (DetRampDownRx0 == 1'b1)
      DetRampDownRx0Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetRampDownRx0Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetRampDownRx1Reg <= 1'b0;
   else if (DetRampDownRx1 == 1'b1)
      DetRampDownRx1Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetRampDownRx1Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetRampDownRx2Reg <= 1'b0;
   else if (DetRampDownRx2 == 1'b1)
      DetRampDownRx2Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetRampDownRx2Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DetRampDownRx3Reg <= 1'b0;
   else if (DetRampDownRx3 == 1'b1)
      DetRampDownRx3Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      DetRampDownRx3Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      ADCPowDisRx0Reg <= 1'b0;
   else if (ADCPowDisRx0 == 1'b1)
      ADCPowDisRx0Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      ADCPowDisRx0Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      ADCPowDisRx1Reg <= 1'b0;
   else if (ADCPowDisRx1 == 1'b1)
      ADCPowDisRx1Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      ADCPowDisRx1Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      ADCPowDisRx2Reg <= 1'b0;
   else if (ADCPowDisRx2 == 1'b1)
      ADCPowDisRx2Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      ADCPowDisRx2Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      ADCPowDisRx3Reg <= 1'b0;
   else if (ADCPowDisRx3 == 1'b1)
      ADCPowDisRx3Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      ADCPowDisRx3Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      TimeOutReg <= 1'b0;
   else if (TimeOut == 1'b1)
      TimeOutReg <= 1'b1;
   else if (AGCClear == 1'b1)
      TimeOutReg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      RFInterfDoneReg <= 1'b0;
   else if (RFGainSetDoneP == 1'b1)
      RFInterfDoneReg <= 1'b1;
   else if (AGCClear == 1'b1)
      RFInterfDoneReg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      RxEndTimingReg <= 1'b0;
   else if (RxEndTimingP == 1'b1)
      RxEndTimingReg <= 1'b1;
   else if (AGCClear == 1'b1)
      RxEndTimingReg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      HTSTFStartEstimReg <= 1'b0;
   else if (HTSTFStartEstimP == 1'b1)
      HTSTFStartEstimReg <= 1'b1;
   else if (AGCClear == 1'b1)
      HTSTFStartEstimReg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      HTSTFGainUpdateReg <= 1'b0;
   else if (HTSTFGainUpdateP == 1'b1)
      HTSTFGainUpdateReg <= 1'b1;
   else if (AGCClear == 1'b1)
      HTSTFGainUpdateReg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      SFDFoundReg <= 1'b0;
   else if (SFDFound == 1'b1)
      SFDFoundReg <= 1'b1;
   else if (AGCClear == 1'b1)
      SFDFoundReg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      LSIGValidReg <= 1'b0;
   else if (LSIGValid == 1'b1)
      LSIGValidReg <= 1'b1;
   else if (AGCClear == 1'b1)
      LSIGValidReg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      HTSIGValidReg <= 1'b0;
   else if (HTSIGValid == 1'b1)
      HTSIGValidReg <= 1'b1;
   else if (AGCClear == 1'b1)
      HTSIGValidReg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      NoGainUpdateReg <= 1'b0;
   else if (NoGainUpdateP == 1'b1)
      NoGainUpdateReg <= 1'b1;
   else if (AGCClear == 1'b1)
      NoGainUpdateReg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      DSSSDetectReg <= 1'b0;
   else if (DSSSDetect == 1'b1)
      DSSSDetectReg <= 1'b1;
   else if (AGCClear == 1'b1)
      DSSSDetectReg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      ExtDetectRx0Reg <= 1'b0;
   else if (ExtDetectRx0 == 1'b1)
      ExtDetectRx0Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      ExtDetectRx0Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      ExtDetectRx1Reg <= 1'b0;
   else if (ExtDetectRx1 == 1'b1)
      ExtDetectRx1Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      ExtDetectRx1Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      ExtDetectRx2Reg <= 1'b0;
   else if (ExtDetectRx2 == 1'b1)
      ExtDetectRx2Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      ExtDetectRx2Reg <= 1'b0;

always @ (posedge AGCClk or negedge nAGCRst)
   if (nAGCRst == 1'b0)
      ExtDetectRx3Reg <= 1'b0;
   else if (ExtDetectRx3 == 1'b1)
      ExtDetectRx3Reg <= 1'b1;
   else if (AGCClear == 1'b1)
      ExtDetectRx3Reg <= 1'b0;


// Decode SatCount
assign SatCount0 = (SatCount == 3'd0) ? 1'b1 : 1'b0;
assign SatCount1 = (SatCount == 3'd1) ? 1'b1 : 1'b0;
assign SatCount2 = (SatCount == 3'd2) ? 1'b1 : 1'b0;
assign SatCount3 = (SatCount == 3'd3) ? 1'b1 : 1'b0;
assign SatCount4 = (SatCount >= 3'd4) ? 1'b1 : 1'b0;

// Decode GenCount
assign GenCount0 = (GenCount == 3'd0) ? 1'b1 : 1'b0;
assign GenCount1 = (GenCount == 3'd1) ? 1'b1 : 1'b0;
assign GenCount2 = (GenCount == 3'd2) ? 1'b1 : 1'b0;
assign GenCount3 = (GenCount == 3'd3) ? 1'b1 : 1'b0;
assign GenCount4 = (GenCount >= 3'd4) ? 1'b1 : 1'b0;

endmodule //AGCStatusRegister

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
