////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 10205 $
// $Date: 2013-09-23 09:59:10 +0200 (Mon, 23 Sep 2013) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Carrier Sense Flags Register Block
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/CSFlagsReg.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module CSFlagsReg (
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nAGCRst,   //Active Low Reset
            input    wire                                  AGCClk,    //AGC Clock

            //Controls
            input    wire              [7:0]               AGCCommand,  //Command from FSM Core
            input    wire              [23:0]              AGCParam,    //Command Parameter
            input    wire                                  AGCCmdValid, //AGC Command Valid

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   wire                                  CSFlagAHigh, //CA_DET_HIGH Flag
            output   wire                                  CSFlagALow,  //CA_DET_LOW  Flag
            output   wire                                  CSFlagBHigh, //CB_DET_HIGH Flag
            output   wire                                  CSFlagBLow,  //CB_DET_LOW  Flag
            output   reg                                   CSFlagValidP, //Flags Updated
            output   wire      [1:0]                       CSFlagNum    //Flags Number
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers & Wires Declarations
//////////////////////////////////////////////////////////////////////////////
reg                                    CSFlagAHighInt;
reg                                    CSFlagALowInt;
reg                                    CSFlagBHighInt;
reg                                    CSFlagBLowInt;
reg                [1:0]               CSFlagNumInt;

wire               [23:0]              AGCParam_aux;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This module registers the CS Flags as indicated by the AGC Commands.
//Whenever the Flags are updated, it asserts the CSFlagValidP pulse. It also
//indicates the Flag Number.

//Register the Flags
always @ (posedge AGCClk or negedge nAGCRst)
   begin: FlagInt_Blk
      if (nAGCRst == 1'b0) begin
         CSFlagAHighInt <= 1'b0;
         CSFlagALowInt  <= 1'b0;
         CSFlagBHighInt <= 1'b0;
         CSFlagBLowInt  <= 1'b0;
         CSFlagValidP   <= 1'b0;
         CSFlagNumInt   <= 2'b0;
      end
      else if ((AGCCommand == 8'd1) && (AGCCmdValid == 1'b1)) begin
         //Reset Flags
         CSFlagAHighInt <= 1'b0;
         CSFlagALowInt  <= 1'b0;
         CSFlagBHighInt <= 1'b0;
         CSFlagBLowInt  <= 1'b0;
         CSFlagValidP   <= 1'b0;
         CSFlagNumInt   <= 2'b0;
      end
      else if (AGCCommand == 8'd41 && AGCCmdValid == 1'b1) begin
         //Update OFDM Flags
         CSFlagBHighInt <= AGCParam[17];
         CSFlagBLowInt  <= AGCParam[16];
         CSFlagAHighInt <= AGCParam[9];
         CSFlagALowInt  <= AGCParam[8];
         CSFlagNumInt   <= AGCParam[1:0];
         CSFlagValidP   <= 1'b1;
      end
      else begin
         //Generate pulse
         CSFlagValidP   <= 1'b0;
      end

   end //FlagInt_Blk

//
assign AGCParam_aux = AGCParam; // To Avoid Lint Warning
//

//Outputs
assign CSFlagAHigh = CSFlagAHighInt;
assign CSFlagALow  = CSFlagALowInt;
assign CSFlagBHigh = CSFlagBHighInt;
assign CSFlagBLow  = CSFlagBLowInt;
assign CSFlagNum   = CSFlagNumInt;

endmodule //CSFlagsReg

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
