////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 10205 $
// $Date: 2013-09-23 09:59:10 +0200 (Mon, 23 Sep 2013) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : AGC command Flag Register Block
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/JammerDetReg.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module CmdCtrlFlagReg (
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nAGCRst,   //Active Low Reset
            input    wire                                  AGCClk,    //AGC Clock

            //Controls
            input    wire              [7:0]               AGCCommand,  //Command from FSM Core
            input    wire                                  AGCCmdValid, //AGC Command Valid

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   reg                                   CmdCtrlFlag //Command Flag
            );


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This module registers the Command Flag as indicated by the AGC Commands.

//Register the Flag
always @ (posedge AGCClk or negedge nAGCRst)
   begin: FlagInt_Blk
      if (nAGCRst == 1'b0) begin
         CmdCtrlFlag <= 1'b0;
      end
      else if ((AGCCommand == 8'd1) && (AGCCmdValid == 1'b1)) begin
         //Reset Flag
         CmdCtrlFlag <= 1'b0;
      end
      else if ((AGCCommand == 8'd37) && (AGCCmdValid == 1'b1)) begin
         //Set Flag
         CmdCtrlFlag <= 1'b1;
      end
      else if ((AGCCommand == 8'd38) && (AGCCmdValid == 1'b1)) begin
         //Reset Flag
         CmdCtrlFlag <= 1'b0;
      end
   end //FlagInt_Blk

endmodule //CmdCtrlFlagReg

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
