//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 25524 $
// $Date: 2016-03-30 19:11:02 +0200 (Wed, 30 Mar 2016) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : DSSS detector
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MDMCOMMON/RIUCORE/AGC/AGCFSM/verilog/rtl/DSSSDet.v $
//
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module DSSSDet
(
  ///////////////////////////////////////////////
  // Inputs
  ///////////////////////////////////////////////
  // Clock and reset
  input  wire        nAGCRst,                  // Active Low Reset
  input  wire        AGCClk,                   // AGC Clock

  // Control
  input  wire        DSSSDetEn,                // Block enable from FSM Core
  input  wire  [6:0] DSSSContCCThr,            // DSSS CC Threshold

  // Input data
  input  wire [21:0] DsssContCCAccSum,         // DSSS barker correlation
  input  wire [21:0] RefLevDsssCont,           // DSSS level estimation
  input  wire        RefLevDsssContValid,      // DSSS level estimation valid

  ///////////////////////////////////////////////
  // Outputs
  ///////////////////////////////////////////////
  // DSSS detected
  output wire        DSSSDetect                // DSSS vs Noise (Cross)
  );

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////

  // DSSS barker correlation
  reg  [21:0] DsssContCCAccSum_q;

  // DSSS level estimation DsssContCCMultiplied by Threshold
  wire [23:0] RefLevDsssContw_d;
  reg  [23:0] RefLevDsssContw_q;

  reg         DSSSDetect_q;
  
  wire [28:0] DsssContCCMult;
  wire [23:0] RefLevDsssContw_rnd;

  wire        DSSSDetect_d;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  // All DFF 
  always @ (posedge AGCClk or negedge nAGCRst)
  begin
    if (nAGCRst == 1'b0) begin
      DSSSDetect_q       <= 1'b0;
      RefLevDsssContw_q  <= 24'b0;
      DsssContCCAccSum_q <= 22'b0;
    end
    else if (!DSSSDetEn) begin
      DSSSDetect_q       <= 1'b0;
      RefLevDsssContw_q  <= 24'b0;
      DsssContCCAccSum_q <= 22'b0;
    end
    else begin
      DSSSDetect_q       <= DSSSDetect_d;
      if (RefLevDsssContValid) begin
        RefLevDsssContw_q  <= RefLevDsssContw_d;
        DsssContCCAccSum_q <= DsssContCCAccSum;
      end
    end
  end

  //          29u       =      22u       *            7u
  assign DsssContCCMult = RefLevDsssCont * {15'b0,DSSSContCCThr};

  // RND(RefLevDsssCont * reg_cca_thr_dsss, 5)
  USgnRound # (
    .INPUT_WIDTH(29),
    .OUTPUT_WIDTH(24)
    )
    u_DsssContCCMultRound (
      .InputData(DsssContCCMult),
      .RoundData(RefLevDsssContw_rnd)
      );
  
  // RefLevDsssContw combinational
  assign RefLevDsssContw_d = RefLevDsssContw_rnd[23:0];

  // Comparator DsssContCCAccSum > RefLevDsssContw combinational
  assign DSSSDetect_d = ({2'b0,DsssContCCAccSum_q} > RefLevDsssContw_q) ? 1'b1 : 1'b0;
  
  // Output assignment
  assign DSSSDetect = DSSSDetect_q & DSSSDetEn;
 
endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////

`default_nettype wire
