////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 11132 $
// $Date: 2013-10-25 19:10:36 +0200 (Fri, 25 Oct 2013) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Detection Threshold Register Block
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/DetectionThrReg.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module DetectionThrReg (
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nAGCRst,   //Active Low Reset
            input    wire                                  AGCClk,    //AGC Clock

            //Controls
            input    wire              [7:0]               AGCCommand,  //Command from FSM Core
            input    wire              [23:0]              AGCParam,    //Command Parameter
            input    wire                                  AGCCmdValid, //AGC Command Valid

            //Config Registers
            input    wire   signed     [7:0]               RegDetRampUp, //Ramp Up Detect Value in qdB
            input    wire   signed     [7:0]               RegDetRampDown,//Ramp Down Detect Value in qdB
            input    wire   signed     [9:0]               RegDetRiseThrqdBm,  //Threshold Rise Detection in qdBm
            input    wire   signed     [9:0]               RegDetFallThrqdBm,  //Threshold Fall Detection in qdBm
            input    wire   signed     [6:0]               RegADCPowDisThrdBV, //Threshold ADC Pow Disappearance in dBV

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   reg    signed     [7:0]               DetThrRampUp,  //Ramp Up Threshold Value in qdB
            output   reg    signed     [7:0]               DetThrRampDown,//Ramp Down Threshold Value in qdB

            output   reg    signed     [12:0]              DetThrCrossUp,  //Cross Up Threshold Value in qdBm
            output   reg    signed     [12:0]              DetThrCrossDown,//Cross Down Threshold Value in qdBm

            output   reg    signed     [11:0]              ADCPowDisThr    //ADC disappearance Threshold Value in qdBV
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers & Wires Declarations
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This module registers the Thresholds as indicated by the AGC Commands.

//Register the Detector Thresholds
always @ (posedge AGCClk or negedge nAGCRst)
   begin: ThrInt_Blk
      if (nAGCRst == 1'b0) begin
         DetThrRampUp    <= 8'sd16;
         DetThrRampDown  <= 8'sd32;
         DetThrCrossUp   <= -13'sd376;
         DetThrCrossDown <= -13'sd376;
         ADCPowDisThr    <= -12'sd176;
      end
      // During synchronous reset set value from register
      else if (AGCCommand == 8'd1 && AGCCmdValid) begin
         DetThrRampUp    <= RegDetRampUp;
         DetThrRampDown  <= RegDetRampDown;
         DetThrCrossUp   <= $signed({{3{RegDetRiseThrqdBm[9]}}, RegDetRiseThrqdBm});
         DetThrCrossDown <= $signed({{3{RegDetFallThrqdBm[9]}}, RegDetFallThrqdBm});
         ADCPowDisThr    <= $signed({{3{RegADCPowDisThrdBV[6]}}, RegADCPowDisThrdBV,2'b0});// From register, value is in dBV
      end
      // Update detection threshold
      else if (AGCCommand == 8'd34 && AGCCmdValid) begin
         DetThrRampUp    <= AGCParam[15:8];
         DetThrCrossUp   <= {{3{AGCParam[7]}},AGCParam[7:0],2'b0}; // From AGC FSM, value is in dBm
      end
      // Update disappearance threshold
      else if (AGCCommand == 8'd35 && AGCCmdValid) begin
         ADCPowDisThr    <= $signed({{2{AGCParam[23]}},AGCParam[23:16],2'b0}); // From AGC FSM, value is in dBV
         DetThrRampDown  <= $signed(AGCParam[15:8]);
         DetThrCrossDown <= $signed({{3{AGCParam[7]}},AGCParam[7:0],2'b0});    // From AGC FSM, value is in dBm
      end
   end //ThrInt_Blk


endmodule //DetectionThrReg

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
