////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 11129 $
// $Date: 2013-10-25 19:02:17 +0200 (Fri, 25 Oct 2013) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Energy comparator Module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/EnergyComp.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module EnergyComp #(parameter DBMPOW_WIDTH = 13, // Data width of dBm power
                    parameter DBVPOW_WIDTH = 12  // Data width of dBV power
                   )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            // Clock and Reset
            input    wire                                  nAGCRst,   //Active Low Reset
            input    wire                                  AGCClk,    //AGC Clock

            // Registers
            input    wire              [7:0]               IdInBdPowGapDnqdBm,//InBand Power Gap Down
            input    wire              [7:0]               IdInBdPowGapUpqdBm,//InBand Power Gap Up
            input    wire              [7:0]               InBdPowInfThrdBm, //InBand Power in dBm Inferior Threshold
            input    wire              [7:0]               InBdPowSupThrdBm, //InBand Power in dBm Superior Threshold
            input    wire              [7:0]               ADCPowInfThrdBV, //ADC Power in dBV Inferior Threshold
            input    wire              [7:0]               ADCPowSupThrdBV, //ADC Power in dBV Superior Threshold
            input    wire              [7:0]               ADCPowInfThrdBm, //ADC Power in dBm Inferior Threshold
            input    wire              [7:0]               ADCPowSupThrdBm, //ADC Power in dBm Superior Threshold

            // Control
            input    wire                                  IdPowEn,   //Enable Identical Power Detection for RIFS

            // ADC Power Estimate in dBVrms
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx0, //ADC Power in Rx Chain 0
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx1, //ADC Power in Rx Chain 1
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx2, //ADC Power in Rx Chain 2
            input    wire   signed     [DBVPOW_WIDTH-1:0]  ADCPowdBVRx3, //ADC Power in Rx Chain 3

            // ADC Sat Power Estimate in dBm
            input    wire   signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx0, //ADC Sat Power in Rx Chain 0
            input    wire   signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx1, //ADC Sat Power in Rx Chain 1
            input    wire   signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx2, //ADC Sat Power in Rx Chain 2
            input    wire   signed     [DBMPOW_WIDTH-1:0]  ADCSatPowdBmRx3, //ADC Sat Power in Rx Chain 3

            // In Band Power in dBm for 20 MHz packet
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx0, //In Band Power in Rx Chain 0
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx1, //In Band Power in Rx Chain 1
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx2, //In Band Power in Rx Chain 2
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx3, //In Band Power in Rx Chain 3
            input    wire                                  InBdPowValid,    //Qualifies InBdPowdBm

            // In Band Power Threshold in qdBm from DSP Dynamic Configuration Block
            input    wire   signed     [DBMPOW_WIDTH-1:0]  IdThrqdBmRx0,
            input    wire   signed     [DBMPOW_WIDTH-1:0]  IdThrqdBmRx1,
            input    wire   signed     [DBMPOW_WIDTH-1:0]  IdThrqdBmRx2,
            input    wire   signed     [DBMPOW_WIDTH-1:0]  IdThrqdBmRx3,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //To AGC Core FSM
            output   reg                                   InBdPowSupRx0, //InBand Power Sup Threshold comparator in Rx Chain 0
            output   reg                                   InBdPowSupRx1, //InBand Power Sup Threshold comparator in Rx Chain 1
            output   reg                                   InBdPowSupRx2, //InBand Power Sup Threshold comparator in Rx Chain 2
            output   reg                                   InBdPowSupRx3, //InBand Power Sup Threshold comparator in Rx Chain 3
            output   reg                                   InBdPowInfRx0, //InBand Power Inf Threshold comparator in Rx Chain 0
            output   reg                                   InBdPowInfRx1, //InBand Power Inf Threshold comparator in Rx Chain 1
            output   reg                                   InBdPowInfRx2, //InBand Power Inf Threshold comparator in Rx Chain 2
            output   reg                                   InBdPowInfRx3, //InBand Power Inf Threshold comparator in Rx Chain 3
            output   reg                                   IdPowRx0,      //Identical InBand Power Detection in Rx Chain 0
            output   reg                                   IdPowRx1,      //Identical InBand Power Detection in Rx Chain 1
            output   reg                                   IdPowRx2,      //Identical InBand Power Detection in Rx Chain 2
            output   reg                                   IdPowRx3,      //Identical InBand Power Detection in Rx Chain 3
            //
            output   reg                                   ADCPowdBVSupRx0,  //ADC Power in dBV Sup Threshold comparator in Rx Chain 0
            output   reg                                   ADCPowdBVSupRx1,  //ADC Power in dBV Sup Threshold comparator in Rx Chain 1
            output   reg                                   ADCPowdBVSupRx2,  //ADC Power in dBV Sup Threshold comparator in Rx Chain 2
            output   reg                                   ADCPowdBVSupRx3,  //ADC Power in dBV Sup Threshold comparator in Rx Chain 3
            output   reg                                   ADCPowdBVInfRx0,  //ADC Power in dBV Inf Threshold comparator in Rx Chain 0
            output   reg                                   ADCPowdBVInfRx1,  //ADC Power in dBV Inf Threshold comparator in Rx Chain 1
            output   reg                                   ADCPowdBVInfRx2,  //ADC Power in dBV Inf Threshold comparator in Rx Chain 2
            output   reg                                   ADCPowdBVInfRx3,  //ADC Power in dBV Inf Threshold comparator in Rx Chain 3
            output   reg                                   ADCPowdBmSupRx0,  //ADC Power in dBm Sup Threshold comparator in Rx Chain 0
            output   reg                                   ADCPowdBmSupRx1,  //ADC Power in dBm Sup Threshold comparator in Rx Chain 1
            output   reg                                   ADCPowdBmSupRx2,  //ADC Power in dBm Sup Threshold comparator in Rx Chain 2
            output   reg                                   ADCPowdBmSupRx3,  //ADC Power in dBm Sup Threshold comparator in Rx Chain 3
            output   reg                                   ADCPowdBmInfRx0,  //ADC Power in dBm Inf Threshold comparator in Rx Chain 0
            output   reg                                   ADCPowdBmInfRx1,  //ADC Power in dBm Inf Threshold comparator in Rx Chain 1
            output   reg                                   ADCPowdBmInfRx2,  //ADC Power in dBm Inf Threshold comparator in Rx Chain 2
            output   reg                                   ADCPowdBmInfRx3   //ADC Power in dBm Inf Threshold comparator in Rx Chain 3
            );


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// This module computes the power comparators for AGC status registers and RIFS detection

///////////////////////////////////
// In Band Power comparators
///////////////////////////////////

always @ (posedge AGCClk or negedge nAGCRst)
   begin: InBdPowSupRx0_Blk
      if (nAGCRst == 1'b0)
         InBdPowSupRx0 <= 1'b0;
      else if ((InBdPowValid == 1'b1) &&
               ($signed(InBd20PowdBmRx0[DBMPOW_WIDTH-1:2]) > $signed({{3{InBdPowSupThrdBm[7]}},InBdPowSupThrdBm})))
         InBdPowSupRx0 <= 1'b1;
      else
         InBdPowSupRx0 <= 1'b0;
   end //InBdPowSupRx0_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: InBdPowInfRx0_Blk
      if (nAGCRst == 1'b0)
         InBdPowInfRx0 <= 1'b0;
      else if ((InBdPowValid == 1'b1) &&
               ($signed(InBd20PowdBmRx0[DBMPOW_WIDTH-1:2]) < $signed({{3{InBdPowInfThrdBm[7]}},InBdPowInfThrdBm})))
         InBdPowInfRx0 <= 1'b1;
      else
         InBdPowInfRx0 <= 1'b0;
   end //InBdPowInfRx0_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: IdPowRx0_Blk
      if (nAGCRst == 1'b0)
         IdPowRx0 <= 1'b0;
      else if ((InBdPowValid == 1'b1) && (IdPowEn == 1'b1) &&
               ($signed(InBd20PowdBmRx0) <= $signed(IdThrqdBmRx0 + {{DBMPOW_WIDTH-8{1'b0}},IdInBdPowGapUpqdBm})) &&
               ($signed(InBd20PowdBmRx0) >= $signed(IdThrqdBmRx0 - {{DBMPOW_WIDTH-8{1'b0}},IdInBdPowGapDnqdBm})))
         IdPowRx0 <= 1'b1;
      else
         IdPowRx0 <= 1'b0;
   end //IdPowRx0_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: InBdPowSupRx1_Blk
      if (nAGCRst == 1'b0)
         InBdPowSupRx1 <= 1'b0;
      else if ((InBdPowValid == 1'b1) &&
               ($signed(InBd20PowdBmRx1[DBMPOW_WIDTH-1:2]) > $signed({{3{InBdPowSupThrdBm[7]}},InBdPowSupThrdBm})))
         InBdPowSupRx1 <= 1'b1;
      else
         InBdPowSupRx1 <= 1'b0;
   end //InBdPowSupRx1_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: InBdPowInfRx1_Blk
      if (nAGCRst == 1'b0)
         InBdPowInfRx1 <= 1'b0;
      else if ((InBdPowValid == 1'b1) &&
               ($signed(InBd20PowdBmRx1[DBMPOW_WIDTH-1:2]) < $signed({{3{InBdPowInfThrdBm[7]}},InBdPowInfThrdBm})))
         InBdPowInfRx1 <= 1'b1;
      else
         InBdPowInfRx1 <= 1'b0;
   end //InBdPowInfRx1_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: IdPowRx1_Blk
      if (nAGCRst == 1'b0)
         IdPowRx1 <= 1'b0;
      else if ((InBdPowValid == 1'b1) && (IdPowEn == 1'b1) &&
               ($signed(InBd20PowdBmRx1) <= $signed(IdThrqdBmRx1 + {{DBMPOW_WIDTH-8{1'b0}},IdInBdPowGapUpqdBm})) &&
               ($signed(InBd20PowdBmRx1) >= $signed(IdThrqdBmRx1 - {{DBMPOW_WIDTH-8{1'b0}},IdInBdPowGapDnqdBm})))
         IdPowRx1 <= 1'b1;
      else
         IdPowRx1 <= 1'b0;
   end //IdPowRx1_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: InBdPowSupRx2_Blk
      if (nAGCRst == 1'b0)
         InBdPowSupRx2 <= 1'b0;
      else if ((InBdPowValid == 1'b1) &&
               ($signed(InBd20PowdBmRx2[DBMPOW_WIDTH-1:2]) > $signed({{3{InBdPowSupThrdBm[7]}},InBdPowSupThrdBm})))
         InBdPowSupRx2 <= 1'b1;
      else
         InBdPowSupRx2 <= 1'b0;
   end //InBdPowSupRx2_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: InBdPowInfRx2_Blk
      if (nAGCRst == 1'b0)
         InBdPowInfRx2 <= 1'b0;
      else if ((InBdPowValid == 1'b1) &&
               ($signed(InBd20PowdBmRx2[DBMPOW_WIDTH-1:2]) < $signed({{3{InBdPowInfThrdBm[7]}},InBdPowInfThrdBm})))
         InBdPowInfRx2 <= 1'b1;
      else
         InBdPowInfRx2 <= 1'b0;
   end //InBdPowInfRx2_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: IdPowRx2_Blk
      if (nAGCRst == 1'b0)
         IdPowRx2 <= 1'b0;
      else if ((InBdPowValid == 1'b1) && (IdPowEn == 1'b1) &&
               ($signed(InBd20PowdBmRx2) <= $signed(IdThrqdBmRx2 + {{DBMPOW_WIDTH-8{1'b0}},IdInBdPowGapUpqdBm})) &&
               ($signed(InBd20PowdBmRx2) >= $signed(IdThrqdBmRx2 - {{DBMPOW_WIDTH-8{1'b0}},IdInBdPowGapDnqdBm})))
         IdPowRx2 <= 1'b1;
      else
         IdPowRx2 <= 1'b0;
   end //IdPowRx2_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: InBdPowSupRx3_Blk
      if (nAGCRst == 1'b0)
         InBdPowSupRx3 <= 1'b0;
      else if ((InBdPowValid == 1'b1) &&
               ($signed(InBd20PowdBmRx3[DBMPOW_WIDTH-1:2]) > $signed({{3{InBdPowSupThrdBm[7]}},InBdPowSupThrdBm})))
         InBdPowSupRx3 <= 1'b1;
      else
         InBdPowSupRx3 <= 1'b0;
   end //InBdPowSupRx3_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: InBdPowInfRx3_Blk
      if (nAGCRst == 1'b0)
         InBdPowInfRx3 <= 1'b0;
      else if ((InBdPowValid == 1'b1) &&
               ($signed(InBd20PowdBmRx3[DBMPOW_WIDTH-1:2]) < $signed({{3{InBdPowInfThrdBm[7]}},InBdPowInfThrdBm})))
         InBdPowInfRx3 <= 1'b1;
      else
         InBdPowInfRx3 <= 1'b0;
   end //InBdPowInfRx3_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: IdPowRx3_Blk
      if (nAGCRst == 1'b0)
         IdPowRx3 <= 1'b0;
      else if ((InBdPowValid == 1'b1) && (IdPowEn == 1'b1) &&
               ($signed(InBd20PowdBmRx3) <= $signed(IdThrqdBmRx3 + {{DBMPOW_WIDTH-8{1'b0}},IdInBdPowGapUpqdBm})) &&
               ($signed(InBd20PowdBmRx3) >= $signed(IdThrqdBmRx3 - {{DBMPOW_WIDTH-8{1'b0}},IdInBdPowGapDnqdBm})))
         IdPowRx3 <= 1'b1;
      else
         IdPowRx3 <= 1'b0;
   end //IdPowRx3_Blk

///////////////////////////////////
// ADC Power dBV comparators
///////////////////////////////////

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBVSupRx0_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBVSupRx0 <= 1'b0;
      else if ($signed(ADCPowdBVRx0[DBVPOW_WIDTH-1:2]) > $signed({{2{ADCPowSupThrdBV[7]}},ADCPowSupThrdBV}))
         ADCPowdBVSupRx0 <= 1'b1;
      else
         ADCPowdBVSupRx0 <= 1'b0;
   end //ADCPowdBVSupRx0_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBVInfRx0_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBVInfRx0 <= 1'b0;
      else if ($signed(ADCPowdBVRx0[DBVPOW_WIDTH-1:2]) < $signed({{2{ADCPowInfThrdBV[7]}},ADCPowInfThrdBV}))
         ADCPowdBVInfRx0 <= 1'b1;
      else
         ADCPowdBVInfRx0 <= 1'b0;
   end //ADCPowdBVInfRx0_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBVSupRx1_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBVSupRx1 <= 1'b0;
      else if ($signed(ADCPowdBVRx1[DBVPOW_WIDTH-1:2]) > $signed({{2{ADCPowSupThrdBV[7]}},ADCPowSupThrdBV}))
         ADCPowdBVSupRx1 <= 1'b1;
      else
         ADCPowdBVSupRx1 <= 1'b0;
   end //ADCPowdBVSupRx1_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBVInfRx1_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBVInfRx1 <= 1'b0;
      else if ($signed(ADCPowdBVRx1[DBVPOW_WIDTH-1:2]) < $signed({{2{ADCPowInfThrdBV[7]}},ADCPowInfThrdBV}))
         ADCPowdBVInfRx1 <= 1'b1;
      else
         ADCPowdBVInfRx1 <= 1'b0;
   end //ADCPowdBVInfRx1_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBVSupRx2_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBVSupRx2 <= 1'b0;
      else if ($signed(ADCPowdBVRx2[DBVPOW_WIDTH-1:2]) > $signed({{2{ADCPowSupThrdBV[7]}},ADCPowSupThrdBV}))
         ADCPowdBVSupRx2 <= 1'b1;
      else
         ADCPowdBVSupRx2 <= 1'b0;
   end //ADCPowdBVSupRx2_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBVInfRx2_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBVInfRx2 <= 1'b0;
      else if ($signed(ADCPowdBVRx2[DBVPOW_WIDTH-1:2]) < $signed({{2{ADCPowInfThrdBV[7]}},ADCPowInfThrdBV}))
         ADCPowdBVInfRx2 <= 1'b1;
      else
         ADCPowdBVInfRx2 <= 1'b0;
   end //ADCPowdBVInfRx2_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBVSupRx3_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBVSupRx3 <= 1'b0;
      else if ($signed(ADCPowdBVRx3[DBVPOW_WIDTH-1:2]) > $signed({{2{ADCPowSupThrdBV[7]}},ADCPowSupThrdBV}))
         ADCPowdBVSupRx3 <= 1'b1;
      else
         ADCPowdBVSupRx3 <= 1'b0;
   end //ADCPowdBVSupRx3_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBVInfRx3_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBVInfRx3 <= 1'b0;
      else if ($signed(ADCPowdBVRx3[DBVPOW_WIDTH-1:2]) < $signed({{2{ADCPowInfThrdBV[7]}},ADCPowInfThrdBV}))
         ADCPowdBVInfRx3 <= 1'b1;
      else
         ADCPowdBVInfRx3 <= 1'b0;
   end //ADCPowdBVInfRx3_Blk

///////////////////////////////////
// ADC Power dBm comparators
///////////////////////////////////

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBmSupRx0_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBmSupRx0 <= 1'b0;
      else if ($signed(ADCSatPowdBmRx0[DBMPOW_WIDTH-1:2]) > $signed({{3{ADCPowSupThrdBm[7]}},ADCPowSupThrdBm}))
         ADCPowdBmSupRx0 <= 1'b1;
      else
         ADCPowdBmSupRx0 <= 1'b0;
   end //ADCPowdBmSupRx0_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBmInfRx0_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBmInfRx0 <= 1'b0;
      else if ($signed(ADCSatPowdBmRx0[DBMPOW_WIDTH-1:2]) < $signed({{3{ADCPowInfThrdBm[7]}},ADCPowInfThrdBm}))
         ADCPowdBmInfRx0 <= 1'b1;
      else
         ADCPowdBmInfRx0 <= 1'b0;
   end //ADCPowdBmInfRx0_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBmSupRx1_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBmSupRx1 <= 1'b0;
      else if ($signed(ADCSatPowdBmRx1[DBMPOW_WIDTH-1:2]) > $signed({{3{ADCPowSupThrdBm[7]}},ADCPowSupThrdBm}))
         ADCPowdBmSupRx1 <= 1'b1;
      else
         ADCPowdBmSupRx1 <= 1'b0;
   end //ADCPowdBmSupRx1_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBmInfRx1_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBmInfRx1 <= 1'b0;
      else if ($signed(ADCSatPowdBmRx1[DBMPOW_WIDTH-1:2]) < $signed({{3{ADCPowInfThrdBm[7]}},ADCPowInfThrdBm}))
         ADCPowdBmInfRx1 <= 1'b1;
      else
         ADCPowdBmInfRx1 <= 1'b0;
   end //ADCPowdBmInfRx1_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBmSupRx2_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBmSupRx2 <= 1'b0;
      else if ($signed(ADCSatPowdBmRx2[DBMPOW_WIDTH-1:2]) > $signed({{3{ADCPowSupThrdBm[7]}},ADCPowSupThrdBm}))
         ADCPowdBmSupRx2 <= 1'b1;
      else
         ADCPowdBmSupRx2 <= 1'b0;
   end //ADCPowdBmSupRx2_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBmInfRx2_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBmInfRx2 <= 1'b0;
      else if ($signed(ADCSatPowdBmRx2[DBMPOW_WIDTH-1:2]) < $signed({{3{ADCPowInfThrdBm[7]}},ADCPowInfThrdBm}))
         ADCPowdBmInfRx2 <= 1'b1;
      else
         ADCPowdBmInfRx2 <= 1'b0;
   end //ADCPowdBmInfRx2_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBmSupRx3_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBmSupRx3 <= 1'b0;
      else if ($signed(ADCSatPowdBmRx3[DBMPOW_WIDTH-1:2]) > $signed({{3{ADCPowSupThrdBm[7]}},ADCPowSupThrdBm}))
         ADCPowdBmSupRx3 <= 1'b1;
      else
         ADCPowdBmSupRx3 <= 1'b0;
   end //ADCPowdBmSupRx3_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: ADCPowdBmInfRx3_Blk
      if (nAGCRst == 1'b0)
         ADCPowdBmInfRx3 <= 1'b0;
      else if ($signed(ADCSatPowdBmRx3[DBMPOW_WIDTH-1:2]) < $signed({{3{ADCPowInfThrdBm[7]}},ADCPowInfThrdBm}))
         ADCPowdBmInfRx3 <= 1'b1;
      else
         ADCPowdBmInfRx3 <= 1'b0;
   end //ADCPowdBmInfRx3_Blk

endmodule //EnergyComp

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
