////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 15272 $
// $Date: 2014-06-11 10:50:04 +0200 (Wed, 11 Jun 2014) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Modem Interface Register Block
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/ModemIFReg.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module ModemIFReg (

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nAGCRst,   //Active Low Reset
            input    wire                                  AGCClk,    //AGC Clock

            //Controls
            input    wire                                  AGCFSMSftRst,//Synchronous reset
            input    wire              [7:0]               AGCCommand,  //Command from FSM Core
            input    wire              [23:0]              AGCParam,    //Command Parameter
            input    wire                                  AGCCmdValid, //AGC Command Valid

            // Rx gains
            input    wire              [7:0]               RxGain0, //Gain for Rx Chain 0
            input    wire              [7:0]               RxGain1, //Gain for Rx Chain 1
            input    wire              [7:0]               RxGain2, //Gain for Rx Chain 2
            input    wire              [7:0]               RxGain3, //Gain for Rx Chain 3

            // RF gains
            input    wire              [7:0]               RFGain0, //RF Gain for Rx Chain 0
            input    wire              [7:0]               RFGain1, //RF Gain for Rx Chain 1
            input    wire              [7:0]               RFGain2, //RF Gain for Rx Chain 2
            input    wire              [7:0]               RFGain3, //RF Gain for Rx Chain 3

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   wire                                  AGCOFDMLock,   //AGC OFDM Lock Indication
            output   wire                                  AGCOFDMHTSTF,  //AGC OFDM HTSTF Indication

            output   wire                                  AGCDSSSLock,   //AGC DSSS Lock Indication

            output   wire                                  RifsDetected,  //OFDM RIFS Indication

            output  reg              [7:0]                 RxGainAnt0,      //Gain for Rx Chain 0 in dB
            output  reg              [7:0]                 RxGainAnt1,      //Gain for Rx Chain 1 in dB
            output  reg              [7:0]                 RxGainAnt2,      //Gain for Rx Chain 2 in dB
            output  reg              [7:0]                 RxGainAnt3,      //Gain for Rx Chain 3 in dB

            output  reg              [7:0]                 RFGainAnt0,      //RF Gain for Rx Chain 0
            output  reg              [7:0]                 RFGainAnt1,      //RF Gain for Rx Chain 1
            output  reg              [7:0]                 RFGainAnt2,      //RF Gain for Rx Chain 2
            output  reg              [7:0]                 RFGainAnt3       //RF Gain for Rx Chain 3
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers & Wires Declarations
//////////////////////////////////////////////////////////////////////////////
reg                                    AGCOFDMLockInt;
reg                                    AGCDSSSLockInt;
reg                                    AGCOFDMHTSTFInt;
reg                                    RifsDetectedInt;

wire               [23:0]              AGCParam_aux;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This module is used to convey certain status signals to the Modem. The FSM
//directly programs these values through individual commands.

//Register the incoming value based on the command
always @ (posedge AGCClk or negedge nAGCRst)
   begin: RegInt_Blk
      if (nAGCRst == 1'b0) begin
         AGCOFDMLockInt   <= 1'b0;
         AGCDSSSLockInt   <= 1'b0;
         AGCOFDMHTSTFInt  <= 1'b0;
         RifsDetectedInt  <= 1'b0;
         RxGainAnt0       <= 8'b0;
         RxGainAnt1       <= 8'b0;
         RxGainAnt2       <= 8'b0;
         RxGainAnt3       <= 8'b0;
         RFGainAnt0       <= 8'b0;
         RFGainAnt1       <= 8'b0;
         RFGainAnt2       <= 8'b0;
         RFGainAnt3       <= 8'b0;
      end
      else if (((AGCCommand == 8'd1) && (AGCCmdValid == 1'b1)) || AGCFSMSftRst) begin
         //Reset Status Bits
         AGCOFDMLockInt   <= 1'b0;
         AGCDSSSLockInt   <= 1'b0;
         AGCOFDMHTSTFInt  <= 1'b0;
         RifsDetectedInt  <= 1'b0;
      end
      else if (AGCCommand == 8'd50 && AGCCmdValid == 1'b1) begin
         //Set AGC Lock Flags and clear AGC Unlock Flags
         AGCOFDMLockInt   <= AGCParam[0];
         AGCDSSSLockInt   <= AGCParam[8];
         if (AGCParam[0] || AGCParam[8]) begin
            //Store Rx gains into status registers
            RxGainAnt0 <= RxGain0;
            RxGainAnt1 <= RxGain1;
            RxGainAnt2 <= RxGain2;
            RxGainAnt3 <= RxGain3;
            //Store RF gains into status registers
            RFGainAnt0 <= RFGain0;
            RFGainAnt1 <= RFGain1;
            RFGainAnt2 <= RFGain2;
            RFGainAnt3 <= RFGain3;
         end
      end
      else if (AGCCommand == 8'd51 && AGCCmdValid == 1'b1) begin
         //Set AGC HTSTF Flag
         AGCOFDMHTSTFInt  <= AGCParam[0];
         if (AGCParam[0]) begin
            //Store Rx gains into status registers
            RxGainAnt0 <= RxGain0;
            RxGainAnt1 <= RxGain1;
            RxGainAnt2 <= RxGain2;
            RxGainAnt3 <= RxGain3;
            //Store RF gains into status registers
            RFGainAnt0 <= RFGain0;
            RFGainAnt1 <= RFGain1;
            RFGainAnt2 <= RFGain2;
            RFGainAnt3 <= RFGain3;
         end
      end
      else if (AGCCommand == 8'd52 && AGCCmdValid == 1'b1) begin
         //Set OFDM RIFS Detected
         RifsDetectedInt  <= AGCParam[0];
      end

   end //RegInt_Blk

//
assign AGCParam_aux = AGCParam; // To Avoid Lint Warning
//

//Outputs
assign AGCOFDMLock  = AGCOFDMLockInt;
assign AGCDSSSLock  = AGCDSSSLockInt;
assign AGCOFDMHTSTF = AGCOFDMHTSTFInt;
assign RifsDetected = RifsDetectedInt;

endmodule //ModemIFReg

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
