////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 14968 $
// $Date: 2014-05-19 11:58:09 +0200 (Mon, 19 May 2014) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : RF Gain comparator Module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/RFGainComp.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module RFGainComp #(parameter NRX =  4 //Number of Rx Chains (1 to 4)
                   )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nAGCRst,   //Active Low Reset
            input    wire                                  AGCClk,    //AGC Clock

            //Controls
            input    wire       [7:0]                      AGCCommand,  //Command from FSM Core
            input    wire       [23:0]                     AGCParam,    //Command Parameter 1
            input    wire                                  AGCCmdValid, //AGC Command Valid

            //RF Gain Setting
            input wire signed   [7:0]                      RxGain0, //Gain for Rx Chain 0
            input wire signed   [7:0]                      RxGain1, //Gain for Rx Chain 1
            input wire signed   [7:0]                      RxGain2, //Gain for Rx Chain 2
            input wire signed   [7:0]                      RxGain3, //Gain for Rx Chain 3

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //To AGC Core FSM
            output   reg                                   RFGainCp2MaxRx0,     //For Rx Chain 0
            output   reg                                   RFGainCp2MaxRx1,     //For Rx Chain 1
            output   reg                                   RFGainCp2MaxRx2,     //For Rx Chain 2
            output   reg                                   RFGainCp2MaxRx3,     //For Rx Chain 3
            output   reg                                   RFGainCp2MinRx0,     //For Rx Chain 0
            output   reg                                   RFGainCp2MinRx1,     //For Rx Chain 1
            output   reg                                   RFGainCp2MinRx2,     //For Rx Chain 2
            output   reg                                   RFGainCp2MinRx3,     //For Rx Chain 3
            output   reg                                   RFGainCp2Min4SatRx0, //For Rx Chain 0
            output   reg                                   RFGainCp2Min4SatRx1, //For Rx Chain 1
            output   reg                                   RFGainCp2Min4SatRx2, //For Rx Chain 2
            output   reg                                   RFGainCp2Min4SatRx3  //For Rx Chain 3
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers & Wires Declarations
//////////////////////////////////////////////////////////////////////////////
reg signed         [7:0]               MaxGain;
reg signed         [7:0]               MinGain;
reg signed         [7:0]               MinGain4Sat;

wire               [23:0]              AGCParam_aux;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// This module computes the gain comparators for AGC status registers.

//RFGainCp2Max signal generation
/////////////////////////////////////////////////////////
always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2MaxRx0_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2MaxRx0 <= 1'b0;
      else if (RxGain0 <= MaxGain)
         RFGainCp2MaxRx0 <= 1'b1;
      else
         RFGainCp2MaxRx0 <= 1'b0;
   end //RFGainCp2MaxRx0_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2MaxRx1_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2MaxRx1 <= 1'b0;
      else if ((RxGain1 <= MaxGain) && (NRX > 'd1))
         RFGainCp2MaxRx1 <= 1'b1;
      else
         RFGainCp2MaxRx1 <= 1'b0;
   end //RFGainCp2MaxRx1_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2MaxRx2_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2MaxRx2 <= 1'b0;
      else if ((RxGain2 <= MaxGain) && (NRX > 'd2))
         RFGainCp2MaxRx2 <= 1'b1;
      else
         RFGainCp2MaxRx2 <= 1'b0;
   end //RFGainCp2MaxRx2_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2MaxRx3_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2MaxRx3 <= 1'b0;
      else if ((RxGain3 <= MaxGain) && (NRX > 'd3))
         RFGainCp2MaxRx3 <= 1'b1;
      else
         RFGainCp2MaxRx3 <= 1'b0;
   end //RFGainCp2MaxRx3_Blk

//RFGainCp2Min signal generation
/////////////////////////////////////////////////////////
always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2MinRx0_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2MinRx0 <= 1'b0;
      else if (RxGain0 >= MinGain)
         RFGainCp2MinRx0 <= 1'b1;
      else
         RFGainCp2MinRx0 <= 1'b0;
   end //RFGainCp2MinRx0_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2MinRx1_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2MinRx1 <= 1'b0;
      else if ((RxGain1 >= MinGain) && (NRX > 'd1))
         RFGainCp2MinRx1 <= 1'b1;
      else
         RFGainCp2MinRx1 <= 1'b0;
   end //RFGainCp2MinRx1_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2MinRx2_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2MinRx2 <= 1'b0;
      else if ((RxGain2 >= MinGain) && (NRX > 'd2))
         RFGainCp2MinRx2 <= 1'b1;
      else
         RFGainCp2MinRx2 <= 1'b0;
   end //RFGainCp2MinRx2_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2MinRx3_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2MinRx3 <= 1'b0;
      else if ((RxGain3 >= MinGain) && (NRX > 'd3))
         RFGainCp2MinRx3 <= 1'b1;
      else
         RFGainCp2MinRx3 <= 1'b0;
   end //RFGainCp2MinRx3_Blk

//RFGainCp2Min4Sat signal generation
/////////////////////////////////////////////////////////
always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2Min4SatRx0_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2Min4SatRx0 <= 1'b0;
      else if (RxGain0 >= MinGain4Sat)
         RFGainCp2Min4SatRx0 <= 1'b1;
      else
         RFGainCp2Min4SatRx0 <= 1'b0;
   end //RFGainCp2Min4SatRx0_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2Min4SatRx1_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2Min4SatRx1 <= 1'b0;
      else if ((RxGain1 >= MinGain4Sat) && (NRX > 'd1))
         RFGainCp2Min4SatRx1 <= 1'b1;
      else
         RFGainCp2Min4SatRx1 <= 1'b0;
   end //RFGainCp2Min4SatRx1_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2Min4SatRx2_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2Min4SatRx2 <= 1'b0;
      else if ((RxGain2 >= MinGain4Sat) && (NRX > 'd2))
         RFGainCp2Min4SatRx2 <= 1'b1;
      else
         RFGainCp2Min4SatRx2 <= 1'b0;
   end //RFGainCp2Min4SatRx2_Blk

always @ (posedge AGCClk or negedge nAGCRst)
   begin: RFGainCp2Min4SatRx3_Blk
      if (nAGCRst == 1'b0)
         RFGainCp2Min4SatRx3 <= 1'b0;
      else if ((RxGain3 >= MinGain4Sat) && (NRX > 'd3))
         RFGainCp2Min4SatRx3 <= 1'b1;
      else
         RFGainCp2Min4SatRx3 <= 1'b0;
   end //RFGainCp2Min4SatRx3_Blk

//Decode AGC Commands for threshold configuration
////////////////////////////////////////////////////////////////////////////////////
always @ (posedge AGCClk or negedge nAGCRst)
   begin: DecodeCmd_Blk
      if (nAGCRst == 1'b0)
      begin
         MaxGain     <= 8'd65;
         MinGain     <= 8'h5;
         MinGain4Sat <= 8'h5;
      end
      else if (AGCCmdValid == 1'b1 && AGCCommand == 8'd20)
      begin
         MaxGain     <= AGCParam[7:0];
         MinGain     <= AGCParam[15:8];
         MinGain4Sat <= AGCParam[23:16];
      end
   end //DecodeCmd_Blk

//
assign AGCParam_aux = AGCParam; // To Avoid Lint Warning
//

endmodule //RFGainComp

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
