////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 10205 $
// $Date: 2013-09-23 09:59:10 +0200 (Mon, 23 Sep 2013) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Signed Threshold Crossing Detector
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/ThreshDetSgn.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module ThreshDetSgn #(parameter DATAWIDTH = 20 //Datawidth of Input value and register
                     )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nAGCRst,   //Active Low Reset
            input    wire                                  AGCClk, //FSM Clock

            //Data In
            input    wire   signed     [DATAWIDTH-1:0]     DSPValueIn, //DSP Value

            //Threshold Register
            input    wire   signed     [DATAWIDTH-1:0]     DetThrReg, //Reference for comparison

            //Control
            input    wire                                  DSPValueValid, //Qualifies DSPValueIn
            input    wire                                  GreaterThan, //Input > Ref

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Comparator
            output    reg                                  ThreshDetOut
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                                    ThreshDetInt;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This module implements a simple threshold crossing detector. The input value
//and the reference values are assumed to be signed. If GreaterThan is 1,
//then it checks if the input value is greater than the reference value else
//it checks if the input is lesser than the reference value.

//Compare
always @ (*)
   begin: Compare_Blk
      if (GreaterThan == 1'b1) begin
         if (DSPValueIn > DetThrReg)
            ThreshDetInt = 1'b1;
         else
            ThreshDetInt = 1'b0;
      end
      else begin
         if (DSPValueIn < DetThrReg)
            ThreshDetInt = 1'b1;
         else
            ThreshDetInt = 1'b0;
      end

   end //Compare_Blk

//Register the output
always @ (posedge AGCClk or negedge nAGCRst)
   begin: RegOut_Blk
      if(nAGCRst == 1'b0)
         ThreshDetOut <= 1'b0;
      else if (DSPValueValid == 1'b0)
         ThreshDetOut <= 1'b0;
      else
         ThreshDetOut <= ThreshDetInt;

   end //RegOut_Blk


endmodule //ThreshDetSgn

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
