////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 10205 $
// $Date: 2013-09-23 09:59:10 +0200 (Mon, 23 Sep 2013) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Signed Threshold Crossing Detector with FSM Enable
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/ThreshDetSgnFSM.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module ThreshDetSgnFSM #(parameter DATAWIDTH = 20 //Datawidth of Input value and register
                        )(
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input wire                                nAGCRst,   //Active Low Reset
            input wire                                AGCClk,    //AGC Clock

            //Data In
            input wire  signed     [DATAWIDTH-1:0]    DSPValueIn0, //DSP Value 0
            input wire  signed     [DATAWIDTH-1:0]    DSPValueIn1, //DSP Value 1

            //Threshold Register
            input wire  signed     [DATAWIDTH-1:0]    DetThrReg, //Reference for comparison

            //Control
            input wire                                GreaterThan, //Input > Ref
            input wire                                DetEnable, //Enable from FSM

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Comparator
            output wire                               ThreshDetOut
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                                    ThreshDetInt;
reg                                    ThreshDetOutInt;
reg                                    ThreshDetOutIntD;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This module implements a simple threshold crossing detector. The input value
//and the reference values are assumed to be signed. If GreaterThan is 1,
//then it checks if the input value is greater than the reference value else
//it checks if the input is lesser than the reference value. This block has an
//enable which is set by the FSM

//Compare
always @ (*)
   begin: Compare_Blk
      if (GreaterThan == 1'b1) begin
         if ((DSPValueIn1 >= DetThrReg) && (DSPValueIn0 < DetThrReg))
            ThreshDetInt = 1'b1;
         else
            ThreshDetInt = 1'b0;
      end
      else begin
         if ((DSPValueIn1 <= DetThrReg) && (DSPValueIn0 > DetThrReg))
            ThreshDetInt = 1'b1;
         else
            ThreshDetInt = 1'b0;
      end

   end //Compare_Blk

//Register the output
always @ (posedge AGCClk or negedge nAGCRst)
   begin: RegOutInt_Blk
      if(nAGCRst == 1'b0)
         ThreshDetOutInt <= 1'b0;
      else if (DetEnable == 1'b0)
         ThreshDetOutInt <= 1'b0;
      else
         ThreshDetOutInt <= ThreshDetInt;

   end //RegOutInt_Blk

// Detection delayed for pulse
always @ (posedge AGCClk or negedge nAGCRst)
   begin: RegOutIntD_Blk
      if (nAGCRst == 1'b0)
         ThreshDetOutIntD <= 1'b0;
      else
         ThreshDetOutIntD <= ThreshDetOutInt;

   end //RegOutIntD_Blk

assign ThreshDetOut = ThreshDetOutInt & ~ThreshDetOutIntD & DetEnable;

endmodule //ThreshDetSgnFSM

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
