////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 10205 $
// $Date: 2013-09-23 09:59:10 +0200 (Mon, 23 Sep 2013) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Signed Threshold Crossing Detector with Hysteresis
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/ThreshDetSgnHys.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module ThreshDetSgnHys #(parameter DATAWIDTH = 20 //Datawidth of Input value and register
                        )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nAGCRst,   //Active Low Reset
            input    wire                                  FsmRst,
            input    wire                                  AGCClk,    //AGC Clock

            //Data In
            input    wire   signed     [DATAWIDTH-1:0]     DSPValueIn, //DSP Value

            //Threshold Register
            input    wire   signed     [DATAWIDTH-1:0]     DetSetThrReg, //Reference for comparison
            input    wire   signed     [DATAWIDTH-1:0]     DetClrThrReg, //Reference for comparison

            //Saturation and Disappearance Events
            input    wire                                  EventSat,
            input    wire                                  EventDis,

            //Control
            input    wire                                  DSPValueValid, //Qualifies DSPValueIn

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Comparator
            output  wire                                   ThreshDetOut
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers & Wires Declarations
//////////////////////////////////////////////////////////////////////////////
reg                                    ThreshDetInt;
reg                                    EventDisD;
reg                                    EventSatD;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////


//This module implements a threshold crossing detector with hystersis, i.e.
//a different reference value is used to set the comparator output and
//a different value is used to clear it. The inputs are signed.

//Comparison
always @ (posedge AGCClk or negedge nAGCRst)
   begin: ThreshDetInt_Blk
      if(nAGCRst == 1'b0)
         ThreshDetInt <= 1'b0;
      else if (FsmRst == 1'b1)
         ThreshDetInt <= 1'b0;
      else if (EventDisD == 1'b1)
         ThreshDetInt <= 1'b0;
      else if (EventSatD == 1'b1)
         ThreshDetInt <= 1'b1;
      else if (DSPValueValid == 1'b1)
      begin
         if ((DSPValueIn > DetSetThrReg) && !ThreshDetInt)
            ThreshDetInt <= 1'b1;
         else if ((DSPValueIn < DetClrThrReg) && ThreshDetInt)
            ThreshDetInt <= 1'b0;
      end
   end //ThreshDetInt_Blk

//Trigger saturation and disappearance events
always@(posedge AGCClk or negedge nAGCRst)
begin
  if(nAGCRst==1'b0)
    EventDisD <= 1'b0;
  else if (EventDis == 1'b1)
    EventDisD <= 1'b1;
  else if (DSPValueValid == 1'b0)
    EventDisD <= 1'b0;
end

always@(posedge AGCClk or negedge nAGCRst)
begin
  if(nAGCRst==1'b0)
    EventSatD <= 1'b0;
  else if (EventSat == 1'b1)
    EventSatD <= 1'b1;
  else if (DSPValueValid == 1'b0)
    EventSatD <= 1'b0;
end

//Output
assign ThreshDetOut = ThreshDetInt;


endmodule //ThreshDetSgnHys

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////

