////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: jandre $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 14742 $
// $Date: 2014-04-29 13:12:57 +0200 (Tue, 29 Apr 2014) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Transition and Event Decoder 
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/AGCFSM/verilog/rtl/TransDec.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module TransDec #(parameter NRX = 4 // Number of Rx Chains (1 to 4)
                 )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            // Data and Control
            input    wire              [21:0]              TransCondReg, // Transition Condition
            input    wire              [127:0]             AGCStatusReg, // Status Register
            input    wire              [3:0]               ChCombMode,   // From Config Register
            
            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            // Control
            output   wire                                  TransValid, // Transition Valid
            output   wire      [15:0]                      DbgAgc // Debug port
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire               [63:0]              StatRegInt;
wire                                   SatDetect;
wire                                   ExtTrigger;
wire                                   PowerStable;
wire                                   DetCrossUp;
wire                                   DetCrossDown;
wire                                   DetRampUp;
wire                                   DetRampDown;
wire                                   ADCPowDis;
wire                                   RFGainCp2Max;
wire                                   RFGainCp2Min;
wire                                   RFGainCp2Min4Sat;
wire                                   InBdPowSup;
wire                                   InBdPowInf;
wire                                   ADCPowdBVSup;
wire                                   ADCPowdBVInf;
wire                                   ADCPowdBmSup;
wire                                   ADCPowdBmInf;
wire                                   IdPow;
wire               [3:0]               ChCombModeInt;
wire                                   PathComb;
wire               [2:0]               CombOrAnd;
wire               [5:0]               TransSelect1;
wire               [5:0]               TransSelect2;
wire               [5:0]               TransSelect3;
wire                                   TransValidInt1;
wire                                   TransValidInt2;
wire                                   TransValidInt3;
wire              [127:0]              AGCStatus_aux;
wire              [3:0]                ValidAnt;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////


// This module is used by the FSM to check for the occurence of a transition or
// event. It consists mainly of three 64 to 1 Muxes which perform the check
// against values coming from the AGC Status Reg. 
// The values of NRX and ChCombMode are used to choose either all of
// the Rx Chains are a combimation of them. An AND/OR of the chains is also
// possible depending on a bit in the TransCondReg


assign ValidAnt = ChCombModeInt;

//Internal Status Register - Input to Mux
assign StatRegInt[00] = AGCStatusReg[00];  // Always FALSE
assign StatRegInt[01] = AGCStatusReg[01];  // Always TRUE
assign StatRegInt[02] = AGCStatusReg[23];  // TimeOut
assign StatRegInt[03] = AGCStatusReg[06];  // Sat Counter = 0
assign StatRegInt[04] = AGCStatusReg[07];  // Sat Counter = 1
assign StatRegInt[05] = AGCStatusReg[08];  // Sat Counter = 2
assign StatRegInt[06] = AGCStatusReg[09];  // Sat Counter = 3
assign StatRegInt[07] = AGCStatusReg[10];  // Sat Counter >= 4
assign StatRegInt[08] = AGCStatusReg[49];  // Generic Counter = 0                 
assign StatRegInt[09] = AGCStatusReg[50];  // Generic Counter = 1
assign StatRegInt[10] = AGCStatusReg[51];  // Generic Counter = 2
assign StatRegInt[11] = AGCStatusReg[52];  // Generic Counter = 3
assign StatRegInt[12] = AGCStatusReg[53];  // Generic Counter >= 4
assign StatRegInt[13] = AGCStatusReg[24];  // RF Interface Done
assign StatRegInt[14] = RFGainCp2Max;      // RF gain setting is less than maxGain_dB
assign StatRegInt[15] = RFGainCp2Min;      // RF gain setting is more than minGain_dB
assign StatRegInt[16] = RFGainCp2Min4Sat;  // RF gain setting is more than minGain4Sat_dB
assign StatRegInt[17] = AGCStatusReg[75];  // Demodulation running
assign StatRegInt[18] = AGCStatusReg[54];  // CmdCtrlFlag
assign StatRegInt[19] = ExtTrigger;        // External Trigger
assign StatRegInt[20] = SatDetect;         // Saturation Detection
assign StatRegInt[21] = DetCrossUp;        // InBand Power Crossing Threshold Up
assign StatRegInt[22] = DetCrossDown;      // InBand Power Crossing Threshold Down
assign StatRegInt[23] = DetRampUp;         // InBand Power Ramp Up Detection
assign StatRegInt[24] = DetRampDown;       // InBand Power Ramp Down Detection
assign StatRegInt[25] = ADCPowDis;         // ADC Power Disappearance
assign StatRegInt[26] = PowerStable;       // Plateau Detection
assign StatRegInt[27] = AGCStatusReg[19];  // OFDM CC Diff
assign StatRegInt[28] = AGCStatusReg[20];  // OFDM AC Diff
assign StatRegInt[29] = AGCStatusReg[21];  // Barker CC Diff
assign StatRegInt[30] = AGCStatusReg[22];  // Barker AC Diff
assign StatRegInt[31] = AGCStatusReg[56];  // SFD Found
assign StatRegInt[32] = AGCStatusReg[73];  // No gain update
assign StatRegInt[33] = AGCStatusReg[91];  // Force20
assign StatRegInt[34] = AGCStatusReg[92];  // Force40
assign StatRegInt[35] = AGCStatusReg[71];  // LSIG Valid
assign StatRegInt[36] = AGCStatusReg[72];  // HTSIG Valid
assign StatRegInt[37] = AGCStatusReg[70];  // RxEndTimingP
assign StatRegInt[38] = AGCStatusReg[90];  // Mode 11b only
assign StatRegInt[39] = AGCStatusReg[89];  // Mode 11a only
assign StatRegInt[40] = AGCStatusReg[87];  // RIFS Detection Enable
assign StatRegInt[41] = InBdPowSup;        // InBand Power above Threshold
assign StatRegInt[42] = InBdPowInf;        // InBand Power below Threshold
assign StatRegInt[43] = ADCPowdBVSup;      // ADC Power in dBV above Threshold
assign StatRegInt[44] = ADCPowdBVInf;      // ADC Power in dBV below Threshold
assign StatRegInt[45] = ADCPowdBmSup;      // ADC Power in dBm above Threshold
assign StatRegInt[46] = ADCPowdBmInf;      // ADC Power in dBm below Threshold
assign StatRegInt[47] = IdPow;             // Identical Power Detection
assign StatRegInt[48] = AGCStatusReg[69];  // HTSTF Start Estimation
assign StatRegInt[49] = AGCStatusReg[82];  // HTSTF Gain Update
assign StatRegInt[50] = AGCStatusReg[94];  // FomHigh
assign StatRegInt[51] = AGCStatusReg[95];  // FomMed
assign StatRegInt[52] = AGCStatusReg[96];  // FomSing
assign StatRegInt[53] = AGCStatusReg[97];  // FreqHigh
assign StatRegInt[54] = AGCStatusReg[98];  // FreqLow
assign StatRegInt[55] = AGCStatusReg[99];  // FreqSing
assign StatRegInt[56] = AGCStatusReg[100]; // FreqDC
assign StatRegInt[57] = AGCStatusReg[101]; // LengthHigh
assign StatRegInt[58] = AGCStatusReg[102]; // LengthLow
assign StatRegInt[59] = AGCStatusReg[103]; // Meas1Done
assign StatRegInt[60] = AGCStatusReg[104]; // Meas2Done
assign StatRegInt[61] = AGCStatusReg[105]; // Meas3Done
assign StatRegInt[62] = AGCStatusReg[88];  // RadarDet
assign StatRegInt[63] = AGCStatusReg[74];  // DSSS Continuous Detection


// Generate ChCombModeInt depending on NRX
generate

   if (NRX == 4)
      assign ChCombModeInt[3:0] = ChCombMode[3:0];
   else if (NRX == 3)
      assign ChCombModeInt[3:0] = {1'b0, ChCombMode[2:0]};
   else if (NRX == 2)
      assign ChCombModeInt[3:0] = {2'b0, ChCombMode[1:0]};
   else //NRX == 1
      assign ChCombModeInt[3:0] = {3'b0, ChCombMode[0]};

endgenerate

// Path Combining
assign PathComb  = TransCondReg[3];   //0 = OR; 1 = AND

assign CombOrAnd = TransCondReg[2:0]; //0 = Op1 OR    Op2  OR    Op3
                                      //1 = Op1 AND   Op2  AND   Op3
                                      //2 =(Op1 OR    Op2) AND   Op3
                                      //3 =(Op1 AND   Op2) OR    Op3
                                      //4 = Op1 OR    Op2  OR  ! Op3
                                      //5 =(Op1 AND   Op2) AND ! Op3
                                      //6 =(Op1 OR    Op2) AND ! Op3
                                      //7 = Op1 AND ! Op2  AND ! Op3


// Generating combination values for multiple Rx Chains
generate
  if (NRX == 4) begin
assign SatDetect     = (PathComb == 1'b1) ?
                       ((AGCStatusReg[02] | ~ValidAnt[0]) &
                        (AGCStatusReg[03] | ~ValidAnt[1]) &
                        (AGCStatusReg[04] | ~ValidAnt[2]) &
                        (AGCStatusReg[05] | ~ValidAnt[3])) :
                       ((AGCStatusReg[02] &  ValidAnt[0]) |
                        (AGCStatusReg[03] &  ValidAnt[1]) |
                        (AGCStatusReg[04] &  ValidAnt[2]) |
                        (AGCStatusReg[05] &  ValidAnt[3]));

assign ExtTrigger    = (PathComb == 1'b1) ?
                       ((AGCStatusReg[83] | ~ValidAnt[0]) &
                        (AGCStatusReg[84] | ~ValidAnt[1]) &
                        (AGCStatusReg[85] | ~ValidAnt[2]) &
                        (AGCStatusReg[86] | ~ValidAnt[3])) :
                       ((AGCStatusReg[83] &  ValidAnt[0]) |
                        (AGCStatusReg[84] &  ValidAnt[1]) |
                        (AGCStatusReg[85] &  ValidAnt[2]) |
                        (AGCStatusReg[86] &  ValidAnt[3]));

assign PowerStable   = (PathComb == 1'b1) ?
                       ((AGCStatusReg[11] | ~ValidAnt[0]) &
                        (AGCStatusReg[12] | ~ValidAnt[1]) &
                        (AGCStatusReg[13] | ~ValidAnt[2]) &
                        (AGCStatusReg[14] | ~ValidAnt[3])) :
                       ((AGCStatusReg[11] &  ValidAnt[0]) |
                        (AGCStatusReg[12] &  ValidAnt[1]) |
                        (AGCStatusReg[13] &  ValidAnt[2]) |
                        (AGCStatusReg[14] &  ValidAnt[3]));

assign DetCrossUp    = (PathComb == 1'b1) ?
                       ((AGCStatusReg[25] | ~ValidAnt[0]) &
                        (AGCStatusReg[26] | ~ValidAnt[1]) &
                        (AGCStatusReg[27] | ~ValidAnt[2]) &
                        (AGCStatusReg[28] | ~ValidAnt[3])) :
                       ((AGCStatusReg[25] &  ValidAnt[0]) |
                        (AGCStatusReg[26] &  ValidAnt[1]) |
                        (AGCStatusReg[27] &  ValidAnt[2]) |
                        (AGCStatusReg[28] &  ValidAnt[3]));

assign DetCrossDown  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[29] | ~ValidAnt[0]) &
                        (AGCStatusReg[30] | ~ValidAnt[1]) &
                        (AGCStatusReg[31] | ~ValidAnt[2]) &
                        (AGCStatusReg[32] | ~ValidAnt[3])) :
                       ((AGCStatusReg[29] &  ValidAnt[0]) |
                        (AGCStatusReg[30] &  ValidAnt[1]) |
                        (AGCStatusReg[31] &  ValidAnt[2]) |
                        (AGCStatusReg[32] &  ValidAnt[3]));

assign DetRampUp     = (PathComb == 1'b1) ?
                       ((AGCStatusReg[33] | ~ValidAnt[0]) &
                        (AGCStatusReg[34] | ~ValidAnt[1]) &
                        (AGCStatusReg[35] | ~ValidAnt[2]) &
                        (AGCStatusReg[36] | ~ValidAnt[3])) :
                       ((AGCStatusReg[33] &  ValidAnt[0]) |
                        (AGCStatusReg[34] &  ValidAnt[1]) |
                        (AGCStatusReg[35] &  ValidAnt[2]) |
                        (AGCStatusReg[36] &  ValidAnt[3]));

assign DetRampDown   = (PathComb == 1'b1) ?
                       ((AGCStatusReg[37] | ~ValidAnt[0]) &
                        (AGCStatusReg[38] | ~ValidAnt[1]) &
                        (AGCStatusReg[39] | ~ValidAnt[2]) &
                        (AGCStatusReg[40] | ~ValidAnt[3])) :
                       ((AGCStatusReg[37] &  ValidAnt[0]) |
                        (AGCStatusReg[38] &  ValidAnt[1]) |
                        (AGCStatusReg[39] &  ValidAnt[2]) |
                        (AGCStatusReg[40] &  ValidAnt[3]));

assign ADCPowDis     = (PathComb == 1'b1) ?
                       ((AGCStatusReg[41] | ~ValidAnt[0]) &
                        (AGCStatusReg[42] | ~ValidAnt[1]) &
                        (AGCStatusReg[43] | ~ValidAnt[2]) &
                        (AGCStatusReg[44] | ~ValidAnt[3])) :
                       ((AGCStatusReg[41] &  ValidAnt[0]) |
                        (AGCStatusReg[42] &  ValidAnt[1]) |
                        (AGCStatusReg[43] &  ValidAnt[2]) |
                        (AGCStatusReg[44] &  ValidAnt[3]));

assign RFGainCp2Max  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[57] | ~ValidAnt[0]) &
                        (AGCStatusReg[58] | ~ValidAnt[1]) &
                        (AGCStatusReg[59] | ~ValidAnt[2]) &
                        (AGCStatusReg[60] | ~ValidAnt[3])) :
                       ((AGCStatusReg[57] &  ValidAnt[0]) |
                        (AGCStatusReg[58] &  ValidAnt[1]) |
                        (AGCStatusReg[59] &  ValidAnt[2]) |
                        (AGCStatusReg[60] &  ValidAnt[3]));

assign RFGainCp2Min  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[61] | ~ValidAnt[0]) &
                        (AGCStatusReg[62] | ~ValidAnt[1]) &
                        (AGCStatusReg[63] | ~ValidAnt[2]) &
                        (AGCStatusReg[64] | ~ValidAnt[3])) :
                       ((AGCStatusReg[61] &  ValidAnt[0]) |
                        (AGCStatusReg[62] &  ValidAnt[1]) |
                        (AGCStatusReg[63] &  ValidAnt[2]) |
                        (AGCStatusReg[64] &  ValidAnt[3]));

assign RFGainCp2Min4Sat = (PathComb == 1'b1) ?
                       ((AGCStatusReg[65] | ~ValidAnt[0]) &
                        (AGCStatusReg[66] | ~ValidAnt[1]) &
                        (AGCStatusReg[67] | ~ValidAnt[2]) &
                        (AGCStatusReg[68] | ~ValidAnt[3])) :
                       ((AGCStatusReg[65] &  ValidAnt[0]) |
                        (AGCStatusReg[66] &  ValidAnt[1]) |
                        (AGCStatusReg[67] &  ValidAnt[2]) |
                        (AGCStatusReg[68] &  ValidAnt[3]));

assign InBdPowSup    = (PathComb == 1'b1) ?
                       ((AGCStatusReg[15] | ~ValidAnt[0]) &
                        (AGCStatusReg[16] | ~ValidAnt[1]) &
                        (AGCStatusReg[17] | ~ValidAnt[2]) &
                        (AGCStatusReg[18] | ~ValidAnt[3])) :
                       ((AGCStatusReg[15] &  ValidAnt[0]) |
                        (AGCStatusReg[16] &  ValidAnt[1]) |
                        (AGCStatusReg[17] &  ValidAnt[2]) |
                        (AGCStatusReg[18] &  ValidAnt[3]));

assign InBdPowInf    = (PathComb == 1'b1) ?
                       ((AGCStatusReg[45] | ~ValidAnt[0]) &
                        (AGCStatusReg[46] | ~ValidAnt[1]) &
                        (AGCStatusReg[47] | ~ValidAnt[2]) &
                        (AGCStatusReg[48] | ~ValidAnt[3])) :
                       ((AGCStatusReg[45] &  ValidAnt[0]) |
                        (AGCStatusReg[46] &  ValidAnt[1]) |
                        (AGCStatusReg[47] &  ValidAnt[2]) |
                        (AGCStatusReg[48] &  ValidAnt[3]));

assign ADCPowdBVSup  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[106] | ~ValidAnt[0]) &
                        (AGCStatusReg[107] | ~ValidAnt[1]) &
                        (AGCStatusReg[108] | ~ValidAnt[2]) &
                        (AGCStatusReg[109] | ~ValidAnt[3])) :
                       ((AGCStatusReg[106] &  ValidAnt[0]) |
                        (AGCStatusReg[107] &  ValidAnt[1]) |
                        (AGCStatusReg[108] &  ValidAnt[2]) |
                        (AGCStatusReg[109] &  ValidAnt[3]));

assign ADCPowdBVInf  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[110] | ~ValidAnt[0]) &
                        (AGCStatusReg[111] | ~ValidAnt[1]) &
                        (AGCStatusReg[112] | ~ValidAnt[2]) & 
                        (AGCStatusReg[113] | ~ValidAnt[3])) :
                       ((AGCStatusReg[110] &  ValidAnt[0]) |
                        (AGCStatusReg[111] &  ValidAnt[1]) |
                        (AGCStatusReg[112] &  ValidAnt[2]) |
                        (AGCStatusReg[113] &  ValidAnt[3]));

assign ADCPowdBmSup  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[114] | ~ValidAnt[0]) &
                        (AGCStatusReg[115] | ~ValidAnt[1]) &
                        (AGCStatusReg[116] | ~ValidAnt[2]) &
                        (AGCStatusReg[117] | ~ValidAnt[3])) :
                       ((AGCStatusReg[114] &  ValidAnt[0]) |
                        (AGCStatusReg[115] &  ValidAnt[1]) |
                        (AGCStatusReg[116] &  ValidAnt[2]) |
                        (AGCStatusReg[117] &  ValidAnt[3]));

assign ADCPowdBmInf  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[118] | ~ValidAnt[0]) &
                        (AGCStatusReg[119] | ~ValidAnt[1]) &
                        (AGCStatusReg[120] | ~ValidAnt[2]) &
                        (AGCStatusReg[121] | ~ValidAnt[3])) :
                       ((AGCStatusReg[118] &  ValidAnt[0]) |
                        (AGCStatusReg[119] &  ValidAnt[1]) |
                        (AGCStatusReg[120] &  ValidAnt[2]) |
                        (AGCStatusReg[121] &  ValidAnt[3]));

assign IdPow         = (PathComb == 1'b1) ?
                       ((AGCStatusReg[78] | ~ValidAnt[0]) &
                        (AGCStatusReg[79] | ~ValidAnt[1]) &
                        (AGCStatusReg[80] | ~ValidAnt[2]) &
                        (AGCStatusReg[81] | ~ValidAnt[3])) :
                       ((AGCStatusReg[78] &  ValidAnt[0]) |
                        (AGCStatusReg[79] &  ValidAnt[1]) |
                        (AGCStatusReg[80] &  ValidAnt[2]) |
                        (AGCStatusReg[81] &  ValidAnt[3]));
  end
  else if (NRX == 3) begin

    assign SatDetect   = (PathComb == 1'b1) ?
                       ((AGCStatusReg[02] | ~ValidAnt[0]) &
                        (AGCStatusReg[03] | ~ValidAnt[1]) &
                        (AGCStatusReg[04] | ~ValidAnt[2])) :
                       ((AGCStatusReg[02] &  ValidAnt[0]) |
                        (AGCStatusReg[03] &  ValidAnt[1]) |
                        (AGCStatusReg[04] &  ValidAnt[2]));

    assign ExtTrigger = (PathComb == 1'b1) ?
                       ((AGCStatusReg[83] | ~ValidAnt[0]) &
                        (AGCStatusReg[84] | ~ValidAnt[1]) &
                        (AGCStatusReg[85] | ~ValidAnt[2])) :
                       ((AGCStatusReg[83] &  ValidAnt[0]) |
                        (AGCStatusReg[84] &  ValidAnt[1]) |
                        (AGCStatusReg[85] &  ValidAnt[2]));

    assign PowerStable   = (PathComb == 1'b1) ?
                       ((AGCStatusReg[11] | ~ValidAnt[0]) &
                        (AGCStatusReg[12] | ~ValidAnt[1]) &
                        (AGCStatusReg[13] | ~ValidAnt[2])) :
                       ((AGCStatusReg[11] &  ValidAnt[0]) |
                        (AGCStatusReg[12] &  ValidAnt[1]) |
                        (AGCStatusReg[13] &  ValidAnt[2]));

    assign DetCrossUp    = (PathComb == 1'b1) ?
                       ((AGCStatusReg[25] | ~ValidAnt[0]) &
                        (AGCStatusReg[26] | ~ValidAnt[1]) &
                        (AGCStatusReg[27] | ~ValidAnt[2])) :
                       ((AGCStatusReg[25] &  ValidAnt[0]) |
                        (AGCStatusReg[26] &  ValidAnt[1]) |
                        (AGCStatusReg[27] &  ValidAnt[2]));

    assign DetCrossDown  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[29] | ~ValidAnt[0]) &
                        (AGCStatusReg[30] | ~ValidAnt[1]) &
                        (AGCStatusReg[31] | ~ValidAnt[2])) :
                       ((AGCStatusReg[29] &  ValidAnt[0]) |
                        (AGCStatusReg[30] &  ValidAnt[1]) |
                        (AGCStatusReg[31] &  ValidAnt[2]));

    assign DetRampUp     = (PathComb == 1'b1) ?
                       ((AGCStatusReg[33] | ~ValidAnt[0]) &
                        (AGCStatusReg[34] | ~ValidAnt[1]) &
                        (AGCStatusReg[35] | ~ValidAnt[2])) :
                       ((AGCStatusReg[33] &  ValidAnt[0]) |
                        (AGCStatusReg[34] &  ValidAnt[1]) |
                        (AGCStatusReg[35] &  ValidAnt[2]));

    assign DetRampDown   = (PathComb == 1'b1) ?
                       ((AGCStatusReg[37] | ~ValidAnt[0]) &
                        (AGCStatusReg[38] | ~ValidAnt[1]) &
                        (AGCStatusReg[39] | ~ValidAnt[2])) :
                       ((AGCStatusReg[37] &  ValidAnt[0]) |
                        (AGCStatusReg[38] &  ValidAnt[1]) |
                        (AGCStatusReg[39] &  ValidAnt[2]));

    assign ADCPowDis     = (PathComb == 1'b1) ?
                       ((AGCStatusReg[41] | ~ValidAnt[0]) &
                        (AGCStatusReg[42] | ~ValidAnt[1]) &
                        (AGCStatusReg[43] | ~ValidAnt[2])) :
                       ((AGCStatusReg[41] &  ValidAnt[0]) |
                        (AGCStatusReg[42] &  ValidAnt[1]) |
                        (AGCStatusReg[43] &  ValidAnt[2]));

    assign RFGainCp2Max  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[57] | ~ValidAnt[0]) &
                        (AGCStatusReg[58] | ~ValidAnt[1]) &
                        (AGCStatusReg[59] | ~ValidAnt[2])) :
                       ((AGCStatusReg[57] &  ValidAnt[0]) |
                        (AGCStatusReg[58] &  ValidAnt[1]) |
                        (AGCStatusReg[59] &  ValidAnt[2]));

    assign RFGainCp2Min  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[61] | ~ValidAnt[0]) &
                        (AGCStatusReg[62] | ~ValidAnt[1]) &
                        (AGCStatusReg[63] | ~ValidAnt[2])) :
                       ((AGCStatusReg[61] &  ValidAnt[0]) |
                        (AGCStatusReg[62] &  ValidAnt[1]) |
                        (AGCStatusReg[63] &  ValidAnt[2]));

    assign RFGainCp2Min4Sat = (PathComb == 1'b1) ?
                       ((AGCStatusReg[65] | ~ValidAnt[0]) &
                        (AGCStatusReg[66] | ~ValidAnt[1]) &
                        (AGCStatusReg[67] | ~ValidAnt[2])) :
                       ((AGCStatusReg[65] &  ValidAnt[0]) |
                        (AGCStatusReg[66] &  ValidAnt[1]) |
                        (AGCStatusReg[67] &  ValidAnt[2]));

    assign InBdPowSup    = (PathComb == 1'b1) ?
                       ((AGCStatusReg[15] | ~ValidAnt[0]) &
                        (AGCStatusReg[16] | ~ValidAnt[1]) &
                        (AGCStatusReg[17] | ~ValidAnt[2])) :
                       ((AGCStatusReg[15] &  ValidAnt[0]) |
                        (AGCStatusReg[16] &  ValidAnt[1]) |
                        (AGCStatusReg[17] &  ValidAnt[2]));

    assign InBdPowInf    = (PathComb == 1'b1) ?
                       ((AGCStatusReg[45] | ~ValidAnt[0]) &
                        (AGCStatusReg[46] | ~ValidAnt[1]) &
                        (AGCStatusReg[47] | ~ValidAnt[2])) :
                       ((AGCStatusReg[45] &  ValidAnt[0]) |
                        (AGCStatusReg[46] &  ValidAnt[1]) |
                        (AGCStatusReg[47] &  ValidAnt[2]));

    assign ADCPowdBVSup  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[106] | ~ValidAnt[0]) &
                        (AGCStatusReg[107] | ~ValidAnt[1]) &
                        (AGCStatusReg[108] | ~ValidAnt[2])) :
                       ((AGCStatusReg[106] &  ValidAnt[0]) |
                        (AGCStatusReg[107] &  ValidAnt[1]) |
                        (AGCStatusReg[108] &  ValidAnt[2]));

    assign ADCPowdBVInf  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[110] | ~ValidAnt[0]) &
                        (AGCStatusReg[111] | ~ValidAnt[1]) &
                        (AGCStatusReg[112] | ~ValidAnt[2])) :
                       ((AGCStatusReg[110] &  ValidAnt[0]) |
                        (AGCStatusReg[111] &  ValidAnt[1]) |
                        (AGCStatusReg[112] &  ValidAnt[2]));

    assign ADCPowdBmSup  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[114] | ~ValidAnt[0]) &
                        (AGCStatusReg[115] | ~ValidAnt[1]) &
                        (AGCStatusReg[116] | ~ValidAnt[2])) :
                       ((AGCStatusReg[114] &  ValidAnt[0]) |
                        (AGCStatusReg[115] &  ValidAnt[1]) |
                        (AGCStatusReg[116] &  ValidAnt[2]));

    assign ADCPowdBmInf  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[118] | ~ValidAnt[0]) &
                        (AGCStatusReg[119] | ~ValidAnt[1]) &
                        (AGCStatusReg[120] | ~ValidAnt[2])) :
                       ((AGCStatusReg[118] &  ValidAnt[0]) |
                        (AGCStatusReg[119] &  ValidAnt[1]) |
                        (AGCStatusReg[120] &  ValidAnt[2]));

    assign IdPow         = (PathComb == 1'b1) ?
                       ((AGCStatusReg[78] | ~ValidAnt[0]) &
                        (AGCStatusReg[79] | ~ValidAnt[1]) &
                        (AGCStatusReg[80] | ~ValidAnt[2])) :
                       ((AGCStatusReg[78] &  ValidAnt[0]) |
                        (AGCStatusReg[79] &  ValidAnt[1]) |
                        (AGCStatusReg[80] &  ValidAnt[2]));
  end
  else if (NRX == 2) begin

    assign SatDetect   = (PathComb == 1'b1) ?
                       ((AGCStatusReg[02] | ~ValidAnt[0]) &
                        (AGCStatusReg[03] | ~ValidAnt[1])) :
                       ((AGCStatusReg[02] &  ValidAnt[0]) |
                        (AGCStatusReg[03] &  ValidAnt[1]));

    assign ExtTrigger = (PathComb == 1'b1) ?
                       ((AGCStatusReg[83] | ~ValidAnt[0]) &
                        (AGCStatusReg[84] | ~ValidAnt[1])) :
                       ((AGCStatusReg[83] &  ValidAnt[0]) |
                        (AGCStatusReg[84] &  ValidAnt[1]));

    assign PowerStable   = (PathComb == 1'b1) ?
                       ((AGCStatusReg[11] | ~ValidAnt[0]) &
                        (AGCStatusReg[12] | ~ValidAnt[1])) :
                       ((AGCStatusReg[11] &  ValidAnt[0]) |
                        (AGCStatusReg[12] &  ValidAnt[1]));

    assign DetCrossUp    = (PathComb == 1'b1) ?
                       ((AGCStatusReg[25] | ~ValidAnt[0]) &
                        (AGCStatusReg[26] | ~ValidAnt[1])) :
                       ((AGCStatusReg[25] &  ValidAnt[0]) |
                        (AGCStatusReg[26] &  ValidAnt[1]));

    assign DetCrossDown  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[29] | ~ValidAnt[0]) &
                        (AGCStatusReg[30] | ~ValidAnt[1])) :
                       ((AGCStatusReg[29] &  ValidAnt[0]) |
                        (AGCStatusReg[30] &  ValidAnt[1]));

    assign DetRampUp     = (PathComb == 1'b1) ?
                       ((AGCStatusReg[33] | ~ValidAnt[0]) &
                        (AGCStatusReg[34] | ~ValidAnt[1])) :
                       ((AGCStatusReg[33] &  ValidAnt[0]) |
                        (AGCStatusReg[34] &  ValidAnt[1]));

    assign DetRampDown   = (PathComb == 1'b1) ?
                       ((AGCStatusReg[37] | ~ValidAnt[0]) &
                        (AGCStatusReg[38] | ~ValidAnt[1])) :
                       ((AGCStatusReg[37] &  ValidAnt[0]) |
                        (AGCStatusReg[38] &  ValidAnt[1]));

    assign ADCPowDis     = (PathComb == 1'b1) ?
                       ((AGCStatusReg[41] | ~ValidAnt[0]) &
                        (AGCStatusReg[42] | ~ValidAnt[1])) :
                       ((AGCStatusReg[41] &  ValidAnt[0]) |
                        (AGCStatusReg[42] &  ValidAnt[1]));

    assign RFGainCp2Max  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[57] | ~ValidAnt[0]) &
                        (AGCStatusReg[58] | ~ValidAnt[1])) :
                       ((AGCStatusReg[57] &  ValidAnt[0]) |
                        (AGCStatusReg[58] &  ValidAnt[1]));

    assign RFGainCp2Min  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[61] | ~ValidAnt[0]) &
                        (AGCStatusReg[62] | ~ValidAnt[1])) :
                       ((AGCStatusReg[61] &  ValidAnt[0]) |
                        (AGCStatusReg[62] &  ValidAnt[1]));

    assign RFGainCp2Min4Sat = (PathComb == 1'b1) ?
                       ((AGCStatusReg[65] | ~ValidAnt[0]) &
                        (AGCStatusReg[66] | ~ValidAnt[1])) :
                       ((AGCStatusReg[65] &  ValidAnt[0]) |
                        (AGCStatusReg[66] &  ValidAnt[1]));

    assign InBdPowSup    = (PathComb == 1'b1) ?
                       ((AGCStatusReg[15] | ~ValidAnt[0]) &
                        (AGCStatusReg[16] | ~ValidAnt[1])) :
                       ((AGCStatusReg[15] &  ValidAnt[0]) |
                        (AGCStatusReg[16] &  ValidAnt[1]));

    assign InBdPowInf    = (PathComb == 1'b1) ?
                       ((AGCStatusReg[45] | ~ValidAnt[0]) &
                        (AGCStatusReg[46] | ~ValidAnt[1])) :
                       ((AGCStatusReg[45] &  ValidAnt[0]) |
                        (AGCStatusReg[46] &  ValidAnt[1]));

    assign ADCPowdBVSup  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[106] | ~ValidAnt[0]) &
                        (AGCStatusReg[107] | ~ValidAnt[1])) :
                       ((AGCStatusReg[106] &  ValidAnt[0]) |
                        (AGCStatusReg[107] &  ValidAnt[1]));

    assign ADCPowdBVInf  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[110] | ~ValidAnt[0]) &
                        (AGCStatusReg[111] | ~ValidAnt[1])) :
                       ((AGCStatusReg[110] &  ValidAnt[0]) |
                        (AGCStatusReg[111] &  ValidAnt[1]));

    assign ADCPowdBmSup  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[114] | ~ValidAnt[0]) &
                        (AGCStatusReg[115] | ~ValidAnt[1])) :
                       ((AGCStatusReg[114] &  ValidAnt[0]) |
                        (AGCStatusReg[115] &  ValidAnt[1]));

    assign ADCPowdBmInf  = (PathComb == 1'b1) ?
                       ((AGCStatusReg[118] | ~ValidAnt[0]) &
                        (AGCStatusReg[119] | ~ValidAnt[1])) :
                       ((AGCStatusReg[118] &  ValidAnt[0]) |
                        (AGCStatusReg[119] &  ValidAnt[1]));

    assign IdPow         = (PathComb == 1'b1) ?
                       ((AGCStatusReg[78] | ~ValidAnt[0]) &
                        (AGCStatusReg[79] | ~ValidAnt[1])) :
                       ((AGCStatusReg[78] &  ValidAnt[0]) |
                        (AGCStatusReg[79] &  ValidAnt[1]));
  end
  else begin
    assign SatDetect     = AGCStatusReg[02] & ValidAnt[0];

    assign ExtTrigger    = AGCStatusReg[83] & ValidAnt[0];

    assign PowerStable   = AGCStatusReg[11] & ValidAnt[0];

    assign DetCrossUp    = AGCStatusReg[25] & ValidAnt[0];

    assign DetCrossDown  = AGCStatusReg[29] & ValidAnt[0];

    assign DetRampUp     = AGCStatusReg[33] & ValidAnt[0];

    assign DetRampDown   = AGCStatusReg[37] & ValidAnt[0];

    assign ADCPowDis     = AGCStatusReg[41] & ValidAnt[0];

    assign RFGainCp2Max  = AGCStatusReg[57] & ValidAnt[0];

    assign RFGainCp2Min  = AGCStatusReg[61] & ValidAnt[0];

    assign RFGainCp2Min4Sat = AGCStatusReg[65] & ValidAnt[0];

    assign InBdPowSup    = AGCStatusReg[15] & ValidAnt[0];

    assign InBdPowInf    = AGCStatusReg[45] & ValidAnt[0];

    assign ADCPowdBVSup  = AGCStatusReg[106] & ValidAnt[0];

    assign ADCPowdBVInf  = AGCStatusReg[110] & ValidAnt[0];

    assign ADCPowdBmSup  = AGCStatusReg[114] & ValidAnt[0];

    assign ADCPowdBmInf  = AGCStatusReg[118] & ValidAnt[0];

    assign IdPow         = AGCStatusReg[78] & ValidAnt[0];
  end
endgenerate

// Transition Valid Generation
assign TransSelect1   = TransCondReg[21:16];
assign TransValidInt1 = StatRegInt[TransSelect1];

assign TransSelect2   = TransCondReg[15:10];
assign TransValidInt2 = StatRegInt[TransSelect2];

assign TransSelect3   = TransCondReg[9:4];
assign TransValidInt3 = StatRegInt[TransSelect3];

assign AGCStatus_aux = AGCStatusReg; // To Avoid Lint Prob


// Combining the 7 Transition Valids as per CombOrAnd
assign TransValid = (CombOrAnd == 3'h0) ?
                    ( TransValidInt1  | TransValidInt2  |  TransValidInt3) :
                    (CombOrAnd == 3'h1) ?
                    ( TransValidInt1  & TransValidInt2  &  TransValidInt3) :
                    (CombOrAnd == 3'h2) ?
                    ((TransValidInt1 |  TransValidInt2) &  TransValidInt3) :
                    (CombOrAnd == 3'h3) ?
                    ((TransValidInt1 &  TransValidInt2) |  TransValidInt3) :
                    (CombOrAnd == 3'h4) ?
                    ( TransValidInt1 |  TransValidInt2  | ~TransValidInt3) :
                    (CombOrAnd == 3'h5) ?
                    (TransValidInt1  &  TransValidInt2  & ~TransValidInt3) :
                    (CombOrAnd == 3'h6) ?
                    ((TransValidInt1 |  TransValidInt2) & ~TransValidInt3) :
                    ( TransValidInt1 & ~TransValidInt2  & ~TransValidInt3);

// Debug port
assign DbgAgc = {StatRegInt[63], // DSSS Continuous Detection
                 StatRegInt[47], // Identical Power Detection
                 StatRegInt[30], // Barker AC Diff
                 StatRegInt[29], // Barker CC Diff
                 StatRegInt[28], // OFDM AC Diff
                 StatRegInt[27], // OFDM CC Diff
                 StatRegInt[26], // Plateau Detection
                 StatRegInt[25], // ADC Power Disappearance
                 StatRegInt[24], // InBand Power Ramp Down Detection
                 StatRegInt[23], // InBand Power Ramp Up Detection
                 StatRegInt[22], // InBand Power Crossing Threshold Down
                 StatRegInt[21], // InBand Power Crossing Threshold Up
                 StatRegInt[20], // Saturation Detection
                 StatRegInt[14], // RF Gain Compare to Max
                 StatRegInt[16], // RF Gain Compare to Min for Saturation
                 StatRegInt[02]  // TimeOut
                };


endmodule //TransDec

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
