//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: rblanc $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 14770 $
// $Date: 2014-04-29 18:02:54 +0200 (Tue, 29 Apr 2014) $
// ---------------------------------------------------------------------------
// Dependencies     :                                 
// Description      : Top level file for CCA FSMs
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/CCAFSM/verilog/rtl/CcaFsmTop.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module CcaFsmTop #(parameter BW_PARAM     = 80,
                   parameter NRX          =  4, //Number of Rx Chains (1 to 4)
                   parameter DBMPOW_WIDTH = 13 //Data width of qdBm power
                  )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            input    wire                                  nAGCRst,

            // Data and Control
            input    wire                                  FsmRst,
            input    wire                                  Force20,
            input    wire                                  Force40,
            input    wire    [2:0]                         CcaEnergyEn,
            input    wire    [2:0]                         CcaRampUpEn,
            input    wire                                  CcaCsEn,
            input    wire                                  CcaDemodEn,
            input    wire                                  CcaSatEn,
            input    wire                                  CcaDisEn,
            input    wire    [10:0]                        RxStateCca20PSel,
            input    wire    [10:0]                        RxStateCca20SSel,
            input    wire    [10:0]                        RxStateCca40SSel,
            input    wire    [3:0]                         CcaFlag0Ctrl,
            input    wire    [3:0]                         CcaFlag1Ctrl,
            input    wire    [3:0]                         CcaFlag2Ctrl,
            input    wire    [3:0]                         CcaFlag3Ctrl,
            input    wire    [31:0]                        CcaTimeoutReg,
            input    wire   signed     [8:0]               RegInbdCCA20PPowMindBm,
            input    wire   signed     [7:0]               RegCCA20PRiseThrdBm,
            input    wire   signed     [7:0]               RegCCA20PFallThrdBm,
            input    wire   signed     [8:0]               RegInbdCCA20SPowMindBm,
            input    wire   signed     [7:0]               RegCCA20SFallThrdBm,
            input    wire   signed     [7:0]               RegCCA20SRiseThrdBm,
            input    wire   signed     [8:0]               RegInbdCCA40SPowMindBm,
            input    wire   signed     [7:0]               RegCCA40SFallThrdBm,
            input    wire   signed     [7:0]               RegCCA40SRiseThrdBm,
            input    wire   signed     [5:0]               RegCCADetRampUp,
            input    wire   signed     [5:0]               RegCCADetRampDown,
            input    wire              [2:0]               DelCCARampUpTap,
            input    wire              [2:0]               DelCCARampDownTap,
            input    wire                                  BWDetected,
            input    wire                                  BWSup20,
            input    wire                                  BWEq40,
            input    wire                                  BWEq80,
            input    wire                                  AGCOFDMLock,
            input    wire                                  AGCDSSSLock,
            input    wire                                  SFDFound,
            input    wire                                  LSIGValid,
            input    wire                                  HTSIGValid,
            input    wire                                  RxEndTimingP,
            input    wire                                  CsValidP,
            input    wire    [1:0]                         CsFlagNr,
            input    wire                                  CaDetHigh,
            input    wire                                  CaDetLow,
            input    wire                                  CbDetHigh,
            input    wire                                  CbDetLow,
            input    wire                                  EventSat,
            input    wire                                  EventDis,
            

            // In Band Power in qdBm for 20 MHz packet
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx0, //Power in Rx Chain 0
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx1, //Power in Rx Chain 1
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx2, //Power in Rx Chain 2
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20PowdBmRx3, //Power in Rx Chain 3
            input    wire                                  InBd20PowValid,  //InBd 20 Power Valid
            input    wire                                  InBd20PowCCAValid, //InBd 20 Power Valid for crossing

            // In Band Power in qdBm for 40 MHz packet in Secondary Channel
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd20SecPowdBm,   //Power in secondary
            input    wire                                  InBd20SecPowValid, //Sec Power Valid

            // In Band Power in qdBm for 80 MHz packet in Secondary Channel
            input    wire   signed     [DBMPOW_WIDTH-1:0]  InBd40SecPowdBm,   //Power in secondary
            input    wire                                  InBd40SecPowValid, //Sec Power Valid

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            // CCA status
            output wire                                    CCAPrimary,
            output wire                                    CCASecondary20,
            output wire                                    CCASecondary40,

            // CCA ramp time out error
            output wire                                    TimeOutErr,
            
            // Inband Power Max/Min index
            output reg         [1:0]                       InbandPowMaxIndex, //Antenna max index
            output reg         [1:0]                       InbandPowMinIndex, //Antenna min index

            // Debug port
            output wire        [15:0]                      DbgCca
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire                                   EnergyThrCcaPInt;
wire                                   EnergyThrCca20SInt;
wire                                   EnergyThrCca40SInt;
wire                                   EnergyThrCcaPOut;
wire                                   EnergyThrCca20SOut;
wire                                   EnergyThrCca40SOut;
wire                                   RampUpCcaPInt;
wire                                   RampUpCca20SInt;
wire                                   RampUpCca40SInt;
wire                                   RampUpCcaPOut;
wire                                   RampUpCca20SOut;
wire                                   RampUpCca40SOut;
wire              [10:0]               RxStateOutInt;
wire                                   RxStateCcaPInt;
wire                                   RxStateCca20SInt;
wire                                   RxStateCca40SInt;
wire                                   RxStateCcaPMux;
wire                                   RxStateCca20SMux;
wire                                   RxStateCca40SMux;
wire                                   CsCcaInt;
wire                                   CsCcaMux;
wire                                   CCAPrimaryInt;
wire                                   CCASecondary20Int;
wire                                   CCASecondary40Int;
wire                                   TimeOutErrPri;
wire                                   TimeOutErr20Sec;
wire                                   TimeOutErr40Sec;
wire                                   EventSatInt;
wire                                   EventDisInt;
wire                                   CcaRampUpPri;
wire                                   CcaRampDownPri;
wire                                   CcaRampUp20Sec;
wire                                   CcaRampUp40Sec;
wire                                   CcaRampDown20Sec;
wire                                   CcaRampDown40Sec;
wire                                   NullData;
wire   signed     [DBMPOW_WIDTH-1:0]   InbdCCA20PPowMinqdBm;
wire   signed     [DBMPOW_WIDTH-1:0]   InbdCCA20SPowMinqdBm;
wire   signed     [DBMPOW_WIDTH-1:0]   InbdCCA40SPowMinqdBm;
wire   signed     [DBMPOW_WIDTH-1:0]   InBd20PowdBmRx0Int;
wire   signed     [DBMPOW_WIDTH-1:0]   InBd20PowdBmRx1Int;
wire   signed     [DBMPOW_WIDTH-1:0]   InBd20PowdBmRx2Int;
wire   signed     [DBMPOW_WIDTH-1:0]   InBd20PowdBmRx3Int;
wire              [3:0]                DbgCcaFsm;

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                                    EnergyThrCcaPri;
reg                                    EnergyThrCca20Sec;
reg                                    EnergyThrCca40Sec;
reg                                    RampUpCcaPri;
reg                                    RampUpCca20Sec;
reg                                    RampUpCca40Sec;
reg                                    RxStateCcaPOut;
reg                                    RxStateCca20SOut;
reg                                    RxStateCca40SOut;
reg                                    CCAPrimaryReg;
reg                                    CCASecondary20Reg;
reg                                    CCASecondary40Reg;
reg                                    TimeOutReg;
reg     signed     [DBMPOW_WIDTH-1:0]  InBd20PowMaxInt0;
reg     signed     [DBMPOW_WIDTH-1:0]  InBd20PowMaxInt1;
reg     signed     [DBMPOW_WIDTH-1:0]  InBd20PowMax;
reg                [1:0]               InbandPowMaxIndex0;
reg                [1:0]               InbandPowMaxIndex1;
reg                [1:0]               InbandPowMaxIndexInt;
reg                [1:0]               InbandPowMinIndex0;
reg                [1:0]               InbandPowMinIndex1;
reg                [1:0]               InbandPowMinIndexInt;
reg     signed     [DBMPOW_WIDTH-1:0]  InBd20PowMaxCca;
reg     signed     [DBMPOW_WIDTH-1:0]  InBd20SecPowdBmCca;
reg     signed     [DBMPOW_WIDTH-1:0]  InBd40SecPowdBmCca;
reg                                    InBd20PowCCAValidInter;
reg                                    InBd20SecPowValidInter;
reg                                    InBd40SecPowValidInter;
reg                [10:0]              RxStateOutPMux;
reg                [10:0]              RxStateOut20SMux;
reg                [10:0]              RxStateOut40SMux;

// Integer for loop generation
integer              i;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Null wire for unused inputs
  assign NullData = 1'b0;

  assign InBd20PowdBmRx0Int = InBd20PowdBmRx0;
  assign InBd20PowdBmRx1Int = InBd20PowdBmRx1;
  assign InBd20PowdBmRx2Int = InBd20PowdBmRx2;
  assign InBd20PowdBmRx3Int = InBd20PowdBmRx3;

//Output Assignment
  assign CCAPrimary     = CCAPrimaryReg;
  assign CCASecondary20 = CCASecondary20Reg;
  assign CCASecondary40 = CCASecondary40Reg;
  assign TimeOutErr     = TimeOutReg;

//Finding Maximum of InBand Power
//Finding Maximum/Minimum index of InBand Power
generate
   if (NRX == 4) begin
      always @ (*)
      begin: InbdMaxPowInt_Blk
         if (InBd20PowdBmRx0Int > InBd20PowdBmRx1Int) begin
           InBd20PowMaxInt0   = InBd20PowdBmRx0Int;
           InbandPowMaxIndex0 = 2'd0;
           InbandPowMinIndex0 = 2'd1;
         end
         else begin
           InBd20PowMaxInt0   = InBd20PowdBmRx1Int;
           InbandPowMaxIndex0 = 2'd1;
           InbandPowMinIndex0 = 2'd0;
         end

         if (InBd20PowdBmRx2Int > InBd20PowdBmRx3Int) begin
           InBd20PowMaxInt1   = InBd20PowdBmRx2Int;
           InbandPowMaxIndex1 = 2'd2;
           InbandPowMinIndex1 = 2'd3;
         end
         else begin
           InBd20PowMaxInt1   = InBd20PowdBmRx3Int;
           InbandPowMaxIndex1 = 2'd3;
           InbandPowMinIndex1 = 2'd2;
         end

         if (InBd20PowMaxInt0 > InBd20PowMaxInt1) begin
           InBd20PowMax         = InBd20PowMaxInt0;
           InbandPowMaxIndexInt = InbandPowMaxIndex0;
           InbandPowMinIndexInt = InbandPowMinIndex1;
         end
         else begin
           InBd20PowMax         = InBd20PowMaxInt1;
           InbandPowMaxIndexInt = InbandPowMaxIndex1;
           InbandPowMinIndexInt = InbandPowMinIndex0;
         end
      end
   end // NRX == 4
   else if (NRX == 3) begin
      always @ (*)
      begin: InbdMaxPowInt_Blk
         if (InBd20PowdBmRx0Int > InBd20PowdBmRx1Int) begin
           InBd20PowMaxInt0   = InBd20PowdBmRx0Int;
           InbandPowMaxIndex0 = 2'd0;
           InbandPowMinIndex0 = 2'd1;
         end
         else begin
           InBd20PowMaxInt0   = InBd20PowdBmRx1Int;
           InbandPowMaxIndex0 = 2'd1;
           InbandPowMinIndex0 = 2'd0;
         end

         InBd20PowMaxInt1   = InBd20PowdBmRx2Int;
         InbandPowMaxIndex1 = 2'd2;
         InbandPowMinIndex1 = 2'd2;

         if (InBd20PowMaxInt0 > InBd20PowMaxInt1) begin
           InBd20PowMax         = InBd20PowMaxInt0;
           InbandPowMaxIndexInt = InbandPowMaxIndex0;
           InbandPowMinIndexInt = InbandPowMinIndex1;
         end
         else begin
           InBd20PowMax         = InBd20PowMaxInt1;
           InbandPowMaxIndexInt = InbandPowMaxIndex1;
           InbandPowMinIndexInt = InbandPowMinIndex0;
         end
      end
   end // NRX == 3
   else if (NRX == 2) begin
      always @ (*)
      begin: InbdMaxPowInt_Blk
         if (InBd20PowdBmRx0Int > InBd20PowdBmRx1Int) begin
           InBd20PowMaxInt0   = InBd20PowdBmRx0Int;
           InbandPowMaxIndex0 = 2'd0;
           InbandPowMinIndex0 = 2'd1;
         end
         else begin
           InBd20PowMaxInt0   = InBd20PowdBmRx1Int;
           InbandPowMaxIndex0 = 2'd1;
           InbandPowMinIndex0 = 2'd0;
         end

         InBd20PowMaxInt1     = $signed({{DBMPOW_WIDTH}{1'b0}});
         InbandPowMaxIndex1   = 2'b0;
         InbandPowMinIndex1   = 2'b0;

         InBd20PowMax         = InBd20PowMaxInt0;
         InbandPowMaxIndexInt = InbandPowMaxIndex0;
         InbandPowMinIndexInt = InbandPowMinIndex0;
      end
   end // NRX == 2
   else if (NRX == 1) begin
      always @ (*)
      begin: InbdMaxPowInt_Blk
         InBd20PowMaxInt0     = $signed({{DBMPOW_WIDTH}{1'b0}});
         InbandPowMaxIndex0   = 2'b0;
         InbandPowMinIndex0   = 2'b0;

         InBd20PowMaxInt1     = $signed({{DBMPOW_WIDTH}{1'b0}});
         InbandPowMaxIndex1   = 2'b0;
         InbandPowMinIndex1   = 2'b0;

         InBd20PowMax         = InBd20PowdBmRx0Int;
         InbandPowMaxIndexInt = 2'b0;
         InbandPowMinIndexInt = 2'b0;
      end
   end // NRX == 1
endgenerate

//Register Max Power
always @ (posedge AGCClk or negedge nAGCRst)
   begin: InbdMaxPowIndexReg_Blk
      if (nAGCRst == 1'b0) begin
         InbandPowMaxIndex <= 2'b0;
         InbandPowMinIndex <= 2'b0;
      end
      else begin
         InbandPowMaxIndex <= InbandPowMaxIndexInt;
         InbandPowMinIndex <= InbandPowMinIndexInt;
      end
   end //InbdMaxPowIndexReg_Blk

//Saturate the dBm Value
always @ (posedge AGCClk or negedge nAGCRst)
   begin: InBd20PowMaxSat_Blk
      if (nAGCRst == 1'b0) begin
         InBd20PowMaxCca        <= $signed({{DBMPOW_WIDTH}{1'b0}});
         InBd20PowCCAValidInter <= 1'b0;
      end
      else begin
         InBd20PowCCAValidInter <= InBd20PowCCAValid;
         if (InBd20PowCCAValid) begin
           if (InBd20PowMax < InbdCCA20PPowMinqdBm)
              InBd20PowMaxCca <= InbdCCA20PPowMinqdBm;
           else
              InBd20PowMaxCca <= InBd20PowMax;
         end
      end
   end //InBd20PowMaxSat_Blk

assign InbdCCA20PPowMinqdBm = {{DBMPOW_WIDTH-11{RegInbdCCA20PPowMindBm[8]}},RegInbdCCA20PPowMindBm,2'b0};


// CCA Energy Detector for Primary
ThreshDetSgnHys # (
                   // Parameter
                   .DATAWIDTH(DBMPOW_WIDTH)
                  ) U_CCAThrDetPri (
                                    // Inputs
                                    .AGCClk(AGCClk),
                                    .nAGCRst(nAGCRst),
                                    .FsmRst(FsmRst),
                                    .DSPValueIn(InBd20PowMaxCca),
                                    .DetSetThrReg($signed({{3{RegCCA20PRiseThrdBm[7]}},RegCCA20PRiseThrdBm, 2'b00})),
                                    .DetClrThrReg($signed({{3{RegCCA20PFallThrdBm[7]}},RegCCA20PFallThrdBm, 2'b00})),
                                    .EventSat(EventSatInt),
                                    .EventDis(EventDisInt),
                                    .DSPValueValid(InBd20PowCCAValidInter),

                                    // Output
                                    .ThreshDetOut(EnergyThrCcaPInt)
                                   );

// Masks saturation and disappearance events from registers
assign EventSatInt = EventSat & CcaSatEn;
assign EventDisInt = EventDis & CcaDisEn;


// CCA Energy Detector for 20MHz Secondary
generate
   if (BW_PARAM == 40 || BW_PARAM == 80) begin: SecEnergyThrCca20

      //Saturate the dBm Value
      always @ (posedge AGCClk or negedge nAGCRst)
         begin: InBd20SecPowdBmCcaSat_Blk
            if (nAGCRst == 1'b0) begin
               InBd20SecPowdBmCca     <= $signed({{DBMPOW_WIDTH}{1'b0}});
               InBd20SecPowValidInter <= 1'b0;
            end
            else begin
               InBd20SecPowValidInter <= InBd20SecPowValid;
               if (InBd20SecPowValid) begin
                  if (InBd20SecPowdBm < InbdCCA20SPowMinqdBm)
                     InBd20SecPowdBmCca <= InbdCCA20SPowMinqdBm;
                  else
                     InBd20SecPowdBmCca <= InBd20SecPowdBm;
               end
            end
         end //InBd20SecPowdBmCcaSat_Blk

      assign InbdCCA20SPowMinqdBm = {{DBMPOW_WIDTH-11{RegInbdCCA20SPowMindBm[8]}},RegInbdCCA20SPowMindBm,2'b0};

      ThreshDetSgnHys # (
                         // Parameter
                         .DATAWIDTH(DBMPOW_WIDTH)
                        ) U_CCAThrDetSec20 (
                                          // Inputs
                                          .AGCClk(AGCClk),
                                          .nAGCRst(nAGCRst),
                                          .FsmRst(FsmRst),
                                          .DSPValueIn(InBd20SecPowdBmCca),
                                          .DetSetThrReg($signed({{3{RegCCA20SRiseThrdBm[7]}},RegCCA20SRiseThrdBm, 2'b00})),
                                          .DetClrThrReg($signed({{3{RegCCA20SFallThrdBm[7]}},RegCCA20SFallThrdBm, 2'b00})),
                                          .EventSat(NullData),
                                          .EventDis(EventDisInt),
                                          .DSPValueValid(InBd20SecPowValidInter),

                                          // Output
                                          .ThreshDetOut(EnergyThrCca20SInt)
                                         );
   end
   else begin
      assign EnergyThrCca20SInt = 1'b0;
   end //BW_PARAM == 40 || BW_PARAM == 80
endgenerate

// CCA Energy Detector for 40MHz Secondary
generate
   if (BW_PARAM == 80) begin: SecEnergyThrCca40
      
      //Saturate the dBm Value
      always @ (posedge AGCClk or negedge nAGCRst)
         begin: InBd40SecPowdBmCcaSat_Blk
            if (nAGCRst == 1'b0) begin
               InBd40SecPowdBmCca     <= $signed({{DBMPOW_WIDTH}{1'b0}});
               InBd40SecPowValidInter <= 1'b0;
            end
            else begin
               InBd40SecPowValidInter <= InBd40SecPowValid;
               if (InBd40SecPowValid) begin
                  if (InBd40SecPowdBm < InbdCCA40SPowMinqdBm)
                     InBd40SecPowdBmCca <= InbdCCA40SPowMinqdBm;
                  else
                     InBd40SecPowdBmCca <= InBd40SecPowdBm;
               end
            end
         end //InBd20SecPowdBmCcaSat_Blk

      assign InbdCCA40SPowMinqdBm = {{DBMPOW_WIDTH-11{RegInbdCCA40SPowMindBm[8]}},RegInbdCCA40SPowMindBm,2'b0};

      ThreshDetSgnHys # (
                         // Parameter
                         .DATAWIDTH(DBMPOW_WIDTH)
                        ) U_CCAThrDetSec40 (
                                          // Inputs
                                          .AGCClk(AGCClk),
                                          .nAGCRst(nAGCRst),
                                          .FsmRst(FsmRst),
                                          .DSPValueIn(InBd40SecPowdBmCca),
                                          .DetSetThrReg($signed({{3{RegCCA40SRiseThrdBm[7]}},RegCCA40SRiseThrdBm, 2'b00})),
                                          .DetClrThrReg($signed({{3{RegCCA40SFallThrdBm[7]}},RegCCA40SFallThrdBm, 2'b00})),
                                          .EventSat(NullData),
                                          .EventDis(EventDisInt),
                                          .DSPValueValid(InBd40SecPowValidInter),

                                          // Output
                                          .ThreshDetOut(EnergyThrCca40SInt)
                                         );
   end
   else begin
      assign EnergyThrCca40SInt = 1'b0;
   end //BW_PARAM = 80
endgenerate

  //Combining for EnergyThr CCA
  always @ (*) begin: EnergyThrComb
    if (Force20 == 1'b1) begin
       EnergyThrCcaPri   = EnergyThrCcaPInt;
       EnergyThrCca20Sec = 1'b0;
       EnergyThrCca40Sec = 1'b0;
    end
    else if (Force40 == 1'b1) begin
       EnergyThrCcaPri   = EnergyThrCcaPInt;
       EnergyThrCca20Sec = EnergyThrCca20SInt;
       EnergyThrCca40Sec = 1'b0;
    end
    else begin
       EnergyThrCcaPri   = EnergyThrCcaPInt;
       EnergyThrCca20Sec = EnergyThrCca20SInt;
       EnergyThrCca40Sec = EnergyThrCca40SInt;
    end
  end //EnergyThrComb

  //CCAENERGYEN switch
  assign EnergyThrCcaPOut   = (CcaEnergyEn[0] == 1'b1) ? EnergyThrCcaPri   : 1'b0;
  assign EnergyThrCca20SOut = (CcaEnergyEn[1] == 1'b1) ? EnergyThrCca20Sec : 1'b0;
  assign EnergyThrCca40SOut = (CcaEnergyEn[2] == 1'b1) ? EnergyThrCca40Sec : 1'b0;


// Instantiate RampDetect module for primary channel
  RampDetect # (
                // Parameter
                .DBMPOW_WIDTH(DBMPOW_WIDTH-2)
               ) U_RampDetectCcaPri (
                             // Inputs
                             .AGCClk(AGCClk),
                             .nAGCRst(nAGCRst),
                             .InBdPowdBm(InBd20PowMaxCca[DBMPOW_WIDTH-1:2]),
                             .InBdPowValid(InBd20PowCCAValidInter),
                             .RegDetRampUp(RegCCADetRampUp),
                             .RegDetRampDown(RegCCADetRampDown),
                             .DelRampUpTap(DelCCARampUpTap),
                             .DelRampDownTap(DelCCARampDownTap),

                             // Outputs
                             .RampUpDet(CcaRampUpPri),
                             .RampDownDet(CcaRampDownPri)
                            );

  RampUpCca U_RampUpCcaPri(
                        //Inputs
                       .AGCClk(AGCClk),
                       .nAGCRst(nAGCRst),
                       .FsmRst(FsmRst),
                       .inBdPow20Valid(InBd20PowValid),
                       .CcaRampUp(CcaRampUpPri),
                       .CcaRampDown(CcaRampDownPri),
                       .EventDis(EventDisInt),

                        //Output
                       .RampUpCcaOut(RampUpCcaPInt)
                       );

// Instantiate RampDetect module for secondary channel 20 MHz
generate
   if (BW_PARAM == 40 || BW_PARAM == 80) begin: SecRampUpCca20
      RampDetect # (
                    // Parameter
                    .DBMPOW_WIDTH(DBMPOW_WIDTH-2)
                   ) U_RampDetectCcaSec20 (
                                 // Inputs
                                 .AGCClk(AGCClk),
                                 .nAGCRst(nAGCRst),
                                 .InBdPowdBm(InBd20SecPowdBmCca[DBMPOW_WIDTH-1:2]),
                                 .InBdPowValid(InBd20SecPowValidInter),
                                 .RegDetRampUp(RegCCADetRampUp),
                                 .RegDetRampDown(RegCCADetRampDown),
                                 .DelRampUpTap(DelCCARampUpTap),
                                 .DelRampDownTap(DelCCARampDownTap),

                                 // Outputs
                                 .RampUpDet(CcaRampUp20Sec),
                                 .RampDownDet(CcaRampDown20Sec)
                                );

      RampUpCca U_RampUpCcaSec20(
                            //Inputs
                           .AGCClk(AGCClk),
                           .nAGCRst(nAGCRst),
                           .FsmRst(FsmRst),
                           .inBdPow20Valid(InBd20SecPowValidInter),
                           .CcaRampUp(CcaRampUp20Sec),
                           .CcaRampDown(CcaRampDown20Sec),
                           .EventDis(EventDisInt),

                            //Output
                           .RampUpCcaOut(RampUpCca20SInt)
                           );

   end
   else begin
      assign CcaRampUp20Sec   = 1'b0;
      assign CcaRampDown20Sec = 1'b0;
      assign RampUpCca20SInt  = 1'b0;
   end //BW_PARAM == 40 || BW_PARAM == 80
endgenerate

// Instantiate RampDetect module for secondary channel 40 MHz
generate
   if (BW_PARAM == 80) begin: SecRampUpCca40
      RampDetect # (
                    // Parameter
                    .DBMPOW_WIDTH(DBMPOW_WIDTH-2)
                   ) U_RampDetectCcaSec40 (
                                 // Inputs
                                 .AGCClk(AGCClk),
                                 .nAGCRst(nAGCRst),
                                 .InBdPowdBm(InBd40SecPowdBmCca[DBMPOW_WIDTH-1:2]),
                                 .InBdPowValid(InBd40SecPowValidInter),
                                 .RegDetRampUp(RegCCADetRampUp),
                                 .RegDetRampDown(RegCCADetRampDown),
                                 .DelRampUpTap(DelCCARampUpTap),
                                 .DelRampDownTap(DelCCARampDownTap),

                                 // Outputs
                                 .RampUpDet(CcaRampUp40Sec),
                                 .RampDownDet(CcaRampDown40Sec)
                                );

      RampUpCca U_RampUpCcaSec40(
                            //Inputs
                           .AGCClk(AGCClk),
                           .nAGCRst(nAGCRst),
                           .FsmRst(FsmRst),
                           .inBdPow20Valid(InBd40SecPowValidInter),
                           .CcaRampUp(CcaRampUp40Sec),
                           .CcaRampDown(CcaRampDown40Sec),
                           .EventDis(EventDisInt),
                            
                            //Output
                           .RampUpCcaOut(RampUpCca40SInt)
                           );

   end
   else begin
      assign CcaRampUp40Sec   = 1'b0;
      assign CcaRampDown40Sec = 1'b0;
      assign RampUpCca40SInt  = 1'b0;
   end //BW_PARAM == 80
endgenerate


  //Combining for RampUp CCA
  always @ (*) begin: RampUpCcaComb
    if (Force20 == 1'b1) begin
       RampUpCcaPri   = RampUpCcaPInt;
       RampUpCca20Sec = 1'b0;
       RampUpCca40Sec = 1'b0;
    end
    else if (Force40 == 1'b1) begin
       RampUpCcaPri   = RampUpCcaPInt;
       RampUpCca20Sec = RampUpCca20SInt;
       RampUpCca40Sec = 1'b0;
    end
    else begin
       RampUpCcaPri   = RampUpCcaPInt;
       RampUpCca20Sec = RampUpCca20SInt;
       RampUpCca40Sec = RampUpCca40SInt;
    end
  end //RampUpCcaComb

  //CCARAMPUPEN switch
  assign RampUpCcaPOut   = (CcaRampUpEn[0] == 1'b1) ? RampUpCcaPri   : 1'b0;
  assign RampUpCca20SOut = (CcaRampUpEn[1] == 1'b1) ? RampUpCca20Sec : 1'b0;
  assign RampUpCca40SOut = (CcaRampUpEn[2] == 1'b1) ? RampUpCca40Sec : 1'b0;

  //CCA modem FSM
  MdmStateCca U_MdmStateCca(
                            //Inputs
                           .AGCClk(AGCClk),
                           .nAGCRst(nAGCRst),
                           .FsmRst(FsmRst),
                           .AGCOFDMLock(AGCOFDMLock),
                           .AGCDSSSLock(AGCDSSSLock),
                           .SFDFound(SFDFound),
                           .LSIGValid(LSIGValid),
                           .HTSIGValid(HTSIGValid),
                           .RxEndTimingP(RxEndTimingP),
                           .BWDetected(BWDetected),
                           .BWSup20(BWSup20),
                           .BWEq40(BWEq40),
                           .BWEq80(BWEq80),

                            //Output
                           .RxStateOut(RxStateOutInt),
                           .DbgCcaFsm(DbgCcaFsm)
                           );

  //CCAs modem mux from register condition
  always@(*)
  begin
    for (i=0;i<11;i=i+1) begin
      RxStateOutPMux[i]   = (RxStateCca20PSel[i] == 1'b1)? RxStateOutInt[i] : 1'b0;
      RxStateOut20SMux[i] = (RxStateCca20SSel[i] == 1'b1)? RxStateOutInt[i] : 1'b0;
      RxStateOut40SMux[i] = (RxStateCca40SSel[i] == 1'b1)? RxStateOutInt[i] : 1'b0;
    end
  end

  //Or'ed of the 11 bits
  assign RxStateCcaPInt   = | RxStateOutPMux;
  assign RxStateCca20SInt = | RxStateOut20SMux;
  assign RxStateCca40SInt = | RxStateOut40SMux;

  //CCADEMODEN switch
  assign RxStateCcaPMux   = (CcaDemodEn == 1'b1)? RxStateCcaPInt  : 1'b0;
  assign RxStateCca20SMux = (CcaDemodEn == 1'b1)? RxStateCca20SInt: 1'b0;
  assign RxStateCca40SMux = (CcaDemodEn == 1'b1)? RxStateCca40SInt: 1'b0;

  //Combining for CCA based on modem states
  always @ (*) begin: RxStateComb
    if (Force20 == 1'b1) begin
       RxStateCcaPOut   = RxStateCcaPMux;
       RxStateCca20SOut = 1'b0;
       RxStateCca40SOut = 1'b0;
    end
    else if (Force40 == 1'b1) begin
       RxStateCcaPOut   = RxStateCcaPMux;
       RxStateCca20SOut = RxStateCca20SMux;
       RxStateCca40SOut = 1'b0;
    end
    else begin
       RxStateCcaPOut   = RxStateCcaPMux;
       RxStateCca20SOut = RxStateCca20SMux;
       RxStateCca40SOut = RxStateCca40SMux;
    end
  end //RxStateComb

  //CCA CS Flags
  CsCca U_CsCca(
                //Inputs
               .AGCClk(AGCClk),
               .nAGCRst(nAGCRst),
               .FsmRst(FsmRst),
               .CsValidP(CsValidP),
               .CsFlagNr(CsFlagNr),
               .CaDetHigh(CaDetHigh),
               .CaDetLow(CaDetLow),
               .CbDetHigh(CbDetHigh),
               .CbDetLow(CbDetLow),
               .CcaFlag0Ctrl(CcaFlag0Ctrl),
               .CcaFlag1Ctrl(CcaFlag1Ctrl),
               .CcaFlag2Ctrl(CcaFlag2Ctrl),
               .CcaFlag3Ctrl(CcaFlag3Ctrl),

                //Output
                .CsCcaGen(CsCcaInt)
               );

  //CCACSEN switch
  assign CsCcaMux = (CcaCsEn == 1'b1)? CsCcaInt: 1'b0;

  // CCA generation or'ed
  assign CCAPrimaryInt     = RxStateCcaPOut   | RampUpCcaPOut   | EnergyThrCcaPOut   | CsCcaMux;
  assign CCASecondary20Int = RxStateCca20SOut | RampUpCca20SOut | EnergyThrCca20SOut;
  assign CCASecondary40Int = RxStateCca40SOut | RampUpCca40SOut | EnergyThrCca40SOut;

  //Registering the CCA Output
  always @ (posedge AGCClk or negedge nAGCRst)
  begin :RegOutBlk
    if (nAGCRst == 1'b0) begin
      CCAPrimaryReg     <= 1'b0;
      CCASecondary20Reg <= 1'b0;
      CCASecondary40Reg <= 1'b0;
      TimeOutReg        <= 1'b0;
    end
    else if (FsmRst == 1'b1) begin
      CCAPrimaryReg     <= 1'b0;
      CCASecondary20Reg <= 1'b0;
      CCASecondary40Reg <= 1'b0;
      TimeOutReg        <= 1'b0;
    end
    else begin
      CCAPrimaryReg     <= CCAPrimaryInt;
      CCASecondary20Reg <= CCASecondary20Int;
      CCASecondary40Reg <= CCASecondary40Int;
      TimeOutReg        <= TimeOutErrPri | TimeOutErr20Sec | TimeOutErr40Sec;
    end
  end //RegOutBlk

  //CCA TimeOut
  CcaTimeOut U_CcaTimeOutPri(
                        //Inputs
                       .AGCClk(AGCClk),
                       .nAGCRst(nAGCRst),
                       .FsmRst(FsmRst),
                       .Cca(CCAPrimaryInt),
                       .CcaTimeoutReg(CcaTimeoutReg),

                        //Output
                       .TimeOutErr(TimeOutErrPri)
                       );

// Instantiate CcaTimeOut module for secondary channel 20 MHz
generate
   if (BW_PARAM == 40 || BW_PARAM == 80) begin: SecCcaTimeOut20
      CcaTimeOut U_CcaTimeOutSec20(
                        //Inputs
                       .AGCClk(AGCClk),
                       .nAGCRst(nAGCRst),
                       .FsmRst(FsmRst),
                       .Cca(CCASecondary20Int),
                       .CcaTimeoutReg(CcaTimeoutReg),

                        //Output
                       .TimeOutErr(TimeOutErr20Sec)
                       );
   end
   else begin
      assign TimeOutErr20Sec  = 1'b0;
   end //BW_PARAM == 40 || BW_PARAM == 80
endgenerate

// Instantiate CcaTimeOut module for secondary channel 40 MHz
generate
   if (BW_PARAM == 80) begin: SecCcaTimeOut40
      CcaTimeOut U_CcaTimeOutSec40(
                        //Inputs
                       .AGCClk(AGCClk),
                       .nAGCRst(nAGCRst),
                       .FsmRst(FsmRst),
                       .Cca(CCASecondary40Int),
                       .CcaTimeoutReg(CcaTimeoutReg),

                        //Output
                       .TimeOutErr(TimeOutErr40Sec)
                       );
   end
   else begin
      assign TimeOutErr40Sec  = 1'b0;
   end //BW_PARAM == 80
endgenerate

// Debug port
assign DbgCca = {RxStateCca40SOut,
                 RampUpCca40SOut,
                 EnergyThrCca40SOut,
                 RxStateCca20SOut,
                 RampUpCca20SOut,
                 EnergyThrCca20SOut,
                 RxStateCcaPOut,
                 RampUpCcaPOut,
                 EnergyThrCcaPOut,
                 CsCcaMux,
                 EventSat,
                 EventDis | FsmRst,
                 DbgCcaFsm[3:0]
                };

endmodule // CcaFsmTop

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
