//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 14730 $
// $Date: 2014-04-29 09:35:35 +0200 (Tue, 29 Apr 2014) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : CCA Time-out
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/CCAFSM/verilog/rtl/CcaTimeOut.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module CcaTimeOut (

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            input    wire                                  nAGCRst,

            // Data and Control
            input    wire                                  FsmRst,
            input    wire                                  Cca,
            input    wire    [31:0]                        CcaTimeoutReg,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   wire                                  TimeOutErr
            );

//////////////////////////////////////////////////////////////////////////////
//  Local parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam IDLE_ST       = 2'd0;
localparam BUSY_ST       = 2'd1;
localparam CCATIMEOUT_ST = 2'd2;

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg [1:0]  CurrState;
reg [1:0]  NextState;
reg        NextTimeOutErr;
reg        TimeOutErrInt;
reg [31:0] TimeOutCnt;
reg        TimeOutFlg;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Output Assignment
  assign TimeOutErr = TimeOutErrInt;

//State Machine Sequential Part
  always @ (posedge AGCClk or negedge nAGCRst) begin :SeqBlk
    if (nAGCRst == 1'b0) begin
      CurrState     <= IDLE_ST;
      TimeOutErrInt <= 1'b0;
    end
    else if(FsmRst == 1'b1) begin
      CurrState     <= IDLE_ST;
      TimeOutErrInt <= 1'b0;
    end
    else begin
      CurrState     <= NextState;
      TimeOutErrInt <= NextTimeOutErr;
    end
  end //SeqBlk

//Next State assignment
  always @ (*) begin :NextStateBlk
    NextState = IDLE_ST;
    case (CurrState)
      IDLE_ST: begin
        if (Cca == 1'b1)
          NextState = BUSY_ST;
        else
          NextState = IDLE_ST;
      end

      BUSY_ST: begin
        if (Cca == 1'b0)
          NextState = IDLE_ST;
        else if (TimeOutFlg == 1'b1)
          NextState = CCATIMEOUT_ST;
        else
          NextState = BUSY_ST;
      end

      CCATIMEOUT_ST: begin
        NextState = IDLE_ST;
      end

      // pragma coverage block = off
      default: begin
        NextState = IDLE_ST;
      end
      // pragma coverage block = on

    endcase
  end //NextStateBlk

//Output assignment
  always @ (*) begin :OutputBlk
    case (CurrState)
      IDLE_ST: begin
          NextTimeOutErr = 1'b0;
      end

      BUSY_ST: begin
          NextTimeOutErr = 1'b0;
      end

      CCATIMEOUT_ST: begin
          NextTimeOutErr = 1'b1;
      end

      // pragma coverage block = off
      default: begin
        NextTimeOutErr = 1'b0;
      end
      // pragma coverage block = on

    endcase
  end //OutputBlk

//Timeout counter
  always @ (posedge AGCClk or negedge nAGCRst) begin :TimeOutBlk
    if (nAGCRst == 1'b0) begin
      TimeOutCnt <= 32'd0;
      TimeOutFlg <= 1'd0;
    end
    else if(FsmRst == 1'b1) begin
      TimeOutCnt <= CcaTimeoutReg;
      TimeOutFlg <= 1'd0;
    end
    else if (CurrState == IDLE_ST) begin
      TimeOutCnt <= CcaTimeoutReg;
      TimeOutFlg <= 1'd0;
    end
    else begin
      if (TimeOutCnt == 32'd0) begin
        TimeOutCnt <= TimeOutCnt;
        TimeOutFlg <= 1'd1;
      end
      else begin
        TimeOutCnt <= TimeOutCnt - 32'd1;
        TimeOutFlg <= 1'd0;
      end
    end
  end //TimeOutBlk

endmodule // RampUpCca

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
