//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 12940 $
// $Date: 2014-01-16 14:13:28 +0100 (Thu, 16 Jan 2014) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : CS Flag based CCA
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/CCAFSM/verilog/rtl/CsCca.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module CsCca(
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            input    wire                                  nAGCRst,

            // Data and Control
            input    wire                                  FsmRst,
            input    wire                                  CsValidP,
            input    wire    [1:0]                         CsFlagNr,
            input    wire                                  CaDetHigh,
            input    wire                                  CaDetLow,
            input    wire                                  CbDetHigh,
            input    wire                                  CbDetLow,
            input    wire    [3:0]                         CcaFlag0Ctrl,
            input    wire    [3:0]                         CcaFlag1Ctrl,
            input    wire    [3:0]                         CcaFlag2Ctrl,
            input    wire    [3:0]                         CcaFlag3Ctrl,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   wire                                  CsCcaGen
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                                    CsCcaInt ;
reg                                    CsCcaReg ;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Output Assignment
  assign CsCcaGen = CsCcaReg;

//Registering the CS flag based CCA
  always @ (posedge AGCClk or negedge nAGCRst) begin :RegBlk
    if (nAGCRst == 1'b0)
      CsCcaReg <= 1'b0;
    else if(FsmRst == 1'b1)
      CsCcaReg <= 1'b0;
    else if(CsValidP == 1'b1)
      CsCcaReg <= CsCcaInt;
    else
      CsCcaReg <= CsCcaReg;
  end //RegBlk

//LUT for asserting CCA based on CS flags
  always @ (*) begin :OutputBlk
    case (CsFlagNr)
      2'b00: begin
          if (CaDetHigh == 1'b1)
            CsCcaInt = CcaFlag0Ctrl[3];
          else if (CaDetLow == 1'b1)
            CsCcaInt = CcaFlag0Ctrl[2];
          else if (CbDetHigh == 1'b1)
            CsCcaInt = CcaFlag0Ctrl[1];
          else if (CbDetLow == 1'b1)
            CsCcaInt = CcaFlag0Ctrl[0];
          else
            CsCcaInt = 1'b0;
      end

      2'b01: begin
          if (CaDetHigh == 1'b1)
            CsCcaInt = CcaFlag1Ctrl[3];
          else if (CaDetLow == 1'b1)
            CsCcaInt = CcaFlag1Ctrl[2];
          else if (CbDetHigh == 1'b1)
            CsCcaInt = CcaFlag1Ctrl[1];
          else if (CbDetLow == 1'b1)
            CsCcaInt = CcaFlag1Ctrl[0];
          else
            CsCcaInt = 1'b0;
      end

      2'b10: begin
          if (CaDetHigh == 1'b1)
            CsCcaInt = CcaFlag2Ctrl[3];
          else if (CaDetLow == 1'b1)
            CsCcaInt = CcaFlag2Ctrl[2];
          else if (CbDetHigh == 1'b1)
            CsCcaInt = CcaFlag2Ctrl[1];
          else if (CbDetLow == 1'b1)
            CsCcaInt = CcaFlag2Ctrl[0];
          else
            CsCcaInt = 1'b0;
      end

      default: begin
          if (CaDetHigh == 1'b1)
            CsCcaInt = CcaFlag3Ctrl[3];
          else if (CaDetLow == 1'b1)
            CsCcaInt = CcaFlag3Ctrl[2];
          else if (CbDetHigh == 1'b1)
            CsCcaInt = CcaFlag3Ctrl[1];
          else if (CbDetLow == 1'b1)
            CsCcaInt = CcaFlag3Ctrl[0];
          else
            CsCcaInt = 1'b0;
      end
    endcase
  end //OutputBlk


endmodule // CsCca

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
