//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10207 $
// $Date: 2013-09-23 10:01:19 +0200 (Mon, 23 Sep 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Energy Detection based CCA
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/CCAFSM/verilog/rtl/EnergyThrCca.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module EnergyThrCca(
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            input    wire                                  nAGCRst,

            // Data and Control
            input    wire                                  FsmRst,
            input    wire                                  inBdPow20Valid,
            input    wire                                  EnergyThrDet,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output                                         EnergyThrCcaOut
            );


//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declaration
//////////////////////////////////////////////////////////////////////////////
localparam IDLE  = 2'd0;
localparam BUSY  = 2'd1;


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg      [1:0]                         CurrState;
reg      [1:0]                         NextState;
reg                                    NextEnergyThrCca;
reg                                    EnergyThrCcaInt;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Output Assignment
  assign EnergyThrCcaOut = EnergyThrCcaInt;

//State Machine Sequential Part
  always @ (posedge AGCClk or negedge nAGCRst) begin :SeqBlk
    if (nAGCRst == 1'b0) begin
      CurrState <= IDLE;
      EnergyThrCcaInt <= 1'b0;
    end
    else if(FsmRst == 1'b1) begin
      CurrState <= IDLE;
      EnergyThrCcaInt <= 1'b0;
    end
    else begin
      CurrState <= NextState;
      EnergyThrCcaInt <= NextEnergyThrCca;
    end
  end //SeqBlk

//Next State assignment
  always @ (*) begin :NextStateBlk
    NextState = IDLE;
    case (CurrState)
      IDLE: begin
        if (inBdPow20Valid == 1'b1 && EnergyThrDet == 1'b1)
          NextState = BUSY;
        else
          NextState = IDLE;
      end

      BUSY: begin
        if (inBdPow20Valid == 1'b1 && EnergyThrDet == 1'b0)
          NextState = IDLE;
        else
          NextState = BUSY;
      end

      default: begin
        NextState = IDLE;
      end

    endcase
  end //NextStateBlk

//Output assignment
  always @ (*) begin :OutputBlk
    NextEnergyThrCca = 1'b0;
    case (CurrState)
      IDLE: begin
          NextEnergyThrCca = 1'b0;
      end

      BUSY: begin
          NextEnergyThrCca = 1'b1;
      end

      default: begin
        NextEnergyThrCca = 1'b0;
      end

    endcase
  end //OutputBlk

endmodule // EnergyThrCca

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
