//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 14729 $
// $Date: 2014-04-29 09:35:19 +0200 (Tue, 29 Apr 2014) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Energy Ramp Up-Down based CCA
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/CCAFSM/verilog/rtl/RampUpCca.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module RampUpCca (

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            input    wire                                  nAGCRst,

            // Data and Control
            input    wire                                  FsmRst,
            input    wire                                  inBdPow20Valid,
            input    wire                                  CcaRampUp,
            input    wire                                  CcaRampDown,
            input    wire                                  EventDis,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   wire                                  RampUpCcaOut
            );

//////////////////////////////////////////////////////////////////////////////
//  Local parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam IDLE       = 1'd0;
localparam BUSYRAMPUP = 1'd1;

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg        CurrState;
reg        NextState;
reg        NextRampUpCca;
reg        RampUpCcaInt;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Output Assignment
  assign RampUpCcaOut = RampUpCcaInt;

//State Machine Sequential Part
  always @ (posedge AGCClk or negedge nAGCRst) begin :SeqBlk
    if (nAGCRst == 1'b0) begin
      CurrState    <= IDLE;
      RampUpCcaInt <= 1'b0;
    end
    else if(FsmRst == 1'b1) begin
      CurrState    <= IDLE;
      RampUpCcaInt <= 1'b0;
    end
    else begin
      CurrState    <= NextState;
      RampUpCcaInt <= NextRampUpCca;
    end
  end //SeqBlk

//Next State assignment
  always @ (*) begin :NextStateBlk
    NextState = IDLE;
    case (CurrState)
      IDLE: begin
        if (inBdPow20Valid == 1'b1 && CcaRampUp == 1'b1)
          NextState = BUSYRAMPUP;
        else
          NextState = IDLE;
      end

      BUSYRAMPUP: begin
        if ((inBdPow20Valid == 1'b1 && CcaRampDown == 1'b1) || EventDis)
          NextState = IDLE;
        else
          NextState = BUSYRAMPUP;
      end

      // pragma coverage block = off
      default: begin
        NextState = IDLE;
      end
      // pragma coverage block = on

    endcase
  end //NextStateBlk

//Output assignment
  always @ (*) begin :OutputBlk
    NextRampUpCca = 1'b0;
    case (CurrState)
      IDLE: begin
          NextRampUpCca  = 1'b0;
      end

      BUSYRAMPUP: begin
          NextRampUpCca  = 1'b1;
      end

      // pragma coverage block = off
      default: begin
        NextRampUpCca  = 1'b0;
      end
      // pragma coverage block = on

    endcase
  end //OutputBlk

endmodule // RampUpCca

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
