//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10209 $
// $Date: 2013-09-23 10:03:49 +0200 (Mon, 23 Sep 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Quantized Complex multiplication modules
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/Correlator/verilog/rtl/ACQuantMult.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module ACQuantMult #(parameter DATAINWIDTH = 13 // Input width
                    )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            // Data and Control
            input    wire signed     [DATAINWIDTH-1:0]   DataInI,       
            input    wire signed     [DATAINWIDTH-1:0]   DataInQ,       
            input    wire                                QuantDataInI,  
            input    wire                                QuantDataInQ,  
            input    wire                                NullDataInI,   
            input    wire                                NullDataInQ,   

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   wire signed     [DATAINWIDTH:0]     DataOutI,
            output   wire signed     [DATAINWIDTH:0]     DataOutQ
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam    signed     [31:0] NULL_32_PARAM_0 = 32'b0;

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire    signed     [DATAINWIDTH-1:0]   NegDataInI;
wire    signed     [DATAINWIDTH-1:0]   NegDataInQ;
wire    signed     [DATAINWIDTH-1:0]   MuxDataI1;
wire    signed     [DATAINWIDTH-1:0]   MuxDataQ1;
wire    signed     [DATAINWIDTH-1:0]   MuxDataI2;
wire    signed     [DATAINWIDTH-1:0]   MuxDataQ2;
wire    signed     [DATAINWIDTH-1:0]   Mux2DataI1;
wire    signed     [DATAINWIDTH-1:0]   Mux2DataQ1;
wire    signed     [DATAINWIDTH-1:0]   Mux2DataI2;
wire    signed     [DATAINWIDTH-1:0]   Mux2DataQ2;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Negating the Inputs (Added check on value -4096 -> +4095)
  assign NegDataInI = $signed((DataInI == {1'b1,{(DATAINWIDTH-1){1'b0}}}) ?
                      {1'b0,{(DATAINWIDTH-1){1'b1}}} : (NULL_32_PARAM_0[DATAINWIDTH-1:0] - DataInI));
  assign NegDataInQ = $signed((DataInQ == {1'b1,{(DATAINWIDTH-1){1'b0}}}) ?
                      {1'b0,{(DATAINWIDTH-1){1'b1}}} : (NULL_32_PARAM_0[DATAINWIDTH-1:0] - DataInQ));

//Mux replacing Multiplication
//For DataOutI
  assign MuxDataI1  = (QuantDataInI) ? NegDataInI : DataInI;
  assign MuxDataQ1  = (QuantDataInQ) ? NegDataInQ : DataInQ;
  assign Mux2DataI1 = (NullDataInI)  ? $signed({{DATAINWIDTH}{1'b0}}) : MuxDataI1;
  assign Mux2DataQ1 = (NullDataInQ)  ? $signed({{DATAINWIDTH}{1'b0}}) : MuxDataQ1;
//For DataOutQ
  assign MuxDataI2  = (QuantDataInI) ? NegDataInQ : DataInQ;
  assign MuxDataQ2  = (QuantDataInQ) ? NegDataInI : DataInI;
  assign Mux2DataI2 = (NullDataInI)  ? $signed({{DATAINWIDTH}{1'b0}}) : MuxDataI2;
  assign Mux2DataQ2 = (NullDataInQ)  ? $signed({{DATAINWIDTH}{1'b0}}) : MuxDataQ2;

//Outputs after Adder
  assign DataOutI = $signed({Mux2DataI1[DATAINWIDTH-1],Mux2DataI1[DATAINWIDTH-1:0]} + {Mux2DataQ1[DATAINWIDTH-1],Mux2DataQ1[DATAINWIDTH-1:0]});
  assign DataOutQ = $signed({Mux2DataI2[DATAINWIDTH-1],Mux2DataI2[DATAINWIDTH-1:0]} - {Mux2DataQ2[DATAINWIDTH-1],Mux2DataQ2[DATAINWIDTH-1:0]});

endmodule // ACQuantMult

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////

