//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 11972 $
// $Date: 2013-11-27 19:11:40 +0100 (Wed, 27 Nov 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Agc Correlation top module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/Correlator/verilog/rtl/AgcCorrTop.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module AgcCorrTop #(parameter NRX             = 4, // Number of RX chains
                    parameter DATAINWIDTH     = 13, // Input data from TXRX FE and delay lines
                    parameter DATAOUTOFDMAC   = 22,
                    parameter DATAOUTOFDMCC   = 20,
                    parameter DATAOUTDSSSAC   = 22,
                    parameter DATAOUTDSSSCC   = 20,
                    parameter DATAOUTOFDMREF  = 19,
                    parameter DATAOUTDSSSREF  = 20
                   )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            //Reset resynchronized to AGCClk
            input    wire                                  nAGCRst,

            //Control Signals
            //Enable for Correlation block, from AGC FSM
            input    wire                                  OfdmCCBlockEn,
            input    wire                                  OfdmACBlockEn,
            input    wire                                  DsssCCBlockEn,
            input    wire                                  DsssACBlockEn,
            input    wire                                  RefLevBlockEn,
            //Force outputs as zero, from AGC FSM
            input    wire                                  ZeroOutOfdmCC,
            input    wire                                  ZeroOutOfdmAC,
            input    wire                                  ZeroOutDsssCC,
            input    wire                                  ZeroOutDsssAC,
            //Signal to subtract 0 instead of data from delay line, from AGC FSM
            input    wire                                  AddZeroOfdmAC,
            input    wire                                  AddZeroDsssAC,
            input    wire                                  DsssSubZeroRef,
            input    wire                                  OfdmSubZeroRef,
            //Mode select for AutoCorr
            input    wire              [1:0]               OfdmACModeSel,
            input    wire                                  DsssACModeSel,
            //Enable for input data
            input    wire                                  DataInEn,

            //Data input RxChain1
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn16DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn16DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn17DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn17DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn18DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn18DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn19DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn19DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn32DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn32DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn48DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn48DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn64DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn64DQ1,

            //Data input RxChain2
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn16DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn16DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn17DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn17DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn18DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn18DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn19DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn19DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn32DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn32DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn48DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn48DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn64DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn64DQ2,

            //Data input RxChain3
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn16DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn16DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn17DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn17DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn18DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn18DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn19DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn19DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn32DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn32DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn48DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn48DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn64DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn64DQ3,

            //Data input RxChain4
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn16DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn16DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn17DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn17DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn18DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn18DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn19DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn19DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn32DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn32DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn48DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn48DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn64DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn64DQ4,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Output for Auto Correlation
            output   wire      [DATAOUTOFDMAC-1:0]  OfdmACAccSum,
            output   wire                           OfdmACDataEn,
            //Output for Cross Correlation
            output   wire      [DATAOUTOFDMCC-1:0]  OfdmCCAccSum,
            output   wire                           OfdmCCDataEn,
            //Output for Auto Correlation
            output   wire      [DATAOUTDSSSAC-1:0]  DsssACAccSum,
            output   wire                           DsssACDataEn,
            //Output for Cross Correlation
            output   wire      [DATAOUTDSSSCC-1:0]  DsssCCAccSum,
            output   wire                           DsssCCDataEn,
            //Output for RefLev
            output   wire                           RefLevDataEn,
            output   wire      [DATAOUTDSSSREF-1:0] RefLevDsss,
            output   wire      [DATAOUTOFDMREF-1:0] RefLevOfdm
            );


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////


/////////////////////////
//Ofdm Correlators
/////////////////////////

//Ofdm Auto Correlator
OfdmAutoCorrTop #(
                  .NRX          (NRX),
                  .DATAINWIDTH  (DATAINWIDTH),
                  .DATAOUTWIDTH (DATAOUTOFDMAC)
                  )
                U_OfdmAutoCorrTop(
                  //Inputs
                  .AGCClk(AGCClk),
                  .nAGCRst(nAGCRst),
                  .OfdmACBlockEn(OfdmACBlockEn),
                  .SetZeroOutput(ZeroOutOfdmAC),
                  .AddZeroValue(AddZeroOfdmAC),
                  .OfdmACModeSel(OfdmACModeSel),
                  .DataInEn(DataInEn),

                  .DataInI1(DataInI1),
                  .DataInQ1(DataInQ1),
                  .DataIn16DI1(DataIn16DI1),
                  .DataIn16DQ1(DataIn16DQ1),
                  .DataIn32DI1(DataIn32DI1),
                  .DataIn32DQ1(DataIn32DQ1),
                  .DataIn48DI1(DataIn48DI1),
                  .DataIn48DQ1(DataIn48DQ1),
                  .DataIn64DI1(DataIn64DI1),
                  .DataIn64DQ1(DataIn64DQ1),

                  .DataInI2(DataInI2),
                  .DataInQ2(DataInQ2),
                  .DataIn16DI2(DataIn16DI2),
                  .DataIn16DQ2(DataIn16DQ2),
                  .DataIn32DI2(DataIn32DI2),
                  .DataIn32DQ2(DataIn32DQ2),
                  .DataIn48DI2(DataIn48DI2),
                  .DataIn48DQ2(DataIn48DQ2),
                  .DataIn64DI2(DataIn64DI2),
                  .DataIn64DQ2(DataIn64DQ2),

                  .DataInI3(DataInI3),
                  .DataInQ3(DataInQ3),
                  .DataIn16DI3(DataIn16DI3),
                  .DataIn16DQ3(DataIn16DQ3),
                  .DataIn32DI3(DataIn32DI3),
                  .DataIn32DQ3(DataIn32DQ3),
                  .DataIn48DI3(DataIn48DI3),
                  .DataIn48DQ3(DataIn48DQ3),
                  .DataIn64DI3(DataIn64DI3),
                  .DataIn64DQ3(DataIn64DQ3),

                  .DataInI4(DataInI4),
                  .DataInQ4(DataInQ4),
                  .DataIn16DI4(DataIn16DI4),
                  .DataIn16DQ4(DataIn16DQ4),
                  .DataIn32DI4(DataIn32DI4),
                  .DataIn32DQ4(DataIn32DQ4),
                  .DataIn48DI4(DataIn48DI4),
                  .DataIn48DQ4(DataIn48DQ4),
                  .DataIn64DI4(DataIn64DI4),
                  .DataIn64DQ4(DataIn64DQ4),

                  //Outputs
                  .OfdmACDataEn(OfdmACDataEn),
                  .OfdmACAccSum(OfdmACAccSum)
                   );

//Ofdm Cross Correlator
OfdmCrossCorrTop #(
                  .NRX          (NRX),
                  .DATAINWIDTH  (DATAINWIDTH),
                  .DATAOUTWIDTH (DATAOUTOFDMCC)
                  )
                U_OfdmCrossCorrTop(
                  //Inputs
                  .AGCClk(AGCClk),
                  .nAGCRst(nAGCRst),
                  .OfdmCCBlockEn(OfdmCCBlockEn),
                  .SetZeroOutput(ZeroOutOfdmCC),
                  .DataInEn(DataInEn),

                  .DataInI1(DataInI1),
                  .DataInQ1(DataInQ1),
                  .DataIn1DI1(DataIn1DI1),
                  .DataIn1DQ1(DataIn1DQ1),
                  .DataIn2DI1(DataIn2DI1),
                  .DataIn2DQ1(DataIn2DQ1),
                  .DataIn3DI1(DataIn3DI1),
                  .DataIn3DQ1(DataIn3DQ1),
                  .DataIn4DI1(DataIn4DI1),
                  .DataIn4DQ1(DataIn4DQ1),
                  .DataIn5DI1(DataIn5DI1),
                  .DataIn5DQ1(DataIn5DQ1),
                  .DataIn6DI1(DataIn6DI1),
                  .DataIn6DQ1(DataIn6DQ1),
                  .DataIn7DI1(DataIn7DI1),
                  .DataIn7DQ1(DataIn7DQ1),
                  .DataIn8DI1(DataIn8DI1),
                  .DataIn8DQ1(DataIn8DQ1),
                  .DataIn9DI1(DataIn9DI1),
                  .DataIn9DQ1(DataIn9DQ1),
                  .DataIn10DI1(DataIn10DI1),
                  .DataIn10DQ1(DataIn10DQ1),
                  .DataIn11DI1(DataIn11DI1),
                  .DataIn11DQ1(DataIn11DQ1),
                  .DataIn12DI1(DataIn12DI1),
                  .DataIn12DQ1(DataIn12DQ1),
                  .DataIn13DI1(DataIn13DI1),
                  .DataIn13DQ1(DataIn13DQ1),
                  .DataIn14DI1(DataIn14DI1),
                  .DataIn14DQ1(DataIn14DQ1),
                  .DataIn15DI1(DataIn15DI1),
                  .DataIn15DQ1(DataIn15DQ1),

                  .DataInI2(DataInI2),
                  .DataInQ2(DataInQ2),
                  .DataIn1DI2(DataIn1DI2),
                  .DataIn1DQ2(DataIn1DQ2),
                  .DataIn2DI2(DataIn2DI2),
                  .DataIn2DQ2(DataIn2DQ2),
                  .DataIn3DI2(DataIn3DI2),
                  .DataIn3DQ2(DataIn3DQ2),
                  .DataIn4DI2(DataIn4DI2),
                  .DataIn4DQ2(DataIn4DQ2),
                  .DataIn5DI2(DataIn5DI2),
                  .DataIn5DQ2(DataIn5DQ2),
                  .DataIn6DI2(DataIn6DI2),
                  .DataIn6DQ2(DataIn6DQ2),
                  .DataIn7DI2(DataIn7DI2),
                  .DataIn7DQ2(DataIn7DQ2),
                  .DataIn8DI2(DataIn8DI2),
                  .DataIn8DQ2(DataIn8DQ2),
                  .DataIn9DI2(DataIn9DI2),
                  .DataIn9DQ2(DataIn9DQ2),
                  .DataIn10DI2(DataIn10DI2),
                  .DataIn10DQ2(DataIn10DQ2),
                  .DataIn11DI2(DataIn11DI2),
                  .DataIn11DQ2(DataIn11DQ2),
                  .DataIn12DI2(DataIn12DI2),
                  .DataIn12DQ2(DataIn12DQ2),
                  .DataIn13DI2(DataIn13DI2),
                  .DataIn13DQ2(DataIn13DQ2),
                  .DataIn14DI2(DataIn14DI2),
                  .DataIn14DQ2(DataIn14DQ2),
                  .DataIn15DI2(DataIn15DI2),
                  .DataIn15DQ2(DataIn15DQ2),

                  .DataInI3(DataInI3),
                  .DataInQ3(DataInQ3),
                  .DataIn1DI3(DataIn1DI3),
                  .DataIn1DQ3(DataIn1DQ3),
                  .DataIn2DI3(DataIn2DI3),
                  .DataIn2DQ3(DataIn2DQ3),
                  .DataIn3DI3(DataIn3DI3),
                  .DataIn3DQ3(DataIn3DQ3),
                  .DataIn4DI3(DataIn4DI3),
                  .DataIn4DQ3(DataIn4DQ3),
                  .DataIn5DI3(DataIn5DI3),
                  .DataIn5DQ3(DataIn5DQ3),
                  .DataIn6DI3(DataIn6DI3),
                  .DataIn6DQ3(DataIn6DQ3),
                  .DataIn7DI3(DataIn7DI3),
                  .DataIn7DQ3(DataIn7DQ3),
                  .DataIn8DI3(DataIn8DI3),
                  .DataIn8DQ3(DataIn8DQ3),
                  .DataIn9DI3(DataIn9DI3),
                  .DataIn9DQ3(DataIn9DQ3),
                  .DataIn10DI3(DataIn10DI3),
                  .DataIn10DQ3(DataIn10DQ3),
                  .DataIn11DI3(DataIn11DI3),
                  .DataIn11DQ3(DataIn11DQ3),
                  .DataIn12DI3(DataIn12DI3),
                  .DataIn12DQ3(DataIn12DQ3),
                  .DataIn13DI3(DataIn13DI3),
                  .DataIn13DQ3(DataIn13DQ3),
                  .DataIn14DI3(DataIn14DI3),
                  .DataIn14DQ3(DataIn14DQ3),
                  .DataIn15DI3(DataIn15DI3),
                  .DataIn15DQ3(DataIn15DQ3),

                  .DataInI4(DataInI4),
                  .DataInQ4(DataInQ4),
                  .DataIn1DI4(DataIn1DI4),
                  .DataIn1DQ4(DataIn1DQ4),
                  .DataIn2DI4(DataIn2DI4),
                  .DataIn2DQ4(DataIn2DQ4),
                  .DataIn3DI4(DataIn3DI4),
                  .DataIn3DQ4(DataIn3DQ4),
                  .DataIn4DI4(DataIn4DI4),
                  .DataIn4DQ4(DataIn4DQ4),
                  .DataIn5DI4(DataIn5DI4),
                  .DataIn5DQ4(DataIn5DQ4),
                  .DataIn6DI4(DataIn6DI4),
                  .DataIn6DQ4(DataIn6DQ4),
                  .DataIn7DI4(DataIn7DI4),
                  .DataIn7DQ4(DataIn7DQ4),
                  .DataIn8DI4(DataIn8DI4),
                  .DataIn8DQ4(DataIn8DQ4),
                  .DataIn9DI4(DataIn9DI4),
                  .DataIn9DQ4(DataIn9DQ4),
                  .DataIn10DI4(DataIn10DI4),
                  .DataIn10DQ4(DataIn10DQ4),
                  .DataIn11DI4(DataIn11DI4),
                  .DataIn11DQ4(DataIn11DQ4),
                  .DataIn12DI4(DataIn12DI4),
                  .DataIn12DQ4(DataIn12DQ4),
                  .DataIn13DI4(DataIn13DI4),
                  .DataIn13DQ4(DataIn13DQ4),
                  .DataIn14DI4(DataIn14DI4),
                  .DataIn14DQ4(DataIn14DQ4),
                  .DataIn15DI4(DataIn15DI4),
                  .DataIn15DQ4(DataIn15DQ4),

                  //Outputs
                  .OfdmCCDataEn(OfdmCCDataEn),
                  .OfdmCCAccSum(OfdmCCAccSum)
                   );

//////////////////////////////////////////////////////////////////////////////
//Dsss Correlators
//////////////////////////////////////////////////////////////////////////////
//Dsss Auto Correlator
DsssAutoCorrTop #(
                  .NRX          (NRX),
                  .DATAINWIDTH  (DATAINWIDTH),
                  .DATAOUTWIDTH (DATAOUTDSSSAC)
                  )
                U_DsssAutoCorrTop(
                  //Inputs
                  .AGCClk(AGCClk),
                  .nAGCRst(nAGCRst),
                  .DsssACBlockEn(DsssACBlockEn),
                  .SetZeroOutput(ZeroOutDsssAC),
                  .AddZeroValue(AddZeroDsssAC),
                  .DsssACModeSel(DsssACModeSel),
                  .DataInEn(DataInEn),

                  .DataInI1(DataInI1),
                  .DataInQ1(DataInQ1),
                  .DataIn20DI1(DataIn20DI1),
                  .DataIn20DQ1(DataIn20DQ1),
                  .DataIn40DI1(DataIn40DI1),
                  .DataIn40DQ1(DataIn40DQ1),
                  .DataIn60DI1(DataIn60DI1),
                  .DataIn60DQ1(DataIn60DQ1),

                  .DataInI2(DataInI2),
                  .DataInQ2(DataInQ2),
                  .DataIn20DI2(DataIn20DI2),
                  .DataIn20DQ2(DataIn20DQ2),
                  .DataIn40DI2(DataIn40DI2),
                  .DataIn40DQ2(DataIn40DQ2),
                  .DataIn60DI2(DataIn60DI2),
                  .DataIn60DQ2(DataIn60DQ2),

                  .DataInI3(DataInI3),
                  .DataInQ3(DataInQ3),
                  .DataIn20DI3(DataIn20DI3),
                  .DataIn20DQ3(DataIn20DQ3),
                  .DataIn40DI3(DataIn40DI3),
                  .DataIn40DQ3(DataIn40DQ3),
                  .DataIn60DI3(DataIn60DI3),
                  .DataIn60DQ3(DataIn60DQ3),

                  .DataInI4(DataInI4),
                  .DataInQ4(DataInQ4),
                  .DataIn20DI4(DataIn20DI4),
                  .DataIn20DQ4(DataIn20DQ4),
                  .DataIn40DI4(DataIn40DI4),
                  .DataIn40DQ4(DataIn40DQ4),
                  .DataIn60DI4(DataIn60DI4),
                  .DataIn60DQ4(DataIn60DQ4),

                  //Outputs
                  .DsssACDataEn(DsssACDataEn),
                  .DsssACAccSum(DsssACAccSum)
                   );

//Dsss Cross Correlator
DsssCrossCorrTop #(
                  .NRX          (NRX),
                  .DATAINWIDTH  (DATAINWIDTH),
                  .DATAOUTWIDTH (DATAOUTDSSSCC)
                  )
                U_DsssCrossCorrTop(
                  //Inputs
                  .AGCClk(AGCClk),
                  .nAGCRst(nAGCRst),
                  .DsssCCBlockEn(DsssCCBlockEn),
                  .SetZeroOutput(ZeroOutDsssCC),
                  .DataInEn(DataInEn),

                  .DataInI1(DataInI1),
                  .DataInQ1(DataInQ1),
                  .DataIn1DI1(DataIn1DI1),
                  .DataIn1DQ1(DataIn1DQ1),
                  .DataIn2DI1(DataIn2DI1),
                  .DataIn2DQ1(DataIn2DQ1),
                  .DataIn3DI1(DataIn3DI1),
                  .DataIn3DQ1(DataIn3DQ1),
                  .DataIn4DI1(DataIn4DI1),
                  .DataIn4DQ1(DataIn4DQ1),
                  .DataIn5DI1(DataIn5DI1),
                  .DataIn5DQ1(DataIn5DQ1),
                  .DataIn6DI1(DataIn6DI1),
                  .DataIn6DQ1(DataIn6DQ1),
                  .DataIn7DI1(DataIn7DI1),
                  .DataIn7DQ1(DataIn7DQ1),
                  .DataIn8DI1(DataIn8DI1),
                  .DataIn8DQ1(DataIn8DQ1),
                  .DataIn9DI1(DataIn9DI1),
                  .DataIn9DQ1(DataIn9DQ1),
                  .DataIn10DI1(DataIn10DI1),
                  .DataIn10DQ1(DataIn10DQ1),
                  .DataIn11DI1(DataIn11DI1),
                  .DataIn11DQ1(DataIn11DQ1),
                  .DataIn12DI1(DataIn12DI1),
                  .DataIn12DQ1(DataIn12DQ1),
                  .DataIn13DI1(DataIn13DI1),
                  .DataIn13DQ1(DataIn13DQ1),
                  .DataIn14DI1(DataIn14DI1),
                  .DataIn14DQ1(DataIn14DQ1),
                  .DataIn15DI1(DataIn15DI1),
                  .DataIn15DQ1(DataIn15DQ1),
                  .DataIn16DI1(DataIn16DI1),
                  .DataIn16DQ1(DataIn16DQ1),
                  .DataIn17DI1(DataIn17DI1),
                  .DataIn17DQ1(DataIn17DQ1),
                  .DataIn18DI1(DataIn18DI1),
                  .DataIn18DQ1(DataIn18DQ1),
                  .DataIn19DI1(DataIn19DI1),
                  .DataIn19DQ1(DataIn19DQ1),

                  .DataInI2(DataInI2),
                  .DataInQ2(DataInQ2),
                  .DataIn1DI2(DataIn1DI2),
                  .DataIn1DQ2(DataIn1DQ2),
                  .DataIn2DI2(DataIn2DI2),
                  .DataIn2DQ2(DataIn2DQ2),
                  .DataIn3DI2(DataIn3DI2),
                  .DataIn3DQ2(DataIn3DQ2),
                  .DataIn4DI2(DataIn4DI2),
                  .DataIn4DQ2(DataIn4DQ2),
                  .DataIn5DI2(DataIn5DI2),
                  .DataIn5DQ2(DataIn5DQ2),
                  .DataIn6DI2(DataIn6DI2),
                  .DataIn6DQ2(DataIn6DQ2),
                  .DataIn7DI2(DataIn7DI2),
                  .DataIn7DQ2(DataIn7DQ2),
                  .DataIn8DI2(DataIn8DI2),
                  .DataIn8DQ2(DataIn8DQ2),
                  .DataIn9DI2(DataIn9DI2),
                  .DataIn9DQ2(DataIn9DQ2),
                  .DataIn10DI2(DataIn10DI2),
                  .DataIn10DQ2(DataIn10DQ2),
                  .DataIn11DI2(DataIn11DI2),
                  .DataIn11DQ2(DataIn11DQ2),
                  .DataIn12DI2(DataIn12DI2),
                  .DataIn12DQ2(DataIn12DQ2),
                  .DataIn13DI2(DataIn13DI2),
                  .DataIn13DQ2(DataIn13DQ2),
                  .DataIn14DI2(DataIn14DI2),
                  .DataIn14DQ2(DataIn14DQ2),
                  .DataIn15DI2(DataIn15DI2),
                  .DataIn15DQ2(DataIn15DQ2),
                  .DataIn16DI2(DataIn16DI2),
                  .DataIn16DQ2(DataIn16DQ2),
                  .DataIn17DI2(DataIn17DI2),
                  .DataIn17DQ2(DataIn17DQ2),
                  .DataIn18DI2(DataIn18DI2),
                  .DataIn18DQ2(DataIn18DQ2),
                  .DataIn19DI2(DataIn19DI2),
                  .DataIn19DQ2(DataIn19DQ2),

                  .DataInI3(DataInI3),
                  .DataInQ3(DataInQ3),
                  .DataIn1DI3(DataIn1DI3),
                  .DataIn1DQ3(DataIn1DQ3),
                  .DataIn2DI3(DataIn2DI3),
                  .DataIn2DQ3(DataIn2DQ3),
                  .DataIn3DI3(DataIn3DI3),
                  .DataIn3DQ3(DataIn3DQ3),
                  .DataIn4DI3(DataIn4DI3),
                  .DataIn4DQ3(DataIn4DQ3),
                  .DataIn5DI3(DataIn5DI3),
                  .DataIn5DQ3(DataIn5DQ3),
                  .DataIn6DI3(DataIn6DI3),
                  .DataIn6DQ3(DataIn6DQ3),
                  .DataIn7DI3(DataIn7DI3),
                  .DataIn7DQ3(DataIn7DQ3),
                  .DataIn8DI3(DataIn8DI3),
                  .DataIn8DQ3(DataIn8DQ3),
                  .DataIn9DI3(DataIn9DI3),
                  .DataIn9DQ3(DataIn9DQ3),
                  .DataIn10DI3(DataIn10DI3),
                  .DataIn10DQ3(DataIn10DQ3),
                  .DataIn11DI3(DataIn11DI3),
                  .DataIn11DQ3(DataIn11DQ3),
                  .DataIn12DI3(DataIn12DI3),
                  .DataIn12DQ3(DataIn12DQ3),
                  .DataIn13DI3(DataIn13DI3),
                  .DataIn13DQ3(DataIn13DQ3),
                  .DataIn14DI3(DataIn14DI3),
                  .DataIn14DQ3(DataIn14DQ3),
                  .DataIn15DI3(DataIn15DI3),
                  .DataIn15DQ3(DataIn15DQ3),
                  .DataIn16DI3(DataIn16DI3),
                  .DataIn16DQ3(DataIn16DQ3),
                  .DataIn17DI3(DataIn17DI3),
                  .DataIn17DQ3(DataIn17DQ3),
                  .DataIn18DI3(DataIn18DI3),
                  .DataIn18DQ3(DataIn18DQ3),
                  .DataIn19DI3(DataIn19DI3),
                  .DataIn19DQ3(DataIn19DQ3),

                  .DataInI4(DataInI4),
                  .DataInQ4(DataInQ4),
                  .DataIn1DI4(DataIn1DI4),
                  .DataIn1DQ4(DataIn1DQ4),
                  .DataIn2DI4(DataIn2DI4),
                  .DataIn2DQ4(DataIn2DQ4),
                  .DataIn3DI4(DataIn3DI4),
                  .DataIn3DQ4(DataIn3DQ4),
                  .DataIn4DI4(DataIn4DI4),
                  .DataIn4DQ4(DataIn4DQ4),
                  .DataIn5DI4(DataIn5DI4),
                  .DataIn5DQ4(DataIn5DQ4),
                  .DataIn6DI4(DataIn6DI4),
                  .DataIn6DQ4(DataIn6DQ4),
                  .DataIn7DI4(DataIn7DI4),
                  .DataIn7DQ4(DataIn7DQ4),
                  .DataIn8DI4(DataIn8DI4),
                  .DataIn8DQ4(DataIn8DQ4),
                  .DataIn9DI4(DataIn9DI4),
                  .DataIn9DQ4(DataIn9DQ4),
                  .DataIn10DI4(DataIn10DI4),
                  .DataIn10DQ4(DataIn10DQ4),
                  .DataIn11DI4(DataIn11DI4),
                  .DataIn11DQ4(DataIn11DQ4),
                  .DataIn12DI4(DataIn12DI4),
                  .DataIn12DQ4(DataIn12DQ4),
                  .DataIn13DI4(DataIn13DI4),
                  .DataIn13DQ4(DataIn13DQ4),
                  .DataIn14DI4(DataIn14DI4),
                  .DataIn14DQ4(DataIn14DQ4),
                  .DataIn15DI4(DataIn15DI4),
                  .DataIn15DQ4(DataIn15DQ4),
                  .DataIn16DI4(DataIn16DI4),
                  .DataIn16DQ4(DataIn16DQ4),
                  .DataIn17DI4(DataIn17DI4),
                  .DataIn17DQ4(DataIn17DQ4),
                  .DataIn18DI4(DataIn18DI4),
                  .DataIn18DQ4(DataIn18DQ4),
                  .DataIn19DI4(DataIn19DI4),
                  .DataIn19DQ4(DataIn19DQ4),

                  //Outputs
                  .DsssCCDataEn(DsssCCDataEn),
                  .DsssCCAccSum(DsssCCAccSum)
                   );

//////////////////////////////////////////////////////////////////////////////
//Reference Level cal
//////////////////////////////////////////////////////////////////////////////
//Referece level for Dsss and Ofdm correlator
CorrRefLevTop   #(
                 .NRX          (NRX),
                 .DATAINWIDTH  (DATAINWIDTH),
                 .OFDMOUTWIDTH (DATAOUTOFDMREF),
                 .DSSSOUTWIDTH (DATAOUTDSSSREF)
                 )
                U_CorrRefLevTop(
                  //Inputs
                  .AGCClk(AGCClk),
                  .nAGCRst(nAGCRst),
                  .RefLevBlockEn(RefLevBlockEn),
                  .DsssSubZero(DsssSubZeroRef),
                  .OfdmSubZero(OfdmSubZeroRef),
                  .DataInEn(DataInEn),

                  .DataInI1(DataInI1),
                  .DataInQ1(DataInQ1),
                  .DataIn16DI1(DataIn16DI1),
                  .DataIn16DQ1(DataIn16DQ1),
                  .DataIn20DI1(DataIn20DI1),
                  .DataIn20DQ1(DataIn20DQ1),

                  .DataInI2(DataInI2),
                  .DataInQ2(DataInQ2),
                  .DataIn16DI2(DataIn16DI2),
                  .DataIn16DQ2(DataIn16DQ2),
                  .DataIn20DI2(DataIn20DI2),
                  .DataIn20DQ2(DataIn20DQ2),

                  .DataInI3(DataInI3),
                  .DataInQ3(DataInQ3),
                  .DataIn16DI3(DataIn16DI3),
                  .DataIn16DQ3(DataIn16DQ3),
                  .DataIn20DI3(DataIn20DI3),
                  .DataIn20DQ3(DataIn20DQ3),

                  .DataInI4(DataInI4),
                  .DataInQ4(DataInQ4),
                  .DataIn16DI4(DataIn16DI4),
                  .DataIn16DQ4(DataIn16DQ4),
                  .DataIn20DI4(DataIn20DI4),
                  .DataIn20DQ4(DataIn20DQ4),

                  //Outputs
                  .RefLevDataEn(RefLevDataEn),
                  .RefLevDsss(RefLevDsss),
                  .RefLevOfdm(RefLevOfdm)
                   );

endmodule // AgcCorrTop

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
