//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10209 $
// $Date: 2013-09-23 10:03:49 +0200 (Mon, 23 Sep 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Acc for DSSS Cross Correlation output
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/Correlator/verilog/rtl/DSSSCorrAcc.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module DSSSCorrAcc #(parameter DATAOUTDSSSCC  = 20  // Accumulated Cross Corr output
                    )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            //Reset resynchronized to AGCClk
            input    wire                                  nAGCRst,

            //Control Signals
            //Enable for Dsss Cross Correlation block, from AGC FSM
            input    wire                                  DsssCCBlockEn,
            //Sum of Max DsssCCMaxCnt values are given as output
            input    wire              [1:0]               DsssCCMaxCnt,
            //Data from Dsss CC
            input    wire              [DATAOUTDSSSCC-1:0] DsssCCAccSum,
            input    wire                                  DsssCCDataEn,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Max accumulated Dsss CC values
            output   wire          [DATAOUTDSSSCC+2:0] DSSSCCMax,
            //Sum of Max DsssCCMaxCnt values
            output   wire          [DATAOUTDSSSCC+4:0] DSSSCCMaxSum,
            //Enable for MaxSumOut
            output   wire                              DSSSCCMaxSumEn
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declaration
//////////////////////////////////////////////////////////////////////////////
parameter CONSTZERO      = 32'd0;// Zero


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires & Vars Declarations
//////////////////////////////////////////////////////////////////////////////
wire               [DATAOUTDSSSCC+2:0] Sum20Del;
wire               [DATAOUTDSSSCC+4:0] MaxSum;

//Integer
integer                                k;

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                [2:0]               DelDataEn;
reg                [DATAOUTDSSSCC+2:0] RegMax;
reg                [DATAOUTDSSSCC+4:0] RegMaxSum;
reg                [DATAOUTDSSSCC+2:0] Max1Reg;
reg                [DATAOUTDSSSCC+2:0] Max2Reg;
reg                [DATAOUTDSSSCC+2:0] Max3Reg;
reg                [DATAOUTDSSSCC+2:0] Max4Reg;
reg                [DATAOUTDSSSCC+2:0] AccBufReg [0:19];
reg                [DATAOUTDSSSCC+4:0] AddIn1;
reg                [DATAOUTDSSSCC+4:0] AddIn2;
reg                [DATAOUTDSSSCC+4:0] AddIn3;
reg                [DATAOUTDSSSCC+4:0] AddIn4;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

////////////////
//Peak search
////////////////

//Data is registered with delayed version of DataInEn
  always @ (posedge AGCClk or negedge nAGCRst) begin:EnDelayBlk
    if (nAGCRst == 1'b0) begin
      DelDataEn <= 3'd0;
    end
    else begin
      if (DsssCCBlockEn == 1'b0) begin
        DelDataEn <= 3'd0;
      end
      else begin
        DelDataEn[0]   <= DsssCCDataEn;
        DelDataEn[2:1] <= DelDataEn[1:0];
      end
    end
  end //EnDelayBlk

//Adder CCDsss[n] + CCDsss[n-20]
  assign  Sum20Del = {3'b0,DsssCCAccSum} + AccBufReg[19];

//20 samples wide Buffer
  always @ (posedge AGCClk or negedge nAGCRst) begin: AccBuffer
    if (nAGCRst == 1'b0) begin
      for (k=0;k<20;k=k+1) begin: init
        AccBufReg[k] <= 20'd0;
      end
    end
    else begin
      if (DsssCCBlockEn == 1'b0) begin
        for (k=0;k<20;k=k+1) begin: BlkEn
          AccBufReg[k] <= 20'd0;
        end //BlkEn
      end
      else if (DelDataEn == 3'b1) begin
        for (k=1;k<20;k=k+1) begin: shift
          AccBufReg[k] <= AccBufReg[k-1];
        end //Shift
        AccBufReg[0] <= Sum20Del;
      end
    end
  end // AccBuffer

//Finding out 4 Max values
  always @ (posedge AGCClk or negedge nAGCRst) begin: MaxSearchBlk
    if (nAGCRst == 1'b0) begin
      Max1Reg <= CONSTZERO[DATAOUTDSSSCC+2:0];
      Max2Reg <= CONSTZERO[DATAOUTDSSSCC+2:0];
      Max3Reg <= CONSTZERO[DATAOUTDSSSCC+2:0];
      Max4Reg <= CONSTZERO[DATAOUTDSSSCC+2:0];
    end
    else begin
      if (DsssCCBlockEn == 1'b0) begin
        Max1Reg <= CONSTZERO[DATAOUTDSSSCC+2:0];
        Max2Reg <= CONSTZERO[DATAOUTDSSSCC+2:0];
        Max3Reg <= CONSTZERO[DATAOUTDSSSCC+2:0];
        Max4Reg <= CONSTZERO[DATAOUTDSSSCC+2:0];
      end 
      else if (DelDataEn[0] == 1'b1) begin
        if (AccBufReg[0] >= Max1Reg) begin
          Max1Reg <= AccBufReg[0];
          Max2Reg <= Max1Reg;
          Max3Reg <= Max2Reg;
          Max4Reg <= Max3Reg;
        end
        else if (AccBufReg[0] >= Max2Reg) begin
          Max1Reg <= Max1Reg;
          Max2Reg <= AccBufReg[0];
          Max3Reg <= Max2Reg;
          Max4Reg <= Max3Reg;
        end
        else if (AccBufReg[0] >= Max3Reg) begin
          Max1Reg <= Max1Reg;
          Max2Reg <= Max2Reg;
          Max3Reg <= AccBufReg[0];
          Max4Reg <= Max3Reg;
        end
        else if (AccBufReg[0] >= Max4Reg) begin
          Max1Reg <= Max1Reg;
          Max2Reg <= Max2Reg;
          Max3Reg <= Max3Reg;
          Max4Reg <= AccBufReg[0];
        end
      end 
    end 
  end // MaxSearchBlk

//Mux For adding ofdm_cc_max_count values
  always @ (*) begin: MuxMultIp1
    case (DsssCCMaxCnt)
      2'b00: begin
         AddIn1 = {2'b0,Max1Reg};
         AddIn2 = CONSTZERO[DATAOUTDSSSCC+4:0];
         AddIn3 = CONSTZERO[DATAOUTDSSSCC+4:0];
         AddIn4 = CONSTZERO[DATAOUTDSSSCC+4:0];
      end
      2'b01: begin
         AddIn1 = {2'b0,Max1Reg};
         AddIn2 = {2'b0,Max2Reg};
         AddIn3 = CONSTZERO[DATAOUTDSSSCC+4:0];
         AddIn4 = CONSTZERO[DATAOUTDSSSCC+4:0];
      end
      2'b10: begin
         AddIn1 = {2'b0,Max1Reg};
         AddIn2 = {2'b0,Max2Reg};
         AddIn3 = {2'b0,Max3Reg};
         AddIn4 = CONSTZERO[DATAOUTDSSSCC+4:0];
      end
      default: begin
         AddIn1 = {2'b0,Max1Reg};
         AddIn2 = {2'b0,Max2Reg};
         AddIn3 = {2'b0,Max3Reg};
         AddIn4 = {2'b0,Max4Reg};
      end
    endcase

  end //MuxMultIp1

//Sum of Max values
  assign MaxSum = AddIn1 + AddIn2 + AddIn3 + AddIn4;

//Registering Sum Data
  always @ (posedge AGCClk or negedge nAGCRst) begin: RegMaxSumBlk
    if (nAGCRst == 1'b0) begin
      RegMax    <= CONSTZERO[DATAOUTDSSSCC+2:0];
      RegMaxSum <= CONSTZERO[DATAOUTDSSSCC+4:0];
    end
    else begin
      if (DsssCCBlockEn == 1'b0) begin
        RegMax    <= CONSTZERO[DATAOUTDSSSCC+2:0];
        RegMaxSum <= CONSTZERO[DATAOUTDSSSCC+4:0];
      end
      else begin
        RegMax    <= Max1Reg;
        RegMaxSum <= MaxSum;
      end
    end
  end // RegMaxSumBlk

//Output Assignment
  assign DSSSCCMax = RegMax;
  assign DSSSCCMaxSum = RegMaxSum;
  assign DSSSCCMaxSumEn = DelDataEn[2];

endmodule // DSSSCorrAcc

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////

