//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10209 $
// $Date: 2013-09-23 10:03:49 +0200 (Mon, 23 Sep 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Dsss Auto Correlation top module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/Correlator/verilog/rtl/DsssAutoCorrTop.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module DsssAutoCorrTop #(parameter NRX            = 4,  // Number of RX chains
                         parameter DATAINWIDTH    = 13, // Input data from TXRX FE and delay lines
                         parameter DATAOUTWIDTH   = 22  // Accumulated AutoCorr output
                        )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            //Reset resynchronized to AGCClk
            input    wire                                  nAGCRst,

            //Control Signals
            //Enable for Dsss Auto Correlation block, from AGC FSM
            input    wire                                  DsssACBlockEn,
            //Force first 0.8,1.6,2.4 or 3.2us of outputs as zero, from AGC FSM
            input    wire                                  SetZeroOutput,
            //Add zeros instead of samples from delay block for first 0.8,1.6,2.4 or 3.2 us
            input    wire                                  AddZeroValue,
            //Selects Accumulation of Auto correlation values for 1 or 2 us
            input    wire                                  DsssACModeSel,
            //Enable for input data
            input    wire                                  DataInEn,

            //Data Input RxChain1
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DQ1,

            //Data Input RxChain2
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DQ2,

            //Data Input RxChain3
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DQ3,

            //Data Input RxChain4
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn20DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn40DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn60DQ4,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Output Accumulated sum for AutoCorrelation
            output   wire          [DATAOUTWIDTH-1:0]      DsssACAccSum,
            //Enable for output data
            output   wire                                  DsssACDataEn
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires & Vars Declarations
//////////////////////////////////////////////////////////////////////////////
wire               [DATAINWIDTH+8:0]   ModApproxOut;
wire    signed     [DATAINWIDTH+8:0]   SumAccDataI;
wire    signed     [DATAINWIDTH+8:0]   SumAccDataQ;
wire               [DATAINWIDTH+8:0]   MuxModApprox;
wire               [3:0]               DataOutEn;
wire    signed     [DATAINWIDTH+6:0]   AccSumI [3:0];
wire    signed     [DATAINWIDTH+6:0]   AccSumQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataInI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataInQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn20DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn20DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn40DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn40DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn60DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn60DQ [3:0];

//Genvar
genvar                                 j,i;

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg     signed     [DATAINWIDTH+8:0]   RegSumI;
reg     signed     [DATAINWIDTH+8:0]   RegSumQ;
reg                [DATAINWIDTH+8:0]   RegMuxModApprox;
reg                [4:0]               DelDataOutEn;
reg                [4:0]               DelSetZeroOutput;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////
//Assign Inputs to Array variable
  assign DataInI[0]    = DataInI1;
  assign DataInQ[0]    = DataInQ1;
  assign DataIn20DI[0] = DataIn20DI1;
  assign DataIn20DQ[0] = DataIn20DQ1;
  assign DataIn40DI[0] = DataIn40DI1;
  assign DataIn40DQ[0] = DataIn40DQ1;
  assign DataIn60DI[0] = DataIn60DI1;
  assign DataIn60DQ[0] = DataIn60DQ1;

  assign DataInI[1]    = DataInI2;
  assign DataInQ[1]    = DataInQ2;
  assign DataIn20DI[1] = DataIn20DI2;
  assign DataIn20DQ[1] = DataIn20DQ2;
  assign DataIn40DI[1] = DataIn40DI2;
  assign DataIn40DQ[1] = DataIn40DQ2;
  assign DataIn60DI[1] = DataIn60DI2;
  assign DataIn60DQ[1] = DataIn60DQ2;

  assign DataInI[2]    = DataInI3;
  assign DataInQ[2]    = DataInQ3;
  assign DataIn20DI[2] = DataIn20DI3;
  assign DataIn20DQ[2] = DataIn20DQ3;
  assign DataIn40DI[2] = DataIn40DI3;
  assign DataIn40DQ[2] = DataIn40DQ3;
  assign DataIn60DI[2] = DataIn60DI3;
  assign DataIn60DQ[2] = DataIn60DQ3;

  assign DataInI[3]    = DataInI4;
  assign DataInQ[3]    = DataInQ4;
  assign DataIn20DI[3] = DataIn20DI4;
  assign DataIn20DQ[3] = DataIn20DQ4;
  assign DataIn40DI[3] = DataIn40DI4;
  assign DataIn40DQ[3] = DataIn40DQ4;
  assign DataIn60DI[3] = DataIn60DI4;
  assign DataIn60DQ[3] = DataIn60DQ4;

//Data is registered with delayed version of DataInEn
  always @ (posedge AGCClk or negedge nAGCRst) begin:EnDelayBlk
    if (nAGCRst == 1'b0) begin
      DelDataOutEn     <= 5'd0;
      DelSetZeroOutput <= 5'd0;
    end
    else begin
      if (DsssACBlockEn == 1'b0) begin
        DelDataOutEn     <= 5'd0;
        DelSetZeroOutput <= 5'd0;
      end
      else begin
        DelDataOutEn[0]       <= DataOutEn[0];
        DelDataOutEn[4:1]     <= DelDataOutEn[3:0];
        DelSetZeroOutput[0]   <= SetZeroOutput;
        DelSetZeroOutput[4:1] <= DelSetZeroOutput[3:0];
      end
    end
  end //EnDelayBlk

generate
  for (j=0; j<NRX; j=j+1) begin: GenDsssAutoCorr
    DsssAutoCorr # (
              .DATAINWIDTH (DATAINWIDTH),
              .DATAOUTWIDTH(DATAINWIDTH+7)
              )
      U_DsssAutoCorr(
                   //Inputs
                   .AGCClk(AGCClk),
                   .nAGCRst(nAGCRst),
                   .DsssACBlockEn(DsssACBlockEn),
                   .AddZeroValue(AddZeroValue),
                   .DsssACModeSel(DsssACModeSel),
                   .DataInEn(DataInEn),
                   .DataInI(DataInI[j]),
                   .DataInQ(DataInQ[j]),
                   .DataIn20DI(DataIn20DI[j]),
                   .DataIn20DQ(DataIn20DQ[j]),
                   .DataIn40DI(DataIn40DI[j]),
                   .DataIn40DQ(DataIn40DQ[j]),
                   .DataIn60DI(DataIn60DI[j]),
                   .DataIn60DQ(DataIn60DQ[j]),

                   //Outputs
                   .DsssACDataEn(DataOutEn[j]),
                   .AccSumI(AccSumI[j]),
                   .AccSumQ(AccSumQ[j])
                   );
  end // GenDsssAutoCorr
endgenerate

//Adding the outputs from all the RX chains
generate
  for(i=NRX;i<4;i=i+1) begin: GenAdder

     assign AccSumI[i]   = $signed({{(DATAINWIDTH+7)}{1'b0}});
     assign AccSumQ[i]   = $signed({{(DATAINWIDTH+7)}{1'b0}});
     assign DataOutEn[i] = 1'b0;

  end //GenAdder
endgenerate

     assign SumAccDataI =  $signed({{2{AccSumI[0][DATAINWIDTH+6]}},AccSumI[0][DATAINWIDTH+6:0]} +
                           {{2{AccSumI[1][DATAINWIDTH+6]}},AccSumI[1][DATAINWIDTH+6:0]} +
                           {{2{AccSumI[2][DATAINWIDTH+6]}},AccSumI[2][DATAINWIDTH+6:0]} +
                           {{2{AccSumI[3][DATAINWIDTH+6]}},AccSumI[3][DATAINWIDTH+6:0]});

     assign SumAccDataQ =  $signed({{2{AccSumQ[0][DATAINWIDTH+6]}},AccSumQ[0][DATAINWIDTH+6:0]} +
                           {{2{AccSumQ[1][DATAINWIDTH+6]}},AccSumQ[1][DATAINWIDTH+6:0]} +
                           {{2{AccSumQ[2][DATAINWIDTH+6]}},AccSumQ[2][DATAINWIDTH+6:0]} +
                           {{2{AccSumQ[3][DATAINWIDTH+6]}},AccSumQ[3][DATAINWIDTH+6:0]});

//Registering Sum Data
  always @ (posedge AGCClk or negedge nAGCRst) begin: RegSumData
    if (nAGCRst == 1'b0) begin
      RegSumI <= $signed({{(DATAINWIDTH+9)}{1'b0}});
      RegSumQ <= $signed({{(DATAINWIDTH+9)}{1'b0}});
    end
    else begin
      if (DsssACBlockEn == 1'b0) begin
        RegSumI <= $signed({{(DATAINWIDTH+9)}{1'b0}});
        RegSumQ <= $signed({{(DATAINWIDTH+9)}{1'b0}});
      end
      else begin
        RegSumI <= SumAccDataI;
        RegSumQ <= SumAccDataQ;
      end
    end
  end // RegSumData

//Mod Approx
  ModApprox # (
              .SUM_WIDTH(DATAINWIDTH+9),
              .CORRVAL_WIDTH(DATAINWIDTH+9)
              )
              U_ModApprox (
                //Inputs
                .PhyClk(AGCClk),
                .nPhyRst(nAGCRst),
                .ISum(RegSumI),
                .QSum(RegSumQ),
                .ComputeOn(DsssACBlockEn),

                //Output
                .CorrVal(ModApproxOut)
              );

  assign MuxModApprox = (DelSetZeroOutput[4])? {{(DATAINWIDTH+9)}{1'b0}}:
                          ModApproxOut;

//Registering Mux Data
//Adding 2 clock delay to give common 7 clock delay to all correlator modules
  always @ (posedge AGCClk or negedge nAGCRst) begin: RegMuxData
    if (nAGCRst == 1'b0) begin
      RegMuxModApprox <= {{(DATAINWIDTH+9)}{1'b0}};
    end
    else begin
      if (DsssACBlockEn == 1'b0) begin
        RegMuxModApprox <= {{(DATAINWIDTH+9)}{1'b0}};
      end
      else if (DelDataOutEn[3] == 1'b1) begin
        if (DsssACModeSel == 1'b0)
          RegMuxModApprox <= MuxModApprox;
        else
          RegMuxModApprox <= {1'b0, MuxModApprox[DATAINWIDTH+8:1]};
      end
    end
  end // RegMuxData

//Output Assignment
  assign DsssACAccSum = RegMuxModApprox;
  assign DsssACDataEn = DelDataOutEn[4];

endmodule // DsssAutoCorrTop

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
