//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10209 $
// $Date: 2013-09-23 10:03:49 +0200 (Mon, 23 Sep 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Complex number * const mult for DSSS cross correlation
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/Correlator/verilog/rtl/DsssCCQuantMult.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module DsssCCQuantMult #(parameter DATAINWIDTH = 13  // Input
                        )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ,
            input    wire                                  QuantDataIn,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output wire signed     [DATAINWIDTH:0]         DataOutI,
            output wire signed     [DATAINWIDTH:0]         DataOutQ
            );



//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire    signed     [DATAINWIDTH-1:0]   NegDataInI;
wire    signed     [DATAINWIDTH-1:0]   NegDataInQ;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Negating the Inputs
  assign NegDataInI = $signed({{DATAINWIDTH}{1'b0}})-DataInI;
  assign NegDataInQ = $signed({{DATAINWIDTH}{1'b0}})-DataInQ;

//Mux replacing Multiplication
//For DataOutI
  assign DataOutI = (QuantDataIn) ? $signed({NegDataInI[DATAINWIDTH-1],NegDataInI[DATAINWIDTH-1:0]}) :
                                    $signed({DataInI[DATAINWIDTH-1],DataInI[DATAINWIDTH-1:0]});
  assign DataOutQ = (QuantDataIn) ? $signed({NegDataInQ[DATAINWIDTH-1],NegDataInQ[DATAINWIDTH-1:0]}) :
                                    $signed({DataInQ[DATAINWIDTH-1],DataInQ[DATAINWIDTH-1:0]});

endmodule // DsssCCQuantMult

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
