//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10209 $
// $Date: 2013-09-23 10:03:49 +0200 (Mon, 23 Sep 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : DSSS Cross Correlation module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/Correlator/verilog/rtl/DsssCrossCorr.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module DsssCrossCorr #(parameter DATAINWIDTH = 13, // Input data from TXRX FE and delay lines
                       parameter DATAOUTWIDTH  = 18  // Accumulated CrossCorr output
                      )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            //Reset resynchronized to AGCClk
            input    wire                                  nAGCRst,

            //Control Signals
            //Enable for Dsss Cross Correlation block, from AGC FSM
            input    wire                                  DsssCCBlockEn,
            //Enable for input data
            input    wire                                  DataInEn,
            //Data Input
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn17DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn17DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn19DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn19DQ,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Output Accumulated sum for Cross Correlation
            output   wire          [DATAOUTWIDTH-1:0]      DsssCrossCorrOut,
            //Enable for output data
            output   wire                                  DsssCCDataEn
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam STOREDPRE     = 20'h2101F; // Stored dsss preamble


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires & Vars Declarations
//////////////////////////////////////////////////////////////////////////////
wire    signed     [DATAINWIDTH-1:0]   MultInDataI [19:0];
wire    signed     [DATAINWIDTH-1:0]   MultInDataQ [19:0];
wire               [19:0]              StoredPreInt;
wire    signed     [DATAINWIDTH:0]     MultOutDataI [19:0];
wire    signed     [DATAINWIDTH:0]     MultOutDataQ [19:0];

wire               [DATAINWIDTH+5:0]   ModApproxOut;
wire               [DATAINWIDTH+17:0]  MultCrossCorr;
wire               [DATAINWIDTH+6:0]   RndCrossCorr;
wire               [DATAOUTWIDTH-1:0]  SatCrossCorr;
wire    signed     [DATAINWIDTH+5:0]   SumDataI;
wire    signed     [DATAINWIDTH+5:0]   SumDataQ;

//Genvar declaration
genvar                                 j;


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                [DATAINWIDTH+16:0]  MultCrossCorrReg;
reg                [DATAOUTWIDTH-1:0]  SatCrossCorrReg;
reg     signed     [DATAINWIDTH+5:0]   SumDataIReg;
reg     signed     [DATAINWIDTH+5:0]   SumDataQReg;
reg                [5:0]               DelDataInEn;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Assigning to array to use for loop to instantiate the Quant Mult
  assign MultInDataI[0] = DataInI;
  assign MultInDataQ[0] = DataInQ;
  assign MultInDataI[1] = DataIn1DI;
  assign MultInDataQ[1] = DataIn1DQ;
  assign MultInDataI[2] = DataIn2DI;
  assign MultInDataQ[2] = DataIn2DQ;
  assign MultInDataI[3] = DataIn3DI;
  assign MultInDataQ[3] = DataIn3DQ;
  assign MultInDataI[4] = DataIn4DI;
  assign MultInDataQ[4] = DataIn4DQ;
  assign MultInDataI[5] = $signed({{DATAINWIDTH}{1'b0}});
  assign MultInDataQ[5] = $signed({{DATAINWIDTH}{1'b0}});
  assign MultInDataI[6] = DataIn6DI;
  assign MultInDataQ[6] = DataIn6DQ;
  assign MultInDataI[7] = DataIn7DI;
  assign MultInDataQ[7] = DataIn7DQ;
  assign MultInDataI[8] = DataIn8DI;
  assign MultInDataQ[8] = DataIn8DQ;
  assign MultInDataI[9] = DataIn9DI;
  assign MultInDataQ[9] = DataIn9DQ;
  assign MultInDataI[10] = DataIn10DI;
  assign MultInDataQ[10] = DataIn10DQ;
  assign MultInDataI[11] = $signed({{DATAINWIDTH}{1'b0}});
  assign MultInDataQ[11] = $signed({{DATAINWIDTH}{1'b0}});
  assign MultInDataI[12] = DataIn12DI;
  assign MultInDataQ[12] = DataIn12DQ;
  assign MultInDataI[13] = $signed({{DATAINWIDTH}{1'b0}});
  assign MultInDataQ[13] = $signed({{DATAINWIDTH}{1'b0}});
  assign MultInDataI[14] = DataIn14DI;
  assign MultInDataQ[14] = DataIn14DQ;
  assign MultInDataI[15] = DataIn15DI;
  assign MultInDataQ[15] = DataIn15DQ;
  assign MultInDataI[16] = $signed({{DATAINWIDTH}{1'b0}});
  assign MultInDataQ[16] = $signed({{DATAINWIDTH}{1'b0}});
  assign MultInDataI[17] = DataIn17DI;
  assign MultInDataQ[17] = DataIn17DQ;
  assign MultInDataI[18] = $signed({{DATAINWIDTH}{1'b0}});
  assign MultInDataQ[18] = $signed({{DATAINWIDTH}{1'b0}});
  assign MultInDataI[19] = DataIn19DI;
  assign MultInDataQ[19] = DataIn19DQ;

//Assigning stored preamble values
  assign StoredPreInt = STOREDPRE[19:0];

//Data is registered with delayed version of DataInEn
  always @ (posedge AGCClk or negedge nAGCRst) begin:EnDelayBlk
    if (nAGCRst == 1'b0) begin
      DelDataInEn <= 6'd0;
    end
    else begin
      if (DsssCCBlockEn == 1'b0) begin
        DelDataInEn <= 6'd0;
      end
      else begin
        DelDataInEn[0] <= DataInEn;
        DelDataInEn[5:1] <= DelDataInEn[4:0];
      end
    end
  end //EnDelayBlk

//Quant Mult1
generate
  for (j=0;j<20;j=j+1) begin: QuantMult
  DsssCCQuantMult U_DsssCCQuantMult(
                    .DataInI(MultInDataI[j]),
                    .DataInQ(MultInDataQ[j]),
                    .QuantDataIn(StoredPreInt[j]),
                    .DataOutI(MultOutDataI[j]),
                    .DataOutQ(MultOutDataQ[j])
                    );

  end // QuantMult
endgenerate

  assign SumDataI = $signed({{5{MultOutDataI[0][DATAINWIDTH]}},MultOutDataI[0][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[1][DATAINWIDTH]}},MultOutDataI[1][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[2][DATAINWIDTH]}},MultOutDataI[2][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[3][DATAINWIDTH]}},MultOutDataI[3][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[4][DATAINWIDTH]}},MultOutDataI[4][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[5][DATAINWIDTH]}},MultOutDataI[5][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[6][DATAINWIDTH]}},MultOutDataI[6][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[7][DATAINWIDTH]}},MultOutDataI[7][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[8][DATAINWIDTH]}},MultOutDataI[8][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[9][DATAINWIDTH]}},MultOutDataI[9][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[10][DATAINWIDTH]}},MultOutDataI[10][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[11][DATAINWIDTH]}},MultOutDataI[11][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[12][DATAINWIDTH]}},MultOutDataI[12][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[13][DATAINWIDTH]}},MultOutDataI[13][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[14][DATAINWIDTH]}},MultOutDataI[14][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[15][DATAINWIDTH]}},MultOutDataI[15][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[16][DATAINWIDTH]}},MultOutDataI[16][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[17][DATAINWIDTH]}},MultOutDataI[17][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[18][DATAINWIDTH]}},MultOutDataI[18][DATAINWIDTH:0]} +
                    {{5{MultOutDataI[19][DATAINWIDTH]}},MultOutDataI[19][DATAINWIDTH:0]}) ;

  assign SumDataQ = $signed({{5{MultOutDataQ[0][DATAINWIDTH]}},MultOutDataQ[0][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[1][DATAINWIDTH]}},MultOutDataQ[1][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[2][DATAINWIDTH]}},MultOutDataQ[2][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[3][DATAINWIDTH]}},MultOutDataQ[3][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[4][DATAINWIDTH]}},MultOutDataQ[4][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[5][DATAINWIDTH]}},MultOutDataQ[5][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[6][DATAINWIDTH]}},MultOutDataQ[6][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[7][DATAINWIDTH]}},MultOutDataQ[7][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[8][DATAINWIDTH]}},MultOutDataQ[8][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[9][DATAINWIDTH]}},MultOutDataQ[9][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[10][DATAINWIDTH]}},MultOutDataQ[10][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[11][DATAINWIDTH]}},MultOutDataQ[11][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[12][DATAINWIDTH]}},MultOutDataQ[12][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[13][DATAINWIDTH]}},MultOutDataQ[13][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[14][DATAINWIDTH]}},MultOutDataQ[14][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[15][DATAINWIDTH]}},MultOutDataQ[15][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[16][DATAINWIDTH]}},MultOutDataQ[16][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[17][DATAINWIDTH]}},MultOutDataQ[17][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[18][DATAINWIDTH]}},MultOutDataQ[18][DATAINWIDTH:0]} +
                    {{5{MultOutDataQ[19][DATAINWIDTH]}},MultOutDataQ[19][DATAINWIDTH:0]}) ;

//Input data is at 20Msps. Registering is done with delayed Enable signals
//Delay. Registering the data path
  always @ (posedge AGCClk or negedge nAGCRst) begin:Delay1Blk
    if (nAGCRst == 1'b0) begin
      SumDataIReg <= $signed({{(DATAINWIDTH+6)}{1'b0}});
      SumDataQReg <= $signed({{(DATAINWIDTH+6)}{1'b0}});
    end
    else begin
      if (DsssCCBlockEn == 1'b0) begin
        SumDataIReg <= $signed({{(DATAINWIDTH+6)}{1'b0}});
        SumDataQReg <= $signed({{(DATAINWIDTH+6)}{1'b0}});
      end
      else if (DelDataInEn[0] == 1'b1) begin
        SumDataIReg <= SumDataI;
        SumDataQReg <= SumDataQ;
      end
    end
  end //Delay1Blk

//Mod Approx
  ModApprox  #(
              .SUM_WIDTH(DATAINWIDTH+6),
              .CORRVAL_WIDTH(DATAINWIDTH+6)
              )
              U_ModApprox (
                //Inputs
                .PhyClk(AGCClk),
                .nPhyRst(nAGCRst),
                .ISum(SumDataIReg),
                .QSum(SumDataQReg),
                .ComputeOn(DsssCCBlockEn),

                //Output
                .CorrVal(ModApproxOut)
              );

//Mult by 2016
//2016 = 2048-32 so implement as shift and subtract
  assign MultCrossCorr = {1'b0,ModApproxOut,11'b0} - {7'b0,ModApproxOut,5'b0};

//Registering the mult output
  always @ (posedge AGCClk or negedge nAGCRst) begin:RegMultOut
    if (nAGCRst == 1'b0) begin
      MultCrossCorrReg <= {{(DATAINWIDTH+17)}{1'b0}};
    end
    else begin
      if (DsssCCBlockEn == 1'b0) begin
        MultCrossCorrReg <= {{(DATAINWIDTH+17)}{1'b0}};
      end
      else begin
          MultCrossCorrReg <= MultCrossCorr[DATAINWIDTH+16:0];
      end
    end
  end // RegMultOut

//Round by 10 bits
  USgnRound #(
              .INPUT_WIDTH(DATAINWIDTH+17),
              .OUTPUT_WIDTH(DATAINWIDTH+7)
            )
            U_USgnRound (
              .InputData(MultCrossCorrReg),
              .RoundData(RndCrossCorr)
            );

//Saturate to 18 bits
  SatUnsigned #(
                .INPUT_WIDTH(DATAINWIDTH+7),
                .OUTPUT_WIDTH(DATAOUTWIDTH)
              )
              U_SatUnsigned (
                .InputData(RndCrossCorr),
                .SatData(SatCrossCorr)
              );

//Registering the Sat output
  always @ (posedge AGCClk or negedge nAGCRst) begin:RegSatOut
    if (nAGCRst == 1'b0) begin
      SatCrossCorrReg <= {{(DATAOUTWIDTH)}{1'b0}};
    end
    else begin
      if (DsssCCBlockEn == 1'b0) begin
        SatCrossCorrReg <= {{(DATAOUTWIDTH)}{1'b0}};
      end
      else if (DelDataInEn[4]) begin
        SatCrossCorrReg <= SatCrossCorr;
      end
    end
  end //RegSatOut

//Output Assignment
  assign DsssCrossCorrOut = SatCrossCorrReg;

  assign DsssCCDataEn =  DelDataInEn[5];

endmodule // DsssCrossCorr

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
