//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10209 $
// $Date: 2013-09-23 10:03:49 +0200 (Mon, 23 Sep 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Acc of Cross Correlation output
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/Correlator/verilog/rtl/OFDMCorrAcc.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module OFDMCorrAcc #(parameter DATAOUTOFDMCC = 22 // Input data OFDM CC
                    )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            //Reset resynchronized to AGCClk
            input    wire                                  nAGCRst,

            //Control Signals
            //Enable for Ofdm Cross Correlation block, from AGC FSM
            input    wire                                  OfdmCCBlockEn,
            //Sum of Max OfdmCCMaxCnt values are given as output
            input    wire              [1:0]               OfdmCCMaxCnt,
            //Output from Ofdm Cross Corr Module
            input    wire              [DATAOUTOFDMCC-1:0] OfdmCCAccSum,
            //Enable for input data
            input    wire                                  OfdmCCDataEn,


            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Sum of Max OfdmCCMaxCnt values
            output   wire          [DATAOUTOFDMCC+1:0] OFDMCCMax,
            //Enable for MaxSumOut
            output   wire          [DATAOUTOFDMCC+3:0] OFDMCCMaxSum,
            //Enable for output data
            output   wire                              OFDMCCMaxSumEn
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declaration
//////////////////////////////////////////////////////////////////////////////
parameter CONSTZERO      = 32'd0;// Zero


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                [2:0]               DelDataEn;
reg                [DATAOUTOFDMCC+1:0] RegMax;
reg                [DATAOUTOFDMCC+3:0] RegMaxSum;
reg                [DATAOUTOFDMCC+1:0] Max1Reg;
reg                [DATAOUTOFDMCC+1:0] Max2Reg;
reg                [DATAOUTOFDMCC+1:0] Max3Reg;
reg                [DATAOUTOFDMCC+1:0] Max4Reg;
reg                [DATAOUTOFDMCC+1:0] AccBufReg [0:15];
reg                [DATAOUTOFDMCC+3:0] AddIn1;
reg                [DATAOUTOFDMCC+3:0] AddIn2;
reg                [DATAOUTOFDMCC+3:0] AddIn3;
reg                [DATAOUTOFDMCC+3:0] AddIn4;

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires & Vars Declarations
//////////////////////////////////////////////////////////////////////////////
wire               [DATAOUTOFDMCC+1:0]  Sum16Del;
wire               [DATAOUTOFDMCC+3:0]  MaxSum;

//Integer
integer                                k;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

////////////////
//Peak search
////////////////

//Adder CCOfdm[n] + CCOfdm[n-16]
  assign  Sum16Del = {{2{OfdmCCAccSum[DATAOUTOFDMCC-1]}},OfdmCCAccSum} + AccBufReg[15];

//Data is registered with delayed version of DataEn
  always @ (posedge AGCClk or negedge nAGCRst) begin:EnDelayBlk
    if (nAGCRst == 1'b0) begin
      DelDataEn <= 3'd0;
    end
    else begin
      if (OfdmCCBlockEn == 1'b0) begin 
        DelDataEn <= 3'd0;
      end
      else begin
        DelDataEn[0] <= OfdmCCDataEn;
        DelDataEn[2:1] <= DelDataEn[1:0];
      end
    end
  end //EnDelayBlk

//16 samples wide Buffer
  always @ (posedge AGCClk or negedge nAGCRst) begin: AccBuffer
    if (nAGCRst == 1'b0) begin
      for (k=0;k<16;k=k+1) begin: init
        AccBufReg[k] <= 16'd0;
      end
    end
    else begin
      if (OfdmCCBlockEn == 1'b0) begin
        for (k=0;k<16;k=k+1) begin: BlkEn
          AccBufReg[k] <= 16'd0;
        end //BlkEn
      end
      else if (OfdmCCDataEn == 1'b1) begin
        for (k=1;k<16;k=k+1) begin: shift
          AccBufReg[k] <= AccBufReg[k-1];
        end //Shift
        AccBufReg[0] <= Sum16Del;
      end
    end
  end // AccBuffer

//Finding out 4 Max values
  always @ (posedge AGCClk or negedge nAGCRst) begin: MaxSearchBlk
    if (nAGCRst == 1'b0) begin
      Max1Reg <= CONSTZERO[DATAOUTOFDMCC+1:0];
      Max2Reg <= CONSTZERO[DATAOUTOFDMCC+1:0];
      Max3Reg <= CONSTZERO[DATAOUTOFDMCC+1:0];
      Max4Reg <= CONSTZERO[DATAOUTOFDMCC+1:0];
    end
    else begin
      if (OfdmCCBlockEn == 1'b0) begin
        Max1Reg <= CONSTZERO[DATAOUTOFDMCC+1:0];
        Max2Reg <= CONSTZERO[DATAOUTOFDMCC+1:0];
        Max3Reg <= CONSTZERO[DATAOUTOFDMCC+1:0];
        Max4Reg <= CONSTZERO[DATAOUTOFDMCC+1:0];
      end 
      else if (DelDataEn[0] == 1'b1) begin
        if (AccBufReg[0] >= Max1Reg) begin
          Max1Reg <= AccBufReg[0];
          Max2Reg <= Max1Reg;
          Max3Reg <= Max2Reg;
          Max4Reg <= Max3Reg;
        end
        else if (AccBufReg[0] >= Max2Reg) begin
          Max1Reg <= Max1Reg;
          Max2Reg <= AccBufReg[0];
          Max3Reg <= Max2Reg;
          Max4Reg <= Max3Reg;
        end
        else if (AccBufReg[0] >= Max3Reg) begin
          Max1Reg <= Max1Reg;
          Max2Reg <= Max2Reg;
          Max3Reg <= AccBufReg[0];
          Max4Reg <= Max3Reg;
        end
        else if (AccBufReg[0] >= Max4Reg) begin
          Max1Reg <= Max1Reg;
          Max2Reg <= Max2Reg;
          Max3Reg <= Max3Reg;
          Max4Reg <= AccBufReg[0];
        end
      end
    end
  end // MaxSearchBlk

//Mux For adding ofdm_cc_max_count values
  always @ (*) begin: MuxMultIp1
    case (OfdmCCMaxCnt)
      2'b00: begin
         AddIn1 = {2'b0,Max1Reg};
         AddIn2 = CONSTZERO[DATAOUTOFDMCC+3:0];
         AddIn3 = CONSTZERO[DATAOUTOFDMCC+3:0];
         AddIn4 = CONSTZERO[DATAOUTOFDMCC+3:0];
      end
      2'b01: begin
         AddIn1 = {2'b0,Max1Reg};
         AddIn2 = {2'b0,Max2Reg};
         AddIn3 = CONSTZERO[DATAOUTOFDMCC+3:0];
         AddIn4 = CONSTZERO[DATAOUTOFDMCC+3:0];
      end
      2'b10: begin
         AddIn1 = {2'b0,Max1Reg};
         AddIn2 = {2'b0,Max2Reg};
         AddIn3 = {2'b0,Max3Reg};
         AddIn4 = CONSTZERO[DATAOUTOFDMCC+3:0];
      end
      default: begin
         AddIn1 = {2'b0,Max1Reg};
         AddIn2 = {2'b0,Max2Reg};
         AddIn3 = {2'b0,Max3Reg};
         AddIn4 = {2'b0,Max4Reg};
      end
    endcase

  end //MuxMultIp1

//Sum of Max values
  assign MaxSum = AddIn1 + AddIn2 + AddIn3 + AddIn4;

//Registering Sum Data
  always @ (posedge AGCClk or negedge nAGCRst) begin: RegMaxSumBlk
    if (nAGCRst == 1'b0) begin
      RegMax    <= CONSTZERO[DATAOUTOFDMCC+1:0];
      RegMaxSum <= CONSTZERO[DATAOUTOFDMCC+3:0];
    end
    else begin
      if (OfdmCCBlockEn == 1'b0) begin
        RegMax    <= CONSTZERO[DATAOUTOFDMCC+1:0];
        RegMaxSum <= CONSTZERO[DATAOUTOFDMCC+3:0];
      end
      else begin
        RegMax    <= Max1Reg;
        RegMaxSum <= MaxSum;
      end
    end
  end // RegMaxSumBlk

//Output Assignment
  assign OFDMCCMax      = RegMax;
  assign OFDMCCMaxSum   = RegMaxSum;
  assign OFDMCCMaxSumEn = DelDataEn[2];

endmodule // OFDMCorrAcc

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
