//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10209 $
// $Date: 2013-09-23 10:03:49 +0200 (Mon, 23 Sep 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Quantized Complex multiplication modules
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/Correlator/verilog/rtl/OfdmCCQuantMult.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module OfdmCCQuantMult #(parameter DATAINWIDTH = 13
                        )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ,
            input    wire              [2:0]               QuantDataInI,
            input    wire              [2:0]               QuantDataInQ,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output wire signed     [DATAINWIDTH+1:0]       DataOutI,
            output wire signed     [DATAINWIDTH+1:0]       DataOutQ
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire    signed     [DATAINWIDTH-1:0]   NegDataInI;
wire    signed     [DATAINWIDTH-1:0]   NegDataInQ;

wire    signed     [DATAINWIDTH:0]     DataInIX2;
wire    signed     [DATAINWIDTH:0]     DataInQX2;
wire    signed     [DATAINWIDTH:0]     NegDataInIX2;
wire    signed     [DATAINWIDTH:0]     NegDataInQX2;

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg     signed     [DATAINWIDTH:0]     MuxDataI1;
reg     signed     [DATAINWIDTH:0]     MuxDataQ1;
reg     signed     [DATAINWIDTH:0]     MuxDataI2;
reg     signed     [DATAINWIDTH:0]     MuxDataQ2;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Negating the Inputs
  assign NegDataInI = $signed({{DATAINWIDTH}{1'b0}}) - DataInI;
  assign NegDataInQ = $signed({{DATAINWIDTH}{1'b0}}) - DataInQ;

  assign DataInIX2 = $signed({DataInI[DATAINWIDTH-1:0],1'b0});
  assign DataInQX2 = $signed({DataInQ[DATAINWIDTH-1:0],1'b0});

  assign NegDataInIX2 = $signed({NegDataInI[DATAINWIDTH-1:0],1'b0});
  assign NegDataInQX2 = $signed({NegDataInQ[DATAINWIDTH-1:0],1'b0});

//Mux replacing Multiplication
//(a+jb)*(c-jd) = (ac + bd) + j(ad - bc)
//For DataOutI
  always @ (*) begin:Mux1DataOutI
    case (QuantDataInI)
      3'b000:
         MuxDataI1 = $signed({{(DATAINWIDTH+1)}{1'b0}});
      3'b001:
         MuxDataI1 = $signed({DataInI[DATAINWIDTH-1],DataInI[DATAINWIDTH-1:0]});
      3'b010:
         MuxDataI1 = DataInIX2;
      3'b110:
         MuxDataI1 = NegDataInIX2;
      3'b111:
         MuxDataI1 = $signed({NegDataInI[DATAINWIDTH-1],NegDataInI[DATAINWIDTH-1:0]});
      default:
         MuxDataI1 = $signed({{(DATAINWIDTH+1)}{1'b0}});
      endcase
  end //Mux1DataOutI

  always @ (*) begin:Mux2DataOutI
    case (QuantDataInQ)
      3'b000:
         MuxDataQ1 = $signed({{(DATAINWIDTH+1)}{1'b0}});
      3'b001:
         MuxDataQ1 = $signed({DataInQ[DATAINWIDTH-1],DataInQ[DATAINWIDTH-1:0]});
      3'b010:
         MuxDataQ1 = DataInQX2;
      3'b110:
         MuxDataQ1 = NegDataInQX2;
      3'b111:
         MuxDataQ1 = $signed({NegDataInQ[DATAINWIDTH-1],NegDataInQ[DATAINWIDTH-1:0]});
      default:
         MuxDataQ1 = $signed({{(DATAINWIDTH+1)}{1'b0}});
      endcase
  end //Mux2DataOutI

//For DataOutQ
  always @ (*) begin:Mux1DataOutQ
    case (QuantDataInI)
      3'b000:
         MuxDataI2 = $signed({{(DATAINWIDTH+1)}{1'b0}});
      3'b001:
         MuxDataI2 = $signed({DataInQ[DATAINWIDTH-1],DataInQ[DATAINWIDTH-1:0]});
      3'b010:
         MuxDataI2 = DataInQX2;
      3'b110:
         MuxDataI2 = NegDataInQX2;
      3'b111:
         MuxDataI2 = $signed({NegDataInQ[DATAINWIDTH-1],NegDataInQ[DATAINWIDTH-1:0]});
      default:
         MuxDataI2 = $signed({{(DATAINWIDTH+1)}{1'b0}});
      endcase
  end //Mux1DataOutQ


  always @ (*) begin:Mux2DataOutQ
    case (QuantDataInQ)
      3'b000:
         MuxDataQ2 = $signed({{(DATAINWIDTH+1)}{1'b0}});
      3'b001:
         MuxDataQ2 = $signed({DataInI[DATAINWIDTH-1],DataInI[DATAINWIDTH-1:0]});
      3'b010:
         MuxDataQ2 = DataInIX2;
      3'b110:
         MuxDataQ2 = NegDataInIX2;
      3'b111:
         MuxDataQ2 = $signed({NegDataInI[DATAINWIDTH-1],NegDataInI[DATAINWIDTH-1:0]});
      default:
         MuxDataQ2 = $signed({{(DATAINWIDTH+1)}{1'b0}});
      endcase
  end //Mux2DataOutQ

//Outputs after Adder
  assign DataOutI = $signed({MuxDataI1[DATAINWIDTH],MuxDataI1[DATAINWIDTH:0]} - {MuxDataQ1[DATAINWIDTH],MuxDataQ1[DATAINWIDTH:0]});
  assign DataOutQ = $signed({MuxDataI2[DATAINWIDTH],MuxDataI2[DATAINWIDTH:0]} + {MuxDataQ2[DATAINWIDTH],MuxDataQ2[DATAINWIDTH:0]});

endmodule // OfdmCCQuantMult

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
