//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10209 $
// $Date: 2013-09-23 10:03:49 +0200 (Mon, 23 Sep 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : OFDM Cross Correlation module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/Correlator/verilog/rtl/OfdmCrossCorr.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module OfdmCrossCorr #(parameter DATAINWIDTH    = 13, // Input data from TXRX FE and delay lines
                       parameter DATAOUTWIDTH   = 18  // Accumulated CrossCorr output
                      )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            //Reset resynchronized to AGCClk
            input    wire                                  nAGCRst,

            //Control Signals
            //Enable for Ofdm Cross Correlation block, from AGC FSM
            input    wire                                  OfdmCCBlockEn,
            //Enable for input data
            input    wire                                  DataInEn,
            //Data Input
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DQ,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DI,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DQ,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Output Accumulated sum for Cross Correlation
            output   wire      [DATAOUTWIDTH-1:0]          OfdmCrossCorrOut,
            //Enable for output data
            output   wire                                  OfdmCCDataEn
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam   [2:0]   STOREDPREI0    = 3'h1;  // 0
localparam   [2:0]   STOREDPREQ0    = 3'h0;  // 0
localparam   [2:0]   STOREDPREI1    = 3'h7;  // 1
localparam   [2:0]   STOREDPREQ1    = 3'h6;  // 1
localparam   [2:0]   STOREDPREI2    = 3'h7;  // 2
localparam   [2:0]   STOREDPREQ2    = 3'h2;  // 2
localparam   [2:0]   STOREDPREI3    = 3'h0;  // 3
localparam   [2:0]   STOREDPREQ3    = 3'h2;  // 3
localparam   [2:0]   STOREDPREI4    = 3'h0;  // 4
localparam   [2:0]   STOREDPREQ4    = 3'h2;  // 4

localparam   [2:0]   STOREDPREI5    = 3'h7;  // 5
localparam   [2:0]   STOREDPREQ5    = 3'h2;  // 5
localparam   [2:0]   STOREDPREI6    = 3'h7;  // 6
localparam   [2:0]   STOREDPREQ6    = 3'h6;  // 6
localparam   [2:0]   STOREDPREI7    = 3'h1;  // 7
localparam   [2:0]   STOREDPREQ7    = 3'h7;  // 7
localparam   [2:0]   STOREDPREI8    = 3'h0;  // 8
localparam   [2:0]   STOREDPREQ8    = 3'h1;  // 8
localparam   [2:0]   STOREDPREI9    = 3'h6;  // 9
localparam   [2:0]   STOREDPREQ9    = 3'h7;  // 9

localparam   [2:0]   STOREDPREI10   = 3'h2;  // 10
localparam   [2:0]   STOREDPREQ10   = 3'h7;  // 10
localparam   [2:0]   STOREDPREI11   = 3'h2;  // 11
localparam   [2:0]   STOREDPREQ11   = 3'h0;  // 11
localparam   [2:0]   STOREDPREI12   = 3'h2;  // 12
localparam   [2:0]   STOREDPREQ12   = 3'h0;  // 12
localparam   [2:0]   STOREDPREI13   = 3'h2;  // 13
localparam   [2:0]   STOREDPREQ13   = 3'h7;  // 13
localparam   [2:0]   STOREDPREI14   = 3'h6;  // 14
localparam   [2:0]   STOREDPREQ14   = 3'h7;  // 14

localparam   [2:0]   STOREDPREI15   = 3'h7;  // 15
localparam   [2:0]   STOREDPREQ15   = 3'h1;  // 15

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires & Vars Declarations
//////////////////////////////////////////////////////////////////////////////
wire    signed     [DATAINWIDTH-1:0]   MultInDataI [15:0];
wire    signed     [DATAINWIDTH-1:0]   MultInDataQ [15:0];
wire               [2:0]               StoredPreI [15:0];
wire               [2:0]               StoredPreQ [15:0];
wire    signed     [DATAINWIDTH+1:0]   MultOutDataI [15:0];
wire    signed     [DATAINWIDTH+1:0]   MultOutDataQ [15:0];

wire               [DATAINWIDTH+5:0]   ModApproxOut;
wire               [DATAOUTWIDTH-1:0]  SatCrossCorr;
wire    signed     [DATAINWIDTH+5:0]   SumDataI;
wire    signed     [DATAINWIDTH+5:0]   SumDataQ;

//Genvar declaration
genvar                                 j;

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                [DATAOUTWIDTH-1:0]  SatCrossCorrReg;
reg     signed     [DATAINWIDTH+5:0]   SumDataIReg;
reg     signed     [DATAINWIDTH+5:0]   SumDataQReg;
reg                [4:0]               DelDataInEn;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Assigning to array to use for loop to instantiate the Quant Mult
  assign MultInDataI [0]  = DataInI;
  assign MultInDataQ [0]  = DataInQ;
  assign MultInDataI [1]  = DataIn1DI;
  assign MultInDataQ [1]  = DataIn1DQ;
  assign MultInDataI [2]  = DataIn2DI;
  assign MultInDataQ [2]  = DataIn2DQ;
  assign MultInDataI [3]  = DataIn3DI;
  assign MultInDataQ [3]  = DataIn3DQ;
  assign MultInDataI [4]  = DataIn4DI;
  assign MultInDataQ [4]  = DataIn4DQ;
  assign MultInDataI [5]  = DataIn5DI;
  assign MultInDataQ [5]  = DataIn5DQ;
  assign MultInDataI [6]  = DataIn6DI;
  assign MultInDataQ [6]  = DataIn6DQ;
  assign MultInDataI [7]  = DataIn7DI;
  assign MultInDataQ [7]  = DataIn7DQ;
  assign MultInDataI [8]  = DataIn8DI;
  assign MultInDataQ [8]  = DataIn8DQ;
  assign MultInDataI [9]  = DataIn9DI;
  assign MultInDataQ [9]  = DataIn9DQ;
  assign MultInDataI [10] = DataIn10DI;
  assign MultInDataQ [10] = DataIn10DQ;
  assign MultInDataI [11] = DataIn11DI;
  assign MultInDataQ [11] = DataIn11DQ;
  assign MultInDataI [12] = DataIn12DI;
  assign MultInDataQ [12] = DataIn12DQ;
  assign MultInDataI [13] = DataIn13DI;
  assign MultInDataQ [13] = DataIn13DQ;
  assign MultInDataI [14] = DataIn14DI;
  assign MultInDataQ [14] = DataIn14DQ;
  assign MultInDataI [15] = DataIn15DI;
  assign MultInDataQ [15] = DataIn15DQ;

//Assigning stored preamble values
  assign StoredPreI [0]  = STOREDPREI0;
  assign StoredPreQ [0]  = STOREDPREQ0;
  assign StoredPreI [1]  = STOREDPREI1;
  assign StoredPreQ [1]  = STOREDPREQ1;
  assign StoredPreI [2]  = STOREDPREI2;
  assign StoredPreQ [2]  = STOREDPREQ2;
  assign StoredPreI [3]  = STOREDPREI3;
  assign StoredPreQ [3]  = STOREDPREQ3;
  assign StoredPreI [4]  = STOREDPREI4;
  assign StoredPreQ [4]  = STOREDPREQ4;
  assign StoredPreI [5]  = STOREDPREI5;
  assign StoredPreQ [5]  = STOREDPREQ5;
  assign StoredPreI [6]  = STOREDPREI6;
  assign StoredPreQ [6]  = STOREDPREQ6;
  assign StoredPreI [7]  = STOREDPREI7;
  assign StoredPreQ [7]  = STOREDPREQ7;
  assign StoredPreI [8]  = STOREDPREI8;
  assign StoredPreQ [8]  = STOREDPREQ8;
  assign StoredPreI [9]  = STOREDPREI9;
  assign StoredPreQ [9]  = STOREDPREQ9;
  assign StoredPreI [10] =STOREDPREI10;
  assign StoredPreQ [10] =STOREDPREQ10;
  assign StoredPreI [11] =STOREDPREI11;
  assign StoredPreQ [11] =STOREDPREQ11;
  assign StoredPreI [12] =STOREDPREI12;
  assign StoredPreQ [12] =STOREDPREQ12;
  assign StoredPreI [13] =STOREDPREI13;
  assign StoredPreQ [13] =STOREDPREQ13;
  assign StoredPreI [14] =STOREDPREI14;
  assign StoredPreQ [14] =STOREDPREQ14;
  assign StoredPreI [15] =STOREDPREI15;
  assign StoredPreQ [15] =STOREDPREQ15;

//Data is registered with delayed version of DataInEn
  always @ (posedge AGCClk or negedge nAGCRst) begin:EnDelayBlk
    if (nAGCRst == 1'b0) begin
      DelDataInEn <= 5'd0;
    end
    else begin
      if (OfdmCCBlockEn == 1'b0) begin
        DelDataInEn <= 5'd0;
      end
      else begin
          DelDataInEn[0] <= DataInEn;
          DelDataInEn[4:1] <= DelDataInEn[3:0];
      end
    end
  end //EnDelayBlk

//Quant Mult1
generate
  for (j=0;j<16;j=j+1) begin: QuantMult
  OfdmCCQuantMult U_OfdmCCQuantMult(
                    .DataInI(MultInDataI[j]),
                    .DataInQ(MultInDataQ[j]),
                    .QuantDataInI(StoredPreI[j]),
                    .QuantDataInQ(StoredPreQ[j]),
                    .DataOutI(MultOutDataI[j]),
                    .DataOutQ(MultOutDataQ[j])
                    );

  end // QuantMult

endgenerate

  assign SumDataI = $signed({{4{MultOutDataI[0][DATAINWIDTH+1]}},MultOutDataI[0][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[1][DATAINWIDTH+1]}},MultOutDataI[1][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[2][DATAINWIDTH+1]}},MultOutDataI[2][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[3][DATAINWIDTH+1]}},MultOutDataI[3][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[4][DATAINWIDTH+1]}},MultOutDataI[4][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[5][DATAINWIDTH+1]}},MultOutDataI[5][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[6][DATAINWIDTH+1]}},MultOutDataI[6][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[7][DATAINWIDTH+1]}},MultOutDataI[7][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[8][DATAINWIDTH+1]}},MultOutDataI[8][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[9][DATAINWIDTH+1]}},MultOutDataI[9][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[10][DATAINWIDTH+1]}},MultOutDataI[10][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[11][DATAINWIDTH+1]}},MultOutDataI[11][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[12][DATAINWIDTH+1]}},MultOutDataI[12][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[13][DATAINWIDTH+1]}},MultOutDataI[13][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[14][DATAINWIDTH+1]}},MultOutDataI[14][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataI[15][DATAINWIDTH+1]}},MultOutDataI[15][DATAINWIDTH+1:0]});

  assign SumDataQ = $signed({{4{MultOutDataQ[0][DATAINWIDTH+1]}},MultOutDataQ[0][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[1][DATAINWIDTH+1]}},MultOutDataQ[1][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[2][DATAINWIDTH+1]}},MultOutDataQ[2][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[3][DATAINWIDTH+1]}},MultOutDataQ[3][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[4][DATAINWIDTH+1]}},MultOutDataQ[4][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[5][DATAINWIDTH+1]}},MultOutDataQ[5][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[6][DATAINWIDTH+1]}},MultOutDataQ[6][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[7][DATAINWIDTH+1]}},MultOutDataQ[7][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[8][DATAINWIDTH+1]}},MultOutDataQ[8][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[9][DATAINWIDTH+1]}},MultOutDataQ[9][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[10][DATAINWIDTH+1]}},MultOutDataQ[10][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[11][DATAINWIDTH+1]}},MultOutDataQ[11][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[12][DATAINWIDTH+1]}},MultOutDataQ[12][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[13][DATAINWIDTH+1]}},MultOutDataQ[13][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[14][DATAINWIDTH+1]}},MultOutDataQ[14][DATAINWIDTH+1:0]} +
                    {{4{MultOutDataQ[15][DATAINWIDTH+1]}},MultOutDataQ[15][DATAINWIDTH+1:0]});

//Input data is at 20Msps. Registering is done with delayed Enable signals
//Delay. Registering the data path
  always @ (posedge AGCClk or negedge nAGCRst) begin:Delay1Blk
    if (nAGCRst == 1'b0) begin
      SumDataIReg <= $signed({{(DATAINWIDTH+6)}{1'b0}});
      SumDataQReg <= $signed({{(DATAINWIDTH+6)}{1'b0}});
    end
    else begin
      if (OfdmCCBlockEn == 1'b0) begin
        SumDataIReg <= $signed({{(DATAINWIDTH+6)}{1'b0}});
        SumDataQReg <= $signed({{(DATAINWIDTH+6)}{1'b0}});
      end
      else if (DelDataInEn[0] == 1'b1) begin
        SumDataIReg <= SumDataI;
        SumDataQReg <= SumDataQ;
      end
    end
  end //Delay1Blk

//Mod Approx
  ModApprox  #(
              .SUM_WIDTH(DATAINWIDTH+6),
              .CORRVAL_WIDTH(DATAINWIDTH+6)
              )
              U_ModApprox (
                //Inputs
                .PhyClk(AGCClk),
                .nPhyRst(nAGCRst),
                .ISum(SumDataIReg),
                .QSum(SumDataQReg),
                .ComputeOn(OfdmCCBlockEn),

                //Output
                .CorrVal(ModApproxOut)
              );

//Saturate to 18 bits
  SatUnsigned #(
                .INPUT_WIDTH(DATAINWIDTH+6),
                .OUTPUT_WIDTH(DATAOUTWIDTH)
              )
              U_SatUnsigned (
                .InputData(ModApproxOut),
                .SatData(SatCrossCorr)
              );

//Registering the Sat output
  always @ (posedge AGCClk or negedge nAGCRst) begin:RegSatOut
    if (nAGCRst == 1'b0) begin
      SatCrossCorrReg <= {{DATAOUTWIDTH}{1'b0}};
    end
    else begin
      if (OfdmCCBlockEn == 1'b0) begin
        SatCrossCorrReg <= {{DATAOUTWIDTH}{1'b0}};
      end
      else if (DelDataInEn[3]) begin
        SatCrossCorrReg <= SatCrossCorr;
      end
    end
  end //RegSatOut

//Output Assignment
  assign OfdmCrossCorrOut = SatCrossCorrReg;

  assign OfdmCCDataEn = DelDataInEn[4];

endmodule // OfdmCrossCorr

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
