//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10209 $
// $Date: 2013-09-23 10:03:49 +0200 (Mon, 23 Sep 2013) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : OFDM Cross Correlation top module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/Correlator/verilog/rtl/OfdmCrossCorrTop.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module OfdmCrossCorrTop # (parameter NRX  = 4, // Number of RX chains
                           parameter DATAINWIDTH = 13,  // Input data from TXRX FE and delay lines
                           parameter DATAOUTWIDTH = 20  // Accumulated Cross Corr output
                           )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  AGCClk,
            //Reset resynchronized to AGCClk
            input    wire                                  nAGCRst,

            //Control Signals
            //Enable for Ofdm Cross Correlation block, from AGC FSM
            input    wire                                  OfdmCCBlockEn,
            //Force first 0.8,1.6,2.4 or 3.2us of outputs as zero, from AGC FSM
            input    wire                                  SetZeroOutput,
            //Enable for input data
            input    wire                                  DataInEn,

            //Data input RxChain1
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DQ1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DI1,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DQ1,

            //Data input RxChain2
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DQ2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DI2,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DQ2,

            //Data input RxChain3
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DQ3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DI3,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DQ3,

            //Data input RxChain4
            input    wire   signed     [DATAINWIDTH-1:0]   DataInI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataInQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn1DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn2DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn3DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn4DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn5DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn6DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn7DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn8DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn9DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn10DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn11DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn12DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn13DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn14DQ4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DI4,
            input    wire   signed     [DATAINWIDTH-1:0]   DataIn15DQ4,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Output Accumulated sum for Cross Correlation
            output   wire          [DATAOUTWIDTH-1:0]      OfdmCCAccSum,
            //Enable for output data
            output   wire                                  OfdmCCDataEn
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declaration
//////////////////////////////////////////////////////////////////////////////
parameter CONSTZERO      = 32'd0; // Zero


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire               [DATAINWIDTH+6:0]   SumAccData;
wire               [DATAINWIDTH+6:0]   MuxSum;

wire                           [3:0]   DataOutEn;
wire               [DATAINWIDTH+4:0]   AccSum    [3:0];

wire    signed     [DATAINWIDTH-1:0]   DataInI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataInQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn1DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn1DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn2DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn2DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn3DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn3DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn4DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn4DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn5DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn5DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn6DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn6DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn7DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn7DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn8DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn8DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn9DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn9DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn10DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn10DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn11DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn11DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn12DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn12DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn13DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn13DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn14DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn14DQ [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn15DI [3:0];
wire    signed     [DATAINWIDTH-1:0]   DataIn15DQ [3:0];

//Genvar
genvar                                 j,i;


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                [DATAINWIDTH+6:0]   RegSum;
reg                [4:0]               DelSetZeroOut;
reg                [1:0]               DelDataOutEn;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Assign Inputs to Array variable
  assign  DataInI[0] = DataInI1;
  assign  DataInQ[0] = DataInQ1;
  assign  DataIn1DI[0] = DataIn1DI1;
  assign  DataIn1DQ[0] = DataIn1DQ1;
  assign  DataIn2DI[0] = DataIn2DI1;
  assign  DataIn2DQ[0] = DataIn2DQ1;
  assign  DataIn3DI[0] = DataIn3DI1;
  assign  DataIn3DQ[0] = DataIn3DQ1;
  assign  DataIn4DI[0] = DataIn4DI1;
  assign  DataIn4DQ[0] = DataIn4DQ1;
  assign  DataIn5DI[0] = DataIn5DI1;
  assign  DataIn5DQ[0] = DataIn5DQ1;
  assign  DataIn6DI[0] = DataIn6DI1;
  assign  DataIn6DQ[0] = DataIn6DQ1;
  assign  DataIn7DI[0] = DataIn7DI1;
  assign  DataIn7DQ[0] = DataIn7DQ1;
  assign  DataIn8DI[0] = DataIn8DI1;
  assign  DataIn8DQ[0] = DataIn8DQ1;
  assign  DataIn9DI[0] = DataIn9DI1;
  assign  DataIn9DQ[0] = DataIn9DQ1;
  assign  DataIn10DI[0] = DataIn10DI1;
  assign  DataIn10DQ[0] = DataIn10DQ1;
  assign  DataIn11DI[0] = DataIn11DI1;
  assign  DataIn11DQ[0] = DataIn11DQ1;
  assign  DataIn12DI[0] = DataIn12DI1;
  assign  DataIn12DQ[0] = DataIn12DQ1;
  assign  DataIn13DI[0] = DataIn13DI1;
  assign  DataIn13DQ[0] = DataIn13DQ1;
  assign  DataIn14DI[0] = DataIn14DI1;
  assign  DataIn14DQ[0] = DataIn14DQ1;
  assign  DataIn15DI[0] = DataIn15DI1;
  assign  DataIn15DQ[0] = DataIn15DQ1;

  assign  DataInI[1] = DataInI2;
  assign  DataInQ[1] = DataInQ2;
  assign  DataIn1DI[1] = DataIn1DI2;
  assign  DataIn1DQ[1] = DataIn1DQ2;
  assign  DataIn2DI[1] = DataIn2DI2;
  assign  DataIn2DQ[1] = DataIn2DQ2;
  assign  DataIn3DI[1] = DataIn3DI2;
  assign  DataIn3DQ[1] = DataIn3DQ2;
  assign  DataIn4DI[1] = DataIn4DI2;
  assign  DataIn4DQ[1] = DataIn4DQ2;
  assign  DataIn5DI[1] = DataIn5DI2;
  assign  DataIn5DQ[1] = DataIn5DQ2;
  assign  DataIn6DI[1] = DataIn6DI2;
  assign  DataIn6DQ[1] = DataIn6DQ2;
  assign  DataIn7DI[1] = DataIn7DI2;
  assign  DataIn7DQ[1] = DataIn7DQ2;
  assign  DataIn8DI[1] = DataIn8DI2;
  assign  DataIn8DQ[1] = DataIn8DQ2;
  assign  DataIn9DI[1] = DataIn9DI2;
  assign  DataIn9DQ[1] = DataIn9DQ2;
  assign  DataIn10DI[1] = DataIn10DI2;
  assign  DataIn10DQ[1] = DataIn10DQ2;
  assign  DataIn11DI[1] = DataIn11DI2;
  assign  DataIn11DQ[1] = DataIn11DQ2;
  assign  DataIn12DI[1] = DataIn12DI2;
  assign  DataIn12DQ[1] = DataIn12DQ2;
  assign  DataIn13DI[1] = DataIn13DI2;
  assign  DataIn13DQ[1] = DataIn13DQ2;
  assign  DataIn14DI[1] = DataIn14DI2;
  assign  DataIn14DQ[1] = DataIn14DQ2;
  assign  DataIn15DI[1] = DataIn15DI2;
  assign  DataIn15DQ[1] = DataIn15DQ2;

  assign  DataInI[2] = DataInI3;
  assign  DataInQ[2] = DataInQ3;
  assign  DataIn1DI[2] = DataIn1DI3;
  assign  DataIn1DQ[2] = DataIn1DQ3;
  assign  DataIn2DI[2] = DataIn2DI3;
  assign  DataIn2DQ[2] = DataIn2DQ3;
  assign  DataIn3DI[2] = DataIn3DI3;
  assign  DataIn3DQ[2] = DataIn3DQ3;
  assign  DataIn4DI[2] = DataIn4DI3;
  assign  DataIn4DQ[2] = DataIn4DQ3;
  assign  DataIn5DI[2] = DataIn5DI3;
  assign  DataIn5DQ[2] = DataIn5DQ3;
  assign  DataIn6DI[2] = DataIn6DI3;
  assign  DataIn6DQ[2] = DataIn6DQ3;
  assign  DataIn7DI[2] = DataIn7DI3;
  assign  DataIn7DQ[2] = DataIn7DQ3;
  assign  DataIn8DI[2] = DataIn8DI3;
  assign  DataIn8DQ[2] = DataIn8DQ3;
  assign  DataIn9DI[2] = DataIn9DI3;
  assign  DataIn9DQ[2] = DataIn9DQ3;
  assign  DataIn10DI[2] = DataIn10DI3;
  assign  DataIn10DQ[2] = DataIn10DQ3;
  assign  DataIn11DI[2] = DataIn11DI3;
  assign  DataIn11DQ[2] = DataIn11DQ3;
  assign  DataIn12DI[2] = DataIn12DI3;
  assign  DataIn12DQ[2] = DataIn12DQ3;
  assign  DataIn13DI[2] = DataIn13DI3;
  assign  DataIn13DQ[2] = DataIn13DQ3;
  assign  DataIn14DI[2] = DataIn14DI3;
  assign  DataIn14DQ[2] = DataIn14DQ3;
  assign  DataIn15DI[2] = DataIn15DI3;
  assign  DataIn15DQ[2] = DataIn15DQ3;

  assign  DataInI[3] = DataInI4;
  assign  DataInQ[3] = DataInQ4;
  assign  DataIn1DI[3] = DataIn1DI4;
  assign  DataIn1DQ[3] = DataIn1DQ4;
  assign  DataIn2DI[3] = DataIn2DI4;
  assign  DataIn2DQ[3] = DataIn2DQ4;
  assign  DataIn3DI[3] = DataIn3DI4;
  assign  DataIn3DQ[3] = DataIn3DQ4;
  assign  DataIn4DI[3] = DataIn4DI4;
  assign  DataIn4DQ[3] = DataIn4DQ4;
  assign  DataIn5DI[3] = DataIn5DI4;
  assign  DataIn5DQ[3] = DataIn5DQ4;
  assign  DataIn6DI[3] = DataIn6DI4;
  assign  DataIn6DQ[3] = DataIn6DQ4;
  assign  DataIn7DI[3] = DataIn7DI4;
  assign  DataIn7DQ[3] = DataIn7DQ4;
  assign  DataIn8DI[3] = DataIn8DI4;
  assign  DataIn8DQ[3] = DataIn8DQ4;
  assign  DataIn9DI[3] = DataIn9DI4;
  assign  DataIn9DQ[3] = DataIn9DQ4;
  assign  DataIn10DI[3] = DataIn10DI4;
  assign  DataIn10DQ[3] = DataIn10DQ4;
  assign  DataIn11DI[3] = DataIn11DI4;
  assign  DataIn11DQ[3] = DataIn11DQ4;
  assign  DataIn12DI[3] = DataIn12DI4;
  assign  DataIn12DQ[3] = DataIn12DQ4;
  assign  DataIn13DI[3] = DataIn13DI4;
  assign  DataIn13DQ[3] = DataIn13DQ4;
  assign  DataIn14DI[3] = DataIn14DI4;
  assign  DataIn14DQ[3] = DataIn14DQ4;
  assign  DataIn15DI[3] = DataIn15DI4;
  assign  DataIn15DQ[3] = DataIn15DQ4;

//Data is registered with delayed version of DataInEn
  always @ (posedge AGCClk or negedge nAGCRst) begin:EnDelayBlk
    if (nAGCRst == 1'b0) begin
      DelDataOutEn  <= 2'd0;
      DelSetZeroOut <= 5'd0;
    end
    else begin
      if (OfdmCCBlockEn == 1'b0) begin
        DelDataOutEn  <= 2'd0;
        DelSetZeroOut <= 5'd0;
      end
      else begin
        DelDataOutEn[0]    <= DataOutEn[0];
        DelDataOutEn[1]    <= DelDataOutEn[0];
        DelSetZeroOut[0]   <= SetZeroOutput;
        DelSetZeroOut[4:1] <= DelSetZeroOut[3:0];
      end
    end
  end //EnDelayBlk

generate
  for (j=0; j<NRX; j=j+1) begin: GenOfdmCrossCorr
    OfdmCrossCorr U_OfdmCrossCorr(
                   //Inputs
                   .AGCClk(AGCClk),
                   .nAGCRst(nAGCRst),
                   .OfdmCCBlockEn(OfdmCCBlockEn),
                   .DataInEn(DataInEn),
                   .DataInI(DataInI[j]),
                   .DataInQ(DataInQ[j]),
                   .DataIn1DI(DataIn1DI[j]),
                   .DataIn1DQ(DataIn1DQ[j]),
                   .DataIn2DI(DataIn2DI[j]),
                   .DataIn2DQ(DataIn2DQ[j]),
                   .DataIn3DI(DataIn3DI[j]),
                   .DataIn3DQ(DataIn3DQ[j]),
                   .DataIn4DI(DataIn4DI[j]),
                   .DataIn4DQ(DataIn4DQ[j]),
                   .DataIn5DI(DataIn5DI[j]),
                   .DataIn5DQ(DataIn5DQ[j]),
                   .DataIn6DI(DataIn6DI[j]),
                   .DataIn6DQ(DataIn6DQ[j]),
                   .DataIn7DI(DataIn7DI[j]),
                   .DataIn7DQ(DataIn7DQ[j]),
                   .DataIn8DI(DataIn8DI[j]),
                   .DataIn8DQ(DataIn8DQ[j]),
                   .DataIn9DI(DataIn9DI[j]),
                   .DataIn9DQ(DataIn9DQ[j]),
                   .DataIn10DI(DataIn10DI[j]),
                   .DataIn10DQ(DataIn10DQ[j]),
                   .DataIn11DI(DataIn11DI[j]),
                   .DataIn11DQ(DataIn11DQ[j]),
                   .DataIn12DI(DataIn12DI[j]),
                   .DataIn12DQ(DataIn12DQ[j]),
                   .DataIn13DI(DataIn13DI[j]),
                   .DataIn13DQ(DataIn13DQ[j]),
                   .DataIn14DI(DataIn14DI[j]),
                   .DataIn14DQ(DataIn14DQ[j]),
                   .DataIn15DI(DataIn15DI[j]),
                   .DataIn15DQ(DataIn15DQ[j]),

                   //Outputs
                   .OfdmCCDataEn(DataOutEn[j]),
                   .OfdmCrossCorrOut(AccSum[j])
                   );
  end // GenOfdmCrossCorr
endgenerate

//Adding the outputs from all the RX chains
generate
  for(i=NRX;i<4;i=i+1) begin: GenAdder

     assign AccSum[i]    = CONSTZERO[DATAINWIDTH+4:0];
     assign DataOutEn[i] = 1'b0;

  end //GenAdder
endgenerate

     assign SumAccData = {2'b0,AccSum[0]} + {2'b0,AccSum[1]} +
                         {2'b0,AccSum[2]} + {2'b0,AccSum[3]};

//Muxing the output
  assign MuxSum = DelSetZeroOut[4]? CONSTZERO[DATAINWIDTH+6:0]: SumAccData;

//Registering Sum Data
  always @ (posedge AGCClk or negedge nAGCRst) begin: RegSumData
    if (nAGCRst == 1'b0) begin
      RegSum <= {{(DATAINWIDTH+7)}{1'b0}};
    end
    else begin
      if (OfdmCCBlockEn == 1'b0) begin
        RegSum <= {{(DATAINWIDTH+7)}{1'b0}};
      end
      else if(DelDataOutEn[0] == 1'b1)begin
        RegSum <= MuxSum;
      end
    end
  end // RegSumData

//Output Assignment
  assign OfdmCCAccSum = RegSum;
  assign OfdmCCDataEn = DelDataOutEn[1];

endmodule // OfdmCrossCorrTop

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
