//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 18567 $
// $Date: 2015-03-27 12:36:52 +0100 (Fri, 27 Mar 2015) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : This code is adapted from 11b Barker Correlator.
//                    It correlates the input data with a Barker
//                    sequence to find DSSS synchronization. The output data is
//                    sent to a peak detector.
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MDMCOMMON/RIUCORE/AGC/DSSSContCorr/verilog/rtl/BarkerHoldCorr.v $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module BarkerHoldCorr
(
  // Clock and reset
  input  wire        reset_n,       // Global reset.
  input  wire        clk,           // Clock (80 Mhz)
  
  // Control
  input  wire        cb_en,

  // Input data
  input  wire [9:0]  sampl_i,       // I sample input
  input  wire [9:0]  sampl_q,       // Q sample input
  input  wire        sampl_valid,  // Data is valid on each edge of sampl_valid

  // Saturated correlated outputs
  output reg [14:0]  peak_data_i,
  output reg [14:0]  peak_data_q,
  output reg         peak_data_valid
  );

//////////////////////////////////////////////////////////////////////////////
// Internal Regs declarations
//////////////////////////////////////////////////////////////////////////////

  // Signals for I sample shift.
  reg [9:0] sampl_i_ff1;
  reg [9:0] sampl_i_ff2;
  reg [9:0] sampl_i_ff3;
  reg [9:0] sampl_i_ff4;
  reg [9:0] sampl_i_ff5;
  reg [9:0] sampl_i_ff6;
  reg [9:0] sampl_i_ff7;
  reg [9:0] sampl_i_ff8;
  reg [9:0] sampl_i_ff9;
  reg [9:0] sampl_i_ff10;
  reg [9:0] sampl_i_ff11;
  reg [9:0] sampl_i_ff12;
  reg [9:0] sampl_i_ff13;
  reg [9:0] sampl_i_ff14;
  reg [9:0] sampl_i_ff15;
  reg [9:0] sampl_i_ff16;
  reg [9:0] sampl_i_ff17;
  reg [9:0] sampl_i_ff18;
  reg [9:0] sampl_i_ff19;
  reg [9:0] sampl_i_ff20;
  reg [9:0] sampl_i_ff21;
  reg [9:0] sampl_i_ff22;

  // Signals for Q sample shift.
  reg [9:0] sampl_q_ff1;
  reg [9:0] sampl_q_ff2;
  reg [9:0] sampl_q_ff3;
  reg [9:0] sampl_q_ff4;
  reg [9:0] sampl_q_ff5;
  reg [9:0] sampl_q_ff6;
  reg [9:0] sampl_q_ff7;
  reg [9:0] sampl_q_ff8;
  reg [9:0] sampl_q_ff9;
  reg [9:0] sampl_q_ff10;
  reg [9:0] sampl_q_ff11;
  reg [9:0] sampl_q_ff12;
  reg [9:0] sampl_q_ff13;
  reg [9:0] sampl_q_ff14;
  reg [9:0] sampl_q_ff15;
  reg [9:0] sampl_q_ff16;
  reg [9:0] sampl_q_ff17;
  reg [9:0] sampl_q_ff18;
  reg [9:0] sampl_q_ff19;
  reg [9:0] sampl_q_ff20;
  reg [9:0] sampl_q_ff21;
  reg [9:0] sampl_q_ff22;
 
  reg       sampl_valid_ff1;

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////

  wire [10:0] add1_i0;
  wire [10:0] add3_i0;
  wire [10:0] add5_i0;
  wire [10:0] add7_i0;
  wire [10:0] add9_i0;
  wire [10:0] add11_i0;
  wire [10:0] add13_i0;
  wire [10:0] add15_i0;
  wire [10:0] add17_i0;
  wire [10:0] add19_i0;
  wire [10:0] add21_i0;
  wire [11:0] add1_i1;
  wire [11:0] add2_i1;
  wire [11:0] add3_i1;
  wire [11:0] add4_i1;
  wire [11:0] add5_i1;
  wire [12:0] add1_i2;
  wire [12:0] add2_i2;
  wire [12:0] add3_i2;
  wire [13:0] add1_i3;

  wire [10:0] add1_q0;
  wire [10:0] add3_q0;
  wire [10:0] add5_q0;
  wire [10:0] add7_q0;
  wire [10:0] add9_q0;
  wire [10:0] add11_q0;
  wire [10:0] add13_q0;
  wire [10:0] add15_q0;
  wire [10:0] add17_q0;
  wire [10:0] add19_q0;
  wire [10:0] add21_q0;
  wire [11:0] add1_q1;
  wire [11:0] add2_q1;
  wire [11:0] add3_q1;
  wire [11:0] add4_q1;
  wire [11:0] add5_q1;
  wire [12:0] add1_q2;
  wire [12:0] add2_q2;
  wire [12:0] add3_q2;
  wire [13:0] add1_q3;

  // Correlated databeforesaturation.
  wire [14:0] corr_i;
  wire [14:0] corr_q;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  // Shift process for I registers, at 22 MHz.
  always @ (posedge clk or negedge reset_n)
  begin
    if (reset_n == 1'b0) begin
      sampl_i_ff1  <= 10'b0;
      sampl_i_ff2  <= 10'b0;
      sampl_i_ff3  <= 10'b0;
      sampl_i_ff4  <= 10'b0;
      sampl_i_ff5  <= 10'b0;
      sampl_i_ff6  <= 10'b0;
      sampl_i_ff7  <= 10'b0;
      sampl_i_ff8  <= 10'b0;
      sampl_i_ff9  <= 10'b0;
      sampl_i_ff10 <= 10'b0;
      sampl_i_ff11 <= 10'b0;
      sampl_i_ff12 <= 10'b0;
      sampl_i_ff13 <= 10'b0;
      sampl_i_ff14 <= 10'b0;
      sampl_i_ff15 <= 10'b0;
      sampl_i_ff16 <= 10'b0;
      sampl_i_ff17 <= 10'b0;
      sampl_i_ff18 <= 10'b0;
      sampl_i_ff19 <= 10'b0;
      sampl_i_ff20 <= 10'b0;
      sampl_i_ff21 <= 10'b0;
      sampl_i_ff22 <= 10'b0;
    end
    else begin
      if (cb_en) begin
        if (sampl_valid_ff1) begin
          sampl_i_ff1  <= sampl_i;         // Store new value.
          sampl_i_ff2  <= sampl_i_ff1;     // Shift all others registers.
          sampl_i_ff3  <= sampl_i_ff2;
          sampl_i_ff4  <= sampl_i_ff3;
          sampl_i_ff5  <= sampl_i_ff4;
          sampl_i_ff6  <= sampl_i_ff5;
          sampl_i_ff7  <= sampl_i_ff6;
          sampl_i_ff8  <= sampl_i_ff7;
          sampl_i_ff9  <= sampl_i_ff8;
          sampl_i_ff10 <= sampl_i_ff9;
          sampl_i_ff11 <= sampl_i_ff10;
          sampl_i_ff12 <= sampl_i_ff11; 
          sampl_i_ff13 <= sampl_i_ff12;
          sampl_i_ff14 <= sampl_i_ff13;
          sampl_i_ff15 <= sampl_i_ff14;
          sampl_i_ff16 <= sampl_i_ff15;
          sampl_i_ff17 <= sampl_i_ff16;
          sampl_i_ff18 <= sampl_i_ff17;
          sampl_i_ff19 <= sampl_i_ff18;
          sampl_i_ff20 <= sampl_i_ff19;
          sampl_i_ff21 <= sampl_i_ff20;
          sampl_i_ff22 <= sampl_i_ff21;
        end
      end
      else begin
        sampl_i_ff1  <= 10'b0;
        sampl_i_ff2  <= 10'b0;
        sampl_i_ff3  <= 10'b0;
        sampl_i_ff4  <= 10'b0;
        sampl_i_ff5  <= 10'b0;
        sampl_i_ff6  <= 10'b0;
        sampl_i_ff7  <= 10'b0;
        sampl_i_ff8  <= 10'b0;
        sampl_i_ff9  <= 10'b0;
        sampl_i_ff10 <= 10'b0;
        sampl_i_ff11 <= 10'b0;
        sampl_i_ff12 <= 10'b0;
        sampl_i_ff13 <= 10'b0;
        sampl_i_ff14 <= 10'b0;
        sampl_i_ff15 <= 10'b0;
        sampl_i_ff16 <= 10'b0;
        sampl_i_ff17 <= 10'b0;
        sampl_i_ff18 <= 10'b0;
        sampl_i_ff19 <= 10'b0;
        sampl_i_ff20 <= 10'b0;
        sampl_i_ff21 <= 10'b0;
        sampl_i_ff22 <= 10'b0;
      end
    end
  end

  // Adder for I values, correlated with the Barker Sequence.
  // corr_i <= - sampl_i_ff1
  //         - sampl_i_ff2
  //         - sampl_i_ff3
  //         - sampl_i_ff4
  //         - sampl_i_ff5
  //         - sampl_i_ff6
  //         + sampl_i_ff7
  //         + sampl_i_ff8
  //         + sampl_i_ff9
  //         + sampl_i_ff10    
  //         + sampl_i_ff11     
  //         + sampl_i_ff12   
  //         - sampl_i_ff13  
  //         - sampl_i_ff14
  //         + sampl_i_ff15 
  //         + sampl_i_ff16  
  //         + sampl_i_ff17  
  //         + sampl_i_ff18  
  //         - sampl_i_ff19  
  //         - sampl_i_ff20
  //         + sampl_i_ff21; 
  
  // First stage of adders
  assign add1_i0  = $signed({sampl_i_ff1[9],sampl_i_ff1})   + $signed({sampl_i_ff2[9],sampl_i_ff2});
  assign add3_i0  = $signed({sampl_i_ff3[9],sampl_i_ff3})   + $signed({sampl_i_ff4[9],sampl_i_ff4});
  assign add5_i0  = $signed({sampl_i_ff5[9],sampl_i_ff5})   + $signed({sampl_i_ff6[9],sampl_i_ff6});
  assign add7_i0  = $signed({sampl_i_ff7[9],sampl_i_ff7})   + $signed({sampl_i_ff8[9],sampl_i_ff8});
  assign add9_i0  = $signed({sampl_i_ff9[9],sampl_i_ff9})   + $signed({sampl_i_ff10[9],sampl_i_ff10});
  assign add11_i0 = $signed({sampl_i_ff11[9],sampl_i_ff11}) + $signed({sampl_i_ff12[9],sampl_i_ff12});
  assign add13_i0 = $signed({sampl_i_ff13[9],sampl_i_ff13}) + $signed({sampl_i_ff14[9],sampl_i_ff14});
  assign add15_i0 = $signed({sampl_i_ff15[9],sampl_i_ff15}) + $signed({sampl_i_ff16[9],sampl_i_ff16});
  assign add17_i0 = $signed({sampl_i_ff17[9],sampl_i_ff17}) + $signed({sampl_i_ff18[9],sampl_i_ff18});
  assign add19_i0 = $signed({sampl_i_ff19[9],sampl_i_ff19}) + $signed({sampl_i_ff20[9],sampl_i_ff20});
  assign add21_i0 = $signed({sampl_i_ff21[9],sampl_i_ff21}) + $signed({sampl_i_ff22[9],sampl_i_ff22});

  // First stage of adders is 10+1 bits.
  // These values will be added.
  assign add1_i1 = $signed({add1_i0[10],add1_i0})   + $signed({add3_i0[10],add3_i0});
  assign add2_i1 = $signed({add7_i0[10],add7_i0})   + $signed({add9_i0[10],add9_i0});
  assign add3_i1 = $signed({add15_i0[10],add15_i0}) + $signed({add17_i0[10],add17_i0});
  // These values (and sampl_i_ff19) will be substracted.
  assign add4_i1 = $signed({add11_i0[10],add11_i0}) + $signed({add21_i0[10],add21_i0});
  assign add5_i1 = $signed({add13_i0[10],add13_i0}) + $signed({add19_i0[10],add19_i0});

  // Second stage of adders is 10+2 bits.
  // These values will be added.
  assign add1_i2 = $signed({add1_i1[11],add1_i1}) + $signed({add5_i0[10],add5_i0[10],add5_i0});
  assign add2_i2 = $signed({add2_i1[11],add2_i1}) + $signed({add3_i1[11],add3_i1});
  //  This value will be substracted.
  assign add3_i2 = $signed({add4_i1[11],add4_i1}) - $signed({add5_i1[11],add5_i1});

  // Third stage of adders is 10+3 bits.
  // This value will be added.
  assign add1_i3 = $signed({add2_i2[12],add2_i2}) + $signed({add3_i2[12],add3_i2});

  assign corr_i  = $signed({add1_i3[13],add1_i3}) - $signed({add1_i2[12],add1_i2[12],add1_i2});


  // Shift process for Q registers, at 22 MHz.
  always @ (posedge clk or negedge reset_n)
  begin
    if (reset_n == 1'b0) begin
      sampl_q_ff1  <= 10'b0; // Reset all registers.
      sampl_q_ff2  <= 10'b0;
      sampl_q_ff3  <= 10'b0;
      sampl_q_ff4  <= 10'b0;
      sampl_q_ff5  <= 10'b0;
      sampl_q_ff6  <= 10'b0;
      sampl_q_ff7  <= 10'b0;
      sampl_q_ff8  <= 10'b0;
      sampl_q_ff9  <= 10'b0;
      sampl_q_ff10 <= 10'b0;
      sampl_q_ff11 <= 10'b0;
      sampl_q_ff12 <= 10'b0;
      sampl_q_ff13 <= 10'b0;
      sampl_q_ff14 <= 10'b0;
      sampl_q_ff15 <= 10'b0;
      sampl_q_ff16 <= 10'b0;
      sampl_q_ff17 <= 10'b0;
      sampl_q_ff18 <= 10'b0;
      sampl_q_ff19 <= 10'b0;
      sampl_q_ff20 <= 10'b0;
      sampl_q_ff21 <= 10'b0;
      sampl_q_ff22 <= 10'b0;
    end
    else begin
      if (cb_en) begin
        if (sampl_valid_ff1) begin
          sampl_q_ff1  <= sampl_q;
          sampl_q_ff2  <= sampl_q_ff1;    // Store new value.
          sampl_q_ff3  <= sampl_q_ff2;    // Shift all others registers.
          sampl_q_ff4  <= sampl_q_ff3;
          sampl_q_ff5  <= sampl_q_ff4;
          sampl_q_ff6  <= sampl_q_ff5;
          sampl_q_ff7  <= sampl_q_ff6;
          sampl_q_ff8  <= sampl_q_ff7;
          sampl_q_ff9  <= sampl_q_ff8;
          sampl_q_ff10 <= sampl_q_ff9;
          sampl_q_ff11 <= sampl_q_ff10;
          sampl_q_ff12 <= sampl_q_ff11;
          sampl_q_ff13 <= sampl_q_ff12;
          sampl_q_ff14 <= sampl_q_ff13;
          sampl_q_ff15 <= sampl_q_ff14;
          sampl_q_ff16 <= sampl_q_ff15;
          sampl_q_ff17 <= sampl_q_ff16;
          sampl_q_ff18 <= sampl_q_ff17;
          sampl_q_ff19 <= sampl_q_ff18;
          sampl_q_ff20 <= sampl_q_ff19;
          sampl_q_ff21 <= sampl_q_ff20;
          sampl_q_ff22 <= sampl_q_ff21;
        end
      end
      else begin
        sampl_q_ff1  <= 10'b0; // Reset all registers.
        sampl_q_ff2  <= 10'b0;
        sampl_q_ff3  <= 10'b0;
        sampl_q_ff4  <= 10'b0;
        sampl_q_ff5  <= 10'b0;
        sampl_q_ff6  <= 10'b0;
        sampl_q_ff7  <= 10'b0;
        sampl_q_ff8  <= 10'b0;
        sampl_q_ff9  <= 10'b0;
        sampl_q_ff10 <= 10'b0;
        sampl_q_ff11 <= 10'b0;
        sampl_q_ff12 <= 10'b0;
        sampl_q_ff13 <= 10'b0;
        sampl_q_ff14 <= 10'b0;
        sampl_q_ff15 <= 10'b0;
        sampl_q_ff16 <= 10'b0;
        sampl_q_ff17 <= 10'b0;
        sampl_q_ff18 <= 10'b0;
        sampl_q_ff19 <= 10'b0;
        sampl_q_ff20 <= 10'b0;
        sampl_q_ff21 <= 10'b0;
        sampl_q_ff22 <= 10'b0;
      end
    end
  end

  // Adder for Q values, correlated with the Barker Sequence.
  // corr_q <= - sampl_q_ff1
  //         - sampl_q_ff2
  //         - sampl_q_ff3
  //         - sampl_q_ff4
  //         - sampl_q_ff5
  //         - sampl_q_ff6
  //         + sampl_q_ff7
  //         + sampl_q_ff8
  //         + sampl_q_ff9
  //         + sampl_q_ff10    
  //         + sampl_q_ff11     
  //         + sampl_q_ff12   
  //         - sampl_q_ff13  
  //         - sampl_q_ff14
  //         + sampl_q_ff15 
  //         + sampl_q_ff16  
  //         + sampl_q_ff17  
  //         + sampl_q_ff18  
  //         - sampl_q_ff19  
  //         - sampl_q_ff20
  //         + sampl_q_ff21; 

    // First stage of adders
  assign add1_q0  = $signed({sampl_q_ff1[9],sampl_q_ff1})   + $signed({sampl_q_ff2[9],sampl_q_ff2});
  assign add3_q0  = $signed({sampl_q_ff3[9],sampl_q_ff3})   + $signed({sampl_q_ff4[9],sampl_q_ff4});
  assign add5_q0  = $signed({sampl_q_ff5[9],sampl_q_ff5})   + $signed({sampl_q_ff6[9],sampl_q_ff6});
  assign add7_q0  = $signed({sampl_q_ff7[9],sampl_q_ff7})   + $signed({sampl_q_ff8[9],sampl_q_ff8});
  assign add9_q0  = $signed({sampl_q_ff9[9],sampl_q_ff9})   + $signed({sampl_q_ff10[9],sampl_q_ff10});
  assign add11_q0 = $signed({sampl_q_ff11[9],sampl_q_ff11}) + $signed({sampl_q_ff12[9],sampl_q_ff12});
  assign add13_q0 = $signed({sampl_q_ff13[9],sampl_q_ff13}) + $signed({sampl_q_ff14[9],sampl_q_ff14});
  assign add15_q0 = $signed({sampl_q_ff15[9],sampl_q_ff15}) + $signed({sampl_q_ff16[9],sampl_q_ff16});
  assign add17_q0 = $signed({sampl_q_ff17[9],sampl_q_ff17}) + $signed({sampl_q_ff18[9],sampl_q_ff18});
  assign add19_q0 = $signed({sampl_q_ff19[9],sampl_q_ff19}) + $signed({sampl_q_ff20[9],sampl_q_ff20});
  assign add21_q0 = $signed({sampl_q_ff21[9],sampl_q_ff21}) + $signed({sampl_q_ff22[9],sampl_q_ff22});

  // First stage of adders is 10+1 bits.
  // These values will be added.
  assign add1_q1 = $signed({add1_q0[10],add1_q0})   + $signed({add3_q0[10],add3_q0});
  assign add2_q1 = $signed({add7_q0[10],add7_q0})   + $signed({add9_q0[10],add9_q0});
  assign add3_q1 = $signed({add15_q0[10],add15_q0}) + $signed({add17_q0[10],add17_q0});
  // These values (and sampl_q_ff19) will be substracted.
  assign add4_q1 = $signed({add11_q0[10],add11_q0}) + $signed({add21_q0[10],add21_q0});
  assign add5_q1 = $signed({add13_q0[10],add13_q0}) + $signed({add19_q0[10],add19_q0});

  // Second stage of adders is 10+2 bits.
  // These values will be added.
  assign add1_q2 = $signed({add1_q1[11],add1_q1}) + $signed({add5_q0[10],add5_q0[10],add5_q0});
  assign add2_q2 = $signed({add2_q1[11],add2_q1}) + $signed({add3_q1[11],add3_q1});
  // This value will be substracted.
  assign add3_q2 = $signed({add4_q1[11],add4_q1}) - $signed({add5_q1[11],add5_q1});

  // Third stage of adders is 10+3 bits.
  // This value will be added.
  assign add1_q3 = $signed({add2_q2[12],add2_q2}) + $signed({add3_q2[12],add3_q2});

  assign corr_q  = $signed({add1_q3[13],add1_q3}) - $signed({add1_q2[12],add1_q2[12],add1_q2});
   
  ///////////////////////////////////////////////
  // Register outputs.
  ///////////////////////////////////////////////
  always @ (posedge clk or negedge reset_n)
  begin
    if (reset_n == 1'b0) begin
      peak_data_i     <= 15'b0;
      peak_data_q     <= 15'b0;
      peak_data_valid <= 1'b0;
      sampl_valid_ff1 <= 1'b0;
    end
    else begin
      sampl_valid_ff1 <= sampl_valid;
      
      if (cb_en) begin
        peak_data_i     <= corr_i;
        peak_data_q     <= corr_q;
        peak_data_valid <= sampl_valid_ff1;
      end
      else begin
        peak_data_i     <= 15'b0;
        peak_data_q     <= 15'b0;
        peak_data_valid <= 1'b0;
      end
    end
  end

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////

`default_nettype wire
