//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 25573 $
// $Date: 2016-03-31 17:54:36 +0200 (Thu, 31 Mar 2016) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of DSSS Continuous Correlator module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MDMCOMMON/RIUCORE/AGC/DSSSContCorr/verilog/rtl/DSSSContCorr.v $
//
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module DSSSContCorr
(
  // Clock and reset
  input  wire        reset_n,          // Global reset.
  input  wire        clk,              // Clock (80 Mhz)

  // Enable of blocks
  input  wire        cb_en,

  // Block configuration
  input  wire [2:0]  cb_config,
  
  // Input samples @22MS/s from RxFilter4Corr block
  input  wire [9:0]  sampl_i,       // I sample input
  input  wire [9:0]  sampl_q,       // Q sample input
  input  wire        sampl_valid,   // Data is valid on each edge of sampl_valid

  // Signal quality and reference
  output wire [21:0] cb_bc,
  output wire [21:0] cb_rl,
  output wire        cb_rl_valid
  );

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
  
  wire [14:0] peak_data_i;
  wire [14:0] peak_data_q;
  wire        peak_data_valid;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Instanciation of BarkerHoldCorr
// Name of the instance : u_BarkerHoldCorr
// Name of the file containing this module : BarkerHoldCorr.v
BarkerHoldCorr u_BarkerHoldCorr (
    .reset_n                (reset_n),
    .clk                    (clk),
    .cb_en                  (cb_en),
    .sampl_i                (sampl_i),
    .sampl_q                (sampl_q),
    .sampl_valid            (sampl_valid),
    .peak_data_i            (peak_data_i),
    .peak_data_q            (peak_data_q),
    .peak_data_valid        (peak_data_valid)
    );

// Instanciation of DSSSCrossCorr
// Name of the instance : u_DSSSCrossCorr
// Name of the file containing this module : DSSSCrossCorr.v
DSSSContCrossCorr u_DSSSContCrossCorr (
    .reset_n                (reset_n),
    .clk                    (clk),
    .cb_en                  (cb_en),
    .cb_config              (cb_config),
    .data_i_in              (peak_data_i),
    .data_q_in              (peak_data_q),
    .data_valid             (peak_data_valid),
    .cb_bc                  (cb_bc)
    );

// Instanciation of DSSSRefLevel
// Name of the instance : u_DSSSRefLevel
// Name of the file containing this module : DSSSRefLevel.v
DSSSRefLevel u_DSSSRefLevel (
    .reset_n                (reset_n),
    .clk                    (clk),
    .cb_en                  (cb_en),
    .cb_config              (cb_config),
    .data_i_i               (sampl_i),
    .data_q_i               (sampl_q),
    .data_valid             (sampl_valid),
    .cb_rl                  (cb_rl),
    .cb_rl_valid            (cb_rl_valid)
    );

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////

`default_nettype wire
