//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 18523 $
// $Date: 2015-03-24 18:56:15 +0100 (Tue, 24 Mar 2015) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Gives value of G from lookup table
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MDMCOMMON/RIUCORE/AGC/DSSSContCorr/verilog/rtl/MultG.v $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module MultG
(
  // Clock and reset
  input  wire        reset_n,       // Global reset.
  input  wire        clk,           // Clock (80 Mhz)

  // Control
  input  wire [3:0]  counter_g,

  // Outputs.
  output reg [5:0]   g_value
  );

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////
  
  always @ (posedge clk or negedge reset_n)
  begin
    if (reset_n == 1'b0)
      g_value <= 6'd50;
    else begin
      g_value <= 6'd2; // Default
      case (counter_g)
        4'd0 :
          g_value <= 6'd50;
        4'd1 :
          g_value <= 6'd32;
        4'd2 :
          g_value <= 6'd24;
        4'd3 :
          g_value <= 6'd20;
        4'd4 :
          g_value <= 6'd16;
        4'd5 :
          g_value <= 6'd14;
        4'd6 :
          g_value <= 6'd11;
        4'd7 :
          g_value <= 6'd8;
        4'd8 :
          g_value <= 6'd5;
        default :
          g_value <= 6'd2;
      endcase
    end
  end

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////

`default_nettype wire
