//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 18523 $
// $Date: 2015-03-24 18:56:15 +0100 (Tue, 24 Mar 2015) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Gives value of K from lookup table
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MDMCOMMON/RIUCORE/AGC/DSSSContCorr/verilog/rtl/MultK.v $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module MultK
(
  // Clock and reset
  input  wire        reset_n,       // Global reset.
  input  wire        clk,           // Clock (80 Mhz)

  // Control
  input  wire [3:0]  counter_k,

  // Outputs.
  output reg [6:0]   k_value
  );

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  always @ (posedge clk or negedge reset_n)
  begin
    if (reset_n == 1'b0)
      k_value <= 7'd68;
    else begin
      k_value <= 7'd4;
      case (counter_k)
        4'd0 :
          k_value <= 7'd68;
        4'd1 :
          k_value <= 7'd44;          
        4'd2 :
          k_value <= 7'd34; 
        4'd3 :
          k_value <= 7'd28; 
        4'd4 :
          k_value <= 7'd24; 
        4'd5 :
          k_value <= 7'd20; 
        4'd6 :
          k_value <= 7'd16; 
        4'd7 :
          k_value <= 7'd12; 
        4'd8 :
          k_value <= 7'd8; 
         default :
          k_value <= 7'd4;
      endcase
    end
  end

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////

`default_nettype wire
