////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 10211 $
// $Date: 2013-09-23 10:05:57 +0200 (Mon, 23 Sep 2013) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : AGC Delay Line - for use with Pow Est and Correlation
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/PowerEst/verilog/rtl/AGCDelLine.v $
// 
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

module AGCDelLine #(parameter INPUT_WIDTH  = 13 //Input Data Width  
                   )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nAGCRst, //Active Low Reset
            input    wire                                  AGCClk,  //AGC Clock
            //Control Signals
            input    wire                                  AGCEn,   //Block Enable
            input    wire                                  RxDataValid, //Qualifies input data
            input    wire                                  DelLineClr, //Clear Delay Lines
            //Data - from Front End
            input    wire   signed     [INPUT_WIDTH-1:0]   RxAGCRe, //Real Component
            input    wire   signed     [INPUT_WIDTH-1:0]   RxAGCIm, //Imaginary Component

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Delayed versions of data
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe1D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm1D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe2D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm2D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe3D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm3D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe4D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm4D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe5D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm5D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe6D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm6D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe7D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm7D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe8D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm8D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe9D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm9D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe10D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm10D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe11D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm11D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe12D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm12D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe13D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm13D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe14D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm14D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe15D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm15D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe16D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm16D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe17D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm17D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe18D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm18D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe19D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm19D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe20D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm20D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe32D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm32D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe40D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm40D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe48D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm48D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe60D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm60D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCRe64D,
            output wire signed [INPUT_WIDTH-1:0]           RxAGCIm64D
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam    signed   [INPUT_WIDTH-1:0] SIG_INPUT_WIDTH_PARAM_0 = {INPUT_WIDTH{1'b0}};


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire                                   RxDataValidInt;

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers & Vars Declarations
//////////////////////////////////////////////////////////////////////////////
reg     signed     [INPUT_WIDTH-1:0]   RxAGCDelLineRe[63:0];
reg     signed     [INPUT_WIDTH-1:0]   RxAGCDelLineIm[63:0];
reg                [2:0]               RxDataValidIntArr;

integer i;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This block implements a delay line of length 64 to be shared between the
//correlation and the 20 MHz In band power estimation circuits of the AGC.

//For latching the input, a 3 clock delayed version of RxDataValid is used.

//RxDataValidIntArr
always @ (posedge AGCClk or negedge nAGCRst)
   begin: RxDataValidIntArr_Blk
      if (nAGCRst == 1'b0)
         RxDataValidIntArr <= 3'b0;
      else
         RxDataValidIntArr <= {RxDataValidIntArr[1:0], RxDataValid};

   end //RxDataValidIntArr_Blk

//RxDataValidInt
assign RxDataValidInt = RxDataValidIntArr[2];

//Delay Line
always @ (posedge AGCClk or negedge nAGCRst)
   begin: DelayLine_Blk
      if (nAGCRst == 1'b0) begin
         for (i = 0; i <= 63; i = i+1) begin
            RxAGCDelLineRe[i] <= SIG_INPUT_WIDTH_PARAM_0;
            RxAGCDelLineIm[i] <= SIG_INPUT_WIDTH_PARAM_0;
         end
      end
      else if (DelLineClr == 1'b1 || AGCEn == 1'b0) begin
         for (i = 0; i <= 63; i = i+1) begin
            RxAGCDelLineRe[i] <= SIG_INPUT_WIDTH_PARAM_0;
            RxAGCDelLineIm[i] <= SIG_INPUT_WIDTH_PARAM_0;
         end
      end
      else if (RxDataValidInt == 1'b1) begin
         RxAGCDelLineRe[0] <= RxAGCRe;
         RxAGCDelLineIm[0] <= RxAGCIm;
         for (i = 1; i <= 63; i = i+1) begin
            RxAGCDelLineRe[i] <= RxAGCDelLineRe[i-1];
            RxAGCDelLineIm[i] <= RxAGCDelLineIm[i-1];
         end
      end
      else begin
         for (i = 0; i <= 63; i = i+1) begin
            RxAGCDelLineRe[i] <= RxAGCDelLineRe[i];
            RxAGCDelLineIm[i] <= RxAGCDelLineIm[i];
         end
      end

   end //DelayLine_Blk

//Assign outputs as taps from Delay Line
assign RxAGCRe1D  = RxAGCDelLineRe[0];
assign RxAGCIm1D  = RxAGCDelLineIm[0];
assign RxAGCRe2D  = RxAGCDelLineRe[1];
assign RxAGCIm2D  = RxAGCDelLineIm[1];
assign RxAGCRe3D  = RxAGCDelLineRe[2];
assign RxAGCIm3D  = RxAGCDelLineIm[2];
assign RxAGCRe4D  = RxAGCDelLineRe[3];
assign RxAGCIm4D  = RxAGCDelLineIm[3];
assign RxAGCRe5D  = RxAGCDelLineRe[4];
assign RxAGCIm5D  = RxAGCDelLineIm[4];
assign RxAGCRe6D  = RxAGCDelLineRe[5];
assign RxAGCIm6D  = RxAGCDelLineIm[5];
assign RxAGCRe7D  = RxAGCDelLineRe[6];
assign RxAGCIm7D  = RxAGCDelLineIm[6];
assign RxAGCRe8D  = RxAGCDelLineRe[7];
assign RxAGCIm8D  = RxAGCDelLineIm[7];
assign RxAGCRe9D  = RxAGCDelLineRe[8];
assign RxAGCIm9D  = RxAGCDelLineIm[8];
assign RxAGCRe10D = RxAGCDelLineRe[9];
assign RxAGCIm10D = RxAGCDelLineIm[9];
assign RxAGCRe11D = RxAGCDelLineRe[10];
assign RxAGCIm11D = RxAGCDelLineIm[10];
assign RxAGCRe12D = RxAGCDelLineRe[11];
assign RxAGCIm12D = RxAGCDelLineIm[11];
assign RxAGCRe13D = RxAGCDelLineRe[12];
assign RxAGCIm13D = RxAGCDelLineIm[12];
assign RxAGCRe14D = RxAGCDelLineRe[13];
assign RxAGCIm14D = RxAGCDelLineIm[13];
assign RxAGCRe15D = RxAGCDelLineRe[14];
assign RxAGCIm15D = RxAGCDelLineIm[14];
assign RxAGCRe16D = RxAGCDelLineRe[15];
assign RxAGCIm16D = RxAGCDelLineIm[15];
assign RxAGCRe17D = RxAGCDelLineRe[16];
assign RxAGCIm17D = RxAGCDelLineIm[16];
assign RxAGCRe18D = RxAGCDelLineRe[17];
assign RxAGCIm18D = RxAGCDelLineIm[17];
assign RxAGCRe19D = RxAGCDelLineRe[18];
assign RxAGCIm19D = RxAGCDelLineIm[18];
assign RxAGCRe20D = RxAGCDelLineRe[19];
assign RxAGCIm20D = RxAGCDelLineIm[19];
assign RxAGCRe32D = RxAGCDelLineRe[31];
assign RxAGCIm32D = RxAGCDelLineIm[31];
assign RxAGCRe40D = RxAGCDelLineRe[39];
assign RxAGCIm40D = RxAGCDelLineIm[39];
assign RxAGCRe48D = RxAGCDelLineRe[47];
assign RxAGCIm48D = RxAGCDelLineIm[47];
assign RxAGCRe60D = RxAGCDelLineRe[59];
assign RxAGCIm60D = RxAGCDelLineIm[59];
assign RxAGCRe64D = RxAGCDelLineRe[63];
assign RxAGCIm64D = RxAGCDelLineIm[63];

endmodule //AGCDelLine

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
