//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission 
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 6846 $
// $Date: 2013-03-19 17:30:27 +0100 (Tue, 19 Mar 2013) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : This bloc computes the microrotation as defined in CORDIC
//                    algorithm :
//                    ReDataOutut = ReDataInn - (1-2*z_sign)*2^(-STAGE)*ImDataInn
//                    ImDataOutut = ImDataInn + (1-2*z_sign)*2^(-STAGE)*ReDataInn
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/RadarDetection/verilog/rtl/CordicVectoringRot.v $
//
//////////////////////////////////////////////////////////////////////////////

module CordicVectoringRot #(
  parameter DATAWIDTH = 14,
  parameter STAGE     = 0) 
  (
  input  wire signed [DATAWIDTH:0] ReDataIn,
  input  wire signed [DATAWIDTH:0] ImDataIn,
     
  output wire signed [DATAWIDTH:0] ReDataOut,
  output wire signed [DATAWIDTH:0] ImDataOut
  );


//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
  wire                      ImData_sign;
  wire signed [DATAWIDTH:0] shift_ReDataIn;
  wire signed [DATAWIDTH:0] shift_ImDataIn;
  wire [DATAWIDTH:0]        neg_shift_ReDataIn;
  wire [DATAWIDTH:0]        neg_shift_ImDataIn;
  wire signed [DATAWIDTH:0] delta_ReData;
  wire signed [DATAWIDTH:0] delta_ImData;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  // y sign
  assign ImData_sign = ImDataIn[DATAWIDTH];
  
  // The inputs are left shifted of STAGE bits (*2^(-STAGE))
  // shift_ReDataIn = 2^(-STAGE)*ReDataIn
  assign shift_ReDataIn = $signed(ReDataIn[DATAWIDTH:STAGE]);
  // shift_ImDataIn = 2^(-STAGE)*ImDataIn
  assign shift_ImDataIn = $signed(ImDataIn[DATAWIDTH:STAGE]);

  // Negative shift_ReDataIn and shift_ImDataIn
  assign neg_shift_ReDataIn = ~(shift_ReDataIn) + {{DATAWIDTH{1'b0}},1'b1};
  assign neg_shift_ImDataIn = ~(shift_ImDataIn) + {{DATAWIDTH{1'b0}},1'b1};
  
  // Compute delta_x and delta_y
  // delta_x = (1-2*y_sign)*shift_ImDataIn :
  assign delta_ReData = (ImData_sign == 1'b0) ? shift_ImDataIn : neg_shift_ImDataIn;
  // delta_y = -(1-2*y_sign)*shift_ImDataIn :
  assign delta_ImData = (ImData_sign == 1'b1) ? shift_ReDataIn : neg_shift_ReDataIn;
  
  // Output generation

  // ReDataOut = ReDataIn + delta_x
  assign ReDataOut = ReDataIn + delta_ReData;
  // ImDataOut = ImDataIn + delta_y
  assign ImDataOut = ImDataIn + delta_ImData;


endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
