//////////////////////////////////////////////////////////////////////////////
//  Copyright [C] by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 6946 $
// $Date: 2013-03-22 15:24:32 +0100 (Fri, 22 Mar 2013) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Phase storage FIFO
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/RadarDetection/verilog/rtl/PhaseFifo.v $
//
//////////////////////////////////////////////////////////////////////////////

module PhaseFifo #(parameter DATASIZE = 10)      // Data size 
                  (
    ///////////////////////////////////////////////
    // Clock and Reset
    ///////////////////////////////////////////////
    input  wire                AGCClk,           // AGC clock (80MHz)
    input  wire                nAGCRst,          // AGC asynchronous reset

    ///////////////////////////////////////////////
    // Data and control
    ///////////////////////////////////////////////
    input  wire [DATASIZE-1:0] Phi,              // Input data
    input  wire                PhiValid,
    input  wire                FifoLoadEn,       // Enable FIFO read
    input  wire                FifoInitPtr,      // Init FIFO read pointer
    input  wire                FifoShiftEn,      // Enable FIFO write
    input  wire [7:0]          TimeOffsetPhases, // Time offset to select phases
    input  wire [7:0]          N2Plus1Param,     // 2N+1 parameter

    ///////////////////////////////////////////////
    // Radar memory
    ///////////////////////////////////////////////
    input  wire [DATASIZE-1:0] RadarMemRdData,   // Data from Radar RAM
    //
    output wire [DATASIZE-1:0] RadarMemWrData,   // Data to Radar RAM
    output reg  [8:0]          RadarMemAddr,     // Address to Radar RAM
    output wire                RadarMemWriteEn,  // Write enable to Radar RAM
    output wire                RadarMemEn,       // Enable to Radar RAM
    
    ///////////////////////////////////////////////
    // Phi
    ///////////////////////////////////////////////
    output wire [DATASIZE-1:0] PhiFifo           // Output data
    );


//////////////////////////////////////////////////////////////////////////////
// Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// Internal Registers & Vars Declarations
//////////////////////////////////////////////////////////////////////////////

  // Addresses
  reg [8:0]          FifoWrPtr;
  reg                FifoShiftEnDly;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Address control
always @(posedge AGCClk or negedge nAGCRst)
  begin
     if(nAGCRst == 1'b0)
        RadarMemAddr <= 9'd0;
     else if (FifoInitPtr)
        RadarMemAddr <= FifoWrPtr - {1'b0,N2Plus1Param} - {1'b0,TimeOffsetPhases};
     else if (FifoLoadEn || (FifoShiftEn && PhiValid))
        RadarMemAddr <= RadarMemAddr + 9'd1;
  end

// Write and read enable
assign RadarMemWriteEn = FifoShiftEn & PhiValid;
assign RadarMemEn      = FifoLoadEn | RadarMemWriteEn;

// Data bus
assign PhiFifo        = RadarMemRdData;
assign RadarMemWrData = Phi;

// Write pointer keep value
always @ (posedge AGCClk or negedge nAGCRst) begin
  if (nAGCRst == 1'b0) begin
    FifoWrPtr      <= 9'd0;
    FifoShiftEnDly <= 1'b0;
  end
  else begin
    if (!FifoShiftEn && FifoShiftEnDly)
      FifoWrPtr <= RadarMemAddr;
    FifoShiftEnDly <= FifoShiftEn;
  end
end

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
