////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 6846 $
// $Date: 2013-03-19 17:30:27 +0100 (Tue, 19 Mar 2013) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Radar comparator Module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/RadarDetection/verilog/rtl/RadarComp.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module RadarComp (
            ///////////////////////////////////////////////
            //Threshold from dynamic radar registers
            ///////////////////////////////////////////////
            input  wire        [7:0] Fom,               // Figure Of Merite
            input  wire signed [7:0] Freq,              // Frequency
            input  wire        [7:0] PulseLengthTimer,  // Pulse length timer

            ///////////////////////////////////////////////
            //Threshold from dynamic radar registers
            ///////////////////////////////////////////////
            input  wire        [7:0] FomThrHigh,        // FOM threshold high
            input  wire        [7:0] FomThrMed,         // FOM threshold medium

            input  wire signed [7:0] FreqThrInf,        // Frequency threshold inferior
            input  wire signed [7:0] FreqThrSup,        // Frequency threshold superior
            input  wire signed [7:0] FreqThrDC,         // Frequency threshold DC
                      
            input  wire        [7:0] LengthThrInf,      // Timer length threshold inferior
            input  wire        [7:0] LengthThrSup,      // Timer length threshold superior

            ///////////////////////////////////////////////
            //Registers
            ///////////////////////////////////////////////
            input  wire signed [7:0] RegFreqSing,       // Radar Frequency Singuliar value
            input  wire        [3:0] RegFreqSingGap,    // Radar Frequency Singuliar Gap
            input  wire        [7:0] RegFomSing,        // Radar Figure Of Merite Singuliar value
            input  wire        [3:0] RegFomSingGap,     // Radar Figure Of Merite Singuliar Gap

            ///////////////////////////////////////////////
            //Status to AGC Core FSM
            ///////////////////////////////////////////////
            output wire              FomSing,           // FOM singuliar status
            output wire              FomHigh,           // FOM high status
            output wire              FomMed,            // FOM low status

            output wire              FreqSing,          // Frequency singuliar status
            output wire              FreqDC,            // Frequency DC status
            output wire              FreqLow,           // Frequency low status
            output wire              FreqHigh,          // Frequency high status

            output wire              LengthLow,         // Timer length low status
            output wire              LengthHigh         // Timer length high status
            );

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// This module computes the radar comparators for AGC status registers.

// FOM singuliar status
assign FomSing = ((Fom >= RegFomSing) && (Fom <= (RegFomSing + {4'b0,RegFomSingGap}))) ? 1'b1 : 1'b0;

// FOM high status
assign FomHigh = (Fom > FomThrHigh) ? 1'b1 : 1'b0;

// FOM low status
assign FomMed = (Fom > FomThrMed) ? 1'b1 : 1'b0;

// Frequency singuliar status
assign FreqSing = (($signed(Freq) >= $signed(RegFreqSing)) && ($signed(Freq) <= $signed((RegFreqSing + {4'b0,RegFreqSingGap})))) ? 1'b1 : 1'b0;

// Frequency DC status
assign FreqDC = ($signed(Freq) < $signed(FreqThrDC)) ? 1'b1 : 1'b0;

// Frequency low status
assign FreqLow = ($signed(Freq) < $signed(FreqThrSup)) ? 1'b1 : 1'b0;

// Frequency high status
assign FreqHigh = ($signed(Freq) > $signed(FreqThrInf)) ? 1'b1 : 1'b0;

// Timer length low status
assign LengthLow = (PulseLengthTimer < LengthThrSup) ? 1'b1 : 1'b0;

// Timer length high status
assign LengthHigh = (PulseLengthTimer > LengthThrInf) ? 1'b1 : 1'b0;

endmodule //RadarComp

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
