////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 15477 $
// $Date: 2014-07-07 17:13:54 +0200 (Mon, 07 Jul 2014) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Radar Interface Register
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/AGC/RadarDetection/verilog/rtl/RadarIFReg.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

module RadarIFReg(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nAGCRst,   // Active Low Reset
            input    wire                                  AGCClk,    // AGC Clock

            //Controls
            input    wire              [7:0]               AGCCommand,  // Command from FSM Core
            input    wire              [23:0]              AGCParam,    // Command Parameter
            input    wire                                  AGCCmdValid, // AGC Command Valid

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   wire                                  RadSWResetP,      // Radar SW reset

            output   wire                                  RadStartP,        // Start Pulse processing
            output   wire                                  RadStoreFifoP,    // Store pulse to FIFO

            output   wire              [2:0]               PulseProcConf,    // Pulse processing configuration
            output   wire              [7:0]               TimeOffsetPhases, // Time offset to select phases

            output   wire                                  RadTimerEn,       // Timer enable

            output   wire              [7:0]               FomThrHigh,       // FOM threshold high
            output   wire              [7:0]               FomThrMed,        // FOM threshold medium

            output   wire signed       [7:0]               FreqThrInf,       // Frequency threshold inferior
            output   wire signed       [7:0]               FreqThrSup,       // Frequency threshold superior
            output   wire signed       [7:0]               FreqThrDC,        // Frequency threshold DC
                        
            output   wire              [7:0]               LengthThrInf,     // Timer length threshold inferior
            output   wire              [7:0]               LengthThrSup      // Timer length threshold superior
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg              RadSWResetPInt;
reg              RadStartPInt;
reg        [2:0] PulseProcConfInt;
reg        [7:0] TimeOffsetPhasesInt;
reg              RadStoreFifoPInt;
reg              RadTimerEnInt;
reg        [7:0] FomThrHighInt;
reg        [7:0] FomThrMedInt;
reg signed [7:0] FreqThrInfInt;
reg signed [7:0] FreqThrSupInt;
reg signed [7:0] FreqThrDCInt;
reg        [7:0] LengthThrInfInt;
reg        [7:0] LengthThrSupInt;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This module forms the interface between the Radar detection block and the AGC.

//Register the incoming value based on the command
always @ (posedge AGCClk or negedge nAGCRst)
begin: RadRegInt_Blk
  if (nAGCRst == 1'b0) begin
     RadSWResetPInt      <= 1'b0;
     RadStartPInt        <= 1'b0;
     PulseProcConfInt    <= 3'd0;
     TimeOffsetPhasesInt <= 8'd0;
     RadStoreFifoPInt    <= 1'b0;
     RadTimerEnInt       <= 1'b0;
     FomThrHighInt       <= 8'd230;
     FomThrMedInt        <= 8'd217;
     FreqThrInfInt       <= -8'sd80;
     FreqThrSupInt       <= 8'd80;
     FreqThrDCInt        <= 8'd0;
     LengthThrInfInt     <= 8'd1;
     LengthThrSupInt     <= 8'd110;
  end
  else begin
    // Radar soft reset is a pulse
    RadSWResetPInt <= 1'b0;
    // Radar start is a pulse
    RadStartPInt <= 1'b0;
    // Store FIFO command is a pulse
    RadStoreFifoPInt <= 1'b0;
    if ((AGCCommand == 8'd70) && (AGCCmdValid == 1'b1)) begin
      RadSWResetPInt <= 1'b1;
    end
    else if ((AGCCommand == 8'd71) && (AGCCmdValid == 1'b1)) begin
      PulseProcConfInt    <= AGCParam[2:0];
      TimeOffsetPhasesInt <= AGCParam[15:8];
      RadStartPInt        <= 1'b1;
    end
    else if ((AGCCommand == 8'd72) && (AGCCmdValid == 1'b1)) begin
      RadStoreFifoPInt <= 1'b1;
    end
    else if ((AGCCommand == 8'd73) && (AGCCmdValid == 1'b1)) begin
      RadTimerEnInt  <= AGCParam[0];
    end
    else if ((AGCCommand == 8'd74) && (AGCCmdValid == 1'b1)) begin
      FomThrMedInt  <= AGCParam[7:0];
      FomThrHighInt <= AGCParam[15:8];
    end
    else if ((AGCCommand == 8'd75) && (AGCCmdValid == 1'b1)) begin
      FreqThrInfInt <= AGCParam[7:0];
      FreqThrSupInt <= AGCParam[15:8];
      FreqThrDCInt  <= AGCParam[23:16];
    end
    else if ((AGCCommand == 8'd76) && (AGCCmdValid == 1'b1)) begin
      LengthThrInfInt <= AGCParam[7:0];
      LengthThrSupInt <= AGCParam[15:8];
    end
  end
end //RadRegInt_Blk


//Outputs
assign RadSWResetP      = RadSWResetPInt;
assign RadStartP        = RadStartPInt;
assign PulseProcConf    = PulseProcConfInt;
assign TimeOffsetPhases = TimeOffsetPhasesInt;
assign RadStoreFifoP    = RadStoreFifoPInt;
assign RadTimerEn       = RadTimerEnInt;
assign FomThrHigh       = FomThrHighInt;
assign FomThrMed        = FomThrMedInt;
assign FreqThrInf       = FreqThrInfInt;
assign FreqThrSup       = FreqThrSupInt;
assign FreqThrDC        = FreqThrDCInt;
assign LengthThrInf     = LengthThrInfInt;
assign LengthThrSup     = LengthThrSupInt;

endmodule //RadarIFReg

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////

